/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codestyle;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTConditionalExpression;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.java.ast.ASTInfixExpression;
import net.sourceforge.pmd.lang.java.ast.ASTNullLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTUnaryExpression;
import net.sourceforge.pmd.lang.java.ast.BinaryOp;
import net.sourceforge.pmd.lang.java.ast.UnaryOp;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;

public class ConfusingTernaryRule
extends AbstractJavaRulechainRule {
    private static final PropertyDescriptor<Boolean> IGNORE_ELSE_IF = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"ignoreElseIf").desc("Ignore conditions with an else-if case")).defaultValue((Object)false)).build();

    public ConfusingTernaryRule() {
        super(ASTIfStatement.class, ASTConditionalExpression.class);
        this.definePropertyDescriptor(IGNORE_ELSE_IF);
    }

    @Override
    public Object visit(ASTIfStatement node, Object data) {
        if (node.getNumChildren() == 3 && ConfusingTernaryRule.isMatch(node.getCondition()) && (!((Boolean)this.getProperty(IGNORE_ELSE_IF)).booleanValue() || !(node.getElseBranch() instanceof ASTIfStatement) && !(node.getParent() instanceof ASTIfStatement))) {
            this.addViolation(data, (Node)node);
        }
        return data;
    }

    @Override
    public Object visit(ASTConditionalExpression node, Object data) {
        if (ConfusingTernaryRule.isMatch(node.getCondition())) {
            this.addViolation(data, (Node)node);
        }
        return data;
    }

    private static boolean isMatch(ASTExpression node) {
        return ConfusingTernaryRule.isUnaryNot(node) || ConfusingTernaryRule.isNotEquals(node) || ConfusingTernaryRule.isConditionalWithAllMatches(node);
    }

    private static boolean isUnaryNot(ASTExpression node) {
        return node instanceof ASTUnaryExpression && ((ASTUnaryExpression)node).getOperator().equals(UnaryOp.NEGATION);
    }

    private static boolean isNotEquals(ASTExpression node) {
        if (!(node instanceof ASTInfixExpression)) {
            return false;
        }
        ASTInfixExpression infix = (ASTInfixExpression)node;
        return infix.getOperator().equals(BinaryOp.NE) && !(infix.getLeftOperand() instanceof ASTNullLiteral) && !(infix.getRightOperand() instanceof ASTNullLiteral);
    }

    private static boolean isConditionalWithAllMatches(ASTExpression node) {
        if (node instanceof ASTInfixExpression) {
            ASTInfixExpression infix = (ASTInfixExpression)node;
            return (infix.getOperator() == BinaryOp.CONDITIONAL_AND || infix.getOperator() == BinaryOp.CONDITIONAL_OR) && ConfusingTernaryRule.isMatch(infix.getLeftOperand()) && ConfusingTernaryRule.isMatch(infix.getRightOperand());
        }
        return false;
    }
}

