/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.qname;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.sourceforge.pmd.lang.java.ast.JavaQualifiedName;
import net.sourceforge.pmd.lang.java.qname.ImmutableList;
import org.apache.commons.lang3.StringUtils;

public final class JavaTypeQualifiedName
extends JavaQualifiedName {
    static final int NOTLOCAL_PLACEHOLDER = -1;
    private final ImmutableList<String> packages;
    private final ImmutableList<String> classes;
    private final ImmutableList<Integer> localIndices;
    private Class<?> representedType;
    private boolean typeLoaded;
    private final ClassLoader classLoader;

    JavaTypeQualifiedName(ImmutableList<String> packages, ImmutableList<String> classes, ImmutableList<Integer> localIndices, ClassLoader classLoader) {
        Objects.requireNonNull(packages);
        Objects.requireNonNull(classes);
        Objects.requireNonNull(localIndices);
        if (classes.isEmpty() || localIndices.size() != classes.size()) {
            throw new IllegalArgumentException("Error building a type qualified name");
        }
        this.packages = packages;
        this.classes = classes;
        this.localIndices = localIndices;
        this.classLoader = classLoader;
    }

    @Override
    public JavaTypeQualifiedName getClassName() {
        return this;
    }

    @Override
    protected boolean structurallyEquals(JavaQualifiedName qname) {
        JavaTypeQualifiedName that = (JavaTypeQualifiedName)qname;
        return this.packages.equals(that.packages) && this.classes.equals(that.classes) && this.localIndices.equals(that.localIndices);
    }

    @Override
    protected int buildHashCode() {
        return Objects.hash(this.packages, this.classes, this.localIndices);
    }

    public boolean isClass() {
        return true;
    }

    public boolean isOperation() {
        return false;
    }

    @Override
    public boolean isLocalClass() {
        return this.localIndices.head() != -1;
    }

    public boolean isAnonymousClass() {
        return !this.isLocalClass() && StringUtils.isNumeric((CharSequence)this.getClassSimpleName());
    }

    @Override
    public String getClassSimpleName() {
        return this.classes.head();
    }

    @Override
    public boolean isUnnamedPackage() {
        return this.packages.isEmpty();
    }

    public List<String> getPackageList() {
        return this.packages.reverse();
    }

    public List<String> getClassList() {
        return this.classes.reverse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> getType() {
        JavaTypeQualifiedName javaTypeQualifiedName = this;
        synchronized (javaTypeQualifiedName) {
            if (!this.typeLoaded) {
                this.typeLoaded = true;
                try {
                    this.representedType = this.loadType();
                }
                catch (ClassNotFoundException | LinkageError e) {
                    this.representedType = null;
                }
            }
            return this.representedType;
        }
    }

    private Class<?> loadType() throws ClassNotFoundException {
        if (this.classLoader != null) {
            return this.classLoader.loadClass(this.getBinaryName());
        }
        return null;
    }

    public String getBinaryName() {
        return this.toString();
    }

    @Override
    protected String buildToString() {
        StringBuilder sb = new StringBuilder();
        for (String aPackage : this.packages.reverse()) {
            sb.append(aPackage).append('.');
        }
        ImmutableList<String> reversed = this.classes.reverse();
        sb.append(reversed.head());
        for (Map.Entry<String, Integer> classAndLocalIdx : reversed.tail().zip(this.localIndices.reverse().tail())) {
            sb.append('$');
            if (classAndLocalIdx.getValue() != -1) {
                sb.append(classAndLocalIdx.getValue());
            }
            sb.append(classAndLocalIdx.getKey());
        }
        return sb.toString();
    }
}

