/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.errorprone;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclarator;
import net.sourceforge.pmd.lang.java.ast.ASTPrimitiveType;
import net.sourceforge.pmd.lang.java.ast.ASTResultType;
import net.sourceforge.pmd.lang.java.ast.AccessNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.symboltable.ClassScope;
import net.sourceforge.pmd.lang.java.symboltable.MethodNameDeclaration;
import net.sourceforge.pmd.lang.java.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.lang.symboltable.NameOccurrence;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.StringProperty;

public class BeanMembersShouldSerializeRule
extends AbstractJavaRule {
    private String prefixProperty;
    private static final StringProperty PREFIX_DESCRIPTOR = new StringProperty("prefix", "A variable prefix to skip, i.e., m_", "", 1.0f);

    public BeanMembersShouldSerializeRule() {
        this.definePropertyDescriptor((PropertyDescriptor)PREFIX_DESCRIPTOR);
    }

    @Override
    public Object visit(ASTCompilationUnit node, Object data) {
        this.prefixProperty = (String)this.getProperty((PropertyDescriptor)PREFIX_DESCRIPTOR);
        super.visit(node, data);
        return data;
    }

    private static String[] imagesOf(List<? extends Node> nodes) {
        String[] imageArray = new String[nodes.size()];
        for (int i = 0; i < nodes.size(); ++i) {
            imageArray[i] = nodes.get(i).getImage();
        }
        return imageArray;
    }

    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        if (node.isInterface()) {
            return data;
        }
        Map<MethodNameDeclaration, List<NameOccurrence>> methods = ((ClassScope)node.getScope().getEnclosingScope(ClassScope.class)).getMethodDeclarations();
        ArrayList<ASTMethodDeclarator> getSetMethList = new ArrayList<ASTMethodDeclarator>(methods.size());
        for (MethodNameDeclaration d : methods.keySet()) {
            ASTMethodDeclarator mnd = d.getMethodNameDeclaratorNode();
            if (!this.isBeanAccessor(mnd)) continue;
            getSetMethList.add(mnd);
        }
        Object[] methNameArray = BeanMembersShouldSerializeRule.imagesOf(getSetMethList);
        Arrays.sort(methNameArray);
        Map vars = node.getScope().getDeclarations(VariableNameDeclaration.class);
        for (Map.Entry entry : vars.entrySet()) {
            boolean hasSetMethod;
            VariableNameDeclaration decl = (VariableNameDeclaration)entry.getKey();
            AccessNode accessNodeParent = decl.getAccessNodeParent();
            if (((List)entry.getValue()).isEmpty() || accessNodeParent.isTransient() || accessNodeParent.isStatic()) continue;
            String varName = this.trimIfPrefix(decl.getImage());
            varName = varName.substring(0, 1).toUpperCase(Locale.ROOT) + varName.substring(1, varName.length());
            boolean hasGetMethod = Arrays.binarySearch(methNameArray, "get" + varName) >= 0 || Arrays.binarySearch(methNameArray, "is" + varName) >= 0;
            boolean bl = hasSetMethod = Arrays.binarySearch(methNameArray, "set" + varName) >= 0;
            if (hasGetMethod && (accessNodeParent.isFinal() || hasSetMethod)) continue;
            this.addViolation(data, (Node)decl.getNode(), decl.getImage());
        }
        return super.visit(node, data);
    }

    private String trimIfPrefix(String img) {
        if (this.prefixProperty != null && img.startsWith(this.prefixProperty)) {
            return img.substring(this.prefixProperty.length());
        }
        return img;
    }

    private boolean isBeanAccessor(ASTMethodDeclarator meth) {
        ASTResultType ret;
        List primitives;
        String methodName = meth.getImage();
        if (methodName.startsWith("get") || methodName.startsWith("set")) {
            return true;
        }
        return methodName.startsWith("is") && !(primitives = (ret = ((ASTMethodDeclaration)meth.jjtGetParent()).getResultType()).findDescendantsOfType(ASTPrimitiveType.class)).isEmpty() && ((ASTPrimitiveType)primitives.get(0)).isBoolean();
    }
}

