/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.typeresolution;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotationTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTEnumDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTImplementsList;
import net.sourceforge.pmd.lang.java.ast.ASTImportDeclaration;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.symboltable.TypedNameDeclaration;
import net.sourceforge.pmd.lang.java.typeresolution.internal.NullableClassLoader;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public final class TypeHelper {
    private static final Map<String, Class<?>> PRIMITIVES_BY_NAME = new HashMap();

    private TypeHelper() {
    }

    public static boolean isA(TypeNode n, String clazzName) {
        if (n.getType() != null && n.getType().isAnnotation()) {
            return TypeHelper.isAnnotationSubtype(n.getType(), clazzName);
        }
        Class<?> clazz = TypeHelper.loadClassWithNodeClassloader(n, clazzName);
        if (clazz != null || n.getType() != null) {
            return TypeHelper.isA(n, clazz);
        }
        return TypeHelper.fallbackIsA(n, clazzName);
    }

    private static boolean isAnnotationSubtype(Class<?> n, String clazzName) {
        assert (n != null && n.isAnnotation()) : "Not an annotation type";
        return "java.lang.annotation.Annotation".equals(clazzName) || "java.lang.Object".equals(clazzName) || clazzName.equals(n.getName());
    }

    private static boolean fallbackIsA(TypeNode n, String clazzName) {
        if (n.getImage() != null && !n.getImage().contains(".") && clazzName.contains(".")) {
            List imports = n.getRoot().findChildrenOfType(ASTImportDeclaration.class);
            for (ASTImportDeclaration importDecl : imports) {
                if (!n.hasImageEqualTo(importDecl.getImportedSimpleName())) continue;
                return clazzName.equals(importDecl.getImportedName());
            }
        }
        if (clazzName.equals(n.getImage()) || clazzName.endsWith("." + n.getImage())) {
            return true;
        }
        if (n instanceof ASTClassOrInterfaceDeclaration) {
            ASTClassOrInterfaceType superClass = ((ASTClassOrInterfaceDeclaration)n).getSuperClassTypeNode();
            if (superClass != null) {
                return TypeHelper.isA((TypeNode)superClass, clazzName);
            }
            for (ASTClassOrInterfaceType itf : ((ASTClassOrInterfaceDeclaration)n).getSuperInterfacesTypeNodes()) {
                if (!TypeHelper.isA((TypeNode)itf, clazzName)) continue;
                return true;
            }
        } else {
            if (n instanceof ASTEnumDeclaration) {
                ASTImplementsList implemented = (ASTImplementsList)n.getFirstChildOfType(ASTImplementsList.class);
                if (implemented != null) {
                    for (ASTClassOrInterfaceType itf : implemented) {
                        if (!TypeHelper.isA((TypeNode)itf, clazzName)) continue;
                        return true;
                    }
                }
                return "java.lang.Enum".equals(clazzName) || "java.lang.Comparable".equals(clazzName) || "java.io.Serializable".equals(clazzName) || "java.lang.Object".equals(clazzName);
            }
            if (n instanceof ASTAnnotationTypeDeclaration) {
                return "java.lang.annotation.Annotation".equals(clazzName) || "java.lang.Object".equals(clazzName);
            }
        }
        return false;
    }

    public static boolean isExactlyA(TypeNode n, String clazzName) {
        if (n.getType() != null && n.getType().getName().equals(clazzName)) {
            return true;
        }
        Class<?> clazz = TypeHelper.loadClassWithNodeClassloader(n, clazzName);
        if (clazz != null) {
            return n.getType() == clazz;
        }
        return clazzName.equals(n.getImage()) || clazzName.endsWith("." + n.getImage());
    }

    private static Class<?> loadClassWithNodeClassloader(TypeNode n, String clazzName) {
        if (n.getType() != null) {
            return TypeHelper.loadClass(n.getRoot().getClassTypeResolver(), clazzName);
        }
        return null;
    }

    static Class<?> loadClass(NullableClassLoader ctr, String className) {
        return TypeHelper.loadClassMaybeArray(ctr, StringUtils.deleteWhitespace((String)className));
    }

    private static Class<?> loadClassFromCanonicalName(NullableClassLoader ctr, String className) {
        Class<?> clazz = PRIMITIVES_BY_NAME.get(className);
        if (clazz == null) {
            clazz = ctr.loadClassOrNull(className);
        }
        if (clazz != null) {
            return clazz;
        }
        int lastDotIndex = className.lastIndexOf(46);
        if (lastDotIndex >= 0) {
            String asInner = className.substring(0, lastDotIndex) + '$' + className.substring(lastDotIndex + 1);
            return TypeHelper.loadClassFromCanonicalName(ctr, asInner);
        }
        return null;
    }

    private static Class<?> loadClassMaybeArray(NullableClassLoader classLoader, String className) {
        Validate.notNull((Object)className, (String)"className must not be null.", (Object[])new Object[0]);
        if (className.endsWith("[]")) {
            int i;
            int dimension = 0;
            for (i = className.length(); i >= 2 && className.startsWith("[]", i - 2); i -= 2) {
                ++dimension;
            }
            TypeHelper.checkJavaIdent(className, i);
            String elementName = className.substring(0, i);
            Class<?> elementType = TypeHelper.loadClassFromCanonicalName(classLoader, elementName);
            if (elementType == null) {
                return null;
            }
            return Array.newInstance(elementType, (int[])Array.newInstance(Integer.TYPE, dimension)).getClass();
        }
        TypeHelper.checkJavaIdent(className, className.length());
        return TypeHelper.loadClassFromCanonicalName(classLoader, className);
    }

    private static IllegalArgumentException invalidClassName(String className) {
        return new IllegalArgumentException("Not a valid class name \"" + className + "\"");
    }

    private static void checkJavaIdent(String className, int endOffsetExclusive) {
        if (endOffsetExclusive <= 0 || !Character.isJavaIdentifierStart(className.charAt(0))) {
            throw TypeHelper.invalidClassName(className);
        }
        for (int i = 1; i < endOffsetExclusive; ++i) {
            char c = className.charAt(i);
            if (Character.isJavaIdentifierPart(c) || c == '.') continue;
            throw TypeHelper.invalidClassName(className);
        }
    }

    public static boolean isA(TypeNode n, Class<?> clazz) {
        return TypeHelper.subclasses(n, clazz);
    }

    public static boolean isEither(TypeNode n, Class<?> class1, Class<?> class2) {
        return TypeHelper.subclasses(n, class1) || TypeHelper.subclasses(n, class2);
    }

    public static boolean isExactlyAny(TypedNameDeclaration vnd, Class<?> ... clazzes) {
        Class<?> type = vnd.getType();
        for (Class<?> clazz : clazzes) {
            if ((type == null || !type.equals(clazz)) && (type != null || !clazz.getSimpleName().equals(vnd.getTypeImage()) && !clazz.getName().equals(vnd.getTypeImage()))) continue;
            return true;
        }
        return false;
    }

    public static boolean isExactlyNone(TypedNameDeclaration vnd, Class<?> ... clazzes) {
        return !TypeHelper.isExactlyAny(vnd, clazzes);
    }

    @Deprecated
    public static boolean isA(TypedNameDeclaration vnd, Class<?> clazz) {
        return TypeHelper.isExactlyAny(vnd, clazz);
    }

    @Deprecated
    public static boolean isEither(TypedNameDeclaration vnd, Class<?> class1, Class<?> class2) {
        return TypeHelper.isExactlyAny(vnd, class1, class2);
    }

    @Deprecated
    public static boolean isNeither(TypedNameDeclaration vnd, Class<?> class1, Class<?> class2) {
        return !TypeHelper.isA(vnd, class1) && !TypeHelper.isA(vnd, class2);
    }

    public static boolean subclasses(TypeNode n, Class<?> clazz) {
        Class<?> type = n.getType();
        if (clazz == null) {
            return false;
        }
        if (type == null) {
            return TypeHelper.fallbackIsA(n, clazz.getName());
        }
        return clazz.isAssignableFrom(type);
    }

    public static boolean isA(TypedNameDeclaration vnd, String className) {
        Class<?> clazz;
        Class<?> type = vnd.getType();
        if (type != null && (clazz = TypeHelper.loadClass(NullableClassLoader.ClassLoaderWrapper.wrapNullable(type.getClassLoader()), className)) != null) {
            return clazz.isAssignableFrom(type);
        }
        return false;
    }

    static {
        PRIMITIVES_BY_NAME.put("boolean", Boolean.TYPE);
        PRIMITIVES_BY_NAME.put("byte", Byte.TYPE);
        PRIMITIVES_BY_NAME.put("char", Character.TYPE);
        PRIMITIVES_BY_NAME.put("short", Short.TYPE);
        PRIMITIVES_BY_NAME.put("int", Integer.TYPE);
        PRIMITIVES_BY_NAME.put("long", Long.TYPE);
        PRIMITIVES_BY_NAME.put("double", Double.TYPE);
        PRIMITIVES_BY_NAME.put("float", Float.TYPE);
        PRIMITIVES_BY_NAME.put("void", Void.TYPE);
    }
}

