/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.typeresolution;

import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.symboltable.TypedNameDeclaration;
import org.apache.commons.lang3.ClassUtils;

public final class TypeHelper {
    private TypeHelper() {
    }

    public static boolean isA(TypeNode n, String clazzName) {
        Class<?> clazz = TypeHelper.loadClassWithNodeClassloader(n, clazzName);
        if (clazz != null || n.getType() != null) {
            return TypeHelper.isA(n, clazz);
        }
        return clazzName.equals(n.getImage()) || clazzName.endsWith("." + n.getImage());
    }

    public static boolean isExactlyA(TypeNode n, String clazzName) {
        Class<?> clazz = TypeHelper.loadClassWithNodeClassloader(n, clazzName);
        if (clazz != null) {
            return n.getType() == clazz;
        }
        return clazzName.equals(n.getImage()) || clazzName.endsWith("." + n.getImage());
    }

    private static Class<?> loadClassWithNodeClassloader(TypeNode n, String clazzName) {
        if (n.getType() != null) {
            return TypeHelper.loadClass(n.getType().getClassLoader(), clazzName);
        }
        return null;
    }

    private static Class<?> loadClass(ClassLoader nullableClassLoader, String clazzName) {
        try {
            ClassLoader classLoader = nullableClassLoader;
            if (classLoader == null) {
                classLoader = ClassLoader.getSystemClassLoader();
            }
            return ClassUtils.getClass((ClassLoader)classLoader, (String)clazzName);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
        return null;
    }

    public static boolean isA(TypeNode n, Class<?> clazz) {
        return TypeHelper.subclasses(n, clazz);
    }

    public static boolean isEither(TypeNode n, Class<?> class1, Class<?> class2) {
        return TypeHelper.subclasses(n, class1) || TypeHelper.subclasses(n, class2);
    }

    public static boolean isExactlyAny(TypedNameDeclaration vnd, Class<?> ... clazzes) {
        Class<?> type = vnd.getType();
        for (Class<?> clazz : clazzes) {
            if ((type == null || !type.equals(clazz)) && (type != null || !clazz.getSimpleName().equals(vnd.getTypeImage()) && !clazz.getName().equals(vnd.getTypeImage()))) continue;
            return true;
        }
        return false;
    }

    public static boolean isExactlyNone(TypedNameDeclaration vnd, Class<?> ... clazzes) {
        return !TypeHelper.isExactlyAny(vnd, clazzes);
    }

    @Deprecated
    public static boolean isA(TypedNameDeclaration vnd, Class<?> clazz) {
        return TypeHelper.isExactlyAny(vnd, clazz);
    }

    @Deprecated
    public static boolean isEither(TypedNameDeclaration vnd, Class<?> class1, Class<?> class2) {
        return TypeHelper.isExactlyAny(vnd, class1, class2);
    }

    @Deprecated
    public static boolean isNeither(TypedNameDeclaration vnd, Class<?> class1, Class<?> class2) {
        return !TypeHelper.isA(vnd, class1) && !TypeHelper.isA(vnd, class2);
    }

    public static boolean subclasses(TypeNode n, Class<?> clazz) {
        Class<?> type = n.getType();
        if (type == null || clazz == null) {
            return false;
        }
        return clazz.isAssignableFrom(type);
    }

    public static boolean isA(TypedNameDeclaration vnd, String className) {
        Class<?> clazz;
        Class<?> type = vnd.getType();
        if (type != null && (clazz = TypeHelper.loadClass(type.getClassLoader(), className)) != null) {
            return clazz.isAssignableFrom(type);
        }
        return false;
    }
}

