/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.multithreading;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAssignmentOperator;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTNullLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.lang.java.ast.ASTStatementExpression;
import net.sourceforge.pmd.lang.java.ast.ASTSynchronizedStatement;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;

public class NonThreadSafeSingletonRule
extends AbstractJavaRule {
    private Map<String, ASTFieldDeclaration> fieldDecls = new HashMap<String, ASTFieldDeclaration>();
    private boolean checkNonStaticMethods = true;
    private boolean checkNonStaticFields = true;
    private static final PropertyDescriptor<Boolean> CHECK_NON_STATIC_METHODS_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"checkNonStaticMethods").desc("Check for non-static methods.  Do not set this to false and checkNonStaticFields to true.")).defaultValue((Object)true)).build();
    private static final PropertyDescriptor<Boolean> CHECK_NON_STATIC_FIELDS_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"checkNonStaticFields").desc("Check for non-static fields.  Do not set this to true and checkNonStaticMethods to false.")).defaultValue((Object)false)).build();

    public NonThreadSafeSingletonRule() {
        this.definePropertyDescriptor(CHECK_NON_STATIC_METHODS_DESCRIPTOR);
        this.definePropertyDescriptor(CHECK_NON_STATIC_FIELDS_DESCRIPTOR);
    }

    @Override
    public Object visit(ASTCompilationUnit node, Object data) {
        this.fieldDecls.clear();
        this.checkNonStaticMethods = (Boolean)this.getProperty(CHECK_NON_STATIC_METHODS_DESCRIPTOR);
        this.checkNonStaticFields = (Boolean)this.getProperty(CHECK_NON_STATIC_FIELDS_DESCRIPTOR);
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTFieldDeclaration node, Object data) {
        if (this.checkNonStaticFields || node.isStatic()) {
            this.fieldDecls.put(node.getVariableName(), node);
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTMethodDeclaration node, Object data) {
        if (this.checkNonStaticMethods && !node.isStatic() || node.isSynchronized()) {
            return super.visit(node, data);
        }
        List ifStatements = node.findDescendantsOfType(ASTIfStatement.class);
        for (ASTIfStatement ifStatement : ifStatements) {
            ASTName n;
            if (ifStatement.getFirstParentOfType(ASTSynchronizedStatement.class) != null || !ifStatement.hasDescendantOfType(ASTNullLiteral.class) || (n = (ASTName)ifStatement.getFirstDescendantOfType(ASTName.class)) == null || !this.fieldDecls.containsKey(n.getImage())) continue;
            List assigmnents = ifStatement.findDescendantsOfType(ASTAssignmentOperator.class);
            boolean violation = false;
            for (int ix = 0; ix < assigmnents.size(); ++ix) {
                ASTStatementExpression expr;
                ASTAssignmentOperator oper = (ASTAssignmentOperator)assigmnents.get(ix);
                if (!(oper.getParent() instanceof ASTStatementExpression) || !((expr = (ASTStatementExpression)oper.getParent()).getChild(0) instanceof ASTPrimaryExpression) || ((ASTPrimaryExpression)expr.getChild(0)).getNumChildren() != 1 || !(((ASTPrimaryExpression)expr.getChild(0)).getChild(0) instanceof ASTPrimaryPrefix)) continue;
                ASTPrimaryPrefix pp = (ASTPrimaryPrefix)((ASTPrimaryExpression)expr.getChild(0)).getChild(0);
                String name = null;
                if (pp.usesThisModifier()) {
                    ASTPrimarySuffix priSuf = (ASTPrimarySuffix)expr.getFirstDescendantOfType(ASTPrimarySuffix.class);
                    name = priSuf.getImage();
                } else {
                    ASTName astName = (ASTName)pp.getChild(0);
                    name = astName.getImage();
                }
                if (!this.fieldDecls.containsKey(name)) continue;
                violation = true;
            }
            if (!violation) continue;
            this.addViolation(data, (Node)ifStatement);
        }
        return super.visit(node, data);
    }
}

