/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codestyle;

import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.lang.java.ast.ASTForStatement;
import net.sourceforge.pmd.lang.java.ast.ASTLocalVariableDeclaration;
import net.sourceforge.pmd.lang.java.rule.performance.AbstractOptimizationRule;
import net.sourceforge.pmd.lang.java.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.lang.symboltable.Scope;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;

public class LocalVariableCouldBeFinalRule
extends AbstractOptimizationRule {
    private static final PropertyDescriptor<Boolean> IGNORE_FOR_EACH = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"ignoreForEachDecl").defaultValue((Object)false)).desc("Ignore non-final loop variables in a for-each statement.")).build();

    public LocalVariableCouldBeFinalRule() {
        this.definePropertyDescriptor(IGNORE_FOR_EACH);
    }

    @Override
    public Object visit(ASTLocalVariableDeclaration node, Object data) {
        if (node.isFinal()) {
            return data;
        }
        if (((Boolean)this.getProperty(IGNORE_FOR_EACH)).booleanValue() && node.jjtGetParent() instanceof ASTForStatement) {
            return data;
        }
        Scope s = node.getScope();
        Map decls = s.getDeclarations(VariableNameDeclaration.class);
        for (Map.Entry entry : decls.entrySet()) {
            VariableNameDeclaration var = (VariableNameDeclaration)entry.getKey();
            if (var.getAccessNodeParent() != node || this.assigned((List)entry.getValue())) continue;
            this.addViolation(data, var.getAccessNodeParent(), var.getImage());
        }
        return data;
    }
}

