/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codestyle;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import net.sourceforge.pmd.lang.java.ast.ASTAnyTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclarator;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.AbstractAnyTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaAccessNode;
import net.sourceforge.pmd.lang.java.ast.Comment;
import net.sourceforge.pmd.lang.java.rule.AbstractIgnoredAnnotationRule;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;

public class CommentDefaultAccessModifierRule
extends AbstractIgnoredAnnotationRule {
    private static final PropertyDescriptor<Pattern> REGEX_DESCRIPTOR = ((PropertyBuilder.RegexPropertyBuilder)PropertyFactory.regexProperty((String)"regex").desc("Regular expression")).defaultValue("\\/\\*\\s+(default|package)\\s+\\*\\/").build();
    private static final String MESSAGE = "To avoid mistakes add a comment at the beginning of the %s %s if you want a default access modifier";
    private final Set<Integer> interestingLineNumberComments = new HashSet<Integer>();

    public CommentDefaultAccessModifierRule() {
        this.definePropertyDescriptor(REGEX_DESCRIPTOR);
    }

    @Override
    protected Collection<String> defaultSuppressionAnnotations() {
        ArrayList<String> ignoredStrings = new ArrayList<String>();
        ignoredStrings.add("com.google.common.annotations.VisibleForTesting");
        ignoredStrings.add("android.support.annotation.VisibleForTesting");
        return ignoredStrings;
    }

    @Override
    public Object visit(ASTCompilationUnit node, Object data) {
        this.interestingLineNumberComments.clear();
        List<Comment> comments = node.getComments();
        for (Comment comment : comments) {
            if (!((Pattern)this.getProperty(REGEX_DESCRIPTOR)).matcher(comment.getImage()).matches()) continue;
            this.interestingLineNumberComments.add(comment.getBeginLine());
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTMethodDeclaration decl, Object data) {
        if (this.shouldReport(decl)) {
            this.addViolationWithMessage(data, decl, String.format(MESSAGE, ((ASTMethodDeclarator)decl.getFirstChildOfType(ASTMethodDeclarator.class)).getImage(), "method"));
        }
        return super.visit(decl, data);
    }

    @Override
    public Object visit(ASTFieldDeclaration decl, Object data) {
        if (this.shouldReport(decl)) {
            this.addViolationWithMessage(data, decl, String.format(MESSAGE, ((ASTVariableDeclaratorId)decl.getFirstDescendantOfType(ASTVariableDeclaratorId.class)).getImage(), "field"));
        }
        return super.visit(decl, data);
    }

    @Override
    public Object visit(ASTClassOrInterfaceDeclaration decl, Object data) {
        if (decl.isNested() && this.shouldReport(decl)) {
            this.addViolationWithMessage(data, decl, String.format(MESSAGE, decl.getImage(), "nested class"));
        }
        return super.visit(decl, data);
    }

    @Override
    public Object visit(ASTConstructorDeclaration decl, Object data) {
        if (this.shouldReport(decl)) {
            this.addViolationWithMessage(data, decl, String.format(MESSAGE, decl.getImage(), "constructor"));
        }
        return super.visit(decl, data);
    }

    private boolean shouldReport(AbstractJavaAccessNode decl) {
        AbstractAnyTypeDeclaration parentClassOrInterface = (AbstractAnyTypeDeclaration)decl.getFirstParentOfType(AbstractAnyTypeDeclaration.class);
        boolean isConcreteClass = parentClassOrInterface.getTypeKind() == ASTAnyTypeDeclaration.TypeKind.CLASS;
        boolean isEnumConstructor = parentClassOrInterface.getTypeKind() == ASTAnyTypeDeclaration.TypeKind.ENUM && decl instanceof ASTConstructorDeclaration;
        return isConcreteClass && !isEnumConstructor && decl.isPackagePrivate() && !this.interestingLineNumberComments.contains(decl.getBeginLine()) && !this.hasIgnoredAnnotation(decl);
    }
}

