/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symboltable;

import java.util.Set;
import net.sourceforge.pmd.lang.java.symboltable.JavaNameOccurrence;
import net.sourceforge.pmd.lang.java.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.lang.symboltable.AbstractScope;
import net.sourceforge.pmd.lang.symboltable.NameDeclaration;
import net.sourceforge.pmd.lang.symboltable.NameOccurrence;

public abstract class AbstractJavaScope
extends AbstractScope {
    public void addDeclaration(NameDeclaration declaration) {
        this.checkForDuplicatedNameDeclaration(declaration);
        super.addDeclaration(declaration);
    }

    protected void checkForDuplicatedNameDeclaration(NameDeclaration declaration) {
        if (declaration instanceof VariableNameDeclaration && this.getDeclarations().keySet().contains(declaration)) {
            throw new RuntimeException(declaration + " is already in the symbol table");
        }
    }

    public boolean contains(NameOccurrence occurrence) {
        return !this.findVariableHere((JavaNameOccurrence)occurrence).isEmpty();
    }

    protected abstract Set<NameDeclaration> findVariableHere(JavaNameOccurrence var1);

    protected <T> String glomNames(Set<T> s) {
        StringBuilder result = new StringBuilder();
        for (T t : s) {
            result.append(t.toString());
            result.append(',');
        }
        return result.length() == 0 ? "" : result.toString().substring(0, result.length() - 1);
    }
}

