/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.junit;

import java.util.Iterator;
import java.util.List;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.rule.junit.AbstractJUnitRule;

public class TestClassWithoutTestCasesRule
extends AbstractJUnitRule {
    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        if (node.isAbstract() || node.isInterface() || node.isNested()) {
            return data;
        }
        List m = node.findDescendantsOfType(ASTMethodDeclaration.class);
        boolean testsFound = false;
        if (m != null) {
            Iterator it = m.iterator();
            while (it.hasNext() && !testsFound) {
                ASTMethodDeclaration md = (ASTMethodDeclaration)it.next();
                if (this.isInInnerClassOrInterface(md) || !this.isJUnitMethod(md, data)) continue;
                testsFound = true;
            }
        }
        if (!testsFound) {
            this.addViolation(data, node);
        }
        return data;
    }

    private boolean isInInnerClassOrInterface(ASTMethodDeclaration md) {
        ASTClassOrInterfaceDeclaration p = (ASTClassOrInterfaceDeclaration)md.getFirstParentOfType(ASTClassOrInterfaceDeclaration.class);
        return p != null && p.isNested();
    }
}

