/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.ant.internal;

import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.pmd.internal.Slf4jSimpleConfiguration;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.XmlLogger;
import org.apache.tools.ant.taskdefs.RecorderEntry;
import org.slf4j.event.Level;

public final class Slf4jSimpleConfigurationForAnt {
    private static final Level DEFAULT_LEVEL = Level.INFO;
    private static final Level[] LOG_LEVELS = new Level[]{Level.ERROR, Level.WARN, Level.INFO, Level.DEBUG, Level.TRACE};

    private Slf4jSimpleConfigurationForAnt() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Level reconfigureLoggingForAnt(Project antProject) {
        if (!Slf4jSimpleConfiguration.isSimpleLogger()) {
            return DEFAULT_LEVEL;
        }
        PrintStream original = System.err;
        try {
            System.setErr(new SimpleLoggerToAntBridge(antProject, original));
            System.setProperty("org.slf4j.simpleLogger.showDateTime", "false");
            System.setProperty("org.slf4j.simpleLogger.showThreadName", "false");
            System.setProperty("org.slf4j.simpleLogger.showThreadId", "false");
            System.setProperty("org.slf4j.simpleLogger.levelInBrackets", "false");
            System.setProperty("org.slf4j.simpleLogger.cacheOutputStream", "true");
            System.setProperty("org.slf4j.simpleLogger.logFile", "System.err");
            Level level = Slf4jSimpleConfigurationForAnt.getAntLogLevel(antProject);
            Slf4jSimpleConfiguration.reconfigureDefaultLogLevel((Level)level);
            Level level2 = level;
            return level2;
        }
        finally {
            System.setErr(original);
        }
    }

    private static Level getAntLogLevel(Project project) {
        for (BuildListener l : project.getBuildListeners()) {
            Field declaredField = null;
            try {
                if (l instanceof DefaultLogger) {
                    declaredField = DefaultLogger.class.getDeclaredField("msgOutputLevel");
                } else if (l instanceof XmlLogger) {
                    declaredField = XmlLogger.class.getDeclaredField("msgOutputLevel");
                } else if (l instanceof RecorderEntry) {
                    declaredField = RecorderEntry.class.getDeclaredField("loglevel");
                } else {
                    if ("org.gradle.api.internal.project.ant.AntLoggingAdapter".equals(l.getClass().getName())) {
                        return Slf4jSimpleConfigurationForAnt.determineGradleLogLevel(project, l);
                    }
                    try {
                        declaredField = l.getClass().getDeclaredField("logLevel");
                        if (declaredField.getType() != Integer.class && declaredField.getType() != Integer.TYPE) {
                            declaredField = null;
                            project.log("Unsupported build listener: " + l.getClass(), 4);
                        }
                    }
                    catch (NoSuchFieldException e) {
                        project.log("Unsupported build listener: " + l.getClass(), 4);
                    }
                }
                if (declaredField == null) continue;
                declaredField.setAccessible(true);
                return LOG_LEVELS[declaredField.getInt(l)];
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
            }
        }
        project.log("Could not determine ant log level, no supported build listeners found. Log level is set to " + DEFAULT_LEVEL, 1);
        return DEFAULT_LEVEL;
    }

    private static Level determineGradleLogLevel(Project project, BuildListener l) {
        try {
            project.log("Detected gradle AntLoggingAdapter", 4);
            Field loggerField = l.getClass().getDeclaredField("logger");
            loggerField.setAccessible(true);
            Object logger = loggerField.get(l);
            Class<?> gradleLogLevel = l.getClass().getClassLoader().loadClass("org.gradle.api.logging.LogLevel");
            Method isLevelAtMostMethod = logger.getClass().getDeclaredMethod("isLevelAtMost", gradleLogLevel);
            isLevelAtMostMethod.setAccessible(true);
            ?[] logLevels = gradleLogLevel.getEnumConstants();
            Level[] mapping = new Level[]{Level.TRACE, Level.DEBUG, Level.INFO, Level.WARN, Level.ERROR, Level.ERROR};
            for (int i = 0; i < Math.min(logLevels.length, mapping.length); ++i) {
                boolean enabled = (Boolean)isLevelAtMostMethod.invoke(logger, logLevels[i]);
                if (!enabled) continue;
                project.log("Current log level: " + logLevels[i] + " -> " + mapping[i], 4);
                return mapping[i];
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        project.log("Could not determine log level, falling back to default: " + DEFAULT_LEVEL, 1);
        return DEFAULT_LEVEL;
    }

    private static final class SimpleLoggerToAntBridge
    extends PrintStream {
        private static final Map<String, Integer> ANT_LOG_LEVELS = new HashMap<String, Integer>();
        private final StringBuilder buffer = new StringBuilder(100);
        private final Project antProject;

        SimpleLoggerToAntBridge(Project antProject, PrintStream original) {
            super(original);
            this.antProject = antProject;
        }

        @Override
        public void println(String x) {
            this.buffer.append(x).append(System.lineSeparator());
        }

        @Override
        public void flush() {
            String logLevel = this.determineLogLevel();
            int antLogLevel = ANT_LOG_LEVELS.getOrDefault(logLevel, 2);
            this.antProject.log(this.buffer.toString(), antLogLevel);
            this.buffer.setLength(0);
        }

        private String determineLogLevel() {
            int firstSpace = this.buffer.indexOf(" ");
            if (firstSpace != -1) {
                String level = this.buffer.substring(0, firstSpace);
                this.buffer.delete(0, firstSpace + 1);
                return level;
            }
            return DEFAULT_LEVEL.name();
        }

        static {
            ANT_LOG_LEVELS.put(Level.ERROR.name(), 0);
            ANT_LOG_LEVELS.put(Level.WARN.name(), 1);
            ANT_LOG_LEVELS.put(Level.INFO.name(), 2);
            ANT_LOG_LEVELS.put(Level.DEBUG.name(), 3);
            ANT_LOG_LEVELS.put(Level.TRACE.name(), 4);
        }
    }
}

