/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rio.utils;

import info.aduna.xml.SimpleSAXListener;
import info.aduna.xml.XMLReaderFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class OWLAPISimpleSAXParser {
    private XMLReader xmlReader;
    protected SimpleSAXListener listener;
    protected boolean preserveWhitespace = false;

    public OWLAPISimpleSAXParser(XMLReader xmlReader) {
        this.xmlReader = xmlReader;
    }

    public OWLAPISimpleSAXParser() throws SAXException {
        this(XMLReaderFactory.createXMLReader());
    }

    public void setListener(SimpleSAXListener listener) {
        this.listener = listener;
    }

    public SimpleSAXListener getListener() {
        return this.listener;
    }

    public void setPreserveWhitespace(boolean preserveWhitespace) {
        this.preserveWhitespace = preserveWhitespace;
    }

    public boolean isPreserveWhitespace() {
        return this.preserveWhitespace;
    }

    public void parse(File file) throws SAXException, IOException {
        try (FileInputStream in = new FileInputStream(file);){
            this.parse(in);
        }
    }

    public void parse(InputStream in) throws SAXException, IOException {
        this.parse(new InputSource(in));
    }

    public void parse(Reader reader) throws SAXException, IOException {
        this.parse(new InputSource(reader));
    }

    private synchronized void parse(InputSource inputSource) throws SAXException, IOException {
        SimpleSAXDefaultHandler handler = new SimpleSAXDefaultHandler();
        this.xmlReader.setContentHandler(handler);
        this.xmlReader.setErrorHandler(handler);
        this.xmlReader.parse(inputSource);
    }

    class SimpleSAXDefaultHandler
    extends DefaultHandler {
        private StringBuilder charBuf = new StringBuilder(512);
        private String deferredStartTag = null;
        private Map<String, String> deferredAttributes = null;

        @Override
        public void startDocument() throws SAXException {
            OWLAPISimpleSAXParser.this.listener.startDocument();
        }

        @Override
        public void endDocument() throws SAXException {
            OWLAPISimpleSAXParser.this.listener.endDocument();
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.charBuf.append(ch, start, length);
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes attributes) throws SAXException {
            if (this.deferredStartTag != null) {
                this.reportDeferredStartElement();
            }
            this.deferredStartTag = localName;
            int attCount = attributes.getLength();
            if (attCount == 0) {
                this.deferredAttributes = Collections.emptyMap();
            } else {
                this.deferredAttributes = new LinkedHashMap<String, String>(attCount * 2);
                for (int i = 0; i < attCount; ++i) {
                    this.deferredAttributes.put(attributes.getQName(i), attributes.getValue(i));
                }
            }
            this.charBuf.setLength(0);
        }

        private void reportDeferredStartElement() throws SAXException {
            OWLAPISimpleSAXParser.this.listener.startTag(this.deferredStartTag, this.deferredAttributes, "");
            this.deferredStartTag = null;
            this.deferredAttributes = null;
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (this.deferredStartTag != null) {
                String text = this.charBuf.toString();
                if (!OWLAPISimpleSAXParser.this.preserveWhitespace) {
                    text = text.trim();
                }
                OWLAPISimpleSAXParser.this.listener.startTag(this.deferredStartTag, this.deferredAttributes, text);
                this.deferredStartTag = null;
                this.deferredAttributes = null;
            }
            OWLAPISimpleSAXParser.this.listener.endTag(localName);
            this.charBuf.setLength(0);
        }
    }
}

