/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rio;

import java.io.InputStream;
import java.io.Reader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.openrdf.model.Resource;
import org.openrdf.model.ValueFactory;
import org.openrdf.rio.helpers.AbstractRDFParser;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.ReaderDocumentSource;
import org.semanticweb.owlapi.io.StreamDocumentSource;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManagerFactory;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.rio.OWLAPIRDFFormat;
import org.semanticweb.owlapi.rio.RioRenderer;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public class RioOWLRDFParser
extends AbstractRDFParser {
    private final OWLAPIRDFFormat owlFormat;
    private final Set<OWLOntologyManagerFactory> ontologyManagerFactories = new HashSet<OWLOntologyManagerFactory>();

    public RioOWLRDFParser(OWLAPIRDFFormat owlFormat) {
        this.owlFormat = owlFormat;
    }

    public RioOWLRDFParser(OWLAPIRDFFormat owlFormat, ValueFactory valueFactory) {
        super(valueFactory);
        this.owlFormat = owlFormat;
    }

    @Inject
    public void setOntologyManagerFactories(Set<OWLOntologyManagerFactory> factories) {
        this.ontologyManagerFactories.clear();
        this.ontologyManagerFactories.addAll(factories);
    }

    public OWLAPIRDFFormat getRDFFormat() {
        return this.owlFormat;
    }

    public void parse(@Nullable InputStream in, @Nullable String baseURI) {
        OWLDocumentFormat nextFormat = this.getRDFFormat().getOWLFormat();
        String mime = this.getRDFFormat().getDefaultMIMEType();
        IRI iri = IRI.create((String)((String)OWLAPIPreconditions.checkNotNull((Object)baseURI)));
        this.render((OWLOntologyDocumentSource)new StreamDocumentSource((InputStream)OWLAPIPreconditions.checkNotNull((Object)in), iri, nextFormat, mime));
    }

    void render(OWLOntologyDocumentSource source) {
        if (this.ontologyManagerFactories.isEmpty()) {
            throw new OWLRuntimeException("No ontology manager factories available, parsing is impossible");
        }
        try {
            Iterator<OWLOntologyManagerFactory> iterator = this.ontologyManagerFactories.iterator();
            if (iterator.hasNext()) {
                OWLOntologyManagerFactory f = iterator.next();
                OWLOntology ontology = f.get().loadOntologyFromOntologyDocument(source);
                new RioRenderer(ontology, this.getRDFHandler(), this.getRDFFormat().getOWLFormat(), new Resource[0]).render();
                return;
            }
        }
        catch (OWLOntologyCreationException e) {
            throw new OWLRuntimeException((Throwable)e);
        }
    }

    public void parse(@Nullable Reader reader, @Nullable String baseURI) {
        OWLDocumentFormat nextFormat = this.getRDFFormat().getOWLFormat();
        String mime = this.getRDFFormat().getDefaultMIMEType();
        IRI iri = IRI.create((String)((String)OWLAPIPreconditions.checkNotNull((Object)baseURI)));
        this.render((OWLOntologyDocumentSource)new ReaderDocumentSource((Reader)OWLAPIPreconditions.checkNotNull((Object)reader), iri, nextFormat, mime));
    }
}

