/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.manchestersyntax.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.semanticweb.owlapi.expression.OWLEntityChecker;
import org.semanticweb.owlapi.expression.OWLOntologyChecker;
import org.semanticweb.owlapi.formats.ManchesterSyntaxDocumentFormat;
import org.semanticweb.owlapi.io.XMLUtils;
import org.semanticweb.owlapi.manchestersyntax.parser.ManchesterOWLSyntax;
import org.semanticweb.owlapi.manchestersyntax.parser.ManchesterOWLSyntaxOntologyHeader;
import org.semanticweb.owlapi.manchestersyntax.parser.ManchesterOWLSyntaxTokenizer;
import org.semanticweb.owlapi.manchestersyntax.renderer.ParserException;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.AddOntologyAnnotation;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyCharacteristicAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitor;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyCharacteristicAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OntologyConfigurator;
import org.semanticweb.owlapi.model.PrefixManager;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.model.SWRLIndividualArgument;
import org.semanticweb.owlapi.model.SWRLLiteralArgument;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.semanticweb.owlapi.model.SetOntologyID;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.DefaultPrefixManager;
import org.semanticweb.owlapi.util.NamespaceUtil;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OntologyAxiomPair;
import org.semanticweb.owlapi.util.RemappingIndividualProvider;
import org.semanticweb.owlapi.util.mansyntax.ManchesterOWLSyntaxParser;
import org.semanticweb.owlapi.vocab.Namespaces;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import org.semanticweb.owlapi.vocab.OWLFacet;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;
import org.semanticweb.owlapi.vocab.SWRLBuiltInsVocabulary;
import org.semanticweb.owlapi.vocab.XSDVocabulary;

public class ManchesterOWLSyntaxParserImpl
implements ManchesterOWLSyntaxParser {
    private static final String INFINITY = "Infinity";
    private OWLOntologyLoaderConfiguration loaderConfig;
    protected OWLDataFactory df;
    private final List<ManchesterOWLSyntaxTokenizer.Token> tokens = new ArrayList<ManchesterOWLSyntaxTokenizer.Token>();
    private int tokenIndex;
    private OWLEntityChecker checker;
    private OWLOntologyChecker owlOntologyChecker = name -> null;
    private final Map<ManchesterOWLSyntax, AnnAxiom<OWLClass, ?>> classFrameSections = new EnumMap(ManchesterOWLSyntax.class);
    protected final Set<String> classNames = new HashSet<String>();
    protected final Set<String> objectPropertyNames = new HashSet<String>();
    protected final Set<String> dataPropertyNames = new HashSet<String>();
    protected final Set<String> individualNames = new HashSet<String>();
    protected final Set<String> dataTypeNames = new HashSet<String>();
    protected final Set<String> annotationPropertyNames = new HashSet<String>();
    private final Map<String, SWRLBuiltInsVocabulary> ruleBuiltIns = new TreeMap<String, SWRLBuiltInsVocabulary>();
    protected final DefaultPrefixManager pm = new DefaultPrefixManager();
    protected final Set<ManchesterOWLSyntax> potentialKeywords = new HashSet<ManchesterOWLSyntax>();
    @Nullable
    private OWLOntology defaultOntology;
    private static final boolean ALLOWEMPTYFRAMESECTIONS = false;
    private final Map<ManchesterOWLSyntax, AnnAxiom<OWLDataProperty, ?>> dataPropertyFrameSections = new EnumMap(ManchesterOWLSyntax.class);
    private final Map<ManchesterOWLSyntax, AnnAxiom<OWLObjectProperty, ?>> objectPropertyFrameSections = new EnumMap(ManchesterOWLSyntax.class);
    private final Map<ManchesterOWLSyntax, AnnAxiom<OWLAnnotationProperty, ?>> annotationPropertyFrameSections = new EnumMap(ManchesterOWLSyntax.class);
    private final Map<ManchesterOWLSyntax, AnnAxiom<OWLIndividual, ?>> individualFrameSections = new EnumMap(ManchesterOWLSyntax.class);
    protected RemappingIndividualProvider anonProvider;
    private final Map<String, IRI> nameIRIMap = new HashMap<String, IRI>();

    @Inject
    public ManchesterOWLSyntaxParserImpl(OntologyConfigurator configurationProvider, OWLDataFactory dataFactory) {
        this.loaderConfig = configurationProvider.buildLoaderConfiguration();
        this.df = dataFactory;
        this.anonProvider = new RemappingIndividualProvider(configurationProvider, this.df);
        this.pm.setPrefix("rdf:", Namespaces.RDF.toString());
        this.pm.setPrefix("rdfs:", Namespaces.RDFS.toString());
        this.pm.setPrefix("owl:", Namespaces.OWL.toString());
        this.pm.setPrefix("dc:", "http://purl.org/dc/elements/1.1/");
        NamespaceUtil u = new NamespaceUtil();
        this.initialiseClassFrameSections();
        this.initialiseObjectPropertyFrameSections();
        this.initialiseDataPropertyFrameSections();
        this.initialiseAnnotationPropertyFrameSections();
        this.initialiseIndividualFrameSections();
        for (XSDVocabulary xSDVocabulary : XSDVocabulary.values()) {
            this.dataTypeNames.add(xSDVocabulary.getIRI().toString());
            this.dataTypeNames.add(xSDVocabulary.getIRI().toQuotedString());
            this.dataTypeNames.add(xSDVocabulary.getPrefixedName());
        }
        for (XSDVocabulary xSDVocabulary : OWL2Datatype.values()) {
            this.dataTypeNames.add(xSDVocabulary.getIRI().toString());
            this.dataTypeNames.add(xSDVocabulary.getIRI().toQuotedString());
            this.dataTypeNames.add(xSDVocabulary.getPrefixedName());
        }
        this.dataTypeNames.add(OWLRDFVocabulary.RDFS_LITERAL.getPrefixedName());
        this.dataTypeNames.add(OWLRDFVocabulary.RDF_XML_LITERAL.getShortForm());
        this.dataTypeNames.add(OWLRDFVocabulary.RDF_XML_LITERAL.getPrefixedName());
        for (IRI iri : OWLRDFVocabulary.BUILT_IN_AP_IRIS) {
            String string = iri.toString();
            String string2 = XMLUtils.getNCNamePrefix((CharSequence)string);
            String fragment = XMLUtils.getNCNameSuffix((CharSequence)string);
            this.annotationPropertyNames.add(u.getPrefix(string2) + ':' + (fragment != null ? fragment : ""));
        }
        this.checker = new DefaultEntityChecker();
        for (SWRLBuiltInsVocabulary sWRLBuiltInsVocabulary : SWRLBuiltInsVocabulary.values()) {
            this.ruleBuiltIns.put(sWRLBuiltInsVocabulary.getShortForm(), sWRLBuiltInsVocabulary);
            this.ruleBuiltIns.put(sWRLBuiltInsVocabulary.getIRI().toQuotedString(), sWRLBuiltInsVocabulary);
        }
    }

    public PrefixManager getPrefixManager() {
        return this.pm;
    }

    public OWLOntologyLoaderConfiguration getOntologyLoaderConfiguration() {
        return this.loaderConfig;
    }

    public void setOntologyLoaderConfiguration(OWLOntologyLoaderConfiguration conf) {
        this.loaderConfig = conf;
    }

    public void setStringToParse(String s) {
        this.tokens.clear();
        this.tokens.addAll(ManchesterOWLSyntaxParserImpl.getTokenizer(s).tokenize());
        this.tokenIndex = 0;
    }

    protected static ManchesterOWLSyntaxTokenizer getTokenizer(String s) {
        return new ManchesterOWLSyntaxTokenizer(s);
    }

    private void initialiseClassFrameSections() {
        ManchesterOWLSyntaxParserImpl.initialiseSection(new AnnAxiom<OWLClass, OWLAnnotation>(x -> this.parseAnnotation(), ManchesterOWLSyntax.ANNOTATIONS, (s, o, anns) -> this.df.getOWLAnnotationAssertionAxiom((OWLAnnotationSubject)s.getIRI(), o, anns)), this.classFrameSections, new ManchesterOWLSyntax[0]);
        ManchesterOWLSyntaxParserImpl.initialiseSection(new AnnAxiom<OWLClass, OWLClassExpression>(x -> this.parseUnion(), ManchesterOWLSyntax.SUBCLASS_OF, (s, o, anns) -> this.df.getOWLSubClassOfAxiom((OWLClassExpression)s, o, anns)), this.classFrameSections, new ManchesterOWLSyntax[0]);
        ManchesterOWLSyntaxParserImpl.initialiseSection(new AnnAxiom<OWLClass, OWLClassExpression>(x -> this.parseUnion(), ManchesterOWLSyntax.EQUIVALENT_TO, (s, o, anns) -> this.df.getOWLEquivalentClassesAxiom((OWLClassExpression)s, o, anns)), this.classFrameSections, new ManchesterOWLSyntax[0]);
        ManchesterOWLSyntaxParserImpl.initialiseSection(new AnnAxiom<OWLClass, OWLClassExpression>(x -> this.parseUnion(), ManchesterOWLSyntax.DISJOINT_WITH, (s, o, anns) -> this.df.getOWLDisjointClassesAxiom((OWLClassExpression)s, o, anns)), this.classFrameSections, new ManchesterOWLSyntax[0]);
        ManchesterOWLSyntaxParserImpl.initialiseSection(new AnnAxiom<OWLClass, Set>(x -> this.parsePropertyList(), ManchesterOWLSyntax.HAS_KEY, (s, o, anns) -> this.df.getOWLHasKeyAxiom((OWLClassExpression)s, (Collection)o, anns)), this.classFrameSections, new ManchesterOWLSyntax[0]);
        ManchesterOWLSyntaxParserImpl.initialiseSection(new AnnAxiom<OWLClass, Set>(x -> this.parseClassExpressionList(), ManchesterOWLSyntax.DISJOINT_UNION_OF, (s, o, anns) -> this.df.getOWLDisjointUnionAxiom(s, (Collection)o, anns)), this.classFrameSections, new ManchesterOWLSyntax[0]);
        ManchesterOWLSyntaxParserImpl.initialiseSection(new AnnAxiom<OWLClass, OWLClassExpression>(x -> this.parseUnion(), ManchesterOWLSyntax.SUPERCLASS_OF, (s, o, anns) -> this.df.getOWLSubClassOfAxiom(o, (OWLClassExpression)s, anns)), this.classFrameSections, new ManchesterOWLSyntax[0]);
        ManchesterOWLSyntaxParserImpl.initialiseSection(new AnnAxiom<OWLClass, Set>(x -> this.parseClassExpressionList(), ManchesterOWLSyntax.DISJOINT_CLASSES, (s, o, anns) -> this.df.getOWLDisjointClassesAxiom((Collection)o, anns)), this.classFrameSections, new ManchesterOWLSyntax[0]);
        ManchesterOWLSyntaxParserImpl.initialiseSection(new AnnAxiom<OWLClass, OWLIndividual>(x -> this.parseIndividual(), ManchesterOWLSyntax.INDIVIDUALS, (s, o, anns) -> this.df.getOWLClassAssertionAxiom((OWLClassExpression)s, o, anns)), this.classFrameSections, new ManchesterOWLSyntax[0]);
    }

    private void initialiseObjectPropertyFrameSections() {
        ManchesterOWLSyntaxParserImpl.initialiseSection(new AnnAxiom<OWLObjectProperty, OWLAnnotation>(x -> this.parseAnnotation(), ManchesterOWLSyntax.ANNOTATIONS, (s, o, anns) -> this.df.getOWLAnnotationAssertionAxiom((OWLAnnotationSubject)s.getIRI(), o, anns)), this.objectPropertyFrameSections, new ManchesterOWLSyntax[0]);
        ManchesterOWLSyntaxParserImpl.initialiseSection(new AnnAxiom<OWLObjectProperty, OWLObjectPropertyExpression>(x -> this.parseObjectPropertyExpression(false), ManchesterOWLSyntax.SUB_PROPERTY_OF, (s, o, anns) -> this.df.getOWLSubObjectPropertyOfAxiom((OWLObjectPropertyExpression)s, o, anns)), this.objectPropertyFrameSections, new ManchesterOWLSyntax[0]);
        ManchesterOWLSyntaxParserImpl.initialiseSection(new AnnAxiom<OWLObjectProperty, OWLObjectPropertyExpression>(x -> this.parseObjectPropertyExpression(false), ManchesterOWLSyntax.EQUIVALENT_TO, (s, o, anns) -> this.df.getOWLEquivalentObjectPropertiesAxiom((OWLObjectPropertyExpression)s, o, anns)), this.objectPropertyFrameSections, new ManchesterOWLSyntax[0]);
        ManchesterOWLSyntaxParserImpl.initialiseSection(new AnnAxiom<OWLObjectProperty, OWLObjectPropertyExpression>(x -> this.parseObjectPropertyExpression(false), ManchesterOWLSyntax.DISJOINT_WITH, (s, o, anns) -> this.df.getOWLDisjointObjectPropertiesAxiom((OWLObjectPropertyExpression)s, o, anns)), this.objectPropertyFrameSections, new ManchesterOWLSyntax[0]);
        ManchesterOWLSyntaxParserImpl.initialiseSection(new AnnAxiom<OWLObjectProperty, OWLClassExpression>(x -> this.parseUnion(), ManchesterOWLSyntax.DOMAIN, (s, o, anns) -> this.df.getOWLObjectPropertyDomainAxiom((OWLObjectPropertyExpression)s, o, anns)), this.objectPropertyFrameSections, new ManchesterOWLSyntax[0]);
        ManchesterOWLSyntaxParserImpl.initialiseSection(new AnnAxiom<OWLObjectProperty, OWLClassExpression>(x -> this.parseUnion(), ManchesterOWLSyntax.RANGE, (s, o, anns) -> this.df.getOWLObjectPropertyRangeAxiom((OWLObjectPropertyExpression)s, o, anns)), this.objectPropertyFrameSections, new ManchesterOWLSyntax[0]);
        ManchesterOWLSyntaxParserImpl.initialiseSection(new AnnAxiom<OWLObjectProperty, OWLObjectPropertyExpression>(x -> this.parseObjectPropertyExpression(false), ManchesterOWLSyntax.INVERSE_OF, (s, o, anns) -> this.df.getOWLInverseObjectPropertiesAxiom((OWLObjectPropertyExpression)s, o, anns)), this.objectPropertyFrameSections, new ManchesterOWLSyntax[0]);
        ManchesterOWLSyntaxParserImpl.initialiseSection(new AnnAxiom<OWLObjectProperty, OWLObjectPropertyCharacteristicAxiom>(this::parseObjectPropertyCharacteristic, ManchesterOWLSyntax.CHARACTERISTICS, (s, o, anns) -> o.getAnnotatedAxiom(anns)), this.objectPropertyFrameSections, new ManchesterOWLSyntax[0]);
        ManchesterOWLSyntaxParserImpl.initialiseSection(new AnnAxiom<OWLObjectProperty, List>(x -> this.parseObjectPropertyChain(), ManchesterOWLSyntax.SUB_PROPERTY_CHAIN, (s, o, anns) -> this.df.getOWLSubPropertyChainOfAxiom(o, (OWLObjectPropertyExpression)s, anns)), this.objectPropertyFrameSections, new ManchesterOWLSyntax[0]);
        ManchesterOWLSyntaxParserImpl.initialiseSection(new AnnAxiom<OWLObjectProperty, OWLObjectPropertyExpression>(x -> this.parseObjectPropertyExpression(false), ManchesterOWLSyntax.SUPER_PROPERTY_OF, (s, o, anns) -> this.df.getOWLSubObjectPropertyOfAxiom(o, (OWLObjectPropertyExpression)s, anns)), this.objectPropertyFrameSections, new ManchesterOWLSyntax[0]);
    }

    private void initialiseDataPropertyFrameSections() {
        ManchesterOWLSyntaxParserImpl.initialiseSection(new AnnAxiom<OWLDataProperty, OWLDataPropertyExpression>(x -> this.parseDataProperty(), ManchesterOWLSyntax.SUB_PROPERTY_OF, (s, o, anns) -> this.df.getOWLSubDataPropertyOfAxiom((OWLDataPropertyExpression)s, o, anns)), this.dataPropertyFrameSections, new ManchesterOWLSyntax[0]);
        ManchesterOWLSyntaxParserImpl.initialiseSection(new AnnAxiom<OWLDataProperty, OWLDataPropertyExpression>(x -> this.parseDataProperty(), ManchesterOWLSyntax.EQUIVALENT_TO, (s, o, anns) -> this.df.getOWLEquivalentDataPropertiesAxiom((OWLDataPropertyExpression)s, o, anns)), this.dataPropertyFrameSections, new ManchesterOWLSyntax[0]);
        ManchesterOWLSyntaxParserImpl.initialiseSection(new AnnAxiom<OWLDataProperty, OWLDataPropertyExpression>(x -> this.parseDataProperty(), ManchesterOWLSyntax.DISJOINT_WITH, (s, o, anns) -> this.df.getOWLDisjointDataPropertiesAxiom((OWLDataPropertyExpression)s, o, anns)), this.dataPropertyFrameSections, new ManchesterOWLSyntax[0]);
        ManchesterOWLSyntaxParserImpl.initialiseSection(new AnnAxiom<OWLDataProperty, OWLClassExpression>(x -> this.parseUnion(), ManchesterOWLSyntax.DOMAIN, (s, o, anns) -> this.df.getOWLDataPropertyDomainAxiom((OWLDataPropertyExpression)s, o, anns)), this.dataPropertyFrameSections, new ManchesterOWLSyntax[0]);
        ManchesterOWLSyntaxParserImpl.initialiseSection(new AnnAxiom<OWLDataProperty, OWLDataRange>(x -> this.parseDataRange(), ManchesterOWLSyntax.RANGE, (s, o, anns) -> this.df.getOWLDataPropertyRangeAxiom((OWLDataPropertyExpression)s, o, anns)), this.dataPropertyFrameSections, new ManchesterOWLSyntax[0]);
        ManchesterOWLSyntaxParserImpl.initialiseSection(new AnnAxiom<OWLDataProperty, OWLDataPropertyCharacteristicAxiom>(this::parseDataPropertyCharacteristic, ManchesterOWLSyntax.CHARACTERISTICS, (s, o, anns) -> o.getAnnotatedAxiom(anns)), this.dataPropertyFrameSections, new ManchesterOWLSyntax[0]);
        ManchesterOWLSyntaxParserImpl.initialiseSection(new AnnAxiom<OWLDataProperty, OWLAnnotation>(x -> this.parseAnnotation(), ManchesterOWLSyntax.ANNOTATIONS, (s, o, anns) -> this.df.getOWLAnnotationAssertionAxiom((OWLAnnotationSubject)s.getIRI(), o, anns)), this.dataPropertyFrameSections, new ManchesterOWLSyntax[0]);
    }

    private void initialiseAnnotationPropertyFrameSections() {
        ManchesterOWLSyntaxParserImpl.initialiseSection(new AnnAxiom<OWLAnnotationProperty, OWLAnnotationProperty>(x -> this.parseAnnotationProperty(), ManchesterOWLSyntax.SUB_PROPERTY_OF, (s, o, anns) -> this.df.getOWLSubAnnotationPropertyOfAxiom(s, o, anns)), this.annotationPropertyFrameSections, new ManchesterOWLSyntax[0]);
        ManchesterOWLSyntaxParserImpl.initialiseSection(new AnnAxiom<OWLAnnotationProperty, IRI>(x -> this.parseIRI(), ManchesterOWLSyntax.DOMAIN, (s, o, anns) -> this.df.getOWLAnnotationPropertyDomainAxiom(s, o, anns)), this.annotationPropertyFrameSections, new ManchesterOWLSyntax[0]);
        ManchesterOWLSyntaxParserImpl.initialiseSection(new AnnAxiom<OWLAnnotationProperty, IRI>(x -> this.parseIRI(), ManchesterOWLSyntax.RANGE, (s, o, anns) -> this.df.getOWLAnnotationPropertyRangeAxiom(s, o, anns)), this.annotationPropertyFrameSections, new ManchesterOWLSyntax[0]);
        ManchesterOWLSyntaxParserImpl.initialiseSection(new AnnAxiom<OWLAnnotationProperty, OWLAnnotation>(x -> this.parseAnnotation(), ManchesterOWLSyntax.ANNOTATIONS, (s, o, anns) -> this.df.getOWLAnnotationAssertionAxiom((OWLAnnotationSubject)s.getIRI(), o, anns)), this.annotationPropertyFrameSections, new ManchesterOWLSyntax[0]);
    }

    private void initialiseIndividualFrameSections() {
        ManchesterOWLSyntaxParserImpl.initialiseSection(new AnnAxiom<OWLIndividual, OWLAnnotation>(x -> this.parseAnnotation(), ManchesterOWLSyntax.ANNOTATIONS, (s, o, anns) -> ManchesterOWLSyntaxParserImpl.create(this.df, s, o, (Collection<OWLAnnotation>)anns)), this.individualFrameSections, new ManchesterOWLSyntax[0]);
        ManchesterOWLSyntaxParserImpl.initialiseSection(new AnnAxiom<OWLIndividual, OWLClassExpression>(x -> this.parseUnion(), ManchesterOWLSyntax.TYPES, (s, o, anns) -> this.df.getOWLClassAssertionAxiom(o, s, anns)), this.individualFrameSections, new ManchesterOWLSyntax[0]);
        ManchesterOWLSyntaxParserImpl.initialiseSection(new AnnAxiom<OWLIndividual, OWLAxiom>(this::parseFact, ManchesterOWLSyntax.FACTS, (s, o, anns) -> o.getAnnotatedAxiom(anns)), this.individualFrameSections, new ManchesterOWLSyntax[0]);
        ManchesterOWLSyntaxParserImpl.initialiseSection(new AnnAxiom<OWLIndividual, OWLIndividual>(x -> this.parseIndividual(), ManchesterOWLSyntax.SAME_AS, (s, o, anns) -> this.df.getOWLSameIndividualAxiom(s, o, anns)), this.individualFrameSections, new ManchesterOWLSyntax[0]);
        ManchesterOWLSyntaxParserImpl.initialiseSection(new AnnAxiom<OWLIndividual, OWLIndividual>(x -> this.parseIndividual(), ManchesterOWLSyntax.DIFFERENT_FROM, (s, o, anns) -> this.df.getOWLDifferentIndividualsAxiom(s, o, anns)), this.individualFrameSections, new ManchesterOWLSyntax[0]);
        ManchesterOWLSyntaxParserImpl.initialiseSection(new AnnAxiom<OWLIndividual, Set>(x -> this.parseIndividualList(), ManchesterOWLSyntax.DIFFERENT_INDIVIDUALS, (s, o, anns) -> ManchesterOWLSyntaxParserImpl.create(this.df, s, o, (Collection<OWLAnnotation>)anns)), this.individualFrameSections, new ManchesterOWLSyntax[0]);
    }

    public void setOWLEntityChecker(OWLEntityChecker owlEntityChecker) {
        this.checker = owlEntityChecker;
    }

    private boolean isOntologyName(String name) {
        return this.owlOntologyChecker.getOntology(name) != null;
    }

    private boolean isClassName(String name) {
        return this.classNames.contains(name) || this.checker.getOWLClass(name) != null;
    }

    @Nullable
    private OWLOntology getOntology(@Nullable String name) {
        return this.owlOntologyChecker.getOntology(name);
    }

    public void setOWLOntologyChecker(OWLOntologyChecker owlOntologyChecker) {
        this.owlOntologyChecker = owlOntologyChecker;
    }

    private boolean isObjectPropertyName(String name) {
        return this.objectPropertyNames.contains(name) || this.checker.getOWLObjectProperty(name) != null;
    }

    private boolean isAnnotationPropertyName(String name) {
        return this.annotationPropertyNames.contains(name) || this.checker.getOWLAnnotationProperty(name) != null;
    }

    private boolean isDataPropertyName(String name) {
        return this.dataPropertyNames.contains(name) || this.checker.getOWLDataProperty(name) != null;
    }

    private boolean isIndividualName(String name) {
        return this.individualNames.contains(name) || this.checker.getOWLIndividual(name) != null;
    }

    private boolean isDatatypeName(String name) {
        return this.dataTypeNames.contains(name) || this.checker.getOWLDatatype(name) != null;
    }

    private boolean isSWRLBuiltin(String name) {
        return this.ruleBuiltIns.containsKey(name);
    }

    private OWLClass getOWLClass(String name) {
        OWLClass cls = this.checker.getOWLClass(name);
        if (cls == null && this.classNames.contains(name)) {
            cls = this.df.getOWLClass(this.getIRI(name));
        }
        if (cls == null) {
            throw new ExceptionBuilder().withKeyword(this.potentialKeywords).withClass().build();
        }
        return cls;
    }

    private OWLObjectProperty getOWLObjectProperty(String name) {
        OWLObjectProperty prop = this.checker.getOWLObjectProperty(name);
        if (prop == null && this.objectPropertyNames.contains(name)) {
            prop = this.df.getOWLObjectProperty(this.getIRI(name));
        }
        if (prop == null) {
            throw new ExceptionBuilder().withObject().build();
        }
        return prop;
    }

    private OWLIndividual getOWLIndividual(String name) {
        if (name.startsWith("_:")) {
            return this.anonProvider.getOWLAnonymousIndividual(name);
        }
        return this.getOWLNamedIndividual(name);
    }

    private OWLNamedIndividual getOWLNamedIndividual(String name) {
        OWLNamedIndividual ind = this.checker.getOWLIndividual(name);
        if (ind == null && this.individualNames.contains(name)) {
            ind = this.df.getOWLNamedIndividual(this.getIRI(name));
        }
        if (ind == null) {
            throw new ExceptionBuilder().withInd().build();
        }
        return ind;
    }

    private OWLDataProperty getOWLDataProperty(String name) {
        OWLDataProperty prop = this.checker.getOWLDataProperty(name);
        if (prop == null && this.dataPropertyNames.contains(name)) {
            prop = this.df.getOWLDataProperty(this.getIRI(name));
        }
        if (prop == null) {
            throw new ExceptionBuilder().withData().build();
        }
        return prop;
    }

    private OWLDatatype getOWLDatatype(String name) {
        OWLDatatype dt = this.checker.getOWLDatatype(name);
        if (dt == null && this.dataTypeNames.contains(name)) {
            dt = this.df.getOWLDatatype(this.getIRI(name));
        }
        if (dt == null) {
            throw new ExceptionBuilder().withDt().build();
        }
        return dt;
    }

    private OWLAnnotationProperty getOWLAnnotationProperty(String name) {
        OWLAnnotationProperty prop = this.checker.getOWLAnnotationProperty(name);
        if (prop == null && this.annotationPropertyNames.contains(name)) {
            prop = this.df.getOWLAnnotationProperty(this.getIRI(name));
        }
        if (prop == null) {
            throw new ExceptionBuilder().withAnn().build();
        }
        return prop;
    }

    protected ManchesterOWLSyntaxTokenizer.Token getLastToken() {
        if (this.tokenIndex - 1 > -1) {
            return this.tokens.get(this.tokenIndex - 1);
        }
        return this.tokens.get(0);
    }

    private String peekToken() {
        return this.getToken().getToken();
    }

    private String consumeToken() {
        String token = this.getToken().getToken();
        if (this.tokenIndex < this.tokens.size()) {
            ++this.tokenIndex;
        }
        return token;
    }

    private void consumeToken(String expected) {
        String tok = this.consumeToken();
        if (!tok.equals(expected)) {
            throw new ExceptionBuilder().withKeyword(expected).build();
        }
    }

    private void consumeToken(ManchesterOWLSyntax expected) {
        String tok = this.consumeToken();
        if (!expected.matches(tok)) {
            throw new ExceptionBuilder().withKeyword(expected).build();
        }
    }

    private ManchesterOWLSyntaxTokenizer.Token getToken() {
        return this.tokens.get(this.tokenIndex < this.tokens.size() ? this.tokenIndex : this.tokenIndex - 1);
    }

    public OWLClassExpression parseClassExpression() {
        OWLClassExpression desc = this.parseUnion();
        if (!ManchesterOWLSyntaxTokenizer.eof(this.consumeToken())) {
            throw new ExceptionBuilder().withKeyword("|EOF|").build();
        }
        return desc;
    }

    protected OWLClassExpression parseIntersection() {
        HashSet<OWLClassExpression> ops = new HashSet<OWLClassExpression>();
        String kw = ManchesterOWLSyntax.AND.keyword();
        while (ManchesterOWLSyntax.AND.matches(kw)) {
            this.potentialKeywords.remove((Object)ManchesterOWLSyntax.AND);
            ops.add(this.parseNonNaryClassExpression());
            this.potentialKeywords.add(ManchesterOWLSyntax.AND);
            kw = this.peekToken();
            if (ManchesterOWLSyntax.AND.matches(kw)) {
                kw = this.consumeToken();
                continue;
            }
            if (!ManchesterOWLSyntax.THAT.matches(kw)) continue;
            this.consumeToken();
            kw = ManchesterOWLSyntax.AND.keyword();
        }
        if (ops.size() == 1) {
            return (OWLClassExpression)ops.iterator().next();
        }
        return this.df.getOWLObjectIntersectionOf(ops);
    }

    protected OWLClassExpression parseUnion() {
        HashSet<OWLClassExpression> ops = new HashSet<OWLClassExpression>();
        String kw = ManchesterOWLSyntax.OR.keyword();
        while (ManchesterOWLSyntax.OR.matches(kw)) {
            this.potentialKeywords.remove((Object)ManchesterOWLSyntax.OR);
            ops.add(this.parseIntersection());
            this.potentialKeywords.add(ManchesterOWLSyntax.OR);
            kw = this.peekToken();
            if (!ManchesterOWLSyntax.OR.matches(kw)) continue;
            kw = this.consumeToken();
        }
        if (ops.size() == 1) {
            return (OWLClassExpression)ops.iterator().next();
        }
        return this.df.getOWLObjectUnionOf(ops);
    }

    protected OWLObjectPropertyExpression parseObjectPropertyExpression(boolean allowUndeclared) {
        String tok = this.consumeToken();
        if (ManchesterOWLSyntax.INVERSE.matches(tok)) {
            String close;
            OWLObjectPropertyExpression prop;
            String open = this.peekToken();
            boolean brackets = false;
            if (ManchesterOWLSyntax.OPEN.matches(open)) {
                this.consumeToken();
                brackets = true;
            }
            if ((prop = this.parseObjectPropertyExpression(false)).isAnonymous()) {
                throw new ExceptionBuilder().withKeyword("Inverse construct uses nested object property expression, but object property only is allowed").build();
            }
            if (brackets && !ManchesterOWLSyntax.CLOSE.matches(close = this.consumeToken())) {
                throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.CLOSE).build();
            }
            return this.df.getOWLObjectInverseOf(prop.asOWLObjectProperty());
        }
        if (!allowUndeclared && !this.isObjectPropertyName(tok)) {
            throw new ExceptionBuilder().withObject().build();
        }
        return this.getOWLObjectProperty(tok);
    }

    private OWLPropertyExpression parsePropertyExpression() {
        String tok = this.peekToken();
        if (this.isObjectPropertyName(tok)) {
            return this.parseObjectPropertyExpression(false);
        }
        if (ManchesterOWLSyntax.INVERSE.matches(tok)) {
            return this.parseObjectPropertyExpression(false);
        }
        if (this.isDataPropertyName(tok)) {
            return this.parseDataProperty();
        }
        this.consumeToken();
        throw new ExceptionBuilder().withObject().withData().build();
    }

    private OWLClassExpression parseNonNaryClassExpression() {
        String tok = this.peekToken();
        if (ManchesterOWLSyntax.NOT.matches(tok)) {
            this.consumeToken();
            OWLClassExpression complemented = this.parseNestedClassExpression(false);
            return this.df.getOWLObjectComplementOf(complemented);
        }
        if (this.isClassName(tok)) {
            this.consumeToken();
            return this.getOWLClass(tok);
        }
        if (this.isObjectPropertyName(tok) || ManchesterOWLSyntax.INVERSE.matches(tok)) {
            return this.parseObjectRestriction();
        }
        if (this.isDataPropertyName(tok)) {
            return this.parseDataRestriction();
        }
        if (ManchesterOWLSyntax.OPENBRACE.matches(tok)) {
            return this.parseObjectOneOf();
        }
        if (ManchesterOWLSyntax.OPEN.matches(tok)) {
            return this.parseNestedClassExpression(false);
        }
        this.consumeToken();
        throw new ExceptionBuilder().withClass().withObject().withData().withKeyword(ManchesterOWLSyntax.OPEN, ManchesterOWLSyntax.OPENBRACE, ManchesterOWLSyntax.NOT, ManchesterOWLSyntax.INVERSE).build();
    }

    private OWLClassExpression parseObjectRestriction() {
        OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression(false);
        String kw = this.consumeToken();
        if (ManchesterOWLSyntax.SOME.matches(kw)) {
            String possSelfToken = this.peekToken();
            if (ManchesterOWLSyntax.SELF.matches(possSelfToken)) {
                this.consumeToken();
                return this.df.getOWLObjectHasSelf(prop);
            }
            OWLClassExpression filler = null;
            try {
                filler = this.parseNestedClassExpression(false);
            }
            catch (ParserException e) {
                e.getExpectedKeywords().add(ManchesterOWLSyntax.SELF.keyword());
                throw e;
            }
            return this.df.getOWLObjectSomeValuesFrom(prop, filler);
        }
        if (ManchesterOWLSyntax.ONLY.matches(kw)) {
            OWLClassExpression filler = this.parseNestedClassExpression(false);
            return this.df.getOWLObjectAllValuesFrom(prop, filler);
        }
        if (ManchesterOWLSyntax.VALUE.matches(kw)) {
            String indName = this.consumeToken();
            if (!this.isIndividualName(indName)) {
                throw new ExceptionBuilder().withInd().build();
            }
            return this.df.getOWLObjectHasValue(prop, this.getOWLIndividual(indName));
        }
        if (ManchesterOWLSyntax.MIN.matches(kw)) {
            int card = this.parseInteger();
            OWLClassExpression filler = this.parseNestedClassExpression(true);
            return this.df.getOWLObjectMinCardinality(card, prop, filler);
        }
        if (ManchesterOWLSyntax.MAX.matches(kw)) {
            int card = this.parseInteger();
            OWLClassExpression filler = this.parseNestedClassExpression(true);
            return this.df.getOWLObjectMaxCardinality(card, prop, filler);
        }
        if (ManchesterOWLSyntax.EXACTLY.matches(kw)) {
            int card = this.parseInteger();
            OWLClassExpression filler = this.parseNestedClassExpression(true);
            return this.df.getOWLObjectExactCardinality(card, prop, filler);
        }
        if (ManchesterOWLSyntax.ONLYSOME.matches(kw)) {
            String tok = this.peekToken();
            HashSet<OWLClassExpression> descs = new HashSet<OWLClassExpression>();
            if (!ManchesterOWLSyntax.OPENBRACKET.matches(tok)) {
                descs.add(this.parseUnion());
            } else {
                descs.addAll(this.parseClassExpressionList(ManchesterOWLSyntax.OPENBRACKET, ManchesterOWLSyntax.CLOSEBRACKET));
            }
            HashSet<OWLObjectAllValuesFrom> ops = new HashSet<OWLObjectAllValuesFrom>();
            descs.forEach(d -> ops.add((OWLObjectAllValuesFrom)this.df.getOWLObjectSomeValuesFrom(prop, d)));
            Object filler = descs.size() == 1 ? (OWLClassExpression)descs.iterator().next() : this.df.getOWLObjectUnionOf(descs);
            ops.add(this.df.getOWLObjectAllValuesFrom(prop, filler));
            return this.df.getOWLObjectIntersectionOf(ops);
        }
        if (ManchesterOWLSyntax.SELF.matches(kw)) {
            return this.df.getOWLObjectHasSelf(prop);
        }
        throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.SOME, ManchesterOWLSyntax.ONLY, ManchesterOWLSyntax.VALUE, ManchesterOWLSyntax.MIN, ManchesterOWLSyntax.MAX, ManchesterOWLSyntax.EXACTLY, ManchesterOWLSyntax.SELF).build();
    }

    private OWLClassExpression parseDataRestriction() {
        OWLDataProperty prop = this.parseDataProperty();
        String kw = this.consumeToken();
        if (ManchesterOWLSyntax.SOME.matches(kw)) {
            OWLDataRange rng = this.parseDataRange();
            return this.df.getOWLDataSomeValuesFrom((OWLDataPropertyExpression)prop, rng);
        }
        if (ManchesterOWLSyntax.ONLY.matches(kw)) {
            OWLDataRange rng = this.parseDataRange();
            return this.df.getOWLDataAllValuesFrom((OWLDataPropertyExpression)prop, rng);
        }
        if (ManchesterOWLSyntax.VALUE.matches(kw)) {
            OWLLiteral con = this.parseLiteral(null);
            return this.df.getOWLDataHasValue((OWLDataPropertyExpression)prop, con);
        }
        if (ManchesterOWLSyntax.MIN.matches(kw)) {
            int card = this.parseInteger();
            OWLDataRange rng = this.parseDataRange();
            return this.df.getOWLDataMinCardinality(card, (OWLDataPropertyExpression)prop, rng);
        }
        if (ManchesterOWLSyntax.EXACTLY.matches(kw)) {
            int card = this.parseInteger();
            OWLDataRange rng = this.parseDataRange();
            return this.df.getOWLDataExactCardinality(card, (OWLDataPropertyExpression)prop, rng);
        }
        if (ManchesterOWLSyntax.MAX.matches(kw)) {
            int card = this.parseInteger();
            OWLDataRange rng = this.parseDataRange();
            return this.df.getOWLDataMaxCardinality(card, (OWLDataPropertyExpression)prop, rng);
        }
        throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.SOME, ManchesterOWLSyntax.ONLY, ManchesterOWLSyntax.VALUE, ManchesterOWLSyntax.MIN, ManchesterOWLSyntax.EXACTLY, ManchesterOWLSyntax.MAX).build();
    }

    @Nullable
    private OWLFacet parseFacet() {
        String facet = this.consumeToken();
        if (ManchesterOWLSyntax.MIN_INCLUSIVE_FACET.matches(facet, this.peekToken())) {
            this.consumeToken();
            return OWLFacet.MIN_INCLUSIVE;
        }
        if (ManchesterOWLSyntax.MAX_INCLUSIVE_FACET.matches(facet, this.peekToken())) {
            this.consumeToken();
            return OWLFacet.MAX_INCLUSIVE;
        }
        if (ManchesterOWLSyntax.MIN_EXCLUSIVE_FACET.matches(facet)) {
            return OWLFacet.MIN_EXCLUSIVE;
        }
        if (ManchesterOWLSyntax.MAX_EXCLUSIVE_FACET.matches(facet)) {
            return OWLFacet.MAX_EXCLUSIVE;
        }
        return OWLFacet.getFacetBySymbolicName((String)facet);
    }

    private OWLDatatype parseDatatype() {
        String name = this.consumeToken();
        return this.getOWLDatatype(name);
    }

    public OWLDataRange parseDataRange() {
        return this.parseDataIntersectionOf();
    }

    private OWLDataRange parseDataIntersectionOf() {
        String sep = ManchesterOWLSyntax.AND.keyword();
        HashSet<OWLDataRange> ranges = new HashSet<OWLDataRange>();
        while (ManchesterOWLSyntax.AND.matches(sep)) {
            ranges.add(this.parseDataUnionOf());
            sep = this.peekToken();
            if (!ManchesterOWLSyntax.AND.matches(sep)) continue;
            this.consumeToken();
        }
        if (ranges.isEmpty()) {
            return this.df.getTopDatatype();
        }
        if (ranges.size() == 1) {
            return (OWLDataRange)ranges.iterator().next();
        }
        return this.df.getOWLDataIntersectionOf(ranges);
    }

    private OWLDataRange parseDataUnionOf() {
        String sep = ManchesterOWLSyntax.OR.keyword();
        HashSet<OWLDataRange> ranges = new HashSet<OWLDataRange>();
        while (ManchesterOWLSyntax.OR.matches(sep)) {
            ranges.add(this.parseDataRangePrimary());
            sep = this.peekToken();
            if (!ManchesterOWLSyntax.OR.matches(sep)) continue;
            this.consumeToken();
        }
        if (ranges.size() == 1) {
            return (OWLDataRange)ranges.iterator().next();
        }
        return this.df.getOWLDataUnionOf(ranges);
    }

    private OWLDataRange parseDataRangePrimary() {
        String tok = this.peekToken();
        if (this.isDatatypeName(tok)) {
            this.consumeToken();
            OWLDatatype datatype = this.getOWLDatatype(tok);
            String next = this.peekToken();
            if (ManchesterOWLSyntax.OPENBRACKET.matches(next)) {
                this.consumeToken();
                String sep = ManchesterOWLSyntax.COMMA.keyword();
                HashSet<OWLFacetRestriction> facetRestrictions = new HashSet<OWLFacetRestriction>();
                while (ManchesterOWLSyntax.COMMA.matches(sep)) {
                    OWLFacet fv = this.parseFacet();
                    if (fv == null) {
                        throw new ExceptionBuilder().withKeyword(OWLFacet.getFacets()).build();
                    }
                    OWLLiteral con = this.parseLiteral(datatype);
                    facetRestrictions.add(this.df.getOWLFacetRestriction(fv, con));
                    sep = this.consumeToken();
                }
                if (!ManchesterOWLSyntax.CLOSEBRACKET.matches(sep)) {
                    throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.CLOSEBRACKET).build();
                }
                return this.df.getOWLDatatypeRestriction(datatype, facetRestrictions);
            }
            return datatype;
        }
        if (ManchesterOWLSyntax.NOT.matches(tok)) {
            return this.parseDataComplementOf();
        }
        if (ManchesterOWLSyntax.OPENBRACE.matches(tok)) {
            return this.parseDataOneOf();
        }
        if (ManchesterOWLSyntax.OPEN.matches(tok)) {
            this.consumeToken();
            OWLDataRange rng = this.parseDataRange();
            this.consumeToken(ManchesterOWLSyntax.CLOSE.keyword());
            return rng;
        }
        this.consumeToken();
        throw new ExceptionBuilder().withDt().withKeyword(ManchesterOWLSyntax.OPENBRACE, ManchesterOWLSyntax.NOT).build();
    }

    public Set<OWLDataRange> parseDataRangeList() {
        String sep = ManchesterOWLSyntax.COMMA.keyword();
        HashSet<OWLDataRange> ranges = new HashSet<OWLDataRange>();
        while (ManchesterOWLSyntax.COMMA.matches(sep)) {
            this.potentialKeywords.remove((Object)ManchesterOWLSyntax.COMMA);
            OWLDataRange rng = this.parseDataRange();
            ranges.add(rng);
            this.potentialKeywords.add(ManchesterOWLSyntax.COMMA);
            sep = this.peekToken();
            if (!ManchesterOWLSyntax.COMMA.matches(sep)) continue;
            this.consumeToken();
        }
        return ranges;
    }

    private OWLDataRange parseDataOneOf() {
        this.consumeToken();
        HashSet<OWLLiteral> cons = new HashSet<OWLLiteral>();
        String sep = ManchesterOWLSyntax.COMMA.keyword();
        while (ManchesterOWLSyntax.COMMA.matches(sep)) {
            OWLLiteral con = this.parseLiteral(null);
            cons.add(con);
            sep = this.consumeToken();
        }
        if (!ManchesterOWLSyntax.CLOSEBRACE.matches(sep)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.COMMA, ManchesterOWLSyntax.CLOSEBRACE).build();
        }
        return this.df.getOWLDataOneOf(cons);
    }

    private OWLDataRange parseDataComplementOf() {
        String not = this.consumeToken();
        if (!ManchesterOWLSyntax.NOT.matches(not)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.NOT).build();
        }
        OWLDataRange complementedDataRange = this.parseDataRangePrimary();
        return this.df.getOWLDataComplementOf(complementedDataRange);
    }

    public OWLLiteral parseLiteral(@Nullable OWLDatatype datatype) {
        String tok = this.consumeToken();
        if (tok.startsWith("\"")) {
            String lit = this.unquoteLiteral(tok);
            if ("^".equals(this.peekToken())) {
                this.consumeToken();
                if (!"^".equals(this.peekToken())) {
                    throw new ExceptionBuilder().withKeyword("^").build();
                }
                this.consumeToken();
                return this.df.getOWLLiteral(lit, this.parseDatatype());
            }
            if (this.peekToken().startsWith("@")) {
                String lang = this.consumeToken().substring(1);
                return this.df.getOWLLiteral(lit, lang);
            }
            return this.df.getOWLLiteral(lit, "");
        }
        if (datatype != null) {
            return this.df.getOWLLiteral(tok, datatype);
        }
        try {
            int i = Integer.parseInt(tok);
            return this.df.getOWLLiteral(i);
        }
        catch (NumberFormatException i) {
            if (tok.endsWith("f") || tok.endsWith("F")) {
                try {
                    float f = Float.parseFloat(tok.replace("INF", INFINITY).replace("inf", INFINITY));
                    return this.df.getOWLLiteral(ManchesterOWLSyntaxParserImpl.asFloat(f), OWL2Datatype.XSD_FLOAT);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            try {
                Double.parseDouble(tok);
                return this.df.getOWLLiteral(tok, OWL2Datatype.XSD_DECIMAL);
            }
            catch (NumberFormatException numberFormatException) {
                if (ManchesterOWLSyntax.LITERAL_TRUE.matches(tok)) {
                    return this.df.getOWLLiteral(true);
                }
                if (ManchesterOWLSyntax.LITERAL_FALSE.matches(tok)) {
                    return this.df.getOWLLiteral(false);
                }
                throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.LITERAL_TRUE, ManchesterOWLSyntax.LITERAL_FALSE, ManchesterOWLSyntax.LITERAL_INTEGER, ManchesterOWLSyntax.LITERAL_FLOAT, ManchesterOWLSyntax.LITERAL_DOUBLE, ManchesterOWLSyntax.LITERAL_LITERAL, ManchesterOWLSyntax.LITERAL_LIT_DATATYPE, ManchesterOWLSyntax.LITERAL_LIT_LANG).build();
            }
        }
    }

    private String unquoteLiteral(String tok) {
        String lit = "";
        if (!tok.endsWith("\"")) {
            this.consumeToken();
            throw new ExceptionBuilder().withKeyword("\"").build();
        }
        if (tok.length() > 2) {
            lit = tok.substring(1, tok.length() - 1);
        }
        return (String)OWLAPIPreconditions.verifyNotNull((Object)lit);
    }

    private static String asFloat(float f) {
        return Float.toString(f).replace(INFINITY, "INF");
    }

    private int parseInteger() {
        String i = this.consumeToken();
        try {
            return Integer.parseInt(i);
        }
        catch (NumberFormatException e) {
            throw new ExceptionBuilder().withInt().build();
        }
    }

    private OWLClassExpression parseNestedClassExpression(boolean lookaheadCheck) {
        String tok = this.peekToken();
        if (ManchesterOWLSyntax.OPEN.matches(tok)) {
            this.consumeToken();
            OWLClassExpression desc = this.parseUnion();
            String closeBracket = this.consumeToken();
            if (!ManchesterOWLSyntax.CLOSE.matches(closeBracket)) {
                throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.CLOSE).build();
            }
            return desc;
        }
        if (ManchesterOWLSyntax.OPENBRACE.matches(tok)) {
            return this.parseObjectOneOf();
        }
        if (this.isClassName(tok)) {
            String name = this.consumeToken();
            return this.getOWLClass(name);
        }
        for (ManchesterOWLSyntax x : ManchesterOWLSyntax.values()) {
            if (!x.matches(tok)) continue;
            return this.df.getOWLThing();
        }
        if (ManchesterOWLSyntaxTokenizer.eof(tok)) {
            return this.df.getOWLThing();
        }
        if (!ManchesterOWLSyntaxTokenizer.eof(tok) || !lookaheadCheck) {
            this.consumeToken();
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.OPEN, ManchesterOWLSyntax.OPENBRACE).withClass().build();
        }
        return this.df.getOWLThing();
    }

    private OWLClassExpression parseObjectOneOf() {
        String open = this.consumeToken();
        if (!ManchesterOWLSyntax.OPENBRACE.matches(open)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.OPENBRACE).build();
        }
        String sep = ManchesterOWLSyntax.COMMA.keyword();
        HashSet<OWLIndividual> inds = new HashSet<OWLIndividual>();
        while (ManchesterOWLSyntax.COMMA.matches(sep)) {
            inds.add(this.parseIndividual());
            sep = this.peekToken();
            if (!ManchesterOWLSyntax.COMMA.matches(sep)) continue;
            this.consumeToken();
        }
        String close = this.consumeToken();
        if (!ManchesterOWLSyntax.CLOSEBRACE.matches(close)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.CLOSEBRACE, ManchesterOWLSyntax.COMMA).build();
        }
        return this.df.getOWLObjectOneOf(inds);
    }

    private static <F> void initialiseSection(AnnAxiom<F, ?> parser, Map<ManchesterOWLSyntax, AnnAxiom<F, ?>> map, ManchesterOWLSyntax ... synonyms) {
        map.put(parser.keyword, parser);
        for (ManchesterOWLSyntax syn : synonyms) {
            map.put(syn, parser);
        }
    }

    public Set<OntologyAxiomPair> parseFrames() {
        String tok;
        HashSet<OntologyAxiomPair> axioms = new HashSet<OntologyAxiomPair>();
        HashSet<ManchesterOWLSyntax> possible = new HashSet<ManchesterOWLSyntax>();
        ManchesterOWLSyntaxParserImpl.resetPossible(possible);
        while (true) {
            if (ManchesterOWLSyntax.CLASS.matches(tok = this.peekToken())) {
                this.potentialKeywords.clear();
                ManchesterOWLSyntaxParserImpl.resetPossible(possible);
                axioms.addAll(this.parseClassFrame());
                possible.addAll(this.classFrameSections.keySet());
                continue;
            }
            if (ManchesterOWLSyntax.OBJECT_PROPERTY.matches(tok)) {
                this.potentialKeywords.clear();
                ManchesterOWLSyntaxParserImpl.resetPossible(possible);
                axioms.addAll(this.parseObjectPropertyFrame());
                possible.addAll(this.objectPropertyFrameSections.keySet());
                continue;
            }
            if (ManchesterOWLSyntax.DATA_PROPERTY.matches(tok)) {
                this.potentialKeywords.clear();
                ManchesterOWLSyntaxParserImpl.resetPossible(possible);
                axioms.addAll(this.parseDataPropertyFrame());
                possible.addAll(this.dataPropertyFrameSections.keySet());
                continue;
            }
            if (ManchesterOWLSyntax.ANNOTATION_PROPERTY.matches(tok)) {
                this.potentialKeywords.clear();
                ManchesterOWLSyntaxParserImpl.resetPossible(possible);
                axioms.addAll(this.parseAnnotationPropertyFrame());
                possible.addAll(Arrays.asList(ManchesterOWLSyntax.SUB_PROPERTY_OF, ManchesterOWLSyntax.DOMAIN, ManchesterOWLSyntax.RANGE));
                continue;
            }
            if (ManchesterOWLSyntax.INDIVIDUAL.matches(tok)) {
                this.potentialKeywords.clear();
                ManchesterOWLSyntaxParserImpl.resetPossible(possible);
                axioms.addAll(this.parseIndividualFrame());
                possible.addAll(Arrays.asList(ManchesterOWLSyntax.TYPES, ManchesterOWLSyntax.FACTS, ManchesterOWLSyntax.DIFFERENT_FROM, ManchesterOWLSyntax.SAME_AS));
                continue;
            }
            if (ManchesterOWLSyntax.DATATYPE.matches(tok)) {
                this.potentialKeywords.clear();
                ManchesterOWLSyntaxParserImpl.resetPossible(possible);
                axioms.addAll(this.parseDatatypeFrame());
                possible.add(ManchesterOWLSyntax.EQUIVALENT_TO);
                continue;
            }
            if (ManchesterOWLSyntax.VALUE_PARTITION.matches(tok)) {
                this.potentialKeywords.clear();
                ManchesterOWLSyntaxParserImpl.resetPossible(possible);
                this.parseValuePartitionFrame();
                continue;
            }
            if (!ManchesterOWLSyntax.RULE.matches(tok)) break;
            this.potentialKeywords.clear();
            ManchesterOWLSyntaxParserImpl.resetPossible(possible);
            axioms.addAll(this.parseRuleFrame());
        }
        if (!ManchesterOWLSyntaxTokenizer.eof(tok)) {
            this.consumeToken();
            throw new ExceptionBuilder().withKeyword(possible).build();
        }
        return axioms;
    }

    public Set<OntologyAxiomPair> parseDatatypeFrame() {
        String tok = this.consumeToken();
        if (!ManchesterOWLSyntax.DATATYPE.matches(tok)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.DATATYPE).build();
        }
        String subj = this.consumeToken();
        OWLDatatype datatype = this.getOWLDatatype(subj);
        HashSet<OntologyAxiomPair> axioms = new HashSet<OntologyAxiomPair>();
        axioms.add(new OntologyAxiomPair(this.defaultOntology, (OWLAxiom)this.df.getOWLDeclarationAxiom((OWLEntity)datatype)));
        block0: while (true) {
            String sect;
            if (ManchesterOWLSyntax.EQUIVALENT_TO.matches(sect = this.peekToken())) {
                this.potentialKeywords.clear();
                this.consumeToken();
                Set<OWLOntology> onts = this.getOntologies();
                Set<OWLDataRange> drs = this.parseDataRangeList();
                Iterator<OWLOntology> iterator = onts.iterator();
                block1: while (true) {
                    if (!iterator.hasNext()) continue block0;
                    OWLOntology ont = iterator.next();
                    Iterator<OWLDataRange> iterator2 = drs.iterator();
                    while (true) {
                        if (!iterator2.hasNext()) continue block1;
                        OWLDataRange dr = iterator2.next();
                        axioms.add(new OntologyAxiomPair(ont, (OWLAxiom)this.df.getOWLDatatypeDefinitionAxiom(datatype, dr)));
                    }
                    break;
                }
            }
            if (!ManchesterOWLSyntax.ANNOTATIONS.matches(sect)) break;
            this.potentialKeywords.clear();
            axioms.addAll(this.parseAnnotations((OWLAnnotationSubject)datatype.getIRI()));
        }
        return axioms;
    }

    private static void resetPossible(Set<ManchesterOWLSyntax> possible) {
        possible.clear();
        possible.add(ManchesterOWLSyntax.ANNOTATIONS);
        possible.add(ManchesterOWLSyntax.ANNOTATION_PROPERTY);
        possible.add(ManchesterOWLSyntax.CLASS);
        possible.add(ManchesterOWLSyntax.OBJECT_PROPERTY);
        possible.add(ManchesterOWLSyntax.DATATYPE);
        possible.add(ManchesterOWLSyntax.DATA_PROPERTY);
        possible.add(ManchesterOWLSyntax.INDIVIDUAL);
        possible.add(ManchesterOWLSyntax.VALUE_PARTITION);
        possible.add(ManchesterOWLSyntax.RULE);
    }

    private Set<OntologyAxiomPair> parseNaryEquivalentClasses() {
        String tok = this.consumeToken();
        if (!ManchesterOWLSyntax.EQUIVALENT_CLASSES.matches(tok)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.EQUIVALENT_CLASSES).build();
        }
        Set<OWLOntology> ontologies = this.getOntologies();
        Set<OWLAnnotation> annotations = this.parseAnnotations();
        Set<OWLClassExpression> classExpressions = this.parseClassExpressionList();
        HashSet<OntologyAxiomPair> pairs = new HashSet<OntologyAxiomPair>();
        for (OWLOntology ont : ontologies) {
            pairs.add(new OntologyAxiomPair(ont, (OWLAxiom)this.df.getOWLEquivalentClassesAxiom(classExpressions, annotations)));
        }
        return pairs;
    }

    private Set<OntologyAxiomPair> parseNaryEquivalentProperties() {
        OWLEquivalentObjectPropertiesAxiom propertyAxiom;
        String tok = this.consumeToken();
        if (!ManchesterOWLSyntax.EQUIVALENT_PROPERTIES.matches(tok)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.EQUIVALENT_PROPERTIES).build();
        }
        Set<OWLOntology> ontologies = this.getOntologies();
        Set<OWLAnnotation> annotations = this.parseAnnotations();
        Set<OWLPropertyExpression> properties = this.parsePropertyList();
        if (properties.iterator().next().isObjectPropertyExpression()) {
            HashSet ope = new HashSet();
            properties.forEach(pe -> ope.add(pe.asObjectPropertyExpression()));
            propertyAxiom = this.df.getOWLEquivalentObjectPropertiesAxiom(ope, annotations);
        } else {
            HashSet dpe = new HashSet();
            properties.forEach(pe -> dpe.add(pe.asDataPropertyExpression()));
            propertyAxiom = this.df.getOWLEquivalentDataPropertiesAxiom(dpe, annotations);
        }
        HashSet<OntologyAxiomPair> pairs = new HashSet<OntologyAxiomPair>();
        for (OWLOntology ont : ontologies) {
            pairs.add(new OntologyAxiomPair(ont, (OWLAxiom)propertyAxiom));
        }
        return pairs;
    }

    private Set<OWLAnnotation> parseAnnotations() {
        String next = this.peekToken();
        Set<OWLAnnotation> annotations = Collections.emptySet();
        if (ManchesterOWLSyntax.ANNOTATIONS.matches(next)) {
            this.consumeToken();
            annotations = this.parseAnnotationList();
        }
        return annotations;
    }

    private Set<OntologyAxiomPair> parseAnnotations(OWLAnnotationSubject s) {
        String header = this.consumeToken();
        if (!ManchesterOWLSyntax.ANNOTATIONS.matches(header)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.ANNOTATIONS).build();
        }
        Set<OWLOntology> onts = this.getOntologies();
        HashSet<OntologyAxiomPair> pairs = new HashSet<OntologyAxiomPair>();
        Set<OWLAnnotation> annos = this.parseAnnotationList();
        for (OWLOntology ont : onts) {
            for (OWLAnnotation anno : annos) {
                if (!this.getOntologyLoaderConfiguration().isLoadAnnotationAxioms()) continue;
                pairs.add(new OntologyAxiomPair(ont, (OWLAxiom)this.df.getOWLAnnotationAssertionAxiom(s, anno)));
            }
        }
        return pairs;
    }

    private Set<OWLAnnotation> parseAnnotationList() {
        String sep = ManchesterOWLSyntax.COMMA.keyword();
        HashSet<OWLAnnotation> annos = new HashSet<OWLAnnotation>();
        while (ManchesterOWLSyntax.COMMA.matches(sep)) {
            this.potentialKeywords.clear();
            Set<OWLAnnotation> annotations = this.parseAnnotations();
            OWLAnnotation anno = this.parseAnnotation();
            anno = anno.getAnnotatedAnnotation(annotations);
            annos.add(anno);
            sep = this.peekToken();
            if (!ManchesterOWLSyntax.COMMA.matches(sep)) continue;
            this.consumeToken();
        }
        return annos;
    }

    protected OWLAnnotation parseAnnotation() {
        OWLAnnotationProperty annoProp = this.parseAnnotationProperty();
        String obj = this.peekToken();
        if (this.isIndividualName(obj) || this.isClassName(obj) || this.isObjectPropertyName(obj) || this.isDataPropertyName(obj)) {
            this.consumeToken();
            Object value = obj.startsWith("_:") ? this.anonProvider.getOWLAnonymousIndividual(obj) : this.getIRI(obj);
            return this.df.getOWLAnnotation(annoProp, (OWLAnnotationValue)value);
        }
        if (obj.startsWith("<")) {
            IRI value = this.parseIRI();
            return this.df.getOWLAnnotation(annoProp, (OWLAnnotationValue)value);
        }
        OWLLiteral con = this.parseLiteral(null);
        return this.df.getOWLAnnotation(annoProp, (OWLAnnotationValue)con);
    }

    public Set<OntologyAxiomPair> parseClassFrame() {
        return this.parseClassFrame(false);
    }

    public Set<OntologyAxiomPair> parseClassFrameEOF() {
        return this.parseClassFrame(true);
    }

    private Set<OntologyAxiomPair> parseClassFrame(boolean eof) {
        String tok = this.consumeToken();
        if (!ManchesterOWLSyntax.CLASS.matches(tok)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.CLASS).build();
        }
        String subj = this.consumeToken();
        OWLClass cls = this.getOWLClass(subj);
        HashSet<OntologyAxiomPair> axioms = new HashSet<OntologyAxiomPair>();
        axioms.add(new OntologyAxiomPair(this.defaultOntology, (OWLAxiom)this.df.getOWLDeclarationAxiom((OWLEntity)cls)));
        this.parseFrameSections(eof, axioms, cls, this.classFrameSections);
        return axioms;
    }

    private Set<OWLOntology> parseOntologyList() {
        this.potentialKeywords.clear();
        this.consumeToken(ManchesterOWLSyntax.OPENBRACKET.keyword());
        this.consumeToken("in");
        String sep = ManchesterOWLSyntax.COMMA.keyword();
        HashSet<OWLOntology> onts = new HashSet<OWLOntology>();
        while (ManchesterOWLSyntax.COMMA.matches(sep)) {
            String tok = this.consumeToken();
            if (this.isOntologyName(tok)) {
                OWLOntology ont = this.getOntology(tok);
                if (ont != null) {
                    onts.add(ont);
                }
            } else {
                throw new ExceptionBuilder().withOnto().build();
            }
            sep = this.consumeToken();
            if (sep.equals(ManchesterOWLSyntax.CLOSEBRACKET.keyword())) break;
            if (ManchesterOWLSyntax.COMMA.matches(sep)) continue;
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.COMMA, ManchesterOWLSyntax.CLOSEBRACKET).build();
        }
        return onts;
    }

    private Set<OWLOntology> getOntologies() {
        if (this.peekToken().equals(ManchesterOWLSyntax.OPENBRACKET.keyword())) {
            return this.parseOntologyList();
        }
        return CollectionFactory.createSet((Object)this.defaultOntology);
    }

    public void setDefaultOntology(OWLOntology defaultOntology) {
        this.defaultOntology = defaultOntology;
        defaultOntology.axioms(AxiomType.DECLARATION, Imports.INCLUDED).forEach(this::processDeclaredEntities);
    }

    private boolean isEmptyFrameSection(Map<ManchesterOWLSyntax, ?> parsers) {
        return false;
    }

    private <F> void parseFrameSections(boolean eof, Set<OntologyAxiomPair> axioms, F frameSubject, Map<ManchesterOWLSyntax, AnnAxiom<F, ?>> sectionParsers) {
        String sect;
        AnnAxiom<F, ?> parser;
        while ((parser = sectionParsers.get((Object)ManchesterOWLSyntax.parse(sect = this.peekToken()))) != null) {
            this.consumeToken();
            Set<OWLOntology> onts = this.getOntologies();
            if (this.isEmptyFrameSection(sectionParsers)) continue;
            axioms.addAll(this.parseAnnotatedListItems(frameSubject, parser, onts));
        }
        if (eof && !ManchesterOWLSyntaxTokenizer.eof(sect)) {
            ArrayList<ManchesterOWLSyntax> expected = new ArrayList<ManchesterOWLSyntax>();
            expected.addAll(sectionParsers.keySet());
            if (frameSubject instanceof OWLAnnotationSubject || frameSubject instanceof OWLEntity) {
                expected.add(ManchesterOWLSyntax.ANNOTATIONS);
            }
            throw new ExceptionBuilder().withKeyword(expected).build();
        }
    }

    public Set<OntologyAxiomPair> parseObjectPropertyFrame() {
        return this.parseObjectPropertyFrame(false);
    }

    private Set<OntologyAxiomPair> parseObjectPropertyFrame(boolean eof) {
        HashSet<OntologyAxiomPair> axioms = new HashSet<OntologyAxiomPair>();
        this.consumeToken(ManchesterOWLSyntax.OBJECT_PROPERTY);
        String token = this.consumeToken();
        OWLObjectProperty prop = this.getOWLObjectProperty(token);
        if (!prop.isAnonymous()) {
            axioms.add(new OntologyAxiomPair(this.defaultOntology, (OWLAxiom)this.df.getOWLDeclarationAxiom((OWLEntity)prop.asOWLObjectProperty())));
        }
        this.parseFrameSections(eof, axioms, prop, this.objectPropertyFrameSections);
        return axioms;
    }

    public Set<OntologyAxiomPair> parseDataPropertyFrame() {
        String tok = this.consumeToken();
        if (!ManchesterOWLSyntax.DATA_PROPERTY.matches(tok)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.DATA_PROPERTY).build();
        }
        String subj = this.consumeToken();
        OWLDataProperty prop = this.getOWLDataProperty(subj);
        HashSet<OntologyAxiomPair> axioms = new HashSet<OntologyAxiomPair>();
        axioms.add(new OntologyAxiomPair(this.defaultOntology, (OWLAxiom)this.df.getOWLDeclarationAxiom((OWLEntity)prop)));
        this.parseFrameSections(false, axioms, prop, this.dataPropertyFrameSections);
        return axioms;
    }

    public Set<OntologyAxiomPair> parseAnnotationPropertyFrame() {
        String tok = this.consumeToken();
        if (!ManchesterOWLSyntax.ANNOTATION_PROPERTY.matches(tok)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.ANNOTATION_PROPERTY).build();
        }
        String subj = this.consumeToken();
        OWLAnnotationProperty prop = this.getOWLAnnotationProperty(subj);
        HashSet<OntologyAxiomPair> axioms = new HashSet<OntologyAxiomPair>();
        for (OWLOntology ont : this.getOntologies()) {
            axioms.add(new OntologyAxiomPair(ont, (OWLAxiom)this.df.getOWLDeclarationAxiom((OWLEntity)prop)));
        }
        this.parseFrameSections(false, axioms, prop, this.annotationPropertyFrameSections);
        return axioms;
    }

    public Set<OntologyAxiomPair> parseIndividualFrame() {
        String tok = this.consumeToken();
        if (!ManchesterOWLSyntax.INDIVIDUAL.matches(tok)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.INDIVIDUAL).build();
        }
        String subj = this.consumeToken();
        OWLIndividual ind = this.getOWLIndividual(subj);
        HashSet<OntologyAxiomPair> axioms = new HashSet<OntologyAxiomPair>();
        if (!ind.isAnonymous()) {
            axioms.add(new OntologyAxiomPair(this.getOntology(null), (OWLAxiom)this.df.getOWLDeclarationAxiom((OWLEntity)ind.asOWLNamedIndividual())));
        }
        this.parseFrameSections(false, axioms, ind, this.individualFrameSections);
        return axioms;
    }

    protected OWLAxiom parseFact(OWLIndividual ind) {
        String prop;
        boolean negative = false;
        if (ManchesterOWLSyntax.NOT.matches(this.peekToken())) {
            this.consumeToken();
            negative = true;
        }
        if (this.isDataPropertyName(prop = this.peekToken())) {
            OWLDataProperty p = this.parseDataProperty();
            OWLLiteral con = this.parseLiteral(null);
            if (!negative) {
                return this.df.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)p, ind, con);
            }
            return this.df.getOWLNegativeDataPropertyAssertionAxiom((OWLDataPropertyExpression)p, ind, con);
        }
        if (this.isObjectPropertyName(prop) || ManchesterOWLSyntax.INVERSE.matches(prop)) {
            OWLObjectPropertyExpression p = this.parseObjectPropertyExpression(false);
            if (!negative) {
                return this.df.getOWLObjectPropertyAssertionAxiom(p, ind, this.parseIndividual());
            }
            return this.df.getOWLNegativeObjectPropertyAssertionAxiom(p, ind, this.parseIndividual());
        }
        this.consumeToken();
        throw new ExceptionBuilder().withObject().withData().build();
    }

    public Set<OntologyAxiomPair> parseValuePartitionFrame() {
        String section = this.consumeToken();
        if (!ManchesterOWLSyntax.VALUE_PARTITION.matches(section)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.VALUE_PARTITION).build();
        }
        OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression(false);
        String clsName = this.consumeToken();
        if (ManchesterOWLSyntaxTokenizer.eof(clsName)) {
            throw new ExceptionBuilder().withObject().build();
        }
        OWLClass cls = this.getOWLClass(clsName);
        HashSet<OntologyAxiomPair> axioms = new HashSet<OntologyAxiomPair>();
        Set<OWLOntology> onts = this.getOntologies();
        axioms.addAll(this.parseValuePartitionValues(onts, cls));
        for (OWLOntology ont : onts) {
            axioms.add(new OntologyAxiomPair(ont, (OWLAxiom)this.df.getOWLFunctionalObjectPropertyAxiom(prop)));
            axioms.add(new OntologyAxiomPair(ont, (OWLAxiom)this.df.getOWLObjectPropertyRangeAxiom(prop, (OWLClassExpression)cls)));
        }
        return axioms;
    }

    private Set<OntologyAxiomPair> parseValuePartitionValues(Set<OWLOntology> onts, OWLClass superclass) {
        HashSet<OntologyAxiomPair> axioms = new HashSet<OntologyAxiomPair>();
        HashSet<OWLClass> siblings = new HashSet<OWLClass>();
        this.consumeToken(ManchesterOWLSyntax.OPENBRACKET.keyword());
        String sep = ManchesterOWLSyntax.COMMA.keyword();
        while (ManchesterOWLSyntax.COMMA.matches(sep)) {
            String clsName = this.consumeToken();
            OWLClass cls = this.getOWLClass(clsName);
            siblings.add(cls);
            OWLSubClassOfAxiom ax = this.df.getOWLSubClassOfAxiom((OWLClassExpression)cls, (OWLClassExpression)superclass);
            for (OWLOntology ont : onts) {
                axioms.add(new OntologyAxiomPair(ont, (OWLAxiom)ax));
            }
            if (this.peekToken().equals(ManchesterOWLSyntax.OPENBRACKET.keyword())) {
                axioms.addAll(this.parseValuePartitionValues(onts, cls));
            }
            if (!ManchesterOWLSyntax.COMMA.matches(sep = this.peekToken())) continue;
            this.consumeToken();
        }
        this.consumeToken(ManchesterOWLSyntax.CLOSEBRACKET.keyword());
        OWLDisjointClassesAxiom ax = this.df.getOWLDisjointClassesAxiom(siblings);
        for (OWLOntology ont : onts) {
            axioms.add(new OntologyAxiomPair(ont, (OWLAxiom)ax));
        }
        return axioms;
    }

    public List<OntologyAxiomPair> parseRuleFrame() {
        String section = this.consumeToken();
        if (!ManchesterOWLSyntax.RULE.matches(section)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.RULE).build();
        }
        Set<OWLOntology> ontologies = this.getOntologies();
        List<SWRLAtom> body = this.parseRuleAtoms();
        String tok = this.consumeToken();
        if (!ManchesterOWLSyntax.DASH.matches(tok)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.DASH, ManchesterOWLSyntax.COMMA).build();
        }
        this.consumeToken(">");
        List<SWRLAtom> head = this.parseRuleAtoms();
        SWRLRule rule = this.df.getSWRLRule(new LinkedHashSet<SWRLAtom>(body), new LinkedHashSet<SWRLAtom>(head));
        ArrayList<OntologyAxiomPair> pairs = new ArrayList<OntologyAxiomPair>();
        for (OWLOntology ont : ontologies) {
            pairs.add(new OntologyAxiomPair(ont, (OWLAxiom)rule));
        }
        return pairs;
    }

    private List<SWRLAtom> parseRuleAtoms() {
        String sep = ManchesterOWLSyntax.COMMA.keyword();
        ArrayList<SWRLAtom> atoms = new ArrayList<SWRLAtom>();
        while (ManchesterOWLSyntax.COMMA.matches(sep)) {
            this.potentialKeywords.remove((Object)ManchesterOWLSyntax.COMMA);
            SWRLAtom atom = this.parseRuleAtom();
            atoms.add(atom);
            sep = this.peekToken();
            if (ManchesterOWLSyntax.COMMA.matches(sep)) {
                this.consumeToken();
            }
            this.potentialKeywords.add(ManchesterOWLSyntax.COMMA);
        }
        return atoms;
    }

    private SWRLAtom parseRuleAtom() {
        String predicate = this.peekToken();
        if (this.isClassName(predicate)) {
            return this.parseClassAtom();
        }
        if (ManchesterOWLSyntax.OPEN.matches(predicate)) {
            return this.parseClassAtom();
        }
        if (this.isObjectPropertyName(predicate)) {
            return this.parseObjectPropertyAtom();
        }
        if (this.isDataPropertyName(predicate)) {
            return this.parseDataPropertyAtom();
        }
        if (this.isDatatypeName(predicate)) {
            return this.parseDataRangeAtom();
        }
        if (ManchesterOWLSyntax.DIFFERENT_FROM.matchesEitherForm(predicate)) {
            return this.parseDifferentFromAtom();
        }
        if (ManchesterOWLSyntax.SAME_AS.matchesEitherForm(predicate)) {
            return this.parseSameAsAtom();
        }
        if (this.isSWRLBuiltin(predicate) || predicate.startsWith("<")) {
            return this.parseBuiltInAtom();
        }
        this.consumeToken();
        TreeSet<String> kw = new TreeSet<String>();
        kw.addAll(this.ruleBuiltIns.keySet());
        kw.add(ManchesterOWLSyntax.DIFFERENT_FROM.toString());
        kw.add(ManchesterOWLSyntax.SAME_AS.toString());
        throw new ExceptionBuilder().withKeyword(kw).withClass().withObject().withData().build();
    }

    private SWRLAtom parseDataPropertyAtom() {
        String predicate = this.consumeToken();
        if (!this.isDataPropertyName(predicate)) {
            throw new ExceptionBuilder().withData().build();
        }
        this.consumeToken(ManchesterOWLSyntax.OPEN.keyword());
        SWRLIArgument obj1 = this.parseIObject();
        this.consumeToken(ManchesterOWLSyntax.COMMA.keyword());
        SWRLDArgument obj2 = this.parseDObject();
        this.consumeToken(ManchesterOWLSyntax.CLOSE.keyword());
        return this.df.getSWRLDataPropertyAtom((OWLDataPropertyExpression)this.getOWLDataProperty(predicate), obj1, obj2);
    }

    private SWRLAtom parseDataRangeAtom() {
        OWLDataRange range = this.parseDataRange();
        this.consumeToken(ManchesterOWLSyntax.OPEN.keyword());
        SWRLVariable obj1 = this.parseDVariable();
        this.consumeToken(ManchesterOWLSyntax.CLOSE.keyword());
        return this.df.getSWRLDataRangeAtom(range, (SWRLDArgument)obj1);
    }

    private SWRLAtom parseObjectPropertyAtom() {
        String predicate = this.consumeToken();
        if (!this.isObjectPropertyName(predicate)) {
            throw new ExceptionBuilder().withObject().build();
        }
        this.consumeToken(ManchesterOWLSyntax.OPEN.keyword());
        SWRLIArgument obj1 = this.parseIObject();
        this.consumeToken(ManchesterOWLSyntax.COMMA.keyword());
        SWRLIArgument obj2 = this.parseIObject();
        this.consumeToken(ManchesterOWLSyntax.CLOSE.keyword());
        return this.df.getSWRLObjectPropertyAtom((OWLObjectPropertyExpression)this.getOWLObjectProperty(predicate), obj1, obj2);
    }

    private SWRLAtom parseClassAtom() {
        OWLClassExpression predicate = this.parseUnion();
        this.consumeToken(ManchesterOWLSyntax.OPEN.keyword());
        SWRLIArgument obj = this.parseIObject();
        this.consumeToken(ManchesterOWLSyntax.CLOSE.keyword());
        return this.df.getSWRLClassAtom(predicate, obj);
    }

    private SWRLDifferentIndividualsAtom parseDifferentFromAtom() {
        this.consumeToken(ManchesterOWLSyntax.DIFFERENT_FROM.toString());
        this.consumeToken(ManchesterOWLSyntax.OPEN.keyword());
        SWRLIArgument obj1 = this.parseIObject();
        this.consumeToken(ManchesterOWLSyntax.COMMA.keyword());
        SWRLIArgument obj2 = this.parseIObject();
        this.consumeToken(ManchesterOWLSyntax.CLOSE.keyword());
        return this.df.getSWRLDifferentIndividualsAtom(obj1, obj2);
    }

    private SWRLSameIndividualAtom parseSameAsAtom() {
        this.consumeToken(ManchesterOWLSyntax.SAME_AS.toString());
        this.consumeToken(ManchesterOWLSyntax.OPEN.keyword());
        SWRLIArgument obj1 = this.parseIObject();
        this.consumeToken(ManchesterOWLSyntax.COMMA.keyword());
        SWRLIArgument obj2 = this.parseIObject();
        this.consumeToken(ManchesterOWLSyntax.CLOSE.keyword());
        return this.df.getSWRLSameIndividualAtom(obj1, obj2);
    }

    private SWRLIArgument parseIObject() {
        String s = this.peekToken();
        if (this.isIndividualName(s)) {
            return this.parseIIndividualObject();
        }
        if ("?".equals(s)) {
            return this.parseIVariable();
        }
        this.consumeToken();
        throw new ExceptionBuilder().withInd().withKeyword("?$var$").build();
    }

    private SWRLVariable parseIVariable() {
        return this.df.getSWRLVariable(this.parseVariable());
    }

    private SWRLIndividualArgument parseIIndividualObject() {
        return this.df.getSWRLIndividualArgument(this.parseIndividual());
    }

    public IRI parseVariable() {
        this.consumeToken("?");
        String fragment = this.peekToken();
        if (fragment.startsWith("<")) {
            return this.parseIRI();
        }
        this.consumeToken();
        return IRI.create((String)"urn:swrl#", (String)fragment);
    }

    private SWRLDArgument parseDObject() {
        String s = this.peekToken();
        if ("?".equals(s)) {
            return this.parseDVariable();
        }
        try {
            return this.parseLiteralObject();
        }
        catch (ParserException e) {
            e.getExpectedKeywords().add("?");
            throw e;
        }
    }

    private SWRLVariable parseDVariable() {
        IRI var = this.parseVariable();
        return this.df.getSWRLVariable(var);
    }

    private SWRLLiteralArgument parseLiteralObject() {
        OWLLiteral lit = this.parseLiteral(null);
        return this.df.getSWRLLiteralArgument(lit);
    }

    private SWRLBuiltInAtom parseBuiltInAtom() {
        IRI iri;
        String predicate = this.consumeToken();
        this.consumeToken(ManchesterOWLSyntax.OPEN.keyword());
        SWRLBuiltInsVocabulary v = null;
        if (!this.ruleBuiltIns.containsKey(predicate)) {
            iri = this.getIRI(predicate);
        } else {
            v = this.ruleBuiltIns.get(predicate);
            iri = v.getIRI();
        }
        ArrayList<SWRLDArgument> args = new ArrayList<SWRLDArgument>();
        if (v != null && v.getMaxArity() >= 0) {
            for (int i = 0; i < v.getMaxArity(); ++i) {
                SWRLDArgument obj = this.parseDObject();
                args.add(obj);
                if (i < v.getMinArity() - 1) {
                    this.consumeToken(ManchesterOWLSyntax.COMMA.keyword());
                    continue;
                }
                if (i >= v.getMaxArity() - 1) continue;
                if (this.peekToken().equals(ManchesterOWLSyntax.COMMA.keyword())) {
                    this.consumeToken();
                    continue;
                }
                break;
            }
        } else {
            String sep = ManchesterOWLSyntax.COMMA.keyword();
            while (ManchesterOWLSyntax.COMMA.matches(sep)) {
                SWRLDArgument arg = this.parseDObject();
                args.add(arg);
                sep = this.peekToken();
                if (!ManchesterOWLSyntax.COMMA.matches(sep)) continue;
                this.consumeToken();
            }
        }
        this.consumeToken(ManchesterOWLSyntax.CLOSE.keyword());
        return this.df.getSWRLBuiltInAtom(iri, args);
    }

    private Set<OntologyAxiomPair> parseDisjointClasses() {
        String section = this.consumeToken();
        if (!ManchesterOWLSyntax.DISJOINT_CLASSES.matches(section)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.DISJOINT_CLASSES).build();
        }
        Set<OWLOntology> ontologies = this.getOntologies();
        Set<OWLAnnotation> annotations = this.parseAnnotations();
        Set<OWLClassExpression> classExpressions = this.parseClassExpressionList();
        HashSet<OntologyAxiomPair> pairs = new HashSet<OntologyAxiomPair>();
        for (OWLOntology ont : ontologies) {
            pairs.add(new OntologyAxiomPair(ont, (OWLAxiom)this.df.getOWLDisjointClassesAxiom(classExpressions, annotations)));
        }
        return pairs;
    }

    private Set<OntologyAxiomPair> parseSameIndividual() {
        String section = this.consumeToken();
        if (!ManchesterOWLSyntax.SAME_INDIVIDUAL.matches(section)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.SAME_INDIVIDUAL).build();
        }
        Set<OWLIndividual> individuals = this.parseIndividualList();
        Set<OWLOntology> ontologies = this.getOntologies();
        Set<OWLAnnotation> annotations = this.parseAnnotations();
        HashSet<OntologyAxiomPair> pairs = new HashSet<OntologyAxiomPair>();
        for (OWLOntology ont : ontologies) {
            pairs.add(new OntologyAxiomPair(ont, (OWLAxiom)this.df.getOWLSameIndividualAxiom(individuals, annotations)));
        }
        return pairs;
    }

    private Set<OntologyAxiomPair> parseDisjointProperties() {
        OWLDisjointObjectPropertiesAxiom propertiesAxiom;
        String section = this.consumeToken();
        if (!ManchesterOWLSyntax.DISJOINT_PROPERTIES.matches(section)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.DISJOINT_PROPERTIES).build();
        }
        Set<OWLOntology> ontologies = this.getOntologies();
        Set<OWLAnnotation> annotations = this.parseAnnotations();
        Set<OWLPropertyExpression> props = this.parsePropertyList();
        HashSet<OntologyAxiomPair> pairs = new HashSet<OntologyAxiomPair>();
        if (props.iterator().next().isObjectPropertyExpression()) {
            HashSet ope = new HashSet();
            props.forEach(pe -> ope.add(pe.asObjectPropertyExpression()));
            propertiesAxiom = this.df.getOWLDisjointObjectPropertiesAxiom(ope, annotations);
        } else {
            HashSet dpe = new HashSet();
            props.forEach(pe -> dpe.add(pe.asDataPropertyExpression()));
            propertiesAxiom = this.df.getOWLDisjointDataPropertiesAxiom(dpe, annotations);
        }
        for (OWLOntology ont : ontologies) {
            pairs.add(new OntologyAxiomPair(ont, (OWLAxiom)propertiesAxiom));
        }
        return pairs;
    }

    private Set<OntologyAxiomPair> parseDifferentIndividuals() {
        String section = this.consumeToken();
        if (!ManchesterOWLSyntax.DIFFERENT_INDIVIDUALS.matches(section)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.DIFFERENT_INDIVIDUALS).build();
        }
        Set<OWLOntology> ontologies = this.getOntologies();
        Set<OWLAnnotation> annotations = this.parseAnnotations();
        Set<OWLIndividual> individuals = this.parseIndividualList();
        HashSet<OntologyAxiomPair> pairs = new HashSet<OntologyAxiomPair>();
        for (OWLOntology ontology : ontologies) {
            pairs.add(new OntologyAxiomPair(ontology, (OWLAxiom)this.df.getOWLDifferentIndividualsAxiom(individuals, annotations)));
        }
        return pairs;
    }

    protected OWLObjectPropertyCharacteristicAxiom parseObjectPropertyCharacteristic(OWLObjectPropertyExpression prop) {
        String characteristic = this.consumeToken();
        if (ManchesterOWLSyntax.FUNCTIONAL.matches(characteristic)) {
            return this.df.getOWLFunctionalObjectPropertyAxiom(prop);
        }
        if (ManchesterOWLSyntax.INVERSE_FUNCTIONAL.matches(characteristic)) {
            return this.df.getOWLInverseFunctionalObjectPropertyAxiom(prop);
        }
        if (ManchesterOWLSyntax.SYMMETRIC.matches(characteristic)) {
            return this.df.getOWLSymmetricObjectPropertyAxiom(prop);
        }
        if (ManchesterOWLSyntax.ANTI_SYMMETRIC.matches(characteristic) || ManchesterOWLSyntax.ASYMMETRIC.matches(characteristic)) {
            return this.df.getOWLAsymmetricObjectPropertyAxiom(prop);
        }
        if (ManchesterOWLSyntax.TRANSITIVE.matches(characteristic)) {
            return this.df.getOWLTransitiveObjectPropertyAxiom(prop);
        }
        if (ManchesterOWLSyntax.REFLEXIVE.matches(characteristic)) {
            return this.df.getOWLReflexiveObjectPropertyAxiom(prop);
        }
        if (ManchesterOWLSyntax.IRREFLEXIVE.matches(characteristic)) {
            return this.df.getOWLIrreflexiveObjectPropertyAxiom(prop);
        }
        throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.FUNCTIONAL, ManchesterOWLSyntax.INVERSE_FUNCTIONAL, ManchesterOWLSyntax.SYMMETRIC, ManchesterOWLSyntax.ANTI_SYMMETRIC, ManchesterOWLSyntax.TRANSITIVE, ManchesterOWLSyntax.REFLEXIVE, ManchesterOWLSyntax.IRREFLEXIVE).build();
    }

    protected OWLDataPropertyCharacteristicAxiom parseDataPropertyCharacteristic(OWLDataPropertyExpression prop) {
        String characteristic = this.consumeToken();
        if (ManchesterOWLSyntax.FUNCTIONAL.matches(characteristic)) {
            return this.df.getOWLFunctionalDataPropertyAxiom(prop);
        }
        throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.FUNCTIONAL).build();
    }

    public Set<OWLClassExpression> parseClassExpressionList() {
        HashSet<OWLClassExpression> descs = new HashSet<OWLClassExpression>();
        String sep = ManchesterOWLSyntax.COMMA.keyword();
        while (ManchesterOWLSyntax.COMMA.matches(sep)) {
            this.potentialKeywords.remove((Object)ManchesterOWLSyntax.COMMA);
            descs.add(this.parseUnion());
            this.potentialKeywords.add(ManchesterOWLSyntax.COMMA);
            sep = this.peekToken();
            if (!ManchesterOWLSyntax.COMMA.matches(sep)) continue;
            sep = this.consumeToken();
        }
        return descs;
    }

    private Set<OWLClassExpression> parseClassExpressionList(ManchesterOWLSyntax expectedOpen, ManchesterOWLSyntax expectedClose) {
        String open = this.consumeToken();
        if (!expectedOpen.matches(open)) {
            throw new ExceptionBuilder().withKeyword(expectedOpen).build();
        }
        String sep = ManchesterOWLSyntax.COMMA.keyword();
        HashSet<OWLClassExpression> descs = new HashSet<OWLClassExpression>();
        while (ManchesterOWLSyntax.COMMA.matches(sep)) {
            this.potentialKeywords.remove((Object)ManchesterOWLSyntax.COMMA);
            OWLClassExpression desc = this.parseUnion();
            this.potentialKeywords.add(ManchesterOWLSyntax.COMMA);
            descs.add(desc);
            sep = this.peekToken();
            if (!ManchesterOWLSyntax.COMMA.matches(sep)) continue;
            sep = this.consumeToken();
        }
        String close = this.consumeToken();
        if (!expectedClose.matches(close)) {
            throw new ExceptionBuilder().withKeyword(expectedClose).build();
        }
        return descs;
    }

    public Set<OWLPropertyExpression> parsePropertyList() {
        HashSet<OWLPropertyExpression> props = new HashSet<OWLPropertyExpression>();
        String sep = ManchesterOWLSyntax.COMMA.keyword();
        while (ManchesterOWLSyntax.COMMA.matches(sep)) {
            props.add(this.parsePropertyExpression());
            sep = this.peekToken();
            if (!ManchesterOWLSyntax.COMMA.matches(sep)) continue;
            this.consumeToken();
        }
        return props;
    }

    public Set<OWLObjectPropertyExpression> parseObjectPropertyList() {
        HashSet<OWLObjectPropertyExpression> props = new HashSet<OWLObjectPropertyExpression>();
        String sep = ManchesterOWLSyntax.COMMA.keyword();
        while (ManchesterOWLSyntax.COMMA.matches(sep)) {
            props.add(this.parseObjectPropertyExpression(false));
            sep = this.peekToken();
            if (!ManchesterOWLSyntax.COMMA.matches(sep)) continue;
            this.consumeToken();
        }
        return props;
    }

    public Set<OWLDataProperty> parseDataPropertyList() {
        HashSet<OWLDataProperty> props = new HashSet<OWLDataProperty>();
        String sep = ManchesterOWLSyntax.COMMA.keyword();
        while (ManchesterOWLSyntax.COMMA.matches(sep)) {
            props.add(this.parseDataProperty());
            sep = this.peekToken();
            if (!ManchesterOWLSyntax.COMMA.matches(sep)) continue;
            this.consumeToken();
        }
        return props;
    }

    public Set<OWLAnnotationProperty> parseAnnotationPropertyList() {
        HashSet<OWLAnnotationProperty> props = new HashSet<OWLAnnotationProperty>();
        String sep = ManchesterOWLSyntax.COMMA.keyword();
        while (ManchesterOWLSyntax.COMMA.matches(sep)) {
            props.add(this.parseAnnotationProperty());
            sep = this.peekToken();
            if (!ManchesterOWLSyntax.COMMA.matches(sep)) continue;
            this.consumeToken();
        }
        return props;
    }

    public Set<OWLIndividual> parseIndividualList() {
        HashSet<OWLIndividual> inds = new HashSet<OWLIndividual>();
        String sep = ManchesterOWLSyntax.COMMA.keyword();
        while (ManchesterOWLSyntax.COMMA.matches(sep)) {
            inds.add(this.parseIndividual());
            sep = this.peekToken();
            if (!ManchesterOWLSyntax.COMMA.matches(sep)) continue;
            this.consumeToken();
        }
        return inds;
    }

    public List<OWLObjectPropertyExpression> parseObjectPropertyChain() {
        String delim = "o";
        ArrayList<OWLObjectPropertyExpression> properties = new ArrayList<OWLObjectPropertyExpression>();
        while ("o".equals(delim)) {
            properties.add(this.parseObjectPropertyExpression(false));
            delim = this.peekToken();
            if (!"o".equals(delim)) continue;
            this.consumeToken();
        }
        return properties;
    }

    protected OWLIndividual parseIndividual() {
        String name = this.consumeToken();
        if (!this.isIndividualName(name) && !name.startsWith("_:")) {
            throw new ExceptionBuilder().withInd().build();
        }
        return this.getOWLIndividual(name);
    }

    protected OWLDataProperty parseDataProperty() {
        String name = this.consumeToken();
        if (!this.isDataPropertyName(name)) {
            throw new ExceptionBuilder().withData().build();
        }
        return this.getOWLDataProperty(name);
    }

    protected OWLAnnotationProperty parseAnnotationProperty() {
        String name = this.consumeToken();
        if (!this.isAnnotationPropertyName(name)) {
            throw new ExceptionBuilder().withAnn().build();
        }
        return this.getOWLAnnotationProperty(name);
    }

    private Map<String, IRI> parsePrefixDeclaration() {
        this.consumeToken(ManchesterOWLSyntax.PREFIX);
        HashMap<String, IRI> map = new HashMap<String, IRI>(2);
        String prefixName = this.consumeToken();
        if ("=".equals(this.peekToken())) {
            this.consumeToken();
        }
        IRI iri = this.parseIRI();
        map.put(prefixName, iri);
        return map;
    }

    private OWLImportsDeclaration parseImportsDeclaration() {
        this.consumeToken(ManchesterOWLSyntax.IMPORT);
        return this.df.getOWLImportsDeclaration(this.parseIRI());
    }

    protected IRI parseIRI() {
        String iriString = this.consumeToken();
        if (!iriString.startsWith("<") || !iriString.endsWith(">")) {
            throw new ExceptionBuilder().withKeyword("<$IRI$>").build();
        }
        return IRI.create((String)iriString.substring(1, iriString.length() - 1));
    }

    private void processDeclaredEntities() {
        for (int i = 0; i < this.tokens.size(); ++i) {
            String token = this.tokens.get(i).getToken();
            String name = null;
            if (i + 1 < this.tokens.size()) {
                name = this.tokens.get(i + 1).getToken();
            }
            if (ManchesterOWLSyntax.CLASS.matches(token)) {
                if (name == null) continue;
                this.classNames.add(name);
                continue;
            }
            if (ManchesterOWLSyntax.OBJECT_PROPERTY.matches(token)) {
                if (name == null) continue;
                this.objectPropertyNames.add(name);
                continue;
            }
            if (ManchesterOWLSyntax.DATA_PROPERTY.matches(token)) {
                if (name == null) continue;
                this.dataPropertyNames.add(name);
                continue;
            }
            if (ManchesterOWLSyntax.INDIVIDUAL.matches(token)) {
                if (name == null) continue;
                this.individualNames.add(name);
                continue;
            }
            if (ManchesterOWLSyntax.DATATYPE.matches(token)) {
                if (name == null) continue;
                this.dataTypeNames.add(name);
                continue;
            }
            if (ManchesterOWLSyntax.ANNOTATION_PROPERTY.matches(token)) {
                if (name == null) continue;
                this.annotationPropertyNames.add(name);
                continue;
            }
            if (!ManchesterOWLSyntax.VALUE_PARTITION.matches(token)) continue;
            if (name != null) {
                this.objectPropertyNames.add(name);
            }
            if (i + 2 >= this.tokens.size()) continue;
            this.classNames.add(this.tokens.get(i + 2).getToken());
        }
    }

    private void processDeclaredEntities(OWLDeclarationAxiom ax) {
        ax.getEntity().accept((OWLEntityVisitor)new AddNames());
    }

    public ManchesterSyntaxDocumentFormat parseOntology(OWLOntology ont) {
        String section;
        HashSet<OntologyAxiomPair> axioms = new HashSet<OntologyAxiomPair>();
        OWLOntologyID ontologyID = new OWLOntologyID();
        HashSet<AddImport> imports = new HashSet<AddImport>();
        HashSet<AddOntologyAnnotation> ontologyAnnotations = new HashSet<AddOntologyAnnotation>();
        this.defaultOntology = ont;
        this.processDeclaredEntities();
        while (true) {
            if (ManchesterOWLSyntax.ONTOLOGY.matches(section = this.peekToken())) {
                ontologyID = this.handleOntology(ont, imports, ontologyAnnotations);
                continue;
            }
            if (ManchesterOWLSyntax.DISJOINT_CLASSES.matches(section)) {
                axioms.addAll(this.parseDisjointClasses());
                continue;
            }
            if (ManchesterOWLSyntax.EQUIVALENT_CLASSES.matches(section)) {
                axioms.addAll(this.parseNaryEquivalentClasses());
                continue;
            }
            if (ManchesterOWLSyntax.EQUIVALENT_PROPERTIES.matches(section)) {
                axioms.addAll(this.parseNaryEquivalentProperties());
                continue;
            }
            if (ManchesterOWLSyntax.DISJOINT_PROPERTIES.matches(section)) {
                axioms.addAll(this.parseDisjointProperties());
                continue;
            }
            if (ManchesterOWLSyntax.DIFFERENT_INDIVIDUALS.matches(section)) {
                axioms.addAll(this.parseDifferentIndividuals());
                continue;
            }
            if (ManchesterOWLSyntax.SAME_INDIVIDUAL.matches(section)) {
                axioms.addAll(this.parseSameIndividual());
                continue;
            }
            if (ManchesterOWLSyntax.CLASS.matches(section)) {
                axioms.addAll(this.parseClassFrame());
                continue;
            }
            if (ManchesterOWLSyntax.OBJECT_PROPERTY.matches(section)) {
                axioms.addAll(this.parseObjectPropertyFrame());
                continue;
            }
            if (ManchesterOWLSyntax.DATA_PROPERTY.matches(section)) {
                axioms.addAll(this.parseDataPropertyFrame());
                continue;
            }
            if (ManchesterOWLSyntax.INDIVIDUAL.matches(section)) {
                axioms.addAll(this.parseIndividualFrame());
                continue;
            }
            if (ManchesterOWLSyntax.DATATYPE.matches(section)) {
                axioms.addAll(this.parseDatatypeFrame());
                continue;
            }
            if (ManchesterOWLSyntax.ANNOTATION_PROPERTY.matches(section)) {
                axioms.addAll(this.parseAnnotationPropertyFrame());
                continue;
            }
            if (ManchesterOWLSyntax.VALUE_PARTITION.matches(section)) {
                axioms.addAll(this.parseValuePartitionFrame());
                continue;
            }
            if (ManchesterOWLSyntax.IMPORT.matches(section)) {
                OWLImportsDeclaration decl = this.parseImportsDeclaration();
                ont.getOWLOntologyManager().makeLoadImportRequest(decl, this.getOntologyLoaderConfiguration());
                imports.add(new AddImport(ont, decl));
                OWLOntology imported = ont.getOWLOntologyManager().getImportedOntology(decl);
                if (imported == null) continue;
                imported.axioms(AxiomType.DECLARATION).forEach(this::processDeclaredEntities);
                continue;
            }
            if (ManchesterOWLSyntax.PREFIX.matches(section)) {
                this.parsePrefixDeclaration().forEach((k, v) -> this.pm.setPrefix(k, v.toString()));
                continue;
            }
            if (!ManchesterOWLSyntax.RULE.matches(section)) break;
            axioms.addAll(this.parseRuleFrame());
        }
        if (!ManchesterOWLSyntaxTokenizer.eof(section)) {
            this.consumeToken();
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.CLASS, ManchesterOWLSyntax.OBJECT_PROPERTY, ManchesterOWLSyntax.DATA_PROPERTY, ManchesterOWLSyntax.INDIVIDUAL, ManchesterOWLSyntax.DATATYPE, ManchesterOWLSyntax.ANNOTATION_PROPERTY, ManchesterOWLSyntax.IMPORT, ManchesterOWLSyntax.VALUE_PARTITION, ManchesterOWLSyntax.PREFIX, ManchesterOWLSyntax.EQUIVALENT_CLASSES, ManchesterOWLSyntax.DISJOINT_CLASSES, ManchesterOWLSyntax.DISJOINT_PROPERTIES, ManchesterOWLSyntax.DIFFERENT_INDIVIDUALS, ManchesterOWLSyntax.SAME_INDIVIDUAL).build();
        }
        ArrayList<Object> changes = new ArrayList<Object>(axioms.size());
        changes.addAll(imports);
        changes.addAll(ontologyAnnotations);
        for (OntologyAxiomPair pair : axioms) {
            changes.add(new AddAxiom(ont, pair.getAxiom()));
        }
        changes.add(new SetOntologyID(ont, ontologyID));
        ont.getOWLOntologyManager().applyChanges(changes);
        ManchesterSyntaxDocumentFormat format = new ManchesterSyntaxDocumentFormat();
        format.copyPrefixesFrom((PrefixManager)this.pm);
        return format;
    }

    protected OWLOntologyID handleOntology(OWLOntology ont, Set<AddImport> imports, Set<AddOntologyAnnotation> ontologyAnnotations) {
        ManchesterOWLSyntaxOntologyHeader header = this.parseOntologyHeader(false);
        for (OWLImportsDeclaration decl : header.getImportsDeclarations()) {
            assert (decl != null);
            imports.add(new AddImport(ont, decl));
            ont.getOWLOntologyManager().makeLoadImportRequest(decl, this.getOntologyLoaderConfiguration());
            OWLOntology imported = ont.getOWLOntologyManager().getImportedOntology(decl);
            if (imported == null) continue;
            imported.axioms(AxiomType.DECLARATION).forEach(this::processDeclaredEntities);
        }
        for (OWLAnnotation anno : header.getAnnotations()) {
            ontologyAnnotations.add(new AddOntologyAnnotation(ont, anno));
        }
        OWLOntologyID ontologyID = header.getOntologyID();
        return ontologyID;
    }

    private ManchesterOWLSyntaxOntologyHeader parseOntologyHeader(boolean toEOF) {
        String section;
        String tok = this.consumeToken();
        if (!ManchesterOWLSyntax.ONTOLOGY.matches(tok)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.ONTOLOGY).build();
        }
        IRI ontologyIRI = null;
        IRI versionIRI = null;
        if (this.peekToken().startsWith("<")) {
            ontologyIRI = this.parseIRI();
            if (this.peekToken().startsWith("<")) {
                versionIRI = this.parseIRI();
            }
        }
        HashSet<OWLAnnotation> annotations = new HashSet<OWLAnnotation>();
        HashSet<OWLImportsDeclaration> imports = new HashSet<OWLImportsDeclaration>();
        while (true) {
            if (ManchesterOWLSyntax.IMPORT.matches(section = this.peekToken())) {
                this.handleImport(imports);
                continue;
            }
            if (!ManchesterOWLSyntax.ANNOTATIONS.matches(section)) break;
            this.consumeToken();
            annotations.addAll(this.parseAnnotationList());
        }
        if (!ManchesterOWLSyntaxTokenizer.eof(section) && toEOF) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.IMPORT, ManchesterOWLSyntax.ANNOTATIONS).build();
        }
        return new ManchesterOWLSyntaxOntologyHeader(ontologyIRI, versionIRI, annotations, imports);
    }

    protected void handleImport(Set<OWLImportsDeclaration> imports) {
        this.consumeToken();
        String tok = this.peekToken();
        Optional importedIRI = OWLAPIPreconditions.emptyOptional();
        if (tok.startsWith("<")) {
            importedIRI = OWLAPIPreconditions.optional((Object)this.parseIRI());
        } else if (this.isOntologyName(tok)) {
            this.consumeToken();
            OWLOntology ont = this.getOntology(tok);
            if (ont != null) {
                importedIRI = ont.getOntologyID().getOntologyIRI();
            }
        } else {
            this.consumeToken();
            throw new ExceptionBuilder().withOnto().withKeyword("<$ONTOLOGYYURI$>").build();
        }
        if (!importedIRI.isPresent()) {
            throw new ExceptionBuilder().withOnto().withKeyword("Imported IRI is null").build();
        }
        IRI importedOntologyIRI = (IRI)importedIRI.get();
        imports.add(this.df.getOWLImportsDeclaration(importedOntologyIRI));
    }

    protected List<String> getTokenSequence() {
        ArrayList<String> seq = new ArrayList<String>();
        int index = this.tokenIndex - 1;
        if (index < 0) {
            index = 0;
        }
        while (index < this.tokens.size() && seq.size() < 4 && !seq.contains("|EOF|")) {
            seq.add(this.tokens.get(index).getToken());
            ++index;
        }
        if (seq.isEmpty()) {
            seq.add("|EOF|");
        }
        return seq;
    }

    protected IRI getIRI(String inputName) {
        IRI uri;
        String name = inputName;
        boolean fullIRI = "<".equals(name);
        if (fullIRI) {
            name = this.consumeToken();
            this.consumeToken();
        }
        if ((uri = this.nameIRIMap.get(name)) != null) {
            return uri;
        }
        if (fullIRI) {
            uri = IRI.create((String)name);
        } else {
            int colonIndex = name.indexOf(58);
            if (colonIndex == -1) {
                name = ":" + name;
            }
            uri = this.pm.getIRI(name);
        }
        this.nameIRIMap.put(name, uri);
        return uri;
    }

    public OWLAxiom parseAxiom() {
        String token = this.peekToken();
        if (this.isClassName(token)) {
            return this.parseAxiomWithClassExpressionStart();
        }
        if (this.isObjectPropertyName(token)) {
            return this.parseAxiomWithObjectPropertyStart();
        }
        if (this.isDataPropertyName(token)) {
            return this.parseAxiomWithDataPropertyStart();
        }
        if (this.isIndividualName(token)) {
            return this.parseAxiomWithIndividualStart();
        }
        if (ManchesterOWLSyntax.INV.matches(token)) {
            return this.parseAxiomWithObjectPropertyStart();
        }
        if (ManchesterOWLSyntax.OPEN.matches(token)) {
            return this.parseAxiomWithClassExpressionStart();
        }
        if (ManchesterOWLSyntax.OPENBRACE.matches(token)) {
            return this.parseAxiomWithClassExpressionStart();
        }
        if (ManchesterOWLSyntax.FUNCTIONAL.matches(token)) {
            return this.parseFunctionPropertyAxiom();
        }
        if (ManchesterOWLSyntax.INVERSE_FUNCTIONAL.matches(token)) {
            return this.parseInverseFunctionalPropertyAxiom();
        }
        if (ManchesterOWLSyntax.SYMMETRIC.matches(token)) {
            return this.parseSymmetricPropertyAxiom();
        }
        if (ManchesterOWLSyntax.ASYMMETRIC.matches(token)) {
            return this.parseAsymmetricPropertyAxiom();
        }
        if (ManchesterOWLSyntax.TRANSITIVE.matches(token)) {
            return this.parseTransitivePropertyAxiom();
        }
        if (ManchesterOWLSyntax.REFLEXIVE.matches(token)) {
            return this.parseReflexivePropertyAxiom();
        }
        if (ManchesterOWLSyntax.IRREFLEXIVE.matches(token)) {
            return this.parseIrreflexivePropertyAxiom();
        }
        throw new ExceptionBuilder().withClass().withObject().withData().withKeyword(ManchesterOWLSyntax.OPEN, ManchesterOWLSyntax.OPENBRACE, ManchesterOWLSyntax.INV, ManchesterOWLSyntax.FUNCTIONAL, ManchesterOWLSyntax.INVERSE_FUNCTIONAL, ManchesterOWLSyntax.SYMMETRIC, ManchesterOWLSyntax.ASYMMETRIC, ManchesterOWLSyntax.TRANSITIVE, ManchesterOWLSyntax.REFLEXIVE, ManchesterOWLSyntax.IRREFLEXIVE).build();
    }

    public OWLClassAxiom parseClassAxiom() {
        return (OWLClassAxiom)this.parseAxiom();
    }

    private OWLAxiom parseAxiomWithIndividualStart() {
        OWLIndividual ind = this.parseIndividual();
        String kw = this.consumeToken();
        if (ManchesterOWLSyntax.TYPE.matches(kw)) {
            OWLClassExpression type = this.parseClassExpression();
            return this.df.getOWLClassAssertionAxiom(type, ind);
        }
        throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.TYPE).build();
    }

    private OWLAxiom parseAxiomWithDataPropertyStart() {
        OWLDataProperty prop = this.parseDataProperty();
        String kw = this.consumeToken();
        if (ManchesterOWLSyntax.SOME.matches(kw)) {
            OWLDataRange dataRange = this.parseDataIntersectionOf();
            return this.parseClassAxiomRemainder((OWLClassExpression)this.df.getOWLDataSomeValuesFrom((OWLDataPropertyExpression)prop, dataRange));
        }
        if (ManchesterOWLSyntax.ONLY.matches(kw)) {
            OWLDataRange dataRange = this.parseDataIntersectionOf();
            return this.parseClassAxiomRemainder((OWLClassExpression)this.df.getOWLDataAllValuesFrom((OWLDataPropertyExpression)prop, dataRange));
        }
        if (ManchesterOWLSyntax.MIN.matches(kw)) {
            int cardi = this.parseInteger();
            OWLDataRange dataRange = this.parseDataIntersectionOf();
            return this.parseClassAxiomRemainder((OWLClassExpression)this.df.getOWLDataMinCardinality(cardi, (OWLDataPropertyExpression)prop, dataRange));
        }
        if (ManchesterOWLSyntax.MAX.matches(kw)) {
            int cardi = this.parseInteger();
            OWLDataRange dataRange = this.parseDataIntersectionOf();
            return this.parseClassAxiomRemainder((OWLClassExpression)this.df.getOWLDataMaxCardinality(cardi, (OWLDataPropertyExpression)prop, dataRange));
        }
        if (ManchesterOWLSyntax.EXACTLY.matches(kw)) {
            int cardi = this.parseInteger();
            OWLDataRange dataRange = this.parseDataIntersectionOf();
            return this.parseClassAxiomRemainder((OWLClassExpression)this.df.getOWLDataExactCardinality(cardi, (OWLDataPropertyExpression)prop, dataRange));
        }
        if (ManchesterOWLSyntax.SUB_PROPERTY_OF.matches(kw)) {
            OWLDataPropertyExpression superProperty = this.parseDataPropertyExpression();
            return this.df.getOWLSubDataPropertyOfAxiom((OWLDataPropertyExpression)prop, superProperty);
        }
        if (ManchesterOWLSyntax.EQUIVALENT_TO.matches(kw)) {
            OWLDataPropertyExpression equivProp = this.parseDataPropertyExpression();
            return this.df.getOWLEquivalentDataPropertiesAxiom((OWLDataPropertyExpression)prop, equivProp);
        }
        if (ManchesterOWLSyntax.DISJOINT_WITH.matches(kw)) {
            OWLDataPropertyExpression disjProp = this.parseDataPropertyExpression();
            return this.df.getOWLDisjointDataPropertiesAxiom(new OWLDataPropertyExpression[]{prop, disjProp});
        }
        if (ManchesterOWLSyntax.DOMAIN.matches(kw)) {
            OWLClassExpression domain = this.parseClassExpression();
            return this.df.getOWLDataPropertyDomainAxiom((OWLDataPropertyExpression)prop, domain);
        }
        if (ManchesterOWLSyntax.RANGE.matches(kw)) {
            OWLDataRange range = this.parseDataRange();
            return this.df.getOWLDataPropertyRangeAxiom((OWLDataPropertyExpression)prop, range);
        }
        throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.SOME, ManchesterOWLSyntax.ONLY, ManchesterOWLSyntax.MIN, ManchesterOWLSyntax.MAX, ManchesterOWLSyntax.EXACTLY, ManchesterOWLSyntax.SUB_PROPERTY_OF, ManchesterOWLSyntax.EQUIVALENT_TO, ManchesterOWLSyntax.DISJOINT_WITH, ManchesterOWLSyntax.DOMAIN, ManchesterOWLSyntax.RANGE).build();
    }

    private OWLDataPropertyExpression parseDataPropertyExpression() {
        String tok = this.consumeToken();
        if (!this.isDataPropertyName(tok)) {
            throw new ExceptionBuilder().withData().build();
        }
        return this.getOWLDataProperty(tok);
    }

    private OWLAxiom parseAxiomWithClassExpressionStart() {
        return this.parseClassAxiomRemainder(this.parseUnion());
    }

    private OWLAxiom parseClassAxiomRemainder(OWLClassExpression startExpression) {
        String kw = this.consumeToken();
        if (ManchesterOWLSyntax.SUBCLASS_OF.matchesEitherForm(kw)) {
            OWLClassExpression superClass = this.parseClassExpression();
            return this.df.getOWLSubClassOfAxiom(startExpression, superClass);
        }
        if (ManchesterOWLSyntax.DISJOINT_WITH.matchesEitherForm(kw)) {
            OWLClassExpression disjointClass = this.parseClassExpression();
            return this.df.getOWLDisjointClassesAxiom(new OWLClassExpression[]{startExpression, disjointClass});
        }
        if (ManchesterOWLSyntax.EQUIVALENT_TO.matchesEitherForm(kw)) {
            OWLClassExpression equivClass = this.parseClassExpression();
            return this.df.getOWLEquivalentClassesAxiom(startExpression, equivClass);
        }
        if (ManchesterOWLSyntax.AND.matchesEitherForm(kw)) {
            OWLClassExpression conjunct = this.parseIntersection();
            Set conjuncts = conjunct.asConjunctSet();
            conjuncts.add(startExpression);
            OWLObjectIntersectionOf ce = this.df.getOWLObjectIntersectionOf((Collection)conjuncts);
            return this.parseClassAxiomRemainder((OWLClassExpression)ce);
        }
        if (ManchesterOWLSyntax.OR.matchesEitherForm(kw)) {
            OWLClassExpression disjunct = this.parseUnion();
            Set disjuncts = disjunct.asDisjunctSet();
            disjuncts.add(startExpression);
            OWLObjectUnionOf ce = this.df.getOWLObjectUnionOf((Collection)disjuncts);
            return this.parseClassAxiomRemainder((OWLClassExpression)ce);
        }
        throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.SUBCLASS_OF, ManchesterOWLSyntax.DISJOINT_WITH, ManchesterOWLSyntax.EQUIVALENT_TO, ManchesterOWLSyntax.AND, ManchesterOWLSyntax.OR).build();
    }

    private OWLAxiom parseAxiomWithObjectPropertyStart() {
        OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression(false);
        String kw = this.consumeToken();
        if (ManchesterOWLSyntax.SOME.matches(kw)) {
            OWLClassExpression filler = this.parseUnion();
            return this.parseClassAxiomRemainder((OWLClassExpression)this.df.getOWLObjectSomeValuesFrom(prop, filler));
        }
        if (ManchesterOWLSyntax.ONLY.matches(kw)) {
            OWLClassExpression filler = this.parseUnion();
            return this.parseClassAxiomRemainder((OWLClassExpression)this.df.getOWLObjectAllValuesFrom(prop, filler));
        }
        if (ManchesterOWLSyntax.MIN.matches(kw)) {
            int cardi = this.parseInteger();
            OWLClassExpression filler = this.parseUnion();
            return this.parseClassAxiomRemainder((OWLClassExpression)this.df.getOWLObjectMinCardinality(cardi, prop, filler));
        }
        if (ManchesterOWLSyntax.MAX.matches(kw)) {
            int cardi = this.parseInteger();
            OWLClassExpression filler = this.parseUnion();
            return this.parseClassAxiomRemainder((OWLClassExpression)this.df.getOWLObjectMaxCardinality(cardi, prop, filler));
        }
        if (ManchesterOWLSyntax.EXACTLY.matches(kw)) {
            int cardi = this.parseInteger();
            OWLClassExpression filler = this.parseUnion();
            return this.parseClassAxiomRemainder((OWLClassExpression)this.df.getOWLObjectExactCardinality(cardi, prop, filler));
        }
        if (ManchesterOWLSyntax.SUB_PROPERTY_OF.matches(kw)) {
            OWLObjectPropertyExpression superProperty = this.parseObjectPropertyExpression(false);
            return this.df.getOWLSubObjectPropertyOfAxiom(prop, superProperty);
        }
        if (ManchesterOWLSyntax.EQUIVALENT_TO.matches(kw)) {
            OWLObjectPropertyExpression equivProp = this.parseObjectPropertyExpression(false);
            return this.df.getOWLEquivalentObjectPropertiesAxiom(prop, equivProp);
        }
        if (ManchesterOWLSyntax.INVERSE_OF.matches(kw)) {
            OWLObjectPropertyExpression invProp = this.parseObjectPropertyExpression(false);
            return this.df.getOWLInverseObjectPropertiesAxiom(prop, invProp);
        }
        if (ManchesterOWLSyntax.DISJOINT_WITH.matches(kw)) {
            OWLObjectPropertyExpression disjProp = this.parseObjectPropertyExpression(false);
            return this.df.getOWLDisjointObjectPropertiesAxiom(new OWLObjectPropertyExpression[]{prop, disjProp});
        }
        if (ManchesterOWLSyntax.DOMAIN.matches(kw)) {
            OWLClassExpression domain = this.parseClassExpression();
            return this.df.getOWLObjectPropertyDomainAxiom(prop, domain);
        }
        if (ManchesterOWLSyntax.RANGE.matches(kw)) {
            OWLClassExpression range = this.parseClassExpression();
            return this.df.getOWLObjectPropertyRangeAxiom(prop, range);
        }
        if (ManchesterOWLSyntax.CHAIN_CONNECT.matches(kw)) {
            String sep = kw;
            ArrayList<OWLObjectPropertyExpression> chain = new ArrayList<OWLObjectPropertyExpression>();
            chain.add(prop);
            while ("o".equals(sep)) {
                OWLObjectPropertyExpression chainProp = this.parseObjectPropertyExpression(false);
                chain.add(chainProp);
                sep = this.consumeToken();
            }
            if (!ManchesterOWLSyntax.SUB_PROPERTY_OF.matches(sep)) {
                throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.SUB_PROPERTY_OF).build();
            }
            OWLObjectPropertyExpression superProp = this.parseObjectPropertyExpression(false);
            return this.df.getOWLSubPropertyChainOfAxiom(chain, superProp);
        }
        throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.SOME, ManchesterOWLSyntax.ONLY, ManchesterOWLSyntax.MIN, ManchesterOWLSyntax.MAX, ManchesterOWLSyntax.EXACTLY, ManchesterOWLSyntax.SUB_PROPERTY_OF, ManchesterOWLSyntax.EQUIVALENT_TO, ManchesterOWLSyntax.INVERSE_OF, ManchesterOWLSyntax.DISJOINT_WITH, ManchesterOWLSyntax.DOMAIN, ManchesterOWLSyntax.RANGE, ManchesterOWLSyntax.CHAIN_CONNECT).build();
    }

    private OWLAxiom parseInverseFunctionalPropertyAxiom() {
        String kw = this.consumeToken();
        if (!ManchesterOWLSyntax.INVERSE_FUNCTIONAL.matches(kw)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.INVERSE_FUNCTIONAL).build();
        }
        return this.df.getOWLInverseFunctionalObjectPropertyAxiom(this.parseObjectPropertyExpression(false));
    }

    private OWLAxiom parseSymmetricPropertyAxiom() {
        String kw = this.consumeToken();
        if (!ManchesterOWLSyntax.SYMMETRIC.matches(kw)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.SYMMETRIC).build();
        }
        return this.df.getOWLSymmetricObjectPropertyAxiom(this.parseObjectPropertyExpression(false));
    }

    private OWLAxiom parseAsymmetricPropertyAxiom() {
        String kw = this.consumeToken();
        if (!ManchesterOWLSyntax.ASYMMETRIC.matches(kw)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.ASYMMETRIC).build();
        }
        return this.df.getOWLAsymmetricObjectPropertyAxiom(this.parseObjectPropertyExpression(false));
    }

    private OWLAxiom parseTransitivePropertyAxiom() {
        String kw = this.consumeToken();
        if (!ManchesterOWLSyntax.TRANSITIVE.matches(kw)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.TRANSITIVE).build();
        }
        return this.df.getOWLTransitiveObjectPropertyAxiom(this.parseObjectPropertyExpression(false));
    }

    private OWLAxiom parseReflexivePropertyAxiom() {
        String kw = this.consumeToken();
        if (!ManchesterOWLSyntax.REFLEXIVE.matches(kw)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.REFLEXIVE).build();
        }
        return this.df.getOWLReflexiveObjectPropertyAxiom(this.parseObjectPropertyExpression(false));
    }

    private OWLAxiom parseIrreflexivePropertyAxiom() {
        String kw = this.consumeToken();
        if (!ManchesterOWLSyntax.IRREFLEXIVE.matches(kw)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.IRREFLEXIVE).build();
        }
        return this.df.getOWLIrreflexiveObjectPropertyAxiom(this.parseObjectPropertyExpression(false));
    }

    private OWLAxiom parseFunctionPropertyAxiom() {
        String kw = this.consumeToken();
        if (!ManchesterOWLSyntax.FUNCTIONAL.matches(kw)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.FUNCTIONAL).build();
        }
        String name = this.peekToken();
        if (this.isObjectPropertyName(name)) {
            return this.df.getOWLFunctionalObjectPropertyAxiom(this.parseObjectPropertyExpression(false));
        }
        if (this.isDataPropertyName(name)) {
            return this.df.getOWLFunctionalDataPropertyAxiom((OWLDataPropertyExpression)this.parseDataProperty());
        }
        this.consumeToken();
        throw new ExceptionBuilder().withObject().withData().build();
    }

    private <F, O> Set<OntologyAxiomPair> parseAnnotatedListItems(F s, AnnAxiom<F, O> itemParser, Set<OWLOntology> ontologies) {
        HashSet<OntologyAxiomPair> result = new HashSet<OntologyAxiomPair>();
        String sep = ManchesterOWLSyntax.COMMA.keyword();
        while (ManchesterOWLSyntax.COMMA.matches(sep)) {
            Set<OWLAnnotation> annotations = this.parseAnnotations();
            Object item = itemParser.parse.apply(s);
            OWLAxiom axiom = itemParser.createAxiom(s, item, annotations);
            for (OWLOntology ontology : ontologies) {
                result.add(new OntologyAxiomPair(ontology, axiom));
            }
            sep = this.peekToken();
            if (!ManchesterOWLSyntax.COMMA.matches(sep)) continue;
            this.consumeToken();
        }
        return result;
    }

    static OWLAxiom create(OWLDataFactory d, OWLIndividual s, Set<OWLIndividual> o, Collection<OWLAnnotation> anns) {
        HashSet<OWLIndividual> individuals = new HashSet<OWLIndividual>();
        individuals.add(s);
        individuals.addAll(o);
        return d.getOWLDifferentIndividualsAxiom(individuals, anns);
    }

    static OWLAxiom create(OWLDataFactory d, OWLIndividual s, OWLAnnotation o, Collection<OWLAnnotation> anns) {
        if (s.isAnonymous()) {
            return d.getOWLAnnotationAssertionAxiom((OWLAnnotationSubject)s.asOWLAnonymousIndividual(), o, anns);
        }
        return d.getOWLAnnotationAssertionAxiom((OWLAnnotationSubject)s.asOWLNamedIndividual().getIRI(), o, anns);
    }

    @FunctionalInterface
    static interface Builder<F, O> {
        public OWLAxiom createAxiom(F var1, O var2, Collection<OWLAnnotation> var3);
    }

    static class AnnAxiom<F, O> {
        Function<F, O> parse;
        ManchesterOWLSyntax keyword;
        Builder<F, O> builder;

        AnnAxiom(Function<F, O> p, ManchesterOWLSyntax k, Builder<F, O> b) {
            this.parse = p;
            this.keyword = k;
            this.builder = b;
        }

        final OWLAxiom createAxiom(F s, O o, Collection<OWLAnnotation> anns) {
            return this.builder.createAxiom(s, o, anns);
        }
    }

    class DefaultEntityChecker
    implements OWLEntityChecker {
        DefaultEntityChecker() {
        }

        @Nullable
        public OWLClass getOWLClass(String name) {
            if ("Thing".equals(name) || "owl:Thing".equals(name)) {
                return ManchesterOWLSyntaxParserImpl.this.df.getOWLThing();
            }
            if ("Nothing".equals(name) || "owl:Nothing".equals(name)) {
                return ManchesterOWLSyntaxParserImpl.this.df.getOWLNothing();
            }
            if (ManchesterOWLSyntaxParserImpl.this.classNames.contains(name)) {
                return ManchesterOWLSyntaxParserImpl.this.df.getOWLClass(ManchesterOWLSyntaxParserImpl.this.getIRI(name));
            }
            return null;
        }

        @Nullable
        public OWLObjectProperty getOWLObjectProperty(String name) {
            if (ManchesterOWLSyntaxParserImpl.this.objectPropertyNames.contains(name)) {
                return ManchesterOWLSyntaxParserImpl.this.df.getOWLObjectProperty(ManchesterOWLSyntaxParserImpl.this.getIRI(name));
            }
            return null;
        }

        @Nullable
        public OWLDataProperty getOWLDataProperty(String name) {
            if (ManchesterOWLSyntaxParserImpl.this.dataPropertyNames.contains(name)) {
                return ManchesterOWLSyntaxParserImpl.this.df.getOWLDataProperty(ManchesterOWLSyntaxParserImpl.this.getIRI(name));
            }
            return null;
        }

        @Nullable
        public OWLNamedIndividual getOWLIndividual(String name) {
            if (ManchesterOWLSyntaxParserImpl.this.individualNames.contains(name)) {
                return ManchesterOWLSyntaxParserImpl.this.df.getOWLNamedIndividual(ManchesterOWLSyntaxParserImpl.this.getIRI(name));
            }
            return null;
        }

        @Nullable
        public OWLDatatype getOWLDatatype(String name) {
            if (ManchesterOWLSyntaxParserImpl.this.dataTypeNames.contains(name)) {
                return ManchesterOWLSyntaxParserImpl.this.df.getOWLDatatype(ManchesterOWLSyntaxParserImpl.this.getIRI(name));
            }
            return null;
        }

        @Nullable
        public OWLAnnotationProperty getOWLAnnotationProperty(String name) {
            if (ManchesterOWLSyntaxParserImpl.this.annotationPropertyNames.contains(name)) {
                return ManchesterOWLSyntaxParserImpl.this.df.getOWLAnnotationProperty(ManchesterOWLSyntaxParserImpl.this.getIRI(name));
            }
            return null;
        }
    }

    protected class ExceptionBuilder {
        boolean ontologyNameExpected = false;
        boolean classNameExpected = false;
        boolean objectPropertyNameExpected = false;
        boolean dataPropertyNameExpected = false;
        boolean individualNameExpected = false;
        boolean datatypeNameExpected = false;
        boolean annotationPropertyNameExpected = false;
        boolean integerExpected = false;
        Set<String> keywords = new HashSet<String>();
        @Nullable
        List<String> tokenSequence;
        int start = -1;
        int line = -1;
        int column = -1;

        ExceptionBuilder() {
            this.withKeyword(ManchesterOWLSyntaxParserImpl.this.potentialKeywords);
        }

        ExceptionBuilder(ParserException e) {
            this.ontologyNameExpected = e.isOntologyNameExpected();
            this.classNameExpected = e.isClassNameExpected();
            this.objectPropertyNameExpected = e.isObjectPropertyNameExpected();
            this.dataPropertyNameExpected = e.isDataPropertyNameExpected();
            this.individualNameExpected = e.isIndividualNameExpected();
            this.dataPropertyNameExpected = e.isDatatypeNameExpected();
            this.annotationPropertyNameExpected = e.isAnnotationPropertyNameExpected();
            this.integerExpected = e.isIntegerExpected();
            this.withKeyword(e.getExpectedKeywords());
            this.tokenSequence = e.getTokenSequence();
            this.start = e.getStartPos();
            this.line = e.getLineNumber();
            this.column = e.getColumnNumber();
        }

        public ExceptionBuilder withOnto() {
            this.ontologyNameExpected = true;
            return this;
        }

        public ExceptionBuilder withInt() {
            this.integerExpected = true;
            return this;
        }

        public ExceptionBuilder withClass() {
            this.classNameExpected = true;
            return this;
        }

        public ExceptionBuilder withObject() {
            this.objectPropertyNameExpected = true;
            this.withKeyword(ManchesterOWLSyntax.INVERSE);
            return this;
        }

        public ExceptionBuilder withData() {
            this.dataPropertyNameExpected = true;
            return this;
        }

        public ExceptionBuilder withInd() {
            this.individualNameExpected = true;
            return this;
        }

        public ExceptionBuilder withDt() {
            this.datatypeNameExpected = true;
            return this;
        }

        public ExceptionBuilder withAnn() {
            this.annotationPropertyNameExpected = true;
            return this;
        }

        public ExceptionBuilder withKeyword(String s) {
            this.keywords.add(s);
            return this;
        }

        public ExceptionBuilder withKeyword(ManchesterOWLSyntax s) {
            this.keywords.add(s.keyword());
            return this;
        }

        public ExceptionBuilder withKeyword(String ... strings) {
            for (String s : strings) {
                this.keywords.add(s);
            }
            return this;
        }

        public ExceptionBuilder withKeyword(ManchesterOWLSyntax ... keys) {
            for (ManchesterOWLSyntax s : keys) {
                this.keywords.add(s.keyword());
            }
            return this;
        }

        public <T> ExceptionBuilder withKeyword(Collection<T> keys) {
            for (T s : keys) {
                if (s instanceof String) {
                    this.withKeyword((String)s);
                }
                if (!(s instanceof ManchesterOWLSyntax)) continue;
                this.withKeyword((ManchesterOWLSyntax)((Object)s));
            }
            return this;
        }

        public ParserException build() {
            if (this.tokenSequence == null) {
                ManchesterOWLSyntaxTokenizer.Token lastToken = ManchesterOWLSyntaxParserImpl.this.getLastToken();
                this.tokenSequence = ManchesterOWLSyntaxParserImpl.this.getTokenSequence();
                this.start = lastToken.getPos();
                this.line = lastToken.getRow();
                this.column = lastToken.getCol();
            }
            return new ParserException((List<String>)((List)OWLAPIPreconditions.verifyNotNull(this.tokenSequence)), this.start, this.line, this.column, this.ontologyNameExpected, this.classNameExpected, this.objectPropertyNameExpected, this.dataPropertyNameExpected, this.individualNameExpected, this.datatypeNameExpected, this.annotationPropertyNameExpected, this.integerExpected, this.keywords);
        }
    }

    class AddNames
    implements OWLEntityVisitor {
        AddNames() {
        }

        public void visit(OWLAnnotationProperty property) {
            ManchesterOWLSyntaxParserImpl.this.annotationPropertyNames.add(ManchesterOWLSyntaxParserImpl.this.pm.getShortForm(property.getIRI()));
        }

        public void visit(OWLDatatype datatype) {
            ManchesterOWLSyntaxParserImpl.this.dataTypeNames.add(ManchesterOWLSyntaxParserImpl.this.pm.getShortForm(datatype.getIRI()));
        }

        public void visit(OWLNamedIndividual individual) {
            ManchesterOWLSyntaxParserImpl.this.individualNames.add(ManchesterOWLSyntaxParserImpl.this.pm.getShortForm(individual.getIRI()));
        }

        public void visit(OWLDataProperty property) {
            ManchesterOWLSyntaxParserImpl.this.dataPropertyNames.add(ManchesterOWLSyntaxParserImpl.this.pm.getShortForm(property.getIRI()));
        }

        public void visit(OWLObjectProperty property) {
            ManchesterOWLSyntaxParserImpl.this.objectPropertyNames.add(ManchesterOWLSyntaxParserImpl.this.pm.getShortForm(property.getIRI()));
        }

        public void visit(OWLClass cls) {
            ManchesterOWLSyntaxParserImpl.this.classNames.add(ManchesterOWLSyntaxParserImpl.this.pm.getShortForm(cls.getIRI()));
        }
    }
}

