/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.latex.renderer;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.io.AbstractOWLRenderer;
import org.semanticweb.owlapi.io.OWLRendererException;
import org.semanticweb.owlapi.latex.renderer.LatexObjectVisitor;
import org.semanticweb.owlapi.latex.renderer.LatexRendererIOException;
import org.semanticweb.owlapi.latex.renderer.LatexWriter;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.semanticweb.owlapi.util.OWLEntityComparator;
import org.semanticweb.owlapi.util.ShortFormProvider;
import org.semanticweb.owlapi.util.SimpleShortFormProvider;

public class LatexRenderer
extends AbstractOWLRenderer {
    private final ShortFormProvider shortFormProvider = new SimpleShortFormProvider();
    private final OWLEntityComparator entityComparator = new OWLEntityComparator(this.shortFormProvider);

    private void writeEntitySection(OWLEntity entity, LatexWriter w) {
        w.write("\\subsubsection*{");
        w.write(LatexRenderer.escapeName(this.shortFormProvider.getShortForm(entity)));
        w.write("}\n\n");
    }

    private static String escapeName(String name) {
        return name.replace("_", "\\_");
    }

    public void render(OWLOntology o, PrintWriter _w) throws OWLRendererException {
        try {
            LatexWriter w = new LatexWriter(_w);
            w.write("\\documentclass{article}\n");
            w.write("\\parskip 0pt\n");
            w.write("\\parindent 0pt\n");
            w.write("\\oddsidemargin 0cm\n");
            w.write("\\textwidth 19cm\n");
            w.write("\\begin{document}\n\n");
            LatexObjectVisitor renderer = new LatexObjectVisitor(w, o.getOWLOntologyManager().getOWLDataFactory());
            Collection clses = this.sortEntities(o.classesInSignature());
            if (!clses.isEmpty()) {
                w.write("\\subsection*{Classes}\n\n");
            }
            for (OWLClass cls : clses) {
                this.writeEntity(w, renderer, (OWLEntity)cls, LatexRenderer.sortAxioms(o.axioms(cls)));
            }
            w.write("\\section*{Object properties}");
            this.sortEntities(o.objectPropertiesInSignature()).forEach(p -> this.writeEntity(w, renderer, (OWLEntity)p, LatexRenderer.sortAxioms(o.axioms((OWLObjectPropertyExpression)p))));
            w.write("\\section*{Data properties}");
            o.dataPropertiesInSignature().sorted(this.entityComparator).forEach(prop -> this.writeEntity(w, renderer, (OWLEntity)prop, LatexRenderer.sortAxioms(o.axioms(prop))));
            w.write("\\section*{Individuals}");
            o.individualsInSignature().sorted(this.entityComparator).forEach(i -> this.writeEntity(w, renderer, (OWLEntity)i, LatexRenderer.sortAxioms(o.axioms((OWLIndividual)i))));
            w.write("\\section*{Datatypes}");
            o.datatypesInSignature().sorted(this.entityComparator).forEach(type -> this.writeEntity(w, renderer, (OWLEntity)type, LatexRenderer.sortAxioms(o.axioms(type, Imports.EXCLUDED))));
            w.write("\\end{document}\n");
            w.flush();
        }
        catch (OWLRuntimeException e) {
            throw new LatexRendererIOException((Exception)((Object)e));
        }
    }

    protected void writeEntity(LatexWriter w, LatexObjectVisitor renderer, OWLEntity cls, Collection<? extends OWLAxiom> axioms) {
        this.writeEntitySection(cls, w);
        for (OWLAxiom oWLAxiom : axioms) {
            renderer.setSubject((OWLObject)cls);
            oWLAxiom.accept((OWLObjectVisitor)renderer);
            w.write("\n\n");
        }
    }

    private <T extends OWLEntity> Collection<T> sortEntities(Stream<T> entities) {
        return OWLAPIStreamUtils.asList(entities.sorted((Comparator<T>)this.entityComparator));
    }

    private static Collection<? extends OWLAxiom> sortAxioms(Stream<? extends OWLAxiom> axioms) {
        return OWLAPIStreamUtils.asList(axioms.sorted(new OWLAxiomComparator()));
    }

    private static class OWLAxiomComparator
    implements Comparator<OWLAxiom>,
    Serializable {
        OWLAxiomComparator() {
        }

        @Override
        public int compare(@Nullable OWLAxiom o1, @Nullable OWLAxiom o2) {
            int index1 = ((OWLAxiom)OWLAPIPreconditions.verifyNotNull((Object)o1)).getAxiomType().getIndex();
            int index2 = ((OWLAxiom)OWLAPIPreconditions.verifyNotNull((Object)o2)).getAxiomType().getIndex();
            return index1 - index2;
        }
    }
}

