/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rdf.model;

import com.google.common.base.Optional;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.io.RDFResourceBlankNode;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLCardinalityRestriction;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLDocumentFormatImpl;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitorEx;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLIndividualAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLRestriction;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLDataPropertyAtom;
import org.semanticweb.owlapi.model.SWRLDataRangeAtom;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.model.SWRLIndividualArgument;
import org.semanticweb.owlapi.model.SWRLLiteralArgument;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLObjectVisitor;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.rdf.RDFRendererBase;
import org.semanticweb.owlapi.rdf.model.RDFGraph;
import org.semanticweb.owlapi.util.AxiomAppearance;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.IndividualAppearance;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;
import org.semanticweb.owlapi.vocab.SWRLVocabulary;
import org.semanticweb.owlapi.vocab.XSDVocabulary;

public abstract class AbstractTranslator<N extends Serializable, R extends N, P extends N, L extends N>
implements OWLObjectVisitor,
SWRLObjectVisitor {
    private final OWLOntologyManager manager;
    private final OWLOntology ont;
    private final boolean useStrongTyping;
    protected final IndividualAppearance multipleOccurrences;
    protected final AxiomAppearance axiomOccurrences;
    protected RDFGraph graph = new RDFGraph();
    private final AtomicInteger nextBlankNodeId;
    private final Map<Object, Integer> blankNodeMap;
    @Nonnull
    private final Map<OWLObject, N> nodeMap = new HashMap<OWLObject, N>();
    private final Map<OWLObject, N> expressionMap = new IdentityHashMap<OWLObject, N>();
    @Nonnull
    private final Set<OWLIndividual> currentIndividuals = new HashSet<OWLIndividual>();

    public AbstractTranslator(@Nonnull OWLOntologyManager manager, @Nonnull OWLOntology ontology, boolean useStrongTyping, IndividualAppearance multiple, AxiomAppearance appearance, AtomicInteger nextNode, Map<Object, Integer> blankNodeMap) {
        this.ont = (OWLOntology)OWLAPIPreconditions.checkNotNull((Object)ontology, (String)"ontology cannot be null");
        this.manager = (OWLOntologyManager)OWLAPIPreconditions.checkNotNull((Object)manager, (String)"manager cannot be null");
        this.useStrongTyping = useStrongTyping;
        this.multipleOccurrences = multiple;
        this.axiomOccurrences = appearance;
        this.nextBlankNodeId = nextNode;
        this.blankNodeMap = blankNodeMap;
    }

    @Nonnull
    protected RDFResourceBlankNode getBlankNodeFor(Object key, boolean isIndividual, boolean needId, boolean isAxiom) {
        Integer id = this.blankNodeMap.get(key);
        if (id == null) {
            id = this.nextBlankNodeId.getAndIncrement();
            this.blankNodeMap.put(key, id);
        }
        return new RDFResourceBlankNode(id, isIndividual, needId, isAxiom);
    }

    public void visit(@Nonnull OWLDeclarationAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getEntity(), OWLRDFVocabulary.RDF_TYPE.getIRI(), (IRI)axiom.getEntity().accept((OWLEntityVisitorEx)OWLEntityTypeProvider.INSTANCE));
    }

    public void visit(@Nonnull OWLObjectInverseOf property) {
        this.translateAnonymousNode((OWLObject)property);
        this.addTriple((OWLObject)property, OWLRDFVocabulary.OWL_INVERSE_OF.getIRI(), (OWLObject)property.getInverse());
    }

    public void visit(@Nonnull OWLDataIntersectionOf node) {
        this.translateAnonymousNode((OWLObject)node);
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.RDFS_DATATYPE.getIRI());
        this.addListTriples((OWLObject)node, OWLRDFVocabulary.OWL_INTERSECTION_OF.getIRI(), node.getOperands());
    }

    public void visit(@Nonnull OWLDataUnionOf node) {
        this.translateAnonymousNode((OWLObject)node);
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.RDFS_DATATYPE.getIRI());
        this.addListTriples((OWLObject)node, OWLRDFVocabulary.OWL_UNION_OF.getIRI(), node.getOperands());
    }

    public void visit(@Nonnull OWLDataComplementOf node) {
        this.translateAnonymousNode((OWLObject)node);
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.RDFS_DATATYPE.getIRI());
        this.addTriple((OWLObject)node, OWLRDFVocabulary.OWL_DATATYPE_COMPLEMENT_OF.getIRI(), (OWLObject)node.getDataRange());
    }

    public void visit(@Nonnull OWLDataOneOf node) {
        this.translateAnonymousNode((OWLObject)node);
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.RDFS_DATATYPE.getIRI());
        this.addListTriples((OWLObject)node, OWLRDFVocabulary.OWL_ONE_OF.getIRI(), node.getValues());
    }

    public void visit(@Nonnull OWLDatatypeRestriction node) {
        this.translateAnonymousNode((OWLObject)node);
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.RDFS_DATATYPE.getIRI());
        this.addTriple((OWLObject)node, OWLRDFVocabulary.OWL_ON_DATA_TYPE.getIRI(), (OWLObject)node.getDatatype());
        this.addListTriples((OWLObject)node, OWLRDFVocabulary.OWL_WITH_RESTRICTIONS.getIRI(), node.getFacetRestrictions());
    }

    public void visit(@Nonnull OWLObjectIntersectionOf ce) {
        this.translateAnonymousNode((OWLObject)ce);
        this.addListTriples((OWLObject)ce, OWLRDFVocabulary.OWL_INTERSECTION_OF.getIRI(), ce.getOperands());
        this.addTriple((OWLObject)ce, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_CLASS.getIRI());
    }

    public void visit(@Nonnull OWLObjectUnionOf ce) {
        this.translateAnonymousNode((OWLObject)ce);
        this.addTriple((OWLObject)ce, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_CLASS.getIRI());
        this.addListTriples((OWLObject)ce, OWLRDFVocabulary.OWL_UNION_OF.getIRI(), ce.getOperands());
    }

    public void visit(@Nonnull OWLObjectComplementOf ce) {
        this.translateAnonymousNode((OWLObject)ce);
        this.addTriple((OWLObject)ce, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_CLASS.getIRI());
        this.addTriple((OWLObject)ce, OWLRDFVocabulary.OWL_COMPLEMENT_OF.getIRI(), (OWLObject)ce.getOperand());
    }

    public void visit(@Nonnull OWLObjectOneOf ce) {
        this.translateAnonymousNode((OWLObject)ce);
        this.addTriple((OWLObject)ce, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_CLASS.getIRI());
        this.addListTriples((OWLObject)ce, OWLRDFVocabulary.OWL_ONE_OF.getIRI(), ce.getIndividuals());
        this.processIfAnonymous(ce.getIndividuals(), null);
    }

    private void addRestrictionCommonTriplePropertyRange(@Nonnull OWLRestriction desc, @Nonnull OWLPropertyExpression property) {
        this.translateAnonymousNode((OWLObject)desc);
        this.addTriple((OWLObject)desc, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_RESTRICTION.getIRI());
        this.addTriple((OWLObject)desc, OWLRDFVocabulary.OWL_ON_PROPERTY.getIRI(), (OWLObject)property);
    }

    private void addRestrictionCommonTriplePropertyExpression(@Nonnull OWLRestriction desc, @Nonnull OWLPropertyExpression property) {
        this.translateAnonymousNode((OWLObject)desc);
        this.addTriple((OWLObject)desc, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_RESTRICTION.getIRI());
        this.addTriple((OWLObject)desc, OWLRDFVocabulary.OWL_ON_PROPERTY.getIRI(), (OWLObject)property);
    }

    private void addObjectCardinalityRestrictionTriples(@Nonnull OWLCardinalityRestriction<OWLClassExpression> ce, @Nonnull OWLPropertyExpression p, @Nonnull OWLRDFVocabulary cardiPredicate) {
        this.addRestrictionCommonTriplePropertyRange((OWLRestriction)ce, p);
        this.addTriple((OWLObject)ce, cardiPredicate.getIRI(), (OWLObject)this.toTypedConstant(ce.getCardinality()));
        if (ce.isQualified()) {
            if (ce.isObjectRestriction()) {
                this.addTriple((OWLObject)ce, OWLRDFVocabulary.OWL_ON_CLASS.getIRI(), (OWLObject)ce.getFiller());
            } else {
                this.addTriple((OWLObject)ce, OWLRDFVocabulary.OWL_ON_DATA_RANGE.getIRI(), (OWLObject)ce.getFiller());
            }
        }
    }

    private void addDataCardinalityRestrictionTriples(@Nonnull OWLCardinalityRestriction<OWLDataRange> ce, @Nonnull OWLPropertyExpression p, @Nonnull OWLRDFVocabulary cardiPredicate) {
        this.addRestrictionCommonTriplePropertyRange((OWLRestriction)ce, p);
        this.addTriple((OWLObject)ce, cardiPredicate.getIRI(), (OWLObject)this.toTypedConstant(ce.getCardinality()));
        if (ce.isQualified()) {
            if (ce.isObjectRestriction()) {
                this.addTriple((OWLObject)ce, OWLRDFVocabulary.OWL_ON_CLASS.getIRI(), (OWLObject)ce.getFiller());
            } else {
                this.addTriple((OWLObject)ce, OWLRDFVocabulary.OWL_ON_DATA_RANGE.getIRI(), (OWLObject)ce.getFiller());
            }
        }
    }

    public void visit(@Nonnull OWLObjectSomeValuesFrom ce) {
        this.addRestrictionCommonTriplePropertyRange((OWLRestriction)ce, (OWLPropertyExpression)ce.getProperty());
        this.addTriple((OWLObject)ce, OWLRDFVocabulary.OWL_SOME_VALUES_FROM.getIRI(), (OWLObject)ce.getFiller());
    }

    public void visit(@Nonnull OWLObjectAllValuesFrom ce) {
        this.addRestrictionCommonTriplePropertyRange((OWLRestriction)ce, (OWLPropertyExpression)ce.getProperty());
        this.addTriple((OWLObject)ce, OWLRDFVocabulary.OWL_ALL_VALUES_FROM.getIRI(), (OWLObject)ce.getFiller());
    }

    public void visit(@Nonnull OWLObjectHasValue ce) {
        this.addRestrictionCommonTriplePropertyExpression((OWLRestriction)ce, (OWLPropertyExpression)ce.getProperty());
        this.addTriple((OWLObject)ce, OWLRDFVocabulary.OWL_HAS_VALUE.getIRI(), ce.getFiller());
        this.processIfAnonymous((OWLIndividual)ce.getFiller(), null);
    }

    public void visit(@Nonnull OWLObjectHasSelf ce) {
        this.translateAnonymousNode((OWLObject)ce);
        this.addTriple((OWLObject)ce, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_RESTRICTION.getIRI());
        this.addTriple((OWLObject)ce, OWLRDFVocabulary.OWL_ON_PROPERTY.getIRI(), (OWLObject)ce.getProperty());
        this.addTriple((OWLObject)ce, OWLRDFVocabulary.OWL_HAS_SELF.getIRI(), (OWLObject)this.manager.getOWLDataFactory().getOWLLiteral(true));
    }

    public void visit(@Nonnull OWLObjectMinCardinality ce) {
        if (ce.isQualified()) {
            this.addObjectCardinalityRestrictionTriples((OWLCardinalityRestriction<OWLClassExpression>)ce, (OWLPropertyExpression)ce.getProperty(), OWLRDFVocabulary.OWL_MIN_QUALIFIED_CARDINALITY);
        } else {
            this.addObjectCardinalityRestrictionTriples((OWLCardinalityRestriction<OWLClassExpression>)ce, (OWLPropertyExpression)ce.getProperty(), OWLRDFVocabulary.OWL_MIN_CARDINALITY);
        }
    }

    public void visit(@Nonnull OWLObjectMaxCardinality ce) {
        if (ce.isQualified()) {
            this.addObjectCardinalityRestrictionTriples((OWLCardinalityRestriction<OWLClassExpression>)ce, (OWLPropertyExpression)ce.getProperty(), OWLRDFVocabulary.OWL_MAX_QUALIFIED_CARDINALITY);
        } else {
            this.addObjectCardinalityRestrictionTriples((OWLCardinalityRestriction<OWLClassExpression>)ce, (OWLPropertyExpression)ce.getProperty(), OWLRDFVocabulary.OWL_MAX_CARDINALITY);
        }
    }

    public void visit(@Nonnull OWLObjectExactCardinality ce) {
        if (ce.isQualified()) {
            this.addObjectCardinalityRestrictionTriples((OWLCardinalityRestriction<OWLClassExpression>)ce, (OWLPropertyExpression)ce.getProperty(), OWLRDFVocabulary.OWL_QUALIFIED_CARDINALITY);
        } else {
            this.addObjectCardinalityRestrictionTriples((OWLCardinalityRestriction<OWLClassExpression>)ce, (OWLPropertyExpression)ce.getProperty(), OWLRDFVocabulary.OWL_CARDINALITY);
        }
    }

    public void visit(@Nonnull OWLDataSomeValuesFrom ce) {
        this.addRestrictionCommonTriplePropertyRange((OWLRestriction)ce, (OWLPropertyExpression)ce.getProperty());
        this.addTriple((OWLObject)ce, OWLRDFVocabulary.OWL_SOME_VALUES_FROM.getIRI(), (OWLObject)ce.getFiller());
    }

    public void visit(@Nonnull OWLDataAllValuesFrom ce) {
        this.addRestrictionCommonTriplePropertyRange((OWLRestriction)ce, (OWLPropertyExpression)ce.getProperty());
        this.addTriple((OWLObject)ce, OWLRDFVocabulary.OWL_ALL_VALUES_FROM.getIRI(), (OWLObject)ce.getFiller());
    }

    public void visit(@Nonnull OWLDataHasValue ce) {
        this.addRestrictionCommonTriplePropertyExpression((OWLRestriction)ce, (OWLPropertyExpression)ce.getProperty());
        this.addTriple((OWLObject)ce, OWLRDFVocabulary.OWL_HAS_VALUE.getIRI(), ce.getFiller());
    }

    public void visit(@Nonnull OWLDataMinCardinality ce) {
        if (ce.isQualified()) {
            this.addDataCardinalityRestrictionTriples((OWLCardinalityRestriction<OWLDataRange>)ce, (OWLPropertyExpression)ce.getProperty(), OWLRDFVocabulary.OWL_MIN_QUALIFIED_CARDINALITY);
        } else {
            this.addDataCardinalityRestrictionTriples((OWLCardinalityRestriction<OWLDataRange>)ce, (OWLPropertyExpression)ce.getProperty(), OWLRDFVocabulary.OWL_MIN_CARDINALITY);
        }
    }

    public void visit(@Nonnull OWLDataMaxCardinality ce) {
        if (ce.isQualified()) {
            this.addDataCardinalityRestrictionTriples((OWLCardinalityRestriction<OWLDataRange>)ce, (OWLPropertyExpression)ce.getProperty(), OWLRDFVocabulary.OWL_MAX_QUALIFIED_CARDINALITY);
        } else {
            this.addDataCardinalityRestrictionTriples((OWLCardinalityRestriction<OWLDataRange>)ce, (OWLPropertyExpression)ce.getProperty(), OWLRDFVocabulary.OWL_MAX_CARDINALITY);
        }
    }

    public void visit(@Nonnull OWLDataExactCardinality ce) {
        if (ce.isQualified()) {
            this.addDataCardinalityRestrictionTriples((OWLCardinalityRestriction<OWLDataRange>)ce, (OWLPropertyExpression)ce.getProperty(), OWLRDFVocabulary.OWL_QUALIFIED_CARDINALITY);
        } else {
            this.addDataCardinalityRestrictionTriples((OWLCardinalityRestriction<OWLDataRange>)ce, (OWLPropertyExpression)ce.getProperty(), OWLRDFVocabulary.OWL_CARDINALITY);
        }
    }

    public void visit(@Nonnull OWLSubClassOfAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getSubClass(), OWLRDFVocabulary.RDFS_SUBCLASS_OF.getIRI(), (OWLObject)axiom.getSuperClass());
    }

    public void visit(@Nonnull OWLEquivalentClassesAxiom axiom) {
        if (axiom.getClassExpressions().size() == 2) {
            this.addPairwise((OWLAxiom)axiom, axiom.getClassExpressions(), OWLRDFVocabulary.OWL_EQUIVALENT_CLASS.getIRI());
        } else {
            for (OWLEquivalentClassesAxiom ax : AbstractTranslator.sort(axiom.splitToAnnotatedPairs())) {
                ax.accept((OWLObjectVisitor)this);
            }
        }
    }

    public void visit(@Nonnull OWLDisjointClassesAxiom axiom) {
        if (axiom.getClassExpressions().size() == 2) {
            this.addPairwiseClassExpressions((OWLAxiom)axiom, axiom.getClassExpressions(), OWLRDFVocabulary.OWL_DISJOINT_WITH.getIRI());
        } else {
            this.translateAnonymousNode((OWLObject)axiom);
            this.addTriple((OWLObject)axiom, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_ALL_DISJOINT_CLASSES.getIRI());
            this.addListTriples((OWLObject)axiom, OWLRDFVocabulary.OWL_MEMBERS.getIRI(), axiom.getClassExpressions());
            this.translateAnnotations((OWLAxiom)axiom);
        }
    }

    public void visit(@Nonnull OWLDisjointUnionAxiom axiom) {
        Set classExpressions = axiom.getClassExpressions();
        ArrayList list = new ArrayList(classExpressions);
        Collections.sort(list);
        this.addSingleTripleAxiom((OWLAxiom)axiom, axiom.getOWLClass(), OWLRDFVocabulary.OWL_DISJOINT_UNION_OF.getIRI(), list);
    }

    public void visit(@Nonnull OWLSubObjectPropertyOfAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getSubProperty(), OWLRDFVocabulary.RDFS_SUB_PROPERTY_OF.getIRI(), (OWLObject)axiom.getSuperProperty());
    }

    public void visit(@Nonnull OWLSubPropertyChainOfAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, axiom.getSuperProperty(), OWLRDFVocabulary.OWL_PROPERTY_CHAIN_AXIOM.getIRI(), axiom.getPropertyChain());
    }

    public void visit(@Nonnull OWLEquivalentObjectPropertiesAxiom axiom) {
        if (axiom.getProperties().size() == 2) {
            this.addPairwise((OWLAxiom)axiom, axiom.getProperties(), OWLRDFVocabulary.OWL_EQUIVALENT_PROPERTY.getIRI());
        } else {
            for (OWLEquivalentObjectPropertiesAxiom ax : AbstractTranslator.sort(axiom.splitToAnnotatedPairs())) {
                ax.accept((OWLObjectVisitor)this);
            }
        }
    }

    public void visit(@Nonnull OWLDisjointObjectPropertiesAxiom axiom) {
        if (axiom.getProperties().size() == 2) {
            this.addPairwise((OWLAxiom)axiom, axiom.getProperties(), OWLRDFVocabulary.OWL_PROPERTY_DISJOINT_WITH.getIRI());
        } else {
            this.translateAnonymousNode((OWLObject)axiom);
            this.translateAnnotations((OWLAxiom)axiom);
            this.addTriple((OWLObject)axiom, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_ALL_DISJOINT_PROPERTIES.getIRI());
            this.addListTriples((OWLObject)axiom, OWLRDFVocabulary.OWL_MEMBERS.getIRI(), axiom.getProperties());
        }
    }

    public void visit(@Nonnull OWLObjectPropertyDomainAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getProperty(), OWLRDFVocabulary.RDFS_DOMAIN.getIRI(), (OWLObject)axiom.getDomain());
    }

    public void visit(@Nonnull OWLObjectPropertyRangeAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getProperty(), OWLRDFVocabulary.RDFS_RANGE.getIRI(), (OWLObject)axiom.getRange());
    }

    public void visit(@Nonnull OWLInverseObjectPropertiesAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getFirstProperty(), OWLRDFVocabulary.OWL_INVERSE_OF.getIRI(), (OWLObject)axiom.getSecondProperty());
    }

    public void visit(@Nonnull OWLFunctionalObjectPropertyAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getProperty(), OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_FUNCTIONAL_PROPERTY.getIRI());
    }

    public void visit(@Nonnull OWLInverseFunctionalObjectPropertyAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getProperty(), OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_INVERSE_FUNCTIONAL_PROPERTY.getIRI());
    }

    public void visit(@Nonnull OWLReflexiveObjectPropertyAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getProperty(), OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_REFLEXIVE_PROPERTY.getIRI());
    }

    public void visit(@Nonnull OWLIrreflexiveObjectPropertyAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getProperty(), OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_IRREFLEXIVE_PROPERTY.getIRI());
    }

    public void visit(@Nonnull OWLSymmetricObjectPropertyAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getProperty(), OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_SYMMETRIC_PROPERTY.getIRI());
    }

    public void visit(@Nonnull OWLAsymmetricObjectPropertyAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getProperty(), OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_ASYMMETRIC_PROPERTY.getIRI());
    }

    public void visit(@Nonnull OWLTransitiveObjectPropertyAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getProperty(), OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_TRANSITIVE_PROPERTY.getIRI());
    }

    public void visit(@Nonnull OWLSubDataPropertyOfAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getSubProperty(), OWLRDFVocabulary.RDFS_SUB_PROPERTY_OF.getIRI(), (OWLObject)axiom.getSuperProperty());
    }

    public void visit(@Nonnull OWLEquivalentDataPropertiesAxiom axiom) {
        if (axiom.getProperties().size() == 2) {
            this.addPairwise((OWLAxiom)axiom, axiom.getProperties(), OWLRDFVocabulary.OWL_EQUIVALENT_PROPERTY.getIRI());
        } else {
            for (OWLEquivalentDataPropertiesAxiom ax : axiom.splitToAnnotatedPairs()) {
                ax.accept((OWLObjectVisitor)this);
            }
        }
    }

    public void visit(@Nonnull OWLDisjointDataPropertiesAxiom axiom) {
        if (axiom.getProperties().size() == 2) {
            this.addPairwise((OWLAxiom)axiom, axiom.getProperties(), OWLRDFVocabulary.OWL_PROPERTY_DISJOINT_WITH.getIRI());
        } else {
            this.translateAnonymousNode((OWLObject)axiom);
            this.translateAnnotations((OWLAxiom)axiom);
            this.addTriple((OWLObject)axiom, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_ALL_DISJOINT_PROPERTIES.getIRI());
            this.addListTriples((OWLObject)axiom, OWLRDFVocabulary.OWL_MEMBERS.getIRI(), axiom.getProperties());
        }
    }

    public void visit(@Nonnull OWLDataPropertyDomainAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getProperty(), OWLRDFVocabulary.RDFS_DOMAIN.getIRI(), (OWLObject)axiom.getDomain());
    }

    public void visit(@Nonnull OWLDataPropertyRangeAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getProperty(), OWLRDFVocabulary.RDFS_RANGE.getIRI(), (OWLObject)axiom.getRange());
    }

    public void visit(@Nonnull OWLFunctionalDataPropertyAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getProperty(), OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_FUNCTIONAL_PROPERTY.getIRI());
    }

    public void visit(@Nonnull OWLDatatypeDefinitionAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getDatatype(), OWLRDFVocabulary.OWL_EQUIVALENT_CLASS.getIRI(), (OWLObject)axiom.getDataRange());
    }

    public void visit(@Nonnull OWLHasKeyAxiom axiom) {
        Set propertyExpressions = axiom.getPropertyExpressions();
        ArrayList list = new ArrayList(propertyExpressions);
        Collections.sort(list);
        this.addSingleTripleAxiom((OWLAxiom)axiom, axiom.getClassExpression(), OWLRDFVocabulary.OWL_HAS_KEY.getIRI(), list);
    }

    public void visit(@Nonnull OWLSameIndividualAxiom axiom) {
        axiom.splitToAnnotatedPairs().forEach(a -> this.addSingleTripleAxiom((OWLAxiom)a, (OWLObject)a.getIndividualsAsList().get(0), OWLRDFVocabulary.OWL_SAME_AS.getIRI(), (OWLObject)a.getIndividualsAsList().get(1)));
        this.processIfAnonymous(axiom.getIndividuals(), (OWLAxiom)axiom);
    }

    public void visit(@Nonnull OWLDifferentIndividualsAxiom axiom) {
        this.translateAnonymousNode((OWLObject)axiom);
        this.addTriple((OWLObject)axiom, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_ALL_DIFFERENT.getIRI());
        this.addListTriples((OWLObject)axiom, OWLRDFVocabulary.OWL_DISTINCT_MEMBERS.getIRI(), axiom.getIndividuals());
        this.translateAnnotations((OWLAxiom)axiom);
        this.processIfAnonymous(axiom.getIndividuals(), (OWLAxiom)axiom);
    }

    public void visit(@Nonnull OWLClassAssertionAxiom axiom) {
        axiom.getIndividual().accept((OWLObjectVisitor)this);
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getIndividual(), OWLRDFVocabulary.RDF_TYPE.getIRI(), (OWLObject)axiom.getClassExpression());
        this.processIfAnonymous(axiom.getIndividual(), (OWLAxiom)axiom);
    }

    public void visit(@Nonnull OWLObjectPropertyAssertionAxiom axiom) {
        OWLObjectPropertyAssertionAxiom simplified = axiom.getSimplified();
        this.addSingleTripleAxiom((OWLAxiom)simplified, (OWLObject)simplified.getSubject(), (OWLObject)simplified.getProperty(), (OWLObject)simplified.getObject());
        this.processIfAnonymous((OWLIndividual)simplified.getObject(), (OWLAxiom)axiom);
        this.processIfAnonymous(simplified.getSubject(), (OWLAxiom)axiom);
    }

    public void visit(@Nonnull OWLNegativeObjectPropertyAssertionAxiom axiom) {
        this.translateAnonymousNode((OWLObject)axiom);
        this.addTriple((OWLObject)axiom, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_NEGATIVE_PROPERTY_ASSERTION.getIRI());
        this.addTriple((OWLObject)axiom, OWLRDFVocabulary.OWL_SOURCE_INDIVIDUAL.getIRI(), (OWLObject)axiom.getSubject());
        this.addTriple((OWLObject)axiom, OWLRDFVocabulary.OWL_ASSERTION_PROPERTY.getIRI(), (OWLObject)axiom.getProperty());
        this.addTriple((OWLObject)axiom, OWLRDFVocabulary.OWL_TARGET_INDIVIDUAL.getIRI(), (OWLObject)axiom.getObject());
        this.translateAnnotations((OWLAxiom)axiom);
        this.processIfAnonymous(axiom.getSubject(), (OWLAxiom)axiom);
        this.processIfAnonymous((OWLIndividual)axiom.getObject(), (OWLAxiom)axiom);
    }

    public void visit(@Nonnull OWLDataPropertyAssertionAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getSubject(), (OWLObject)axiom.getProperty(), (OWLObject)axiom.getObject());
    }

    public void visit(@Nonnull OWLNegativeDataPropertyAssertionAxiom axiom) {
        this.translateAnonymousNode((OWLObject)axiom);
        this.addTriple((OWLObject)axiom, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_NEGATIVE_PROPERTY_ASSERTION.getIRI());
        this.addTriple((OWLObject)axiom, OWLRDFVocabulary.OWL_SOURCE_INDIVIDUAL.getIRI(), (OWLObject)axiom.getSubject());
        this.addTriple((OWLObject)axiom, OWLRDFVocabulary.OWL_ASSERTION_PROPERTY.getIRI(), (OWLObject)axiom.getProperty());
        this.addTriple((OWLObject)axiom, OWLRDFVocabulary.OWL_TARGET_VALUE.getIRI(), (OWLObject)axiom.getObject());
        this.translateAnnotations((OWLAxiom)axiom);
        this.processIfAnonymous(axiom.getSubject(), (OWLAxiom)axiom);
    }

    public void visit(@Nonnull OWLAnnotationAssertionAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getSubject(), (OWLObject)axiom.getProperty(), (OWLObject)axiom.getValue());
        if (axiom.getValue() instanceof OWLAnonymousIndividual) {
            this.processIfAnonymous((OWLIndividual)((OWLAnonymousIndividual)axiom.getValue()), (OWLAxiom)axiom);
        }
    }

    public void visit(@Nonnull OWLSubAnnotationPropertyOfAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getSubProperty(), OWLRDFVocabulary.RDFS_SUB_PROPERTY_OF.getIRI(), (OWLObject)axiom.getSuperProperty());
    }

    public void visit(@Nonnull OWLAnnotationPropertyDomainAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getProperty(), OWLRDFVocabulary.RDFS_DOMAIN.getIRI(), axiom.getDomain());
    }

    public void visit(@Nonnull OWLAnnotationPropertyRangeAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getProperty(), OWLRDFVocabulary.RDFS_RANGE.getIRI(), axiom.getRange());
    }

    public void visit(@Nonnull OWLClass ce) {
        this.storeNodeIfNotPresent((OWLObject)ce, this.getResourceNode(ce.getIRI()));
        this.addStrongTyping((OWLEntity)ce);
    }

    public void visit(@Nonnull OWLDatatype node) {
        this.storeNodeIfNotPresent((OWLObject)node, this.getResourceNode(node.getIRI()));
        this.addStrongTyping((OWLEntity)node);
    }

    public void visit(@Nonnull OWLFacetRestriction node) {
        this.translateAnonymousNode((OWLObject)node);
        this.addTriple((OWLObject)node, node.getFacet().getIRI(), (OWLObject)node.getFacetValue());
    }

    public void visit(IRI iri) {
        this.storeNodeIfNotPresent((OWLObject)iri, this.getResourceNode(iri));
    }

    public void visit(OWLLiteral node) {
        this.storeNodeIfNotPresent((OWLObject)node, this.getLiteralNode(node));
    }

    public void visit(@Nonnull OWLDataProperty property) {
        this.storeNodeIfNotPresent((OWLObject)property, this.getPredicateNode(property.getIRI()));
        this.addStrongTyping((OWLEntity)property);
    }

    public void visit(@Nonnull OWLObjectProperty property) {
        this.storeNodeIfNotPresent((OWLObject)property, this.getPredicateNode(property.getIRI()));
        this.addStrongTyping((OWLEntity)property);
    }

    public void visit(@Nonnull OWLAnnotationProperty property) {
        this.storeNodeIfNotPresent((OWLObject)property, this.getPredicateNode(property.getIRI()));
        this.addStrongTyping((OWLEntity)property);
    }

    public void visit(@Nonnull OWLNamedIndividual individual) {
        this.storeNodeIfNotPresent((OWLObject)individual, this.getResourceNode(individual.getIRI()));
        this.addStrongTyping((OWLEntity)individual);
    }

    public void visit(OWLAnonymousIndividual individual) {
        this.translateAnonymousNode((OWLObject)individual);
    }

    public void visit(@Nonnull OWLOntology ontology) {
        Optional ontologyIRI = ontology.getOntologyID().getOntologyIRI();
        if (ontologyIRI.isPresent()) {
            this.storeNodeIfNotPresent((OWLObject)ontology, this.getResourceNode((IRI)ontologyIRI.get()));
        } else {
            this.translateAnonymousNode((OWLObject)ontology);
        }
        this.addTriple((OWLObject)ontology, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_ONTOLOGY.getIRI());
        this.addVersionIRIToOntologyHeader(ontology);
        this.addImportsDeclarationsToOntologyHeader(ontology);
        this.addAnnotationsToOntologyHeader(ontology);
    }

    private void addVersionIRIToOntologyHeader(OWLOntology ontology) {
        OWLOntologyID ontID = ontology.getOntologyID();
        if (ontID.getVersionIRI().isPresent()) {
            this.addTriple((OWLObject)ontology, OWLRDFVocabulary.OWL_VERSION_IRI.getIRI(), (IRI)ontID.getVersionIRI().get());
        }
    }

    private void addImportsDeclarationsToOntologyHeader(OWLOntology ontology) {
        ontology.getImportsDeclarations().forEach(decl -> this.addTriple((OWLObject)ontology, OWLRDFVocabulary.OWL_IMPORTS.getIRI(), decl.getIRI()));
    }

    private void addAnnotationsToOntologyHeader(OWLOntology ontology) {
        ontology.getAnnotations().forEach(a -> this.translateAnnotation((OWLObject)ontology, (OWLAnnotation)a));
    }

    public void visit(@Nonnull SWRLRule rule) {
        this.translateAnonymousNode((OWLObject)rule);
        this.translateAnnotations((OWLAxiom)rule);
        this.addTriple((OWLObject)rule, OWLRDFVocabulary.RDF_TYPE.getIRI(), SWRLVocabulary.IMP.getIRI());
        Set antecedent = rule.getBody();
        this.addTriple((OWLObject)rule, SWRLVocabulary.BODY.getIRI(), antecedent, SWRLVocabulary.ATOM_LIST.getIRI());
        Set consequent = rule.getHead();
        this.addTriple((OWLObject)rule, SWRLVocabulary.HEAD.getIRI(), consequent, SWRLVocabulary.ATOM_LIST.getIRI());
    }

    public void visit(@Nonnull SWRLClassAtom node) {
        this.translateAnonymousNode((OWLObject)node);
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getIRI(), SWRLVocabulary.CLASS_ATOM.getIRI());
        node.getPredicate().accept((OWLObjectVisitor)this);
        this.addTriple((OWLObject)node, SWRLVocabulary.CLASS_PREDICATE.getIRI(), (OWLObject)node.getPredicate());
        ((SWRLIArgument)node.getArgument()).accept((SWRLObjectVisitor)this);
        this.addTriple((OWLObject)node, SWRLVocabulary.ARGUMENT_1.getIRI(), (OWLObject)node.getArgument());
    }

    public void visit(@Nonnull SWRLDataRangeAtom node) {
        this.translateAnonymousNode((OWLObject)node);
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getIRI(), SWRLVocabulary.DATA_RANGE_ATOM.getIRI());
        node.getPredicate().accept((OWLObjectVisitor)this);
        this.addTriple((OWLObject)node, SWRLVocabulary.DATA_RANGE.getIRI(), (OWLObject)node.getPredicate());
        ((SWRLDArgument)node.getArgument()).accept((SWRLObjectVisitor)this);
        this.addTriple((OWLObject)node, SWRLVocabulary.ARGUMENT_1.getIRI(), (OWLObject)node.getArgument());
    }

    public void visit(@Nonnull SWRLObjectPropertyAtom node) {
        this.translateAnonymousNode((OWLObject)node);
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getIRI(), SWRLVocabulary.INDIVIDUAL_PROPERTY_ATOM.getIRI());
        node.getPredicate().accept((OWLObjectVisitor)this);
        this.addTriple((OWLObject)node, SWRLVocabulary.PROPERTY_PREDICATE.getIRI(), (OWLObject)node.getPredicate());
        ((SWRLIArgument)node.getFirstArgument()).accept((SWRLObjectVisitor)this);
        this.addTriple((OWLObject)node, SWRLVocabulary.ARGUMENT_1.getIRI(), (OWLObject)node.getFirstArgument());
        ((SWRLIArgument)node.getSecondArgument()).accept((SWRLObjectVisitor)this);
        this.addTriple((OWLObject)node, SWRLVocabulary.ARGUMENT_2.getIRI(), (OWLObject)node.getSecondArgument());
    }

    public void visit(@Nonnull SWRLDataPropertyAtom node) {
        this.translateAnonymousNode((OWLObject)node);
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getIRI(), SWRLVocabulary.DATAVALUED_PROPERTY_ATOM.getIRI());
        node.getPredicate().accept((OWLObjectVisitor)this);
        this.addTriple((OWLObject)node, SWRLVocabulary.PROPERTY_PREDICATE.getIRI(), (OWLObject)node.getPredicate());
        ((SWRLIArgument)node.getFirstArgument()).accept((SWRLObjectVisitor)this);
        this.addTriple((OWLObject)node, SWRLVocabulary.ARGUMENT_1.getIRI(), (OWLObject)node.getFirstArgument());
        ((SWRLDArgument)node.getSecondArgument()).accept((SWRLObjectVisitor)this);
        this.addTriple((OWLObject)node, SWRLVocabulary.ARGUMENT_2.getIRI(), (OWLObject)node.getSecondArgument());
    }

    public void visit(@Nonnull SWRLBuiltInAtom node) {
        this.translateAnonymousNode((OWLObject)node);
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getIRI(), SWRLVocabulary.BUILT_IN_ATOM.getIRI());
        this.addTriple((OWLObject)node, SWRLVocabulary.BUILT_IN.getIRI(), node.getPredicate());
        this.addTriple(this.getResourceNode(node.getPredicate()), this.getPredicateNode(OWLRDFVocabulary.RDF_TYPE.getIRI()), this.getResourceNode(SWRLVocabulary.BUILT_IN_CLASS.getIRI()));
        this.addTriple(this.getResourceNode((OWLObject)node), this.getPredicateNode(SWRLVocabulary.ARGUMENTS.getIRI()), this.translateList(new ArrayList(node.getArguments())));
    }

    public void visit(@Nonnull SWRLDifferentIndividualsAtom node) {
        this.translateAnonymousNode((OWLObject)node);
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getIRI(), SWRLVocabulary.DIFFERENT_INDIVIDUALS_ATOM.getIRI());
        ((SWRLIArgument)node.getFirstArgument()).accept((SWRLObjectVisitor)this);
        this.addTriple((OWLObject)node, SWRLVocabulary.ARGUMENT_1.getIRI(), (OWLObject)node.getFirstArgument());
        ((SWRLIArgument)node.getSecondArgument()).accept((SWRLObjectVisitor)this);
        this.addTriple((OWLObject)node, SWRLVocabulary.ARGUMENT_2.getIRI(), (OWLObject)node.getSecondArgument());
    }

    public void visit(@Nonnull SWRLSameIndividualAtom node) {
        this.translateAnonymousNode((OWLObject)node);
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getIRI(), SWRLVocabulary.SAME_INDIVIDUAL_ATOM.getIRI());
        ((SWRLIArgument)node.getFirstArgument()).accept((SWRLObjectVisitor)this);
        this.addTriple((OWLObject)node, SWRLVocabulary.ARGUMENT_1.getIRI(), (OWLObject)node.getFirstArgument());
        ((SWRLIArgument)node.getSecondArgument()).accept((SWRLObjectVisitor)this);
        this.addTriple((OWLObject)node, SWRLVocabulary.ARGUMENT_2.getIRI(), (OWLObject)node.getSecondArgument());
    }

    public void visit(@Nonnull SWRLVariable node) {
        this.storeNodeIfNotPresent((OWLObject)node, this.getResourceNode(node.getIRI()));
        if (!this.ont.containsIndividualInSignature(node.getIRI())) {
            this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getIRI(), SWRLVocabulary.VARIABLE.getIRI());
        }
    }

    public void visit(@Nonnull SWRLIndividualArgument node) {
        node.getIndividual().accept((OWLObjectVisitor)this);
        this.storeNodeIfNotPresent((OWLObject)node, (Serializable)this.nodeMap.get(node.getIndividual()));
    }

    public void visit(@Nonnull SWRLLiteralArgument node) {
        node.getLiteral().accept((OWLObjectVisitor)this);
        this.storeNodeIfNotPresent((OWLObject)node, (Serializable)this.nodeMap.get(node.getLiteral()));
    }

    private void addSingleTripleAxiom(@Nonnull OWLAxiom ax, @Nonnull OWLObject subject, @Nonnull IRI pred, @Nonnull OWLObject obj) {
        this.addSingleTripleAxiom(ax, this.getResourceNode(subject), this.getPredicateNode(pred), this.getNode(obj));
    }

    private void addSingleTripleAxiom(@Nonnull OWLAxiom ax, @Nonnull OWLObject subject, @Nonnull IRI pred, @Nonnull IRI obj) {
        this.addSingleTripleAxiom(ax, this.getResourceNode(subject), this.getPredicateNode(pred), this.getResourceNode(obj));
    }

    private void addSingleTripleAxiom(@Nonnull OWLAxiom ax, @Nonnull OWLObject subj, @Nonnull IRI pred, @Nonnull List<? extends OWLObject> obj) {
        this.addSingleTripleAxiom(ax, this.getResourceNode(subj), this.getPredicateNode(pred), this.translateList(obj));
    }

    private void addSingleTripleAxiom(@Nonnull OWLAxiom ax, @Nonnull OWLObject subj, @Nonnull OWLObject pred, @Nonnull OWLObject obj) {
        this.addSingleTripleAxiom(ax, this.getResourceNode(subj), this.getPredicateNode(pred), this.getNode(obj));
    }

    private void addSingleTripleAxiom(@Nonnull OWLAxiom ax, @Nonnull R subject, @Nonnull P predicate, @Nonnull N object) {
        this.addTriple(subject, predicate, object);
        if (ax.getAnnotations().isEmpty()) {
            return;
        }
        this.translateAnonymousNode((OWLObject)ax);
        this.addTriple(this.getResourceNode((OWLObject)ax), this.getPredicateNode(OWLRDFVocabulary.RDF_TYPE.getIRI()), this.getResourceNode(OWLRDFVocabulary.OWL_AXIOM.getIRI()));
        this.addTriple(this.getResourceNode((OWLObject)ax), this.getPredicateNode(OWLRDFVocabulary.OWL_ANNOTATED_SOURCE.getIRI()), subject);
        this.addTriple(this.getResourceNode((OWLObject)ax), this.getPredicateNode(OWLRDFVocabulary.OWL_ANNOTATED_PROPERTY.getIRI()), predicate);
        this.addTriple(this.getResourceNode((OWLObject)ax), this.getPredicateNode(OWLRDFVocabulary.OWL_ANNOTATED_TARGET.getIRI()), object);
        this.translateAnnotations(ax);
    }

    private void translateAnnotations(@Nonnull OWLAxiom ax) {
        this.translateAnonymousNode((OWLObject)ax);
        for (OWLAnnotation anno : AbstractTranslator.sort(ax.getAnnotations())) {
            assert (anno != null);
            this.translateAnnotation((OWLObject)ax, anno);
        }
    }

    private void translateAnnotation(@Nonnull OWLObject subject, @Nonnull OWLAnnotation annotation) {
        Set annotations;
        this.addTriple(subject, annotation.getProperty().getIRI(), (OWLObject)annotation.getValue());
        annotation.getProperty().accept((OWLObjectVisitor)this);
        if (annotation.getValue() instanceof OWLAnonymousIndividual) {
            OWLAnonymousIndividual ind = (OWLAnonymousIndividual)annotation.getValue();
            this.translateAnonymousNode((OWLObject)ind);
            this.processIfAnonymous((OWLIndividual)ind);
        }
        if ((annotations = annotation.getAnnotations()).isEmpty()) {
            return;
        }
        this.translateAnonymousNode((OWLObject)annotation);
        this.addTriple((OWLObject)annotation, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_ANNOTATION.getIRI());
        this.addTriple((OWLObject)annotation, OWLRDFVocabulary.OWL_ANNOTATED_SOURCE.getIRI(), subject);
        this.addTriple((OWLObject)annotation, OWLRDFVocabulary.OWL_ANNOTATED_PROPERTY.getIRI(), annotation.getProperty().getIRI());
        this.addTriple((OWLObject)annotation, OWLRDFVocabulary.OWL_ANNOTATED_TARGET.getIRI(), (OWLObject)annotation.getValue());
        for (OWLAnnotation anno : AbstractTranslator.sort(annotations)) {
            assert (anno != null);
            this.translateAnnotation((OWLObject)annotation, anno);
        }
    }

    public void visit(OWLAnnotation node) {
        throw new OWLRuntimeException("The translator should not be used directly on instances of OWLAnnotation because an annotation cannot be translated without a subject.");
    }

    private void translateAnonymousNode(@Nonnull OWLObject object) {
        this.storeNode(object, this.getAnonymousNode(object));
    }

    private void storeNode(@Nonnull OWLObject object, N value) {
        if (!RDFRendererBase.isNotAnonymousExpression(object)) {
            this.expressionMap.put(object, value);
        } else {
            this.nodeMap.put(object, value);
        }
    }

    private void storeNodeIfNotPresent(@Nonnull OWLObject object, N value) {
        Object v = this.getMappedNode(object);
        if (v == null) {
            this.storeNode(object, value);
        }
    }

    public <T extends N> T getMappedNode(OWLObject object) {
        if (!RDFRendererBase.isNotAnonymousExpression(object)) {
            return (T)((Serializable)this.expressionMap.get(object));
        }
        return (T)((Serializable)this.nodeMap.get(object));
    }

    public void addTriple(R subject, IRI pred, IRI object) {
        this.addTriple(subject, this.getPredicateNode(pred), this.getResourceNode(object));
    }

    public void addTriple(R subject, IRI pred, OWLObject object) {
        this.addTriple(subject, this.getPredicateNode(pred), this.getNode(object));
    }

    @Nonnull
    protected abstract R getResourceNode(@Nonnull IRI var1);

    @Nonnull
    protected abstract P getPredicateNode(@Nonnull IRI var1);

    @Nonnull
    protected abstract R getAnonymousNode(@Nonnull Object var1);

    @Nonnull
    protected abstract R getAnonymousNodeForExpressions(@Nonnull Object var1, boolean var2);

    @Nonnull
    protected abstract L getLiteralNode(@Nonnull OWLLiteral var1);

    protected abstract void addTriple(@Nonnull R var1, @Nonnull P var2, @Nonnull N var3);

    @Nonnull
    private R getResourceNode(@Nonnull OWLObject object) {
        Object r = this.getMappedNode(object);
        if (r == null) {
            object.accept((OWLObjectVisitor)this);
            r = this.getMappedNode(object);
            if (r == null) {
                throw new IllegalStateException("Node is null. Attempting to get node for " + object);
            }
        }
        return (R)r;
    }

    @Nonnull
    private P getPredicateNode(@Nonnull OWLObject object) {
        Object p = this.getMappedNode(object);
        if (p == null) {
            object.accept((OWLObjectVisitor)this);
            p = this.getMappedNode(object);
            if (p == null) {
                throw new IllegalStateException("Node is null. Attempting to get node for " + object);
            }
        }
        return (P)p;
    }

    @Nonnull
    private N getNode(@Nonnull OWLObject object) {
        Object node = this.getMappedNode(object);
        if (node == null) {
            object.accept((OWLObjectVisitor)this);
            node = this.getMappedNode(object);
            if (node == null) {
                throw new IllegalStateException("Node is null. Attempting to get node for " + object);
            }
        }
        return (N)node;
    }

    @Nonnull
    private R translateList(@Nonnull List<? extends OWLObject> list) {
        return this.translateList(list, OWLRDFVocabulary.RDF_LIST.getIRI());
    }

    @Nonnull
    private R translateList(@Nonnull List<? extends OWLObject> list, @Nonnull IRI listType) {
        int listSize;
        if (list.isEmpty()) {
            return this.getResourceNode(OWLRDFVocabulary.RDF_NIL.getIRI());
        }
        R main = this.getResourceNode(OWLRDFVocabulary.RDF_NIL.getIRI());
        for (int i = listSize = list.size() - 1; i >= 0; --i) {
            R anonNode = this.getAnonymousNode(list.subList(i, listSize));
            this.addTriple(anonNode, this.getPredicateNode(OWLRDFVocabulary.RDF_TYPE.getIRI()), this.getResourceNode(listType));
            OWLObject obj = list.get(i);
            this.addTriple(anonNode, this.getPredicateNode(OWLRDFVocabulary.RDF_FIRST.getIRI()), this.getNode(obj));
            this.addTriple(anonNode, this.getPredicateNode(OWLRDFVocabulary.RDF_REST.getIRI()), main);
            main = anonNode;
        }
        return main;
    }

    private void addTriple(@Nonnull OWLObject subject, @Nonnull IRI pred, @Nonnull IRI object) {
        this.addTriple(this.getResourceNode(subject), this.getPredicateNode(pred), this.getResourceNode(object));
    }

    private void addTriple(@Nonnull OWLObject subject, @Nonnull IRI pred, @Nonnull OWLObject object) {
        this.addTriple(this.getResourceNode(subject), this.getPredicateNode(pred), this.getNode(object));
    }

    private void addListTriples(@Nonnull OWLObject subject, @Nonnull IRI pred, @Nonnull Set<? extends OWLObject> objects) {
        ArrayList<? extends OWLObject> list = new ArrayList<OWLObject>(objects);
        Collections.sort(list);
        this.addTriple(this.getResourceNode(subject), this.getPredicateNode(pred), this.translateList(list));
    }

    private void addTriple(@Nonnull OWLObject subject, @Nonnull IRI pred, @Nonnull Set<? extends OWLObject> objects, @Nonnull IRI listType) {
        this.addTriple(this.getResourceNode(subject), this.getPredicateNode(pred), this.translateList(new ArrayList<OWLObject>(objects), listType));
    }

    @Nonnull
    private OWLLiteral toTypedConstant(int i) {
        return this.manager.getOWLDataFactory().getOWLLiteral(Integer.toString(i), this.manager.getOWLDataFactory().getOWLDatatype(XSDVocabulary.NON_NEGATIVE_INTEGER.getIRI()));
    }

    private void processIfAnonymous(@Nonnull Set<OWLIndividual> inds, OWLAxiom root) {
        for (OWLIndividual ind : CollectionFactory.sortOptionally(inds)) {
            assert (ind != null);
            this.processIfAnonymous(ind, root);
        }
    }

    private void processIfAnonymous(@Nonnull OWLIndividual ind, @Nullable OWLAxiom root) {
        if (!this.currentIndividuals.contains(ind)) {
            this.currentIndividuals.add(ind);
            if (ind.isAnonymous()) {
                for (OWLAxiom oWLAxiom : this.getSortedIndividualAxioms(ind)) {
                    if (root != null && root.equals(oWLAxiom)) continue;
                    oWLAxiom.accept((OWLObjectVisitor)this);
                }
                for (OWLAnnotationAssertionAxiom oWLAnnotationAssertionAxiom : AbstractTranslator.sort(this.getAnnotationAssertionsForAnonymous(ind))) {
                    oWLAnnotationAssertionAxiom.accept((OWLObjectVisitor)this);
                }
            }
            this.currentIndividuals.remove(ind);
        }
    }

    private void processIfAnonymous(@Nonnull OWLIndividual ind) {
        if (!this.currentIndividuals.contains(ind)) {
            this.currentIndividuals.add(ind);
            if (ind.isAnonymous()) {
                for (OWLAxiom oWLAxiom : this.getSortedIndividualAxioms(ind)) {
                    oWLAxiom.accept((OWLObjectVisitor)this);
                }
                for (OWLAnnotationAssertionAxiom oWLAnnotationAssertionAxiom : AbstractTranslator.sort(this.getAnnotationAssertionsForAnonymous(ind))) {
                    oWLAnnotationAssertionAxiom.accept((OWLObjectVisitor)this);
                }
            }
            this.currentIndividuals.remove(ind);
        }
    }

    @Nonnull
    private static <T extends OWLObject> List<T> sort(Collection<T> axioms) {
        return CollectionFactory.sortOptionally(axioms);
    }

    @Nonnull
    private Set<OWLAnnotationAssertionAxiom> getAnnotationAssertionsForAnonymous(@Nonnull OWLIndividual ind) {
        OWLAnonymousIndividual owlAnonymousIndividual = ind.asOWLAnonymousIndividual();
        return this.ont.getAnnotationAssertionAxioms((OWLAnnotationSubject)owlAnonymousIndividual);
    }

    @Nonnull
    private List<OWLIndividualAxiom> getSortedIndividualAxioms(@Nonnull OWLIndividual ind) {
        return AbstractTranslator.sort(this.ont.getAxioms(ind, Imports.EXCLUDED));
    }

    private void addPairwise(@Nonnull OWLAxiom axiom, @Nonnull Collection<? extends OWLObject> objects, @Nonnull IRI iri) {
        ArrayList<? extends OWLObject> objectList = new ArrayList<OWLObject>(objects);
        Collections.sort(objectList);
        for (int i = 0; i < objectList.size(); ++i) {
            for (int j = i; j < objectList.size(); ++j) {
                if (i == j) continue;
                this.addSingleTripleAxiom(axiom, (OWLObject)objectList.get(i), iri, (OWLObject)objectList.get(j));
            }
        }
    }

    private void addPairwiseClassExpressions(@Nonnull OWLAxiom axiom, @Nonnull Set<OWLClassExpression> classExpressions, @Nonnull IRI iri) {
        this.addPairwise(axiom, classExpressions, iri);
    }

    private void addStrongTyping(@Nonnull OWLEntity entity) {
        if (!this.useStrongTyping) {
            return;
        }
        if (!OWLDocumentFormatImpl.isMissingType((OWLEntity)entity, (OWLOntology)this.ont)) {
            return;
        }
        this.addTriple((OWLObject)entity, OWLRDFVocabulary.RDF_TYPE.getIRI(), (IRI)entity.accept((OWLEntityVisitorEx)OWLEntityTypeProvider.INSTANCE));
    }

    public RDFGraph getGraph() {
        return this.graph;
    }

    public void reset() {
        this.graph = new RDFGraph();
    }

    private static class OWLEntityTypeProvider
    implements OWLEntityVisitorEx<IRI> {
        @Nonnull
        public static final OWLEntityTypeProvider INSTANCE = new OWLEntityTypeProvider();

        private OWLEntityTypeProvider() {
        }

        public IRI visit(OWLClass cls) {
            return OWLRDFVocabulary.OWL_CLASS.getIRI();
        }

        public IRI visit(OWLObjectProperty property) {
            return OWLRDFVocabulary.OWL_OBJECT_PROPERTY.getIRI();
        }

        public IRI visit(OWLDataProperty property) {
            return OWLRDFVocabulary.OWL_DATA_PROPERTY.getIRI();
        }

        public IRI visit(OWLNamedIndividual individual) {
            return OWLRDFVocabulary.OWL_NAMED_INDIVIDUAL.getIRI();
        }

        public IRI visit(OWLDatatype datatype) {
            return OWLRDFVocabulary.RDFS_DATATYPE.getIRI();
        }

        public IRI visit(OWLAnnotationProperty property) {
            return OWLRDFVocabulary.OWL_ANNOTATION_PROPERTY.getIRI();
        }
    }
}

