/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.vocab;

import java.util.Set;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.HasIRI;
import org.semanticweb.owlapi.model.HasPrefixedName;
import org.semanticweb.owlapi.model.HasShortForm;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.semanticweb.owlapi.vocab.Namespaces;

public enum DublinCoreVocabulary implements HasShortForm,
HasIRI,
HasPrefixedName
{
    CONTRIBUTOR("contributor"),
    COVERAGE("coverage"),
    CREATOR("creator"),
    DATE("date"),
    DESCRIPTION("description"),
    FORMAT("format"),
    IDENTIFIER("identifier"),
    LANGUAGE("language"),
    PUBLISHER("publisher"),
    RELATION("relation"),
    RIGHTS("rights"),
    SOURCE("source"),
    SUBJECT("subject"),
    TITLE("title"),
    TYPE("type");

    private final String shortName;
    private final String qname;
    private final IRI iri;
    public static final String NAME_SPACE = "http://purl.org/dc/elements/1.1/";
    public static final Set<IRI> ALL_URIS;

    private DublinCoreVocabulary(String name) {
        this.shortName = name;
        this.qname = Namespaces.DC.getPrefixName() + ':' + name;
        this.iri = IRI.create(NAME_SPACE, name);
    }

    @Override
    public String getShortForm() {
        return this.shortName;
    }

    @Override
    public String getPrefixedName() {
        return this.qname;
    }

    @Override
    public IRI getIRI() {
        return this.iri;
    }

    public String toString() {
        return this.iri.toString();
    }

    static {
        ALL_URIS = OWLAPIStreamUtils.asSet(Stream.of(DublinCoreVocabulary.values()).map(x -> x.getIRI()));
    }
}

