/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.semanticweb.owlapi.model.HasLogicalAxioms;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataCardinalityRestriction;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectCardinalityRestriction;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;

public class DLExpressivityChecker
implements OWLObjectVisitor {
    private static final List<Construct> order = Arrays.asList(Construct.S, Construct.AL, Construct.C, Construct.U, Construct.E, Construct.R, Construct.H, Construct.O, Construct.I, Construct.N, Construct.Q, Construct.F, Construct.TRAN, Construct.D);
    private static final Comparator<Construct> constructComparator = Comparator.comparing(order::indexOf);
    private final Set<Construct> constructs;
    private final List<OWLOntology> ontologies;

    public DLExpressivityChecker(Collection<OWLOntology> ontologies) {
        this.ontologies = new ArrayList<OWLOntology>(ontologies);
        this.constructs = new HashSet<Construct>();
    }

    public List<Construct> getConstructs() {
        return this.getOrderedConstructs();
    }

    public String getDescriptionLogicName() {
        return Joiner.on((String)"").join(this.getOrderedConstructs());
    }

    private void pruneConstructs() {
        if (this.constructs.contains((Object)Construct.AL)) {
            if (this.constructs.contains((Object)Construct.C)) {
                this.constructs.remove((Object)Construct.E);
                this.constructs.remove((Object)Construct.U);
            } else if (this.constructs.contains((Object)Construct.E) && this.constructs.contains((Object)Construct.U)) {
                this.constructs.add(Construct.AL);
                this.constructs.add(Construct.C);
                this.constructs.remove((Object)Construct.E);
                this.constructs.remove((Object)Construct.U);
            }
        }
        if (this.constructs.contains((Object)Construct.N) || this.constructs.contains((Object)Construct.Q)) {
            this.constructs.remove((Object)Construct.F);
        }
        if (this.constructs.contains((Object)Construct.Q)) {
            this.constructs.remove((Object)Construct.N);
        }
        if (this.constructs.contains((Object)Construct.AL) && this.constructs.contains((Object)Construct.C) && this.constructs.contains((Object)Construct.TRAN)) {
            this.constructs.remove((Object)Construct.AL);
            this.constructs.remove((Object)Construct.C);
            this.constructs.remove((Object)Construct.TRAN);
            this.constructs.add(Construct.S);
        }
        if (this.constructs.contains((Object)Construct.R)) {
            this.constructs.remove((Object)Construct.H);
        }
    }

    private List<Construct> getOrderedConstructs() {
        this.constructs.clear();
        this.constructs.add(Construct.AL);
        this.ontologies.stream().flatMap(HasLogicalAxioms::logicalAxioms).forEach(ax -> ax.accept(this));
        this.pruneConstructs();
        return OWLAPIStreamUtils.asList(this.constructs.stream().sorted(constructComparator));
    }

    @Override
    public void visit(OWLObjectInverseOf property) {
        this.constructs.add(Construct.I);
    }

    @Override
    public void visit(OWLDataProperty property) {
        this.constructs.add(Construct.D);
    }

    @Override
    public void visit(OWLDataComplementOf node) {
        this.constructs.add(Construct.D);
    }

    @Override
    public void visit(OWLDataOneOf node) {
        this.constructs.add(Construct.D);
    }

    @Override
    public void visit(OWLDatatypeRestriction node) {
        this.constructs.add(Construct.D);
    }

    @Override
    public void visit(OWLLiteral node) {
        this.constructs.add(Construct.D);
    }

    @Override
    public void visit(OWLFacetRestriction node) {
        this.constructs.add(Construct.D);
    }

    @Override
    public void visit(OWLObjectIntersectionOf ce) {
        this.constructs.add(Construct.AL);
        ce.operands().forEach(o -> o.accept(this));
    }

    @Override
    public void visit(OWLObjectUnionOf ce) {
        this.constructs.add(Construct.U);
        ce.operands().forEach(o -> o.accept(this));
    }

    private static boolean isTop(OWLClassExpression classExpression) {
        return classExpression.isOWLThing();
    }

    private boolean isAtomic(OWLClassExpression classExpression) {
        if (classExpression.isAnonymous()) {
            return false;
        }
        return !this.ontologies.stream().anyMatch(ont -> ont.axioms((OWLClass)classExpression, Imports.EXCLUDED).count() > 0L);
    }

    @Override
    public void visit(OWLObjectComplementOf ce) {
        if (this.isAtomic(ce)) {
            this.constructs.add(Construct.AL);
        } else {
            this.constructs.add(Construct.C);
        }
        ce.getOperand().accept(this);
    }

    @Override
    public void visit(OWLObjectSomeValuesFrom ce) {
        if (DLExpressivityChecker.isTop((OWLClassExpression)ce.getFiller())) {
            this.constructs.add(Construct.AL);
        } else {
            this.constructs.add(Construct.E);
        }
        ce.getProperty().accept(this);
        ((OWLClassExpression)ce.getFiller()).accept(this);
    }

    @Override
    public void visit(OWLObjectAllValuesFrom ce) {
        this.constructs.add(Construct.AL);
        ce.getProperty().accept(this);
        ((OWLClassExpression)ce.getFiller()).accept(this);
    }

    @Override
    public void visit(OWLObjectHasValue ce) {
        this.constructs.add(Construct.O);
        this.constructs.add(Construct.E);
        ce.getProperty().accept(this);
    }

    private void checkCardinality(OWLDataCardinalityRestriction restriction) {
        if (restriction.isQualified()) {
            this.constructs.add(Construct.Q);
        } else {
            this.constructs.add(Construct.N);
        }
        ((OWLDataRange)restriction.getFiller()).accept(this);
        restriction.getProperty().accept(this);
    }

    private void checkCardinality(OWLObjectCardinalityRestriction restriction) {
        if (restriction.isQualified()) {
            this.constructs.add(Construct.Q);
        } else {
            this.constructs.add(Construct.N);
        }
        ((OWLClassExpression)restriction.getFiller()).accept(this);
        restriction.getProperty().accept(this);
    }

    @Override
    public void visit(OWLObjectMinCardinality ce) {
        this.checkCardinality(ce);
    }

    @Override
    public void visit(OWLObjectExactCardinality ce) {
        this.checkCardinality(ce);
    }

    @Override
    public void visit(OWLObjectMaxCardinality ce) {
        this.checkCardinality(ce);
    }

    @Override
    public void visit(OWLObjectHasSelf ce) {
        ce.getProperty().accept(this);
        this.constructs.add(Construct.R);
    }

    @Override
    public void visit(OWLObjectOneOf ce) {
        this.constructs.add(Construct.U);
        this.constructs.add(Construct.O);
    }

    @Override
    public void visit(OWLDataSomeValuesFrom ce) {
        this.constructs.add(Construct.E);
        ((OWLDataRange)ce.getFiller()).accept(this);
        ce.getProperty().accept(this);
    }

    @Override
    public void visit(OWLDataAllValuesFrom ce) {
        ((OWLDataRange)ce.getFiller()).accept(this);
        ce.getProperty().accept(this);
    }

    @Override
    public void visit(OWLDataHasValue ce) {
        this.constructs.add(Construct.D);
        ce.getProperty().accept(this);
    }

    @Override
    public void visit(OWLDataMinCardinality ce) {
        this.checkCardinality(ce);
    }

    @Override
    public void visit(OWLDataExactCardinality ce) {
        this.checkCardinality(ce);
    }

    @Override
    public void visit(OWLDataMaxCardinality ce) {
        this.checkCardinality(ce);
    }

    @Override
    public void visit(OWLSubClassOfAxiom axiom) {
        axiom.getSubClass().accept(this);
        axiom.getSuperClass().accept(this);
    }

    @Override
    public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
        this.constructs.add(Construct.R);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
        this.constructs.add(Construct.R);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLDisjointClassesAxiom axiom) {
        this.constructs.add(Construct.C);
        axiom.classExpressions().forEach(o -> o.accept(this));
    }

    @Override
    public void visit(OWLDataPropertyDomainAxiom axiom) {
        ((OWLClassExpression)axiom.getDomain()).accept(this);
        this.constructs.add(Construct.AL);
        this.constructs.add(Construct.D);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLObjectPropertyDomainAxiom axiom) {
        this.constructs.add(Construct.AL);
        ((OWLClassExpression)axiom.getDomain()).accept(this);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        this.constructs.add(Construct.H);
        axiom.properties().forEach(o -> o.accept(this));
    }

    @Override
    public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLDifferentIndividualsAxiom axiom) {
        this.constructs.add(Construct.U);
        this.constructs.add(Construct.O);
        this.constructs.add(Construct.C);
    }

    @Override
    public void visit(OWLDisjointDataPropertiesAxiom axiom) {
        this.constructs.add(Construct.D);
        axiom.properties().forEach(prop -> prop.accept(this));
    }

    @Override
    public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
        this.constructs.add(Construct.R);
        axiom.properties().forEach(o -> o.accept(this));
    }

    @Override
    public void visit(OWLObjectPropertyRangeAxiom axiom) {
        this.constructs.add(Construct.AL);
        ((OWLClassExpression)axiom.getRange()).accept(this);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
        this.constructs.add(Construct.F);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLSubObjectPropertyOfAxiom axiom) {
        this.constructs.add(Construct.H);
        ((OWLObjectPropertyExpression)axiom.getSubProperty()).accept(this);
        ((OWLObjectPropertyExpression)axiom.getSuperProperty()).accept(this);
    }

    @Override
    public void visit(OWLDisjointUnionAxiom axiom) {
        this.constructs.add(Construct.U);
        this.constructs.add(Construct.C);
        axiom.classExpressions().forEach(o -> o.accept(this));
    }

    @Override
    public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
        this.constructs.add(Construct.I);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLDataPropertyRangeAxiom axiom) {
        this.constructs.add(Construct.AL);
        this.constructs.add(Construct.D);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLFunctionalDataPropertyAxiom axiom) {
        this.constructs.add(Construct.F);
        this.constructs.add(Construct.D);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
        this.constructs.add(Construct.H);
        this.constructs.add(Construct.D);
        axiom.properties().forEach(o -> o.accept(this));
    }

    @Override
    public void visit(OWLClassAssertionAxiom axiom) {
        axiom.getClassExpression().accept(this);
    }

    @Override
    public void visit(OWLEquivalentClassesAxiom axiom) {
        axiom.classExpressions().forEach(o -> o.accept(this));
    }

    @Override
    public void visit(OWLDataPropertyAssertionAxiom axiom) {
        this.constructs.add(Construct.D);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
        this.constructs.add(Construct.TRAN);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        this.constructs.add(Construct.R);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLSubDataPropertyOfAxiom axiom) {
        this.constructs.add(Construct.H);
        this.constructs.add(Construct.D);
    }

    @Override
    public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        this.constructs.add(Construct.I);
        this.constructs.add(Construct.F);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLSameIndividualAxiom axiom) {
        this.constructs.add(Construct.O);
    }

    @Override
    public void visit(OWLSubPropertyChainOfAxiom axiom) {
        this.constructs.add(Construct.R);
        axiom.getPropertyChain().forEach(o -> o.accept(this));
        axiom.getSuperProperty().accept(this);
    }

    @Override
    public void visit(OWLInverseObjectPropertiesAxiom axiom) {
        this.constructs.add(Construct.I);
    }

    public static enum Construct {
        AL("AL"),
        U("U"),
        C("C"),
        E("E"),
        N("N"),
        Q("Q"),
        H("H"),
        I("I"),
        O("O"),
        F("F"),
        TRAN("+"),
        D("(D)"),
        R("R"),
        S("S"),
        EL("EL"),
        ELPLUSPLUS("EL++");

        private final String s;

        private Construct(String s) {
            this.s = s;
        }

        public String toString() {
            return this.s;
        }
    }
}

