/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rio;

import info.aduna.iteration.CloseableIteration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.openrdf.OpenRDFException;
import org.openrdf.model.Model;
import org.openrdf.model.Namespace;
import org.openrdf.model.Statement;
import org.openrdf.model.util.Namespaces;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public class RioMemoryTripleSource
implements OWLOntologyDocumentSource {
    private final Map<String, String> namespaces = new LinkedHashMap<String, String>();
    private final Iterator<Statement> statementIterator;
    private final IRI documentIRI = IRI.getNextDocumentIRI("rio-memory-triples:");

    public RioMemoryTripleSource(Iterator<Statement> statements) {
        this.statementIterator = OWLAPIPreconditions.checkNotNull(statements, "statements cannot be null");
    }

    public RioMemoryTripleSource(Iterator<Statement> statements, Map<String, String> namespaces) {
        this(statements);
        this.namespaces.putAll(namespaces);
    }

    public RioMemoryTripleSource(Iterable<Statement> statements) {
        this.statementIterator = statements.iterator();
        if (statements instanceof Model) {
            this.namespaces.putAll(Namespaces.asMap((Set)((Model)statements).getNamespaces()));
        }
    }

    public RioMemoryTripleSource(CloseableIteration<Statement, ? extends OpenRDFException> statements) {
        this.statementIterator = new StatementIterator(statements);
    }

    public RioMemoryTripleSource(CloseableIteration<Statement, ? extends OpenRDFException> statements, Map<String, String> namespaces) {
        this(statements);
        this.namespaces.putAll(namespaces);
    }

    @Override
    public IRI getDocumentIRI() {
        return this.documentIRI;
    }

    @Override
    public boolean hasAlredyFailedOnStreams() {
        return false;
    }

    public Map<String, String> getNamespaces() {
        return this.namespaces;
    }

    public Iterator<Statement> getStatementIterator() {
        return this.statementIterator;
    }

    public void setNamespaces(Set<Namespace> nextNamespaces) {
        this.namespaces.clear();
        this.namespaces.putAll(Namespaces.asMap(nextNamespaces));
    }

    public void setNamespaces(Map<String, String> nextNamespaces) {
        this.namespaces.clear();
        this.namespaces.putAll(nextNamespaces);
    }

    @Override
    public boolean hasAlredyFailedOnIRIResolution() {
        return false;
    }

    @Override
    public void setIRIResolutionFailed(boolean value) {
    }

    static final class StatementIterator
    implements Iterator<Statement> {
        private final CloseableIteration<Statement, ? extends OpenRDFException> statements;

        StatementIterator(CloseableIteration<Statement, ? extends OpenRDFException> statements) {
            this.statements = statements;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove statements using this iterator");
        }

        @Override
        public Statement next() {
            Statement nextStatement = null;
            try {
                nextStatement = (Statement)this.statements.next();
                if (nextStatement != null) {
                    Statement statement = nextStatement;
                    return statement;
                }
                try {
                    throw new NoSuchElementException("No more statements in this iterator");
                }
                catch (OpenRDFException e) {
                    throw new OWLRuntimeException("Found exception while iterating", e);
                }
            }
            finally {
                if (nextStatement == null) {
                    try {
                        this.statements.close();
                    }
                    catch (OpenRDFException e) {
                        throw new OWLRuntimeException(e);
                    }
                }
            }
        }

        @Override
        public boolean hasNext() {
            boolean result = false;
            try {
                boolean bl = result = this.statements.hasNext();
                return bl;
            }
            catch (OpenRDFException e) {
                throw new OWLRuntimeException("Found exception while iterating", e);
            }
            finally {
                if (!result) {
                    try {
                        this.statements.close();
                    }
                    catch (OpenRDFException e) {
                        throw new OWLRuntimeException(e);
                    }
                }
            }
        }
    }
}

