/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rdf.rdfxml.renderer;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.formats.PrefixDocumentFormat;
import org.semanticweb.owlapi.io.XMLUtils;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLNamedObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.rdf.rdfxml.renderer.XMLWriterNamespaceManager;
import org.semanticweb.owlapi.util.NamespaceUtil;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.semanticweb.owlapi.vocab.Namespaces;

public class OWLOntologyXMLNamespaceManager
extends XMLWriterNamespaceManager {
    private final OWLOntology ontology;
    private final NamespaceUtil namespaceUtil = new NamespaceUtil();
    private final OWLDocumentFormat ontologyFormat;

    public OWLOntologyXMLNamespaceManager(OWLOntology ontology, OWLDocumentFormat format) {
        super(OWLOntologyXMLNamespaceManager.getDefaultNamespace(ontology, format));
        this.ontology = OWLAPIPreconditions.checkNotNull(ontology, "ontology cannot be null");
        this.ontologyFormat = OWLAPIPreconditions.checkNotNull(format, "format cannot be null");
        this.addWellKnownNamespace("skos", Namespaces.SKOS.toString());
        this.addWellKnownNamespace("dc", "http://purl.org/dc/elements/1.1/");
        this.processOntology();
    }

    protected OWLOntology getOntology() {
        return this.ontology;
    }

    private final void processOntology() {
        if (this.ontologyFormat instanceof PrefixDocumentFormat) {
            PrefixDocumentFormat namespaceFormat = (PrefixDocumentFormat)this.ontologyFormat;
            Map<String, String> namespacesByPrefix = namespaceFormat.getPrefixName2PrefixMap();
            for (Map.Entry<String, String> e : namespacesByPrefix.entrySet()) {
                String xmlnsPrefixName = e.getKey().substring(0, e.getKey().length() - 1);
                this.namespaceUtil.setPrefix(OWLAPIPreconditions.verifyNotNull(e.getValue()), OWLAPIPreconditions.verifyNotNull(xmlnsPrefixName));
            }
        }
        if (this.ontology.getAxiomCount(AxiomType.SWRL_RULE) != 0) {
            this.namespaceUtil.setPrefix(Namespaces.SWRL.toString(), "swrl");
            this.namespaceUtil.setPrefix(Namespaces.SWRLB.toString(), "swrlb");
        }
        this.getEntitiesThatRequireNamespaces().forEach(this::processEntity);
        this.namespaceUtil.getNamespace2PrefixMap().forEach(this::setOWL2Prefix);
    }

    protected void setOWL2Prefix(String k, String v) {
        if (!Namespaces.OWL11.inNamespace(k) && !Namespaces.OWL11XML.inNamespace(k)) {
            this.setPrefix(v, k);
        }
    }

    protected Set<OWLEntity> getEntitiesThatRequireNamespaces() {
        HashSet<OWLEntity> result = new HashSet<OWLEntity>();
        OWLAPIStreamUtils.add(result, this.ontology.classesInSignature());
        OWLAPIStreamUtils.add(result, this.ontology.objectPropertiesInSignature());
        OWLAPIStreamUtils.add(result, this.ontology.dataPropertiesInSignature());
        OWLAPIStreamUtils.add(result, this.ontology.individualsInSignature());
        OWLAPIStreamUtils.add(result, this.ontology.annotationPropertiesInSignature());
        return result;
    }

    private void processEntity(OWLNamedObject entity) {
        this.processIRI(OWLAPIPreconditions.checkNotNull(entity, "entity cannot be null").getIRI());
    }

    private void processIRI(IRI iri) {
        String ns = OWLAPIPreconditions.checkNotNull(iri, "iri cannot be null").getNamespace();
        if (!ns.isEmpty() && iri.getRemainder().isPresent()) {
            this.namespaceUtil.getPrefix(ns);
        }
    }

    private static String getDefaultNamespace(OWLOntology ontology, OWLDocumentFormat format) {
        PrefixDocumentFormat prefixOWLDocumentFormat;
        String defaultPrefix;
        OWLAPIPreconditions.checkNotNull(ontology, "ontology cannot be null");
        OWLAPIPreconditions.checkNotNull(format, "format cannot be null");
        if (format instanceof PrefixDocumentFormat && (defaultPrefix = (prefixOWLDocumentFormat = (PrefixDocumentFormat)format).getDefaultPrefix()) != null) {
            return defaultPrefix;
        }
        if (ontology.getOntologyID().isAnonymous()) {
            return Namespaces.OWL.toString();
        }
        String base = ontology.getOntologyID().getOntologyIRI().get().toString();
        if (!base.endsWith("#") && !base.endsWith("/")) {
            base = base + "#";
        }
        return base;
    }

    @Override
    @Nullable
    public String getQName(String name) {
        OWLAPIPreconditions.checkNotNull(name, "name cannot be null");
        String ns = XMLUtils.getNCNamePrefix(name);
        String fragment = XMLUtils.getNCNameSuffix(name);
        if (ns.equals(this.getDefaultNamespace())) {
            return fragment;
        }
        if (name.startsWith("xmlns") || name.startsWith("xml:")) {
            return name;
        }
        if (ns.isEmpty() || fragment == null || fragment.isEmpty()) {
            return name;
        }
        String prefix = this.getPrefixForNamespace(ns);
        if (prefix == null) {
            return null;
        }
        if (prefix.isEmpty()) {
            return fragment;
        }
        return prefix + ":" + fragment;
    }
}

