/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rdf.rdfxml.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.EntityType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLProperty;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.rdf.rdfxml.parser.Mode;
import org.semanticweb.owlapi.rdf.rdfxml.parser.OWLRDFConsumer;
import org.semanticweb.owlapi.rdf.rdfxml.parser.OptimisedListTranslator;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import org.semanticweb.owlapi.vocab.OWLFacet;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;
import org.semanticweb.owlapi.vocab.SWRLVocabulary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Translators {
    protected static final Logger LOGGER = LoggerFactory.getLogger(Translators.class);

    private Translators() {
    }

    static OptimisedListTranslator<OWLPropertyExpression> getListTranslator(OWLRDFConsumer consumer) {
        return new OptimisedListTranslator<OWLPropertyExpression>(consumer, new HasKeyListItemTranslator(consumer));
    }

    static class TypedConstantListItemTranslator
    implements ListItemTranslator<OWLLiteral> {
        TypedConstantListItemTranslator() {
        }

        @Override
        @Nullable
        public OWLLiteral translate(IRI firstObject) {
            LOGGER.info("Cannot translate list item to a constant because rdf:first triple is a resource triple");
            return null;
        }

        @Override
        @Nullable
        public OWLLiteral translate(OWLLiteral firstObject) {
            return firstObject;
        }
    }

    static class SWRLRuleTranslator {
        private final OWLRDFConsumer consumer;
        private final OptimisedListTranslator<SWRLAtom> listTranslator;

        SWRLRuleTranslator(OWLRDFConsumer consumer, TranslatorAccessor accessor) {
            this.consumer = consumer;
            this.listTranslator = new OptimisedListTranslator<SWRLAtom>(consumer, new SWRLAtomListItemTranslator(consumer, accessor));
        }

        public void translateRule(IRI mainNode) {
            IRI remappedNode = this.consumer.remapIRI(mainNode);
            HashSet<OWLAnnotation> annotations = new HashSet<OWLAnnotation>();
            Set<IRI> predicates = this.consumer.getPredicatesBySubject(remappedNode);
            for (IRI i : predicates) {
                if (!this.consumer.isAnnotationProperty(i)) continue;
                OWLAnnotationProperty p = this.consumer.getDataFactory().getOWLAnnotationProperty(i);
                OWLLiteral literal = this.consumer.getLiteralObject(remappedNode, i, true);
                while (literal != null) {
                    annotations.add(this.consumer.getDataFactory().getOWLAnnotation(p, literal));
                    literal = this.consumer.getLiteralObject(remappedNode, i, true);
                }
            }
            Set<SWRLAtom> consequent = Collections.emptySet();
            IRI ruleHeadIRI = this.consumer.getResourceObject(remappedNode, SWRLVocabulary.HEAD.getIRI(), true);
            if (ruleHeadIRI != null) {
                consequent = this.listTranslator.translateToSet(ruleHeadIRI);
            }
            Set<SWRLAtom> antecedent = Collections.emptySet();
            IRI ruleBodyIRI = this.consumer.getResourceObject(remappedNode, SWRLVocabulary.BODY.getIRI(), true);
            if (ruleBodyIRI != null) {
                antecedent = this.listTranslator.translateToSet(ruleBodyIRI);
            }
            this.consumer.addAxiom(this.getRule(remappedNode, annotations, consequent, antecedent));
        }

        protected SWRLRule getRule(IRI remappedNode, Set<OWLAnnotation> annotations, Set<SWRLAtom> consequent, Set<SWRLAtom> antecedent) {
            if (!this.consumer.isAnonymousNode(remappedNode)) {
                return this.consumer.getDataFactory().getSWRLRule(antecedent, consequent, annotations);
            }
            return this.consumer.getDataFactory().getSWRLRule(antecedent, consequent, annotations);
        }
    }

    static class SWRLAtomListItemTranslator
    implements ListItemTranslator<SWRLAtom> {
        private final OWLRDFConsumer consumer;
        protected final OWLDataFactory dataFactory;
        protected final TranslatorAccessor accessor;

        SWRLAtomListItemTranslator(OWLRDFConsumer consumer, TranslatorAccessor accessor) {
            this.consumer = consumer;
            this.accessor = accessor;
            this.dataFactory = consumer.getDataFactory();
        }

        @Override
        @Nullable
        public SWRLAtom translate(IRI firstObject) {
            if (this.consumer.isSWRLBuiltInAtom(firstObject)) {
                return this.builtin(firstObject);
            }
            if (this.consumer.isSWRLClassAtom(firstObject)) {
                return this.classAtom(firstObject);
            }
            if (this.consumer.isSWRLDataRangeAtom(firstObject)) {
                return this.dataRangeAtom(firstObject);
            }
            if (this.consumer.isSWRLDataValuedPropertyAtom(firstObject)) {
                return this.dataValueAtom(firstObject);
            }
            if (this.consumer.isSWRLIndividualPropertyAtom(firstObject)) {
                return this.individualAtom(firstObject);
            }
            if (this.consumer.isSWRLSameAsAtom(firstObject)) {
                return this.sameAsAtom(firstObject);
            }
            if (this.consumer.isSWRLDifferentFromAtom(firstObject)) {
                return this.differentFromAtom(firstObject);
            }
            throw new OWLRuntimeException("Don't know how to translate SWRL Atom: " + firstObject);
        }

        protected SWRLAtom differentFromAtom(IRI firstObject) {
            SWRLIArgument arg1 = this.translateSWRLAtomIObject(firstObject, SWRLVocabulary.ARGUMENT_1.getIRI());
            SWRLIArgument arg2 = this.translateSWRLAtomIObject(firstObject, SWRLVocabulary.ARGUMENT_2.getIRI());
            return this.dataFactory.getSWRLDifferentIndividualsAtom(arg1, arg2);
        }

        protected SWRLAtom sameAsAtom(IRI firstObject) {
            SWRLIArgument arg1 = this.translateSWRLAtomIObject(firstObject, SWRLVocabulary.ARGUMENT_1.getIRI());
            SWRLIArgument arg2 = this.translateSWRLAtomIObject(firstObject, SWRLVocabulary.ARGUMENT_2.getIRI());
            return this.dataFactory.getSWRLSameIndividualAtom(arg1, arg2);
        }

        protected SWRLAtom individualAtom(IRI firstObject) {
            IRI objectPropertyIRI = this.consumer.getResourceObject(firstObject, SWRLVocabulary.PROPERTY_PREDICATE.getIRI(), true);
            if (objectPropertyIRI == null) {
                throw new OWLRuntimeException("Don't know how to translate SWRL Atom: object property IRI is null " + firstObject);
            }
            OWLObjectPropertyExpression prop = this.consumer.translateObjectPropertyExpression(objectPropertyIRI);
            SWRLIArgument arg1 = this.translateSWRLAtomIObject(firstObject, SWRLVocabulary.ARGUMENT_1.getIRI());
            SWRLIArgument arg2 = this.translateSWRLAtomIObject(firstObject, SWRLVocabulary.ARGUMENT_2.getIRI());
            return this.dataFactory.getSWRLObjectPropertyAtom(prop, arg1, arg2);
        }

        protected SWRLAtom dataValueAtom(IRI firstObject) {
            IRI dataPropertyIRI = this.consumer.getResourceObject(firstObject, SWRLVocabulary.PROPERTY_PREDICATE.getIRI(), true);
            if (dataPropertyIRI == null) {
                throw new OWLRuntimeException("Don't know how to translate SWRL Atom: data property IRI is null " + firstObject);
            }
            OWLDataPropertyExpression prop = this.consumer.translateDataPropertyExpression(dataPropertyIRI);
            SWRLIArgument arg1 = this.translateSWRLAtomIObject(firstObject, SWRLVocabulary.ARGUMENT_1.getIRI());
            SWRLDArgument arg2 = this.translateSWRLAtomDObject(firstObject, SWRLVocabulary.ARGUMENT_2.getIRI());
            return this.dataFactory.getSWRLDataPropertyAtom(prop, arg1, arg2);
        }

        protected SWRLAtom dataRangeAtom(IRI firstObject) {
            IRI dataRangeIRI = this.consumer.getResourceObject(firstObject, SWRLVocabulary.DATA_RANGE.getIRI(), true);
            if (dataRangeIRI == null) {
                throw new OWLRuntimeException("Don't know how to translate SWRL Atom: data range IRI is null " + firstObject);
            }
            OWLDataRange dataRange = this.consumer.translateDataRange(dataRangeIRI);
            SWRLDArgument dObject = this.translateSWRLAtomDObject(firstObject, SWRLVocabulary.ARGUMENT_1.getIRI());
            return this.dataFactory.getSWRLDataRangeAtom(dataRange, dObject);
        }

        protected SWRLAtom classAtom(IRI firstObject) {
            IRI classIRI = this.consumer.getResourceObject(firstObject, SWRLVocabulary.CLASS_PREDICATE.getIRI(), true);
            if (classIRI == null) {
                throw new OWLRuntimeException("Don't know how to translate SWRL Atom: class IRI is null " + firstObject);
            }
            OWLClassExpression desc = this.accessor.translateClassExpression(classIRI);
            SWRLIArgument iObject = this.translateSWRLAtomIObject(firstObject, SWRLVocabulary.ARGUMENT_1.getIRI());
            return this.dataFactory.getSWRLClassAtom(desc, iObject);
        }

        protected SWRLAtom builtin(IRI firstObject) {
            IRI builtInIRI = this.consumer.getResourceObject(firstObject, SWRLVocabulary.BUILT_IN.getIRI(), true);
            IRI mainIRI = this.consumer.getResourceObject(firstObject, SWRLVocabulary.ARGUMENTS.getIRI(), true);
            OptimisedListTranslator<SWRLDArgument> listTranslator = new OptimisedListTranslator<SWRLDArgument>(this.consumer, new SWRLAtomDObjectListItemTranslator());
            List<SWRLDArgument> args = listTranslator.translateList(OWLAPIPreconditions.verifyNotNull(mainIRI));
            return this.dataFactory.getSWRLBuiltInAtom(OWLAPIPreconditions.verifyNotNull(builtInIRI), args);
        }

        @Override
        @Nullable
        public SWRLAtom translate(OWLLiteral firstObject) {
            throw new OWLRuntimeException("Unexpected literal in atom list: " + firstObject);
        }

        private SWRLIArgument translateSWRLAtomIObject(IRI mainIRI, IRI argPredicateIRI) {
            IRI argIRI = this.consumer.getResourceObject(mainIRI, argPredicateIRI, true);
            if (argIRI != null) {
                if (this.consumer.isSWRLVariable(argIRI)) {
                    return this.dataFactory.getSWRLVariable(argIRI);
                }
                return this.dataFactory.getSWRLIndividualArgument(this.consumer.getOWLIndividual(argIRI));
            }
            throw new OWLRuntimeException("Cannot translate SWRL Atom I-Object for " + argPredicateIRI + " Triple not found.");
        }

        private SWRLDArgument translateSWRLAtomDObject(IRI mainIRI, IRI argPredicateIRI) {
            IRI argIRI = this.consumer.getResourceObject(mainIRI, argPredicateIRI, true);
            if (argIRI != null) {
                if (!this.consumer.isSWRLVariable(argIRI)) {
                    LOGGER.info("Expected SWRL variable for SWRL Data Object: {} (possibly untyped)", (Object)argIRI);
                }
                return this.dataFactory.getSWRLVariable(argIRI);
            }
            OWLLiteral con = this.consumer.getLiteralObject(mainIRI, argPredicateIRI, true);
            if (con != null) {
                return this.dataFactory.getSWRLLiteralArgument(con);
            }
            throw new IllegalStateException("Could not translate SWRL Atom D-Object");
        }

        private class SWRLAtomDObjectListItemTranslator
        implements ListItemTranslator<SWRLDArgument> {
            SWRLAtomDObjectListItemTranslator() {
            }

            @Override
            @Nullable
            public SWRLDArgument translate(IRI firstObject) {
                return SWRLAtomListItemTranslator.this.dataFactory.getSWRLVariable(firstObject);
            }

            @Override
            @Nullable
            public SWRLDArgument translate(OWLLiteral firstObject) {
                return SWRLAtomListItemTranslator.this.dataFactory.getSWRLLiteralArgument(firstObject);
            }
        }
    }

    static class ObjectUnionOfTranslator
    extends AbstractClassExpressionTranslator {
        ObjectUnionOfTranslator(OWLRDFConsumer consumer, TranslatorAccessor accessor) {
            super(consumer, accessor);
        }

        @Override
        public boolean matchesStrict(IRI mainNode) {
            IRI listNode = this.getConsumer().getResourceObject(mainNode, OWLRDFVocabulary.OWL_UNION_OF, false);
            return this.isClassExpressionStrict(mainNode) && this.isClassExpressionListStrict(listNode, 2);
        }

        @Override
        public boolean matchesLax(IRI mainNode) {
            return this.isResourcePresent(mainNode, OWLRDFVocabulary.OWL_UNION_OF);
        }

        @Override
        public OWLObjectUnionOf translate(IRI mainNode) {
            IRI listNode = this.getConsumer().getResourceObject(mainNode, OWLRDFVocabulary.OWL_UNION_OF, true);
            Set<OWLClassExpression> classExpressions = this.accessor.translateToClassExpressionSet(OWLAPIPreconditions.verifyNotNull(listNode));
            return this.getDataFactory().getOWLObjectUnionOf(classExpressions);
        }
    }

    static class ObjectSomeValuesFromTranslator
    extends AbstractClassExpressionTranslator {
        ObjectSomeValuesFromTranslator(OWLRDFConsumer consumer, TranslatorAccessor accessor) {
            super(consumer, accessor);
        }

        @Override
        public boolean matchesStrict(IRI mainNode) {
            return this.isRestrictionStrict(mainNode) && this.isObjectPropertyStrict(mainNode, OWLRDFVocabulary.OWL_ON_PROPERTY) && this.isClassExpressionStrict(mainNode, OWLRDFVocabulary.OWL_SOME_VALUES_FROM);
        }

        @Override
        public boolean matchesLax(IRI mainNode) {
            return this.isClassExpressionLax(mainNode, OWLRDFVocabulary.OWL_SOME_VALUES_FROM) && this.isResourcePresent(mainNode, OWLRDFVocabulary.OWL_ON_PROPERTY) || this.isObjectPropertyLax(mainNode) && this.isResourcePresent(mainNode, OWLRDFVocabulary.OWL_SOME_VALUES_FROM);
        }

        @Override
        public OWLObjectSomeValuesFrom translate(IRI mainNode) {
            this.getConsumer().consumeTriple(mainNode, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_RESTRICTION.getIRI());
            IRI propertyIRI = this.getConsumer().getResourceObject(mainNode, OWLRDFVocabulary.OWL_ON_PROPERTY, true);
            OWLObjectPropertyExpression property = this.getConsumer().translateObjectPropertyExpression(OWLAPIPreconditions.verifyNotNull(propertyIRI));
            IRI fillerIRI = this.getConsumer().getResourceObject(mainNode, OWLRDFVocabulary.OWL_SOME_VALUES_FROM, true);
            OWLClassExpression filler = this.accessor.translateClassExpression(OWLAPIPreconditions.verifyNotNull(fillerIRI));
            return this.getDataFactory().getOWLObjectSomeValuesFrom(property, filler);
        }
    }

    static class ObjectQualifiedCardinalityTranslator
    extends AbstractClassExpressionTranslator {
        ObjectQualifiedCardinalityTranslator(OWLRDFConsumer consumer, TranslatorAccessor accessor) {
            super(consumer, accessor);
        }

        @Override
        public boolean matchesStrict(IRI mainNode) {
            return this.isRestrictionStrict(mainNode) && this.isNonNegativeIntegerStrict(mainNode, OWLRDFVocabulary.OWL_QUALIFIED_CARDINALITY) && this.isObjectPropertyStrict(mainNode, OWLRDFVocabulary.OWL_ON_PROPERTY) && this.isClassExpressionStrict(mainNode, OWLRDFVocabulary.OWL_ON_CLASS);
        }

        @Override
        public boolean matchesLax(IRI mainNode) {
            return this.isNonNegativeIntegerLax(mainNode, OWLRDFVocabulary.OWL_QUALIFIED_CARDINALITY) && this.isObjectPropertyLax(mainNode, OWLRDFVocabulary.OWL_ON_PROPERTY) && this.isClassExpressionLax(mainNode, OWLRDFVocabulary.OWL_ON_CLASS);
        }

        @Override
        public OWLObjectExactCardinality translate(IRI mainNode) {
            int cardi = this.translateInteger(mainNode, OWLRDFVocabulary.OWL_QUALIFIED_CARDINALITY);
            IRI propertyIRI = this.getConsumer().getResourceObject(mainNode, OWLRDFVocabulary.OWL_ON_PROPERTY, true);
            OWLObjectPropertyExpression property = this.getConsumer().translateObjectPropertyExpression(OWLAPIPreconditions.verifyNotNull(propertyIRI));
            IRI fillerIRI = this.getConsumer().getResourceObject(mainNode, OWLRDFVocabulary.OWL_ON_CLASS, true);
            OWLClassExpression filler = this.accessor.translateClassExpression(OWLAPIPreconditions.verifyNotNull(fillerIRI));
            return this.getDataFactory().getOWLObjectExactCardinality(cardi, property, filler);
        }
    }

    static class ObjectPropertyListItemTranslator
    implements ListItemTranslator<OWLObjectPropertyExpression> {
        private final OWLRDFConsumer consumer;

        ObjectPropertyListItemTranslator(OWLRDFConsumer consumer) {
            this.consumer = consumer;
        }

        @Override
        @Nullable
        public OWLObjectPropertyExpression translate(IRI firstObject) {
            this.consumer.addObjectProperty(firstObject, false);
            return this.consumer.translateObjectPropertyExpression(firstObject);
        }

        @Override
        @Nullable
        public OWLObjectPropertyExpression translate(OWLLiteral firstObject) {
            LOGGER.info("Cannot translate list item as an object property, because rdf:first triple is a literal triple");
            return null;
        }
    }

    static class ObjectOneOfTranslator
    extends AbstractClassExpressionTranslator {
        ObjectOneOfTranslator(OWLRDFConsumer consumer, TranslatorAccessor accessor) {
            super(consumer, accessor);
        }

        @Override
        public boolean matchesStrict(IRI mainNode) {
            IRI listNode = this.getConsumer().getResourceObject(mainNode, OWLRDFVocabulary.OWL_ONE_OF, false);
            return this.isIndividualListStrict(listNode, 1);
        }

        @Override
        public boolean matchesLax(IRI mainNode) {
            return this.isResourcePresent(mainNode, OWLRDFVocabulary.OWL_ONE_OF);
        }

        @Override
        public OWLObjectOneOf translate(IRI mainNode) {
            IRI oneOfObject = this.getConsumer().getResourceObject(mainNode, OWLRDFVocabulary.OWL_ONE_OF, true);
            Set<OWLIndividual> individuals = this.accessor.translateToIndividualSet(OWLAPIPreconditions.verifyNotNull(oneOfObject));
            return this.getDataFactory().getOWLObjectOneOf(individuals);
        }
    }

    static class ObjectMinQualifiedCardinalityTranslator
    extends AbstractClassExpressionTranslator {
        ObjectMinQualifiedCardinalityTranslator(OWLRDFConsumer consumer, TranslatorAccessor accessor) {
            super(consumer, accessor);
        }

        @Override
        public boolean matchesStrict(IRI mainNode) {
            return this.isRestrictionStrict(mainNode) && this.isNonNegativeIntegerStrict(mainNode, OWLRDFVocabulary.OWL_MIN_QUALIFIED_CARDINALITY) && this.isObjectPropertyStrict(mainNode, OWLRDFVocabulary.OWL_ON_PROPERTY) && this.isClassExpressionStrict(mainNode, OWLRDFVocabulary.OWL_ON_CLASS);
        }

        @Override
        public boolean matchesLax(IRI mainNode) {
            return this.isNonNegativeIntegerLax(mainNode, OWLRDFVocabulary.OWL_MIN_QUALIFIED_CARDINALITY) && this.isObjectPropertyLax(mainNode, OWLRDFVocabulary.OWL_ON_PROPERTY) && this.isClassExpressionLax(mainNode, OWLRDFVocabulary.OWL_ON_CLASS);
        }

        @Override
        public OWLObjectMinCardinality translate(IRI mainNode) {
            int cardi = this.translateInteger(mainNode, OWLRDFVocabulary.OWL_MIN_QUALIFIED_CARDINALITY);
            IRI propertyIRI = this.getConsumer().getResourceObject(mainNode, OWLRDFVocabulary.OWL_ON_PROPERTY, true);
            OWLObjectPropertyExpression property = this.getConsumer().translateObjectPropertyExpression(OWLAPIPreconditions.verifyNotNull(propertyIRI));
            IRI fillerIRI = this.getConsumer().getResourceObject(mainNode, OWLRDFVocabulary.OWL_ON_CLASS, true);
            OWLClassExpression filler = this.accessor.translateClassExpression(OWLAPIPreconditions.verifyNotNull(fillerIRI));
            return this.getDataFactory().getOWLObjectMinCardinality(cardi, property, filler);
        }
    }

    static class ObjectMinCardinalityTranslator
    extends AbstractClassExpressionTranslator {
        ObjectMinCardinalityTranslator(OWLRDFConsumer consumer, TranslatorAccessor accessor) {
            super(consumer, accessor);
        }

        @Override
        public boolean matchesStrict(IRI mainNode) {
            return this.isRestrictionStrict(mainNode) && this.isNonNegativeIntegerStrict(mainNode, OWLRDFVocabulary.OWL_MIN_CARDINALITY) && this.isObjectPropertyStrict(mainNode, OWLRDFVocabulary.OWL_ON_PROPERTY);
        }

        @Override
        public boolean matchesLax(IRI mainNode) {
            return this.isNonNegativeIntegerLax(mainNode, OWLRDFVocabulary.OWL_MIN_CARDINALITY) && this.isObjectPropertyLax(mainNode, OWLRDFVocabulary.OWL_ON_PROPERTY);
        }

        @Override
        public OWLObjectMinCardinality translate(IRI mainNode) {
            this.getConsumer().consumeTriple(mainNode, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_RESTRICTION.getIRI());
            int cardi = this.translateInteger(mainNode, OWLRDFVocabulary.OWL_MIN_CARDINALITY);
            IRI propertyIRI = this.getConsumer().getResourceObject(mainNode, OWLRDFVocabulary.OWL_ON_PROPERTY, true);
            OWLObjectPropertyExpression property = this.getConsumer().translateObjectPropertyExpression(OWLAPIPreconditions.verifyNotNull(propertyIRI));
            IRI fillerIRI = this.getConsumer().getResourceObject(mainNode, OWLRDFVocabulary.OWL_ON_CLASS, true);
            if (fillerIRI != null && !this.getConsumer().getConfiguration().isStrict()) {
                OWLClassExpression filler = this.accessor.translateClassExpression(fillerIRI);
                return this.getDataFactory().getOWLObjectMinCardinality(cardi, property, filler);
            }
            return this.getDataFactory().getOWLObjectMinCardinality(cardi, property);
        }
    }

    static class ObjectMaxQualifiedCardinalityTranslator
    extends AbstractClassExpressionTranslator {
        ObjectMaxQualifiedCardinalityTranslator(OWLRDFConsumer consumer, TranslatorAccessor accessor) {
            super(consumer, accessor);
        }

        @Override
        public boolean matchesStrict(IRI mainNode) {
            return this.isRestrictionStrict(mainNode) && this.isNonNegativeIntegerStrict(mainNode, OWLRDFVocabulary.OWL_MAX_QUALIFIED_CARDINALITY) && this.isObjectPropertyStrict(mainNode, OWLRDFVocabulary.OWL_ON_PROPERTY) && this.isClassExpressionStrict(mainNode, OWLRDFVocabulary.OWL_ON_CLASS);
        }

        @Override
        public boolean matchesLax(IRI mainNode) {
            return this.isNonNegativeIntegerLax(mainNode, OWLRDFVocabulary.OWL_MAX_QUALIFIED_CARDINALITY) && this.isObjectPropertyLax(mainNode, OWLRDFVocabulary.OWL_ON_PROPERTY) && this.isClassExpressionLax(mainNode, OWLRDFVocabulary.OWL_ON_CLASS);
        }

        @Override
        public OWLObjectMaxCardinality translate(IRI mainNode) {
            int cardi = this.translateInteger(mainNode, OWLRDFVocabulary.OWL_MAX_QUALIFIED_CARDINALITY);
            IRI propertyIRI = this.getConsumer().getResourceObject(mainNode, OWLRDFVocabulary.OWL_ON_PROPERTY, true);
            OWLObjectPropertyExpression property = this.getConsumer().translateObjectPropertyExpression(OWLAPIPreconditions.verifyNotNull(propertyIRI));
            IRI fillerIRI = this.getConsumer().getResourceObject(mainNode, OWLRDFVocabulary.OWL_ON_CLASS, true);
            OWLClassExpression filler = this.accessor.translateClassExpression(OWLAPIPreconditions.verifyNotNull(fillerIRI));
            return this.getDataFactory().getOWLObjectMaxCardinality(cardi, property, filler);
        }
    }

    static class ObjectMaxCardinalityTranslator
    extends AbstractClassExpressionTranslator {
        ObjectMaxCardinalityTranslator(OWLRDFConsumer consumer, TranslatorAccessor accessor) {
            super(consumer, accessor);
        }

        @Override
        public boolean matchesStrict(IRI mainNode) {
            return this.isRestrictionStrict(mainNode) && this.isNonNegativeIntegerStrict(mainNode, OWLRDFVocabulary.OWL_MAX_CARDINALITY) && this.isObjectPropertyStrict(mainNode, OWLRDFVocabulary.OWL_ON_PROPERTY);
        }

        @Override
        public boolean matchesLax(IRI mainNode) {
            return this.isNonNegativeIntegerLax(mainNode, OWLRDFVocabulary.OWL_MAX_CARDINALITY) && this.isObjectPropertyLax(mainNode, OWLRDFVocabulary.OWL_ON_PROPERTY);
        }

        @Override
        public OWLObjectMaxCardinality translate(IRI mainNode) {
            this.getConsumer().consumeTriple(mainNode, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_RESTRICTION.getIRI());
            int cardi = this.translateInteger(mainNode, OWLRDFVocabulary.OWL_MAX_CARDINALITY);
            IRI propertyIRI = this.getConsumer().getResourceObject(mainNode, OWLRDFVocabulary.OWL_ON_PROPERTY, true);
            OWLObjectPropertyExpression property = this.getConsumer().translateObjectPropertyExpression(OWLAPIPreconditions.verifyNotNull(propertyIRI));
            IRI fillerIRI = this.getConsumer().getResourceObject(mainNode, OWLRDFVocabulary.OWL_ON_CLASS, true);
            if (fillerIRI != null && !this.getConsumer().getConfiguration().isStrict()) {
                OWLClassExpression filler = this.accessor.translateClassExpression(fillerIRI);
                return this.getDataFactory().getOWLObjectMaxCardinality(cardi, property, filler);
            }
            return this.getDataFactory().getOWLObjectMaxCardinality(cardi, property);
        }
    }

    static class ObjectIntersectionOfTranslator
    extends AbstractClassExpressionTranslator {
        ObjectIntersectionOfTranslator(OWLRDFConsumer consumer, TranslatorAccessor accessor) {
            super(consumer, accessor);
        }

        @Override
        public boolean matchesStrict(IRI mainNode) {
            IRI listNode = this.getConsumer().getResourceObject(mainNode, OWLRDFVocabulary.OWL_INTERSECTION_OF, false);
            return this.isClassExpressionStrict(mainNode) && this.isClassExpressionListStrict(listNode, 2);
        }

        @Override
        public boolean matchesLax(IRI mainNode) {
            return this.isResourcePresent(mainNode, OWLRDFVocabulary.OWL_INTERSECTION_OF);
        }

        @Override
        public OWLObjectIntersectionOf translate(IRI mainNode) {
            IRI listNode = this.getConsumer().getResourceObject(mainNode, OWLRDFVocabulary.OWL_INTERSECTION_OF, true);
            Set<OWLClassExpression> classExpressions = this.accessor.translateToClassExpressionSet(OWLAPIPreconditions.verifyNotNull(listNode));
            return this.getDataFactory().getOWLObjectIntersectionOf(classExpressions);
        }
    }

    static class ObjectHasValueTranslator
    extends AbstractClassExpressionTranslator {
        ObjectHasValueTranslator(OWLRDFConsumer consumer, TranslatorAccessor accessor) {
            super(consumer, accessor);
        }

        @Override
        public boolean matchesStrict(IRI mainNode) {
            return this.isRestrictionStrict(mainNode) && this.isObjectPropertyStrict(mainNode, OWLRDFVocabulary.OWL_ON_PROPERTY) && this.isResourcePresent(mainNode, OWLRDFVocabulary.OWL_HAS_VALUE);
        }

        @Override
        public boolean matchesLax(IRI mainNode) {
            return this.isResourcePresent(mainNode, OWLRDFVocabulary.OWL_ON_PROPERTY) && this.isResourcePresent(mainNode, OWLRDFVocabulary.OWL_HAS_VALUE);
        }

        @Override
        public OWLObjectHasValue translate(IRI mainNode) {
            IRI value = this.getConsumer().getResourceObject(mainNode, OWLRDFVocabulary.OWL_HAS_VALUE, true);
            OWLIndividual individual = this.getConsumer().translateIndividual(OWLAPIPreconditions.verifyNotNull(value));
            IRI propertyIRI = this.getConsumer().getResourceObject(mainNode, OWLRDFVocabulary.OWL_ON_PROPERTY, true);
            OWLObjectPropertyExpression property = this.getConsumer().translateObjectPropertyExpression(OWLAPIPreconditions.verifyNotNull(propertyIRI));
            return this.getDataFactory().getOWLObjectHasValue(property, individual);
        }
    }

    static class ObjectHasSelfTranslator
    extends AbstractClassExpressionTranslator {
        ObjectHasSelfTranslator(OWLRDFConsumer consumer, TranslatorAccessor accessor) {
            super(consumer, accessor);
        }

        @Override
        public boolean matchesStrict(IRI mainNode) {
            OWLLiteral literal = this.getConsumer().getLiteralObject(mainNode, OWLRDFVocabulary.OWL_HAS_SELF.getIRI(), false);
            return literal != null && ObjectHasSelfTranslator.isStrictBooleanTrueLiteral(literal) && this.isObjectPropertyStrict(mainNode, OWLRDFVocabulary.OWL_ON_PROPERTY);
        }

        private static boolean isStrictBooleanTrueLiteral(OWLLiteral literal) {
            return OWL2Datatype.XSD_BOOLEAN.getIRI().equals(literal.getDatatype().getIRI()) && Boolean.parseBoolean(literal.getLiteral());
        }

        @Override
        public boolean matchesLax(IRI mainNode) {
            return this.isResourcePresent(mainNode, OWLRDFVocabulary.OWL_ON_PROPERTY) && this.isLiteralPresent(mainNode, OWLRDFVocabulary.OWL_HAS_SELF);
        }

        @Override
        public OWLObjectHasSelf translate(IRI mainNode) {
            this.getConsumer().consumeTriple(mainNode, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_RESTRICTION.getIRI());
            this.getConsumer().getLiteralObject(mainNode, OWLRDFVocabulary.OWL_HAS_SELF, true);
            IRI propertyIRI = this.getConsumer().getResourceObject(mainNode, OWLRDFVocabulary.OWL_ON_PROPERTY, true);
            OWLObjectPropertyExpression property = this.getConsumer().translateObjectPropertyExpression(OWLAPIPreconditions.verifyNotNull(propertyIRI));
            return this.getDataFactory().getOWLObjectHasSelf(property);
        }
    }

    static class ObjectComplementOfTranslator
    extends AbstractClassExpressionTranslator {
        ObjectComplementOfTranslator(OWLRDFConsumer consumer, TranslatorAccessor accessor) {
            super(consumer, accessor);
        }

        @Override
        public boolean matchesStrict(IRI mainNode) {
            IRI complementOfIRI = this.getConsumer().getResourceObject(mainNode, OWLRDFVocabulary.OWL_COMPLEMENT_OF, false);
            return this.isClassExpressionStrict(mainNode) && this.isClassExpressionStrict(complementOfIRI);
        }

        @Override
        public boolean matchesLax(IRI mainNode) {
            return this.isResourcePresent(mainNode, OWLRDFVocabulary.OWL_COMPLEMENT_OF) && this.isClassExpressionLax(mainNode);
        }

        @Override
        public OWLObjectComplementOf translate(IRI mainNode) {
            IRI complementOfObject = this.getConsumer().getResourceObject(mainNode, OWLRDFVocabulary.OWL_COMPLEMENT_OF, true);
            OWLClassExpression operand = this.accessor.translateClassExpression(OWLAPIPreconditions.verifyNotNull(complementOfObject));
            return this.getDataFactory().getOWLObjectComplementOf(operand);
        }
    }

    static class ObjectCardinalityTranslator
    extends AbstractClassExpressionTranslator {
        ObjectCardinalityTranslator(OWLRDFConsumer consumer, TranslatorAccessor accessor) {
            super(consumer, accessor);
        }

        @Override
        public boolean matchesStrict(IRI mainNode) {
            return this.isRestrictionStrict(mainNode) && this.isNonNegativeIntegerStrict(mainNode, OWLRDFVocabulary.OWL_CARDINALITY) && this.isObjectPropertyStrict(mainNode, OWLRDFVocabulary.OWL_ON_PROPERTY);
        }

        @Override
        public boolean matchesLax(IRI mainNode) {
            return this.isNonNegativeIntegerLax(mainNode, OWLRDFVocabulary.OWL_CARDINALITY) && this.isObjectPropertyLax(mainNode, OWLRDFVocabulary.OWL_ON_PROPERTY);
        }

        @Override
        public OWLObjectExactCardinality translate(IRI mainNode) {
            this.getConsumer().consumeTriple(mainNode, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_RESTRICTION.getIRI());
            int cardi = this.translateInteger(mainNode, OWLRDFVocabulary.OWL_CARDINALITY);
            IRI propertyIRI = this.getConsumer().getResourceObject(mainNode, OWLRDFVocabulary.OWL_ON_PROPERTY, true);
            OWLObjectPropertyExpression property = this.getConsumer().translateObjectPropertyExpression(OWLAPIPreconditions.verifyNotNull(propertyIRI));
            IRI fillerIRI = this.getConsumer().getResourceObject(mainNode, OWLRDFVocabulary.OWL_ON_CLASS, true);
            if (fillerIRI != null && !this.getConsumer().getConfiguration().isStrict()) {
                OWLClassExpression filler = this.accessor.translateClassExpression(fillerIRI);
                return this.getDataFactory().getOWLObjectExactCardinality(cardi, property, filler);
            }
            return this.getDataFactory().getOWLObjectExactCardinality(cardi, property);
        }
    }

    static class ObjectAllValuesFromTranslator
    extends AbstractClassExpressionTranslator {
        ObjectAllValuesFromTranslator(OWLRDFConsumer consumer, TranslatorAccessor accessor) {
            super(consumer, accessor);
        }

        @Override
        public boolean matchesStrict(IRI mainNode) {
            return this.isRestrictionStrict(mainNode) && this.isObjectPropertyStrict(mainNode, OWLRDFVocabulary.OWL_ON_PROPERTY) && this.isClassExpressionStrict(mainNode, OWLRDFVocabulary.OWL_ALL_VALUES_FROM);
        }

        @Override
        public boolean matchesLax(IRI mainNode) {
            return this.isClassExpressionLax(mainNode, OWLRDFVocabulary.OWL_ALL_VALUES_FROM) && this.isResourcePresent(mainNode, OWLRDFVocabulary.OWL_ON_PROPERTY) || this.isObjectPropertyLax(mainNode) && this.isResourcePresent(mainNode, OWLRDFVocabulary.OWL_ALL_VALUES_FROM);
        }

        @Override
        public OWLObjectAllValuesFrom translate(IRI mainNode) {
            this.getConsumer().consumeTriple(mainNode, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_RESTRICTION.getIRI());
            IRI propertyIRI = this.getConsumer().getResourceObject(mainNode, OWLRDFVocabulary.OWL_ON_PROPERTY, true);
            OWLObjectPropertyExpression property = this.getConsumer().translateObjectPropertyExpression(OWLAPIPreconditions.verifyNotNull(propertyIRI));
            IRI fillerIRI = this.getConsumer().getResourceObject(mainNode, OWLRDFVocabulary.OWL_ALL_VALUES_FROM, true);
            OWLClassExpression filler = this.accessor.translateClassExpression(OWLAPIPreconditions.verifyNotNull(fillerIRI));
            return this.getDataFactory().getOWLObjectAllValuesFrom(property, filler);
        }
    }

    static class OWLObjectPropertyExpressionListItemTranslator
    implements ListItemTranslator<OWLObjectPropertyExpression> {
        private final OWLRDFConsumer consumer;

        OWLObjectPropertyExpressionListItemTranslator(OWLRDFConsumer consumer) {
            this.consumer = consumer;
        }

        @Override
        @Nullable
        public OWLObjectPropertyExpression translate(IRI firstObject) {
            return this.consumer.translateObjectPropertyExpression(firstObject);
        }

        @Override
        @Nullable
        public OWLObjectPropertyExpression translate(OWLLiteral firstObject) {
            LOGGER.info("Cannot translate list item as an object property, because rdf:first triple is a literal triple");
            return null;
        }
    }

    static class OWLFacetRestrictionListItemTranslator
    implements ListItemTranslator<OWLFacetRestriction> {
        private final OWLRDFConsumer consumer;

        OWLFacetRestrictionListItemTranslator(OWLRDFConsumer consumer) {
            this.consumer = consumer;
        }

        @Override
        @Nullable
        public OWLFacetRestriction translate(OWLLiteral firstObject) {
            return null;
        }

        @Override
        @Nullable
        public OWLFacetRestriction translate(IRI firstObject) {
            for (OWLFacet facet : OWLFacet.values()) {
                OWLLiteral lit = this.consumer.getLiteralObject(firstObject, facet.getIRI(), true);
                if (lit == null) continue;
                return this.consumer.getDataFactory().getOWLFacetRestriction(facet, lit);
            }
            return null;
        }
    }

    static class NamedClassTranslator
    extends AbstractClassExpressionTranslator {
        NamedClassTranslator(OWLRDFConsumer consumer, TranslatorAccessor accessor) {
            super(consumer, accessor);
        }

        @Override
        public boolean matchesStrict(IRI mainNode) {
            return !this.isAnonymous(mainNode) && this.isClassExpressionStrict(mainNode);
        }

        @Override
        public boolean matchesLax(IRI mainNode) {
            return !this.isAnonymous(mainNode);
        }

        @Override
        public OWLClass translate(IRI mainNode) {
            return this.getConsumer().getOWLClass(mainNode);
        }
    }

    public static interface ListItemTranslator<O extends OWLObject> {
        @Nullable
        public O translate(IRI var1);

        @Nullable
        public O translate(OWLLiteral var1);
    }

    static class IndividualListItemTranslator
    implements ListItemTranslator<OWLIndividual> {
        private final OWLRDFConsumer consumer;

        IndividualListItemTranslator(OWLRDFConsumer consumer) {
            this.consumer = consumer;
        }

        @Override
        @Nullable
        public OWLIndividual translate(IRI firstObject) {
            return this.consumer.translateIndividual(firstObject);
        }

        @Override
        @Nullable
        public OWLIndividual translate(OWLLiteral firstObject) {
            LOGGER.info("Cannot translate list item to individual, because rdf:first triple is a literal triple");
            return null;
        }
    }

    static class HasKeyListItemTranslator
    implements ListItemTranslator<OWLPropertyExpression> {
        private final OWLRDFConsumer consumer;

        HasKeyListItemTranslator(OWLRDFConsumer consumer) {
            this.consumer = consumer;
        }

        @Override
        @Nullable
        public OWLPropertyExpression translate(OWLLiteral firstObject) {
            return null;
        }

        @Override
        @Nullable
        public OWLPropertyExpression translate(IRI firstObject) {
            if (this.consumer.isObjectPropertyOnly(firstObject)) {
                return this.consumer.getDataFactory().getOWLObjectProperty(firstObject);
            }
            if (this.consumer.isDataPropertyOnly(firstObject)) {
                return this.consumer.getDataFactory().getOWLDataProperty(firstObject);
            }
            OWLProperty property = null;
            if (this.consumer.isObjectProperty(firstObject)) {
                LOGGER.warn("Property {} has been punned illegally: found declaration as OWLObjectProperty", (Object)firstObject);
                property = this.consumer.getDataFactory().getOWLObjectProperty(firstObject);
            }
            if (this.consumer.isDataProperty(firstObject)) {
                LOGGER.warn("Property {} has been punned illegally: found declaration as OWLDataProperty", (Object)firstObject);
                if (property == null) {
                    property = this.consumer.getDataFactory().getOWLDataProperty(firstObject);
                }
            }
            if (this.consumer.isAnnotationProperty(firstObject)) {
                LOGGER.warn("Property {} has been punned illegally: found declaration as OWLAnnotationProperty", (Object)firstObject);
                if (property == null) {
                    property = this.consumer.getDataFactory().getOWLAnnotationProperty(firstObject);
                }
            }
            if (property == null) {
                LOGGER.warn("Property {} is undeclared at this point in parsing: typing as OWLDataProperty", (Object)firstObject);
                property = this.consumer.getDataFactory().getOWLDataProperty(firstObject);
            }
            return property;
        }
    }

    static class DataSomeValuesFromTranslator
    extends AbstractClassExpressionTranslator {
        DataSomeValuesFromTranslator(OWLRDFConsumer consumer, TranslatorAccessor accessor) {
            super(consumer, accessor);
        }

        @Override
        public boolean matchesStrict(IRI mainNode) {
            return this.isRestrictionStrict(mainNode) && this.isDataPropertyStrict(mainNode, OWLRDFVocabulary.OWL_ON_PROPERTY) && this.isDataRangeStrict(mainNode, OWLRDFVocabulary.OWL_SOME_VALUES_FROM);
        }

        @Override
        public boolean matchesLax(IRI mainNode) {
            return this.isDataRangeLax(mainNode, OWLRDFVocabulary.OWL_SOME_VALUES_FROM) && this.isResourcePresent(mainNode, OWLRDFVocabulary.OWL_ON_PROPERTY) || this.isDataPropertyLax(mainNode, OWLRDFVocabulary.OWL_ON_PROPERTY) && this.isResourcePresent(mainNode, OWLRDFVocabulary.OWL_SOME_VALUES_FROM);
        }

        @Override
        public OWLDataSomeValuesFrom translate(IRI mainNode) {
            this.getConsumer().consumeTriple(mainNode, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_RESTRICTION.getIRI());
            IRI propertyIRI = this.getConsumer().getResourceObject(mainNode, OWLRDFVocabulary.OWL_ON_PROPERTY, true);
            OWLDataPropertyExpression property = this.getConsumer().translateDataPropertyExpression(OWLAPIPreconditions.verifyNotNull(propertyIRI));
            IRI fillerIRI = this.getConsumer().getResourceObject(mainNode, OWLRDFVocabulary.OWL_SOME_VALUES_FROM, true);
            OWLDataRange filler = this.getConsumer().translateDataRange(OWLAPIPreconditions.verifyNotNull(fillerIRI));
            return this.getDataFactory().getOWLDataSomeValuesFrom(property, filler);
        }
    }

    static class DataRangeListItemTranslator
    implements ListItemTranslator<OWLDataRange> {
        private final OWLRDFConsumer consumer;

        DataRangeListItemTranslator(OWLRDFConsumer consumer) {
            this.consumer = consumer;
        }

        @Override
        @Nullable
        public OWLDataRange translate(OWLLiteral firstObject) {
            return null;
        }

        @Override
        @Nullable
        public OWLDataRange translate(IRI firstObject) {
            return this.consumer.translateDataRange(firstObject);
        }
    }

    static class DataQualifiedCardinalityTranslator
    extends AbstractClassExpressionTranslator {
        DataQualifiedCardinalityTranslator(OWLRDFConsumer consumer, TranslatorAccessor accessor) {
            super(consumer, accessor);
        }

        @Override
        public boolean matchesStrict(IRI mainNode) {
            return this.isRestrictionStrict(mainNode) && this.isNonNegativeIntegerStrict(mainNode, OWLRDFVocabulary.OWL_QUALIFIED_CARDINALITY) && this.isDataPropertyStrict(mainNode, OWLRDFVocabulary.OWL_ON_PROPERTY) && this.isDataRangeStrict(mainNode, OWLRDFVocabulary.OWL_ON_CLASS);
        }

        @Override
        public boolean matchesLax(IRI mainNode) {
            return this.isNonNegativeIntegerLax(mainNode, OWLRDFVocabulary.OWL_QUALIFIED_CARDINALITY) && this.isDataPropertyLax(mainNode, OWLRDFVocabulary.OWL_ON_PROPERTY) && this.isDataRangeLax(mainNode, OWLRDFVocabulary.OWL_ON_DATA_RANGE);
        }

        @Override
        public OWLDataExactCardinality translate(IRI mainNode) {
            this.getConsumer().consumeTriple(mainNode, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_RESTRICTION.getIRI());
            int cardi = this.translateInteger(mainNode, OWLRDFVocabulary.OWL_QUALIFIED_CARDINALITY);
            IRI propertyIRI = this.getConsumer().getResourceObject(mainNode, OWLRDFVocabulary.OWL_ON_PROPERTY, true);
            OWLDataPropertyExpression property = this.getConsumer().translateDataPropertyExpression(OWLAPIPreconditions.verifyNotNull(propertyIRI));
            IRI fillerIRI = this.getConsumer().getResourceObject(mainNode, OWLRDFVocabulary.OWL_ON_DATA_RANGE, true);
            OWLDataRange filler = this.getConsumer().translateDataRange(OWLAPIPreconditions.verifyNotNull(fillerIRI));
            return this.getDataFactory().getOWLDataExactCardinality(cardi, property, filler);
        }
    }

    static class DataPropertyListItemTranslator
    implements ListItemTranslator<OWLDataPropertyExpression> {
        private final OWLRDFConsumer consumer;

        DataPropertyListItemTranslator(OWLRDFConsumer consumer) {
            this.consumer = consumer;
        }

        @Override
        @Nullable
        public OWLDataPropertyExpression translate(IRI firstObject) {
            this.consumer.addDataProperty(firstObject, false);
            return this.consumer.getOWLDataProperty(firstObject);
        }

        @Override
        @Nullable
        public OWLDataPropertyExpression translate(OWLLiteral firstObject) {
            return null;
        }
    }

    static class DataMinQualifiedCardinalityTranslator
    extends AbstractClassExpressionTranslator {
        DataMinQualifiedCardinalityTranslator(OWLRDFConsumer consumer, TranslatorAccessor accessor) {
            super(consumer, accessor);
        }

        @Override
        public boolean matchesStrict(IRI mainNode) {
            return this.isRestrictionStrict(mainNode) && this.isNonNegativeIntegerStrict(mainNode, OWLRDFVocabulary.OWL_MIN_QUALIFIED_CARDINALITY) && this.isDataPropertyStrict(mainNode, OWLRDFVocabulary.OWL_ON_PROPERTY) && this.isDataRangeStrict(mainNode, OWLRDFVocabulary.OWL_ON_CLASS);
        }

        @Override
        public boolean matchesLax(IRI mainNode) {
            return this.isNonNegativeIntegerLax(mainNode, OWLRDFVocabulary.OWL_MIN_QUALIFIED_CARDINALITY) && this.isDataPropertyLax(mainNode, OWLRDFVocabulary.OWL_ON_PROPERTY) && this.isDataRangeLax(mainNode, OWLRDFVocabulary.OWL_ON_DATA_RANGE);
        }

        @Override
        public OWLDataMinCardinality translate(IRI mainNode) {
            this.getConsumer().consumeTriple(mainNode, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_RESTRICTION.getIRI());
            int cardi = this.translateInteger(mainNode, OWLRDFVocabulary.OWL_MIN_QUALIFIED_CARDINALITY);
            IRI propertyIRI = this.getConsumer().getResourceObject(mainNode, OWLRDFVocabulary.OWL_ON_PROPERTY, true);
            OWLDataPropertyExpression property = this.getConsumer().translateDataPropertyExpression(OWLAPIPreconditions.verifyNotNull(propertyIRI));
            IRI fillerIRI = this.getConsumer().getResourceObject(mainNode, OWLRDFVocabulary.OWL_ON_DATA_RANGE, true);
            OWLDataRange filler = this.getConsumer().translateDataRange(OWLAPIPreconditions.verifyNotNull(fillerIRI));
            return this.getDataFactory().getOWLDataMinCardinality(cardi, property, filler);
        }
    }

    static class DataMinCardinalityTranslator
    extends AbstractClassExpressionTranslator {
        DataMinCardinalityTranslator(OWLRDFConsumer consumer, TranslatorAccessor accessor) {
            super(consumer, accessor);
        }

        @Override
        public boolean matchesStrict(IRI mainNode) {
            return this.isRestrictionStrict(mainNode) && this.isNonNegativeIntegerStrict(mainNode, OWLRDFVocabulary.OWL_MIN_CARDINALITY) && this.isDataPropertyStrict(mainNode, OWLRDFVocabulary.OWL_ON_PROPERTY);
        }

        @Override
        public boolean matchesLax(IRI mainNode) {
            return this.isNonNegativeIntegerLax(mainNode, OWLRDFVocabulary.OWL_MIN_CARDINALITY) && this.isDataPropertyLax(mainNode, OWLRDFVocabulary.OWL_ON_PROPERTY);
        }

        @Override
        public OWLDataMinCardinality translate(IRI mainNode) {
            this.getConsumer().consumeTriple(mainNode, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_RESTRICTION.getIRI());
            int cardi = this.translateInteger(mainNode, OWLRDFVocabulary.OWL_MIN_CARDINALITY);
            IRI propertyIRI = this.getConsumer().getResourceObject(mainNode, OWLRDFVocabulary.OWL_ON_PROPERTY, true);
            OWLDataPropertyExpression property = this.getConsumer().translateDataPropertyExpression(OWLAPIPreconditions.verifyNotNull(propertyIRI));
            IRI fillerIRI = this.getConsumer().getResourceObject(mainNode, OWLRDFVocabulary.OWL_ON_DATA_RANGE, true);
            if (fillerIRI != null && !this.getConsumer().getConfiguration().isStrict()) {
                OWLDataRange filler = this.getConsumer().translateDataRange(fillerIRI);
                return this.getDataFactory().getOWLDataMinCardinality(cardi, property, filler);
            }
            return this.getDataFactory().getOWLDataMinCardinality(cardi, property);
        }
    }

    static class DataMaxQualifiedCardinalityTranslator
    extends AbstractClassExpressionTranslator {
        DataMaxQualifiedCardinalityTranslator(OWLRDFConsumer consumer, TranslatorAccessor accessor) {
            super(consumer, accessor);
        }

        @Override
        public boolean matchesStrict(IRI mainNode) {
            return this.isRestrictionStrict(mainNode) && this.isNonNegativeIntegerStrict(mainNode, OWLRDFVocabulary.OWL_MAX_QUALIFIED_CARDINALITY) && this.isDataPropertyStrict(mainNode, OWLRDFVocabulary.OWL_ON_PROPERTY) && this.isDataRangeStrict(mainNode, OWLRDFVocabulary.OWL_ON_DATA_RANGE);
        }

        @Override
        public boolean matchesLax(IRI mainNode) {
            return this.isNonNegativeIntegerLax(mainNode, OWLRDFVocabulary.OWL_MAX_QUALIFIED_CARDINALITY) && this.isDataPropertyLax(mainNode, OWLRDFVocabulary.OWL_ON_PROPERTY) && this.isDataRangeLax(mainNode, OWLRDFVocabulary.OWL_ON_DATA_RANGE);
        }

        @Override
        public OWLDataMaxCardinality translate(IRI mainNode) {
            this.getConsumer().consumeTriple(mainNode, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_RESTRICTION.getIRI());
            int cardi = this.translateInteger(mainNode, OWLRDFVocabulary.OWL_MAX_QUALIFIED_CARDINALITY);
            IRI propertyIRI = this.getConsumer().getResourceObject(mainNode, OWLRDFVocabulary.OWL_ON_PROPERTY, true);
            OWLDataPropertyExpression property = this.getConsumer().translateDataPropertyExpression(OWLAPIPreconditions.verifyNotNull(propertyIRI));
            IRI fillerIRI = this.getConsumer().getResourceObject(mainNode, OWLRDFVocabulary.OWL_ON_DATA_RANGE, true);
            OWLDataRange filler = this.getConsumer().translateDataRange(OWLAPIPreconditions.verifyNotNull(fillerIRI));
            return this.getDataFactory().getOWLDataMaxCardinality(cardi, property, filler);
        }
    }

    static class DataMaxCardinalityTranslator
    extends AbstractClassExpressionTranslator {
        DataMaxCardinalityTranslator(OWLRDFConsumer consumer, TranslatorAccessor accessor) {
            super(consumer, accessor);
        }

        @Override
        public boolean matchesStrict(IRI mainNode) {
            return this.isRestrictionStrict(mainNode) && this.isNonNegativeIntegerStrict(mainNode, OWLRDFVocabulary.OWL_MAX_CARDINALITY) && this.isDataPropertyStrict(mainNode, OWLRDFVocabulary.OWL_ON_PROPERTY);
        }

        @Override
        public boolean matchesLax(IRI mainNode) {
            return this.isNonNegativeIntegerLax(mainNode, OWLRDFVocabulary.OWL_MAX_CARDINALITY) && this.isDataPropertyLax(mainNode, OWLRDFVocabulary.OWL_ON_PROPERTY);
        }

        @Override
        public OWLDataMaxCardinality translate(IRI mainNode) {
            this.getConsumer().consumeTriple(mainNode, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_RESTRICTION.getIRI());
            int cardi = this.translateInteger(mainNode, OWLRDFVocabulary.OWL_MAX_CARDINALITY);
            IRI propertyIRI = this.getConsumer().getResourceObject(mainNode, OWLRDFVocabulary.OWL_ON_PROPERTY, true);
            OWLDataPropertyExpression property = this.getConsumer().translateDataPropertyExpression(OWLAPIPreconditions.verifyNotNull(propertyIRI));
            IRI fillerIRI = this.getConsumer().getResourceObject(mainNode, OWLRDFVocabulary.OWL_ON_DATA_RANGE, true);
            if (fillerIRI != null && !this.getConsumer().getConfiguration().isStrict()) {
                OWLDataRange filler = this.getConsumer().translateDataRange(fillerIRI);
                return this.getDataFactory().getOWLDataMaxCardinality(cardi, property, filler);
            }
            return this.getDataFactory().getOWLDataMaxCardinality(cardi, property);
        }
    }

    static class DataHasValueTranslator
    extends AbstractClassExpressionTranslator {
        DataHasValueTranslator(OWLRDFConsumer consumer, TranslatorAccessor accessor) {
            super(consumer, accessor);
        }

        @Override
        public boolean matchesStrict(IRI mainNode) {
            return this.isRestrictionStrict(mainNode) && this.isDataPropertyStrict(mainNode, OWLRDFVocabulary.OWL_ON_PROPERTY) && this.isLiteralPresent(mainNode, OWLRDFVocabulary.OWL_HAS_VALUE);
        }

        @Override
        public boolean matchesLax(IRI mainNode) {
            return this.isLiteralPresent(mainNode, OWLRDFVocabulary.OWL_HAS_VALUE);
        }

        @Override
        public OWLDataHasValue translate(IRI mainNode) {
            this.getConsumer().consumeTriple(mainNode, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_RESTRICTION.getIRI());
            OWLLiteral lit = this.getConsumer().getLiteralObject(mainNode, OWLRDFVocabulary.OWL_HAS_VALUE, true);
            IRI propertyIRI = this.getConsumer().getResourceObject(mainNode, OWLRDFVocabulary.OWL_ON_PROPERTY, true);
            OWLDataPropertyExpression property = this.getConsumer().translateDataPropertyExpression(OWLAPIPreconditions.verifyNotNull(propertyIRI));
            return this.getDataFactory().getOWLDataHasValue(property, OWLAPIPreconditions.verifyNotNull(lit));
        }
    }

    static class DataCardinalityTranslator
    extends AbstractClassExpressionTranslator {
        DataCardinalityTranslator(OWLRDFConsumer consumer, TranslatorAccessor accessor) {
            super(consumer, accessor);
        }

        @Override
        public boolean matchesStrict(IRI mainNode) {
            return this.isRestrictionStrict(mainNode) && this.isNonNegativeIntegerStrict(mainNode, OWLRDFVocabulary.OWL_CARDINALITY) && this.isDataPropertyStrict(mainNode, OWLRDFVocabulary.OWL_ON_PROPERTY);
        }

        @Override
        public boolean matchesLax(IRI mainNode) {
            return this.isNonNegativeIntegerLax(mainNode, OWLRDFVocabulary.OWL_CARDINALITY) && this.isDataPropertyLax(mainNode, OWLRDFVocabulary.OWL_ON_PROPERTY);
        }

        @Override
        public OWLDataExactCardinality translate(IRI mainNode) {
            this.getConsumer().consumeTriple(mainNode, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_RESTRICTION.getIRI());
            int cardi = this.translateInteger(mainNode, OWLRDFVocabulary.OWL_CARDINALITY);
            IRI propertyIRI = this.getConsumer().getResourceObject(mainNode, OWLRDFVocabulary.OWL_ON_PROPERTY, true);
            OWLDataPropertyExpression property = this.getConsumer().translateDataPropertyExpression(OWLAPIPreconditions.verifyNotNull(propertyIRI));
            IRI fillerIRI = this.getConsumer().getResourceObject(mainNode, OWLRDFVocabulary.OWL_ON_DATA_RANGE, true);
            if (fillerIRI != null && !this.getConsumer().getConfiguration().isStrict()) {
                OWLDataRange filler = this.getConsumer().translateDataRange(fillerIRI);
                return this.getDataFactory().getOWLDataExactCardinality(cardi, property, filler);
            }
            return this.getDataFactory().getOWLDataExactCardinality(cardi, property);
        }
    }

    static class DataAllValuesFromTranslator
    extends AbstractClassExpressionTranslator {
        DataAllValuesFromTranslator(OWLRDFConsumer consumer, TranslatorAccessor accessor) {
            super(consumer, accessor);
        }

        @Override
        public boolean matchesStrict(IRI mainNode) {
            return this.isRestrictionStrict(mainNode) && this.isDataPropertyStrict(mainNode, OWLRDFVocabulary.OWL_ON_PROPERTY) && this.isDataRangeStrict(mainNode, OWLRDFVocabulary.OWL_ALL_VALUES_FROM);
        }

        @Override
        public boolean matchesLax(IRI mainNode) {
            return this.isDataRangeLax(mainNode, OWLRDFVocabulary.OWL_ALL_VALUES_FROM) && this.isResourcePresent(mainNode, OWLRDFVocabulary.OWL_ON_PROPERTY) || this.isDataPropertyLax(mainNode, OWLRDFVocabulary.OWL_ON_PROPERTY) && this.isResourcePresent(mainNode, OWLRDFVocabulary.OWL_ALL_VALUES_FROM);
        }

        @Override
        public OWLDataAllValuesFrom translate(IRI mainNode) {
            this.getConsumer().consumeTriple(mainNode, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_RESTRICTION.getIRI());
            IRI propertyIRI = this.getConsumer().getResourceObject(mainNode, OWLRDFVocabulary.OWL_ON_PROPERTY, true);
            IRI fillerIRI = this.getConsumer().getResourceObject(mainNode, OWLRDFVocabulary.OWL_ALL_VALUES_FROM, true);
            OWLDataPropertyExpression property = this.getConsumer().translateDataPropertyExpression(OWLAPIPreconditions.verifyNotNull(propertyIRI));
            OWLDataRange filler = this.getConsumer().translateDataRange(OWLAPIPreconditions.verifyNotNull(fillerIRI));
            return this.getDataFactory().getOWLDataAllValuesFrom(property, filler);
        }
    }

    public static interface ClassExpressionTranslator {
        public boolean matches(IRI var1, Mode var2);

        public boolean matchesStrict(IRI var1);

        public boolean matchesLax(IRI var1);

        public OWLClassExpression translate(IRI var1);
    }

    static class ClassExpressionListItemTranslator
    implements ListItemTranslator<OWLClassExpression> {
        private final OWLRDFConsumer consumer;
        protected final TranslatorAccessor accessor;

        ClassExpressionListItemTranslator(OWLRDFConsumer consumer, TranslatorAccessor accessor) {
            this.consumer = consumer;
            this.accessor = accessor;
        }

        @Override
        @Nullable
        public OWLClassExpression translate(IRI firstObject) {
            this.consumer.addClassExpression(firstObject, false);
            return this.accessor.translateClassExpression(firstObject);
        }

        @Override
        @Nullable
        public OWLClassExpression translate(OWLLiteral firstObject) {
            return this.consumer.getDataFactory().getOWLThing();
        }
    }

    static abstract class AbstractClassExpressionTranslator
    implements ClassExpressionTranslator {
        private final OWLRDFConsumer consumer;
        private final ClassExpressionMatcher classExpressionMatcher = new ClassExpressionMatcher();
        private final DataRangeMatcher dataRangeMatcher = new DataRangeMatcher();
        private final IndividualMatcher individualMatcher = new IndividualMatcher();
        protected final TranslatorAccessor accessor;

        protected AbstractClassExpressionTranslator(OWLRDFConsumer consumer, TranslatorAccessor accessor) {
            this.consumer = consumer;
            this.accessor = accessor;
        }

        @Override
        public boolean matches(IRI mainNode, Mode mode) {
            if (mode.equals((Object)Mode.LAX)) {
                return this.matchesLax(mainNode);
            }
            return this.matchesStrict(mainNode);
        }

        protected OWLRDFConsumer getConsumer() {
            return this.consumer;
        }

        protected OWLDataFactory getDataFactory() {
            return this.consumer.getDataFactory();
        }

        protected boolean isAnonymous(IRI node) {
            return this.consumer.isAnonymousNode(node);
        }

        protected boolean isResourcePresent(IRI mainNode, OWLRDFVocabulary predicate) {
            return this.consumer.getResourceObject(mainNode, predicate, false) != null;
        }

        protected boolean isLiteralPresent(IRI mainNode, OWLRDFVocabulary predicate) {
            return this.consumer.getLiteralObject(mainNode, predicate, false) != null;
        }

        protected boolean isRestrictionStrict(IRI node) {
            return this.consumer.isRestriction(node);
        }

        protected boolean isRestrictionLax(IRI node) {
            return this.consumer.isRestriction(node);
        }

        protected boolean isNonNegativeIntegerStrict(IRI mainNode, OWLRDFVocabulary predicate) {
            OWLLiteral literal = this.consumer.getLiteralObject(mainNode, predicate, false);
            if (literal == null) {
                return false;
            }
            OWLDatatype datatype = literal.getDatatype();
            OWL2Datatype nni = OWL2Datatype.XSD_NON_NEGATIVE_INTEGER;
            return datatype.getIRI().equals(nni.getIRI()) && nni.isInLexicalSpace(literal.getLiteral());
        }

        protected boolean isNonNegativeIntegerLax(IRI mainNode, OWLRDFVocabulary predicate) {
            OWLLiteral literal = this.consumer.getLiteralObject(mainNode, predicate, false);
            if (literal == null) {
                return false;
            }
            return OWL2Datatype.XSD_INTEGER.isInLexicalSpace(OWLAPIPreconditions.verifyNotNull(literal.getLiteral().trim()));
        }

        protected int translateInteger(IRI mainNode, OWLRDFVocabulary predicate) {
            OWLLiteral literal = this.consumer.getLiteralObject(mainNode, predicate, true);
            if (literal == null) {
                return 0;
            }
            try {
                return Integer.parseInt(literal.getLiteral().trim());
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }

        protected boolean isClassExpressionStrict(@Nullable IRI node) {
            return node != null && this.consumer.isClassExpression(node) && !this.consumer.isDataRange(node);
        }

        protected boolean isClassExpressionStrict(IRI mainNode, OWLRDFVocabulary predicate) {
            IRI object = this.consumer.getResourceObject(mainNode, predicate, false);
            return object != null && this.isClassExpressionStrict(object);
        }

        protected boolean isClassExpressionLax(IRI mainNode) {
            return this.consumer.isClassExpression(mainNode) || this.consumer.isParsedAllTriples() && !this.consumer.isDataRange(mainNode);
        }

        protected boolean isClassExpressionLax(IRI mainNode, OWLRDFVocabulary predicate) {
            IRI object = this.consumer.getResourceObject(mainNode, predicate, false);
            return object != null && this.isClassExpressionLax(object);
        }

        protected boolean isObjectPropertyStrict(IRI node) {
            return this.consumer.isObjectPropertyOnly(node);
        }

        protected boolean isObjectPropertyStrict(IRI mainNode, OWLRDFVocabulary predicate) {
            IRI object = this.consumer.getResourceObject(mainNode, predicate, false);
            return object != null && this.isObjectPropertyStrict(object);
        }

        protected boolean isObjectPropertyLax(IRI node) {
            return this.consumer.isObjectProperty(node);
        }

        protected boolean isObjectPropertyLax(IRI mainNode, OWLRDFVocabulary predicate) {
            IRI object = this.consumer.getResourceObject(mainNode, predicate, false);
            return object != null && this.isObjectPropertyLax(object);
        }

        protected boolean isDataPropertyStrict(IRI node) {
            return this.consumer.isDataPropertyOnly(node);
        }

        protected boolean isDataPropertyStrict(IRI mainNode, OWLRDFVocabulary predicate) {
            IRI object = this.consumer.getResourceObject(mainNode, predicate, false);
            return object != null && this.isDataPropertyStrict(object);
        }

        protected boolean isDataPropertyLax(IRI node) {
            return this.consumer.isDataProperty(node);
        }

        protected boolean isDataPropertyLax(IRI mainNode, OWLRDFVocabulary predicate) {
            IRI object = this.consumer.getResourceObject(mainNode, predicate, false);
            return object != null && this.isDataPropertyLax(object);
        }

        protected boolean isDataRangeStrict(IRI node) {
            return this.consumer.isDataRange(node) && !this.consumer.isClassExpression(node);
        }

        protected boolean isDataRangeStrict(IRI mainNode, OWLRDFVocabulary predicate) {
            IRI object = this.consumer.getResourceObject(mainNode, predicate, false);
            return object != null && this.isDataRangeStrict(object);
        }

        protected boolean isDataRangeLax(IRI node) {
            return this.consumer.isParsedAllTriples() && this.consumer.isDataRange(node);
        }

        protected boolean isDataRangeLax(IRI mainNode, OWLRDFVocabulary predicate) {
            IRI object = this.consumer.getResourceObject(mainNode, predicate, false);
            return object != null && this.isDataRangeLax(object);
        }

        protected boolean isClassExpressionListStrict(@Nullable IRI mainNode, int minSize) {
            return this.isResourceListStrict(mainNode, this.classExpressionMatcher, minSize);
        }

        protected boolean isDataRangeListStrict(IRI mainNode, int minSize) {
            return this.isResourceListStrict(mainNode, this.dataRangeMatcher, minSize);
        }

        protected boolean isIndividualListStrict(@Nullable IRI mainNode, int minSize) {
            return mainNode != null && this.isResourceListStrict(mainNode, this.individualMatcher, minSize);
        }

        protected boolean isResourceListStrict(@Nullable IRI mainNode, TypeMatcher typeMatcher, int minSize) {
            if (mainNode == null) {
                return false;
            }
            IRI currentListNode = mainNode;
            HashSet<IRI> visitedListNodes = new HashSet<IRI>();
            int size = 0;
            IRI firstObject;
            while ((firstObject = this.consumer.getResourceObject(currentListNode, OWLRDFVocabulary.RDF_FIRST, false)) != null) {
                if (!typeMatcher.isTypeStrict(firstObject)) {
                    return false;
                }
                ++size;
                IRI restObject = this.consumer.getResourceObject(currentListNode, OWLRDFVocabulary.RDF_REST, false);
                if (restObject == null) {
                    return false;
                }
                if (visitedListNodes.contains(restObject)) {
                    return false;
                }
                if (restObject.equals(OWLRDFVocabulary.RDF_NIL.getIRI())) {
                    return size >= minSize;
                }
                visitedListNodes.add(restObject);
                currentListNode = restObject;
            }
            return false;
        }

        private class IndividualMatcher
        implements TypeMatcher {
            IndividualMatcher() {
            }

            @Override
            public boolean isTypeStrict(IRI node) {
                return true;
            }
        }

        private class DataRangeMatcher
        implements TypeMatcher {
            DataRangeMatcher() {
            }

            @Override
            public boolean isTypeStrict(IRI node) {
                return AbstractClassExpressionTranslator.this.isDataRangeStrict(node);
            }
        }

        private class ClassExpressionMatcher
        implements TypeMatcher {
            ClassExpressionMatcher() {
            }

            @Override
            public boolean isTypeStrict(IRI node) {
                return AbstractClassExpressionTranslator.this.isClassExpressionStrict(node);
            }
        }

        @FunctionalInterface
        private static interface TypeMatcher {
            public boolean isTypeStrict(IRI var1);
        }
    }

    static class TranslatorAccessor {
        private final OptimisedListTranslator<OWLClassExpression> classExpressionListTranslator;
        private final List<ClassExpressionTranslator> classExpressionTranslators = new ArrayList<ClassExpressionTranslator>();
        private final OptimisedListTranslator<OWLIndividual> individualListTranslator;
        private final OptimisedListTranslator<OWLObjectPropertyExpression> objectPropertyListTranslator;
        private final OptimisedListTranslator<OWLLiteral> constantListTranslator;
        private final OptimisedListTranslator<OWLDataPropertyExpression> dataPropertyListTranslator;
        private final OptimisedListTranslator<OWLDataRange> dataRangeListTranslator;
        private final OptimisedListTranslator<OWLFacetRestriction> faceRestrictionListTranslator;
        private final OWLRDFConsumer consumer;
        private final Map<IRI, OWLClassExpression> translatedClassExpression = new HashMap<IRI, OWLClassExpression>();

        TranslatorAccessor(OWLRDFConsumer r) {
            this.consumer = r;
            this.classExpressionListTranslator = new OptimisedListTranslator<OWLClassExpression>(r, new ClassExpressionListItemTranslator(r, this));
            this.individualListTranslator = new OptimisedListTranslator<OWLIndividual>(r, new IndividualListItemTranslator(r));
            this.constantListTranslator = new OptimisedListTranslator<OWLLiteral>(r, new TypedConstantListItemTranslator());
            this.objectPropertyListTranslator = new OptimisedListTranslator<OWLObjectPropertyExpression>(r, new ObjectPropertyListItemTranslator(r));
            this.dataPropertyListTranslator = new OptimisedListTranslator<OWLDataPropertyExpression>(r, new DataPropertyListItemTranslator(r));
            this.dataRangeListTranslator = new OptimisedListTranslator<OWLDataRange>(r, new DataRangeListItemTranslator(r));
            this.faceRestrictionListTranslator = new OptimisedListTranslator<OWLFacetRestriction>(r, new OWLFacetRestrictionListItemTranslator(r));
            this.classExpressionTranslators.add(new NamedClassTranslator(r, this));
            this.classExpressionTranslators.add(new ObjectIntersectionOfTranslator(r, this));
            this.classExpressionTranslators.add(new ObjectUnionOfTranslator(r, this));
            this.classExpressionTranslators.add(new ObjectComplementOfTranslator(r, this));
            this.classExpressionTranslators.add(new ObjectOneOfTranslator(r, this));
            this.classExpressionTranslators.add(new ObjectSomeValuesFromTranslator(r, this));
            this.classExpressionTranslators.add(new ObjectAllValuesFromTranslator(r, this));
            this.classExpressionTranslators.add(new ObjectHasValueTranslator(r, this));
            this.classExpressionTranslators.add(new ObjectHasSelfTranslator(r, this));
            this.classExpressionTranslators.add(new ObjectMinQualifiedCardinalityTranslator(r, this));
            this.classExpressionTranslators.add(new ObjectMaxQualifiedCardinalityTranslator(r, this));
            this.classExpressionTranslators.add(new ObjectQualifiedCardinalityTranslator(r, this));
            this.classExpressionTranslators.add(new ObjectMinCardinalityTranslator(r, this));
            this.classExpressionTranslators.add(new ObjectMaxCardinalityTranslator(r, this));
            this.classExpressionTranslators.add(new ObjectCardinalityTranslator(r, this));
            this.classExpressionTranslators.add(new DataSomeValuesFromTranslator(r, this));
            this.classExpressionTranslators.add(new DataAllValuesFromTranslator(r, this));
            this.classExpressionTranslators.add(new DataHasValueTranslator(r, this));
            this.classExpressionTranslators.add(new DataMinQualifiedCardinalityTranslator(r, this));
            this.classExpressionTranslators.add(new DataMaxQualifiedCardinalityTranslator(r, this));
            this.classExpressionTranslators.add(new DataQualifiedCardinalityTranslator(r, this));
            this.classExpressionTranslators.add(new DataMinCardinalityTranslator(r, this));
            this.classExpressionTranslators.add(new DataMaxCardinalityTranslator(r, this));
            this.classExpressionTranslators.add(new DataCardinalityTranslator(r, this));
        }

        protected Set<OWLClassExpression> translateToClassExpressionSet(IRI mainNode) {
            return this.classExpressionListTranslator.translateToSet(mainNode);
        }

        private OWLClassExpression translateClassExpressionInternal(IRI mainNode) {
            Mode mode = this.consumer.getConfiguration().isStrict() ? Mode.STRICT : Mode.LAX;
            for (ClassExpressionTranslator translator : this.classExpressionTranslators) {
                if (!translator.matches(mainNode, mode)) continue;
                return translator.translate(mainNode);
            }
            if (!this.consumer.isAnonymousNode(mainNode)) {
                return this.consumer.getDataFactory().getOWLClass(mainNode);
            }
            return this.consumer.generateAndLogParseError(EntityType.CLASS, mainNode);
        }

        public void consumeSWRLRules(Set<IRI> swrlRules) {
            SWRLRuleTranslator translator = new SWRLRuleTranslator(this.consumer, this);
            swrlRules.forEach(translator::translateRule);
        }

        @Nullable
        public OWLClassExpression getClassExpressionIfTranslated(IRI mainNode) {
            return this.translatedClassExpression.get(mainNode);
        }

        public void cleanup() {
            this.translatedClassExpression.clear();
        }

        protected List<OWLObjectPropertyExpression> translateToObjectPropertyList(IRI mainNode) {
            return this.objectPropertyListTranslator.translateList(mainNode);
        }

        protected List<OWLDataPropertyExpression> translateToDataPropertyList(IRI mainNode) {
            return this.dataPropertyListTranslator.translateList(mainNode);
        }

        protected Set<OWLLiteral> translateToConstantSet(IRI mainNode) {
            return this.constantListTranslator.translateToSet(mainNode);
        }

        protected Set<OWLIndividual> translateToIndividualSet(IRI mainNode) {
            return this.individualListTranslator.translateToSet(mainNode);
        }

        protected Set<OWLDataRange> translateToDataRangeSet(IRI mainNode) {
            return this.dataRangeListTranslator.translateToSet(mainNode);
        }

        protected Set<OWLFacetRestriction> translateToFacetRestrictionSet(IRI mainNode) {
            return this.faceRestrictionListTranslator.translateToSet(mainNode);
        }

        protected OWLClassExpression translateClassExpression(IRI mainNode) {
            OWLClassExpression ce = this.translatedClassExpression.get(mainNode);
            if (ce == null) {
                ce = this.translateClassExpressionInternal(mainNode);
                this.translatedClassExpression.put(mainNode, ce);
            }
            return ce;
        }
    }
}

