/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.krss2.renderer;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.krss2.renderer.KRSS2Vocabulary;
import org.semanticweb.owlapi.krss2.renderer.KRSSVocabulary;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.search.EntitySearcher;
import org.semanticweb.owlapi.search.Filters;
import org.semanticweb.owlapi.search.Searcher;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;

public class KRSSObjectRenderer
implements OWLObjectVisitor {
    protected static final String OPEN_BRACKET = "(";
    protected static final String CLOSE_BRACKET = ")";
    protected static final String NEWLINE = "\n";
    protected final OWLOntology ont;
    protected final PrintWriter writer;
    private int pos = 0;
    private int lastNewLinePos = 0;

    public KRSSObjectRenderer(OWLOntology ontology, Writer writer) {
        this.ont = OWLAPIPreconditions.checkNotNull(ontology);
        this.writer = new PrintWriter(writer);
    }

    protected void writeOpenBracket() {
        this.write(OPEN_BRACKET);
    }

    protected void writeCloseBracket() {
        this.write(CLOSE_BRACKET);
    }

    protected void write(int i) {
        this.write(" " + i);
    }

    protected void write(IRI iri) {
        this.write(iri.toString());
    }

    protected void write(KRSSVocabulary v) {
        this.write(v.toString());
    }

    protected void write(KRSS2Vocabulary v) {
        this.write(v.toString());
    }

    protected void writeSpace() {
        this.write(" ");
    }

    protected void write(String s) {
        int newLineIndex = s.indexOf(10);
        if (newLineIndex != -1) {
            this.lastNewLinePos = this.pos + newLineIndex;
        }
        this.pos += s.length();
        this.writer.write(s);
    }

    protected int getIndent() {
        return this.pos - this.lastNewLinePos - 1;
    }

    protected void writeIndent(int indent) {
        for (int i = 0; i < indent; ++i) {
            this.writeSpace();
        }
    }

    protected void writeln() {
        this.write(NEWLINE);
    }

    protected void write(OWLClassExpression obj) {
        this.writeSpace();
        obj.accept(this);
    }

    protected void write(OWLIndividual ind) {
        this.writeSpace();
        ind.accept(this);
    }

    protected void write(OWLPropertyExpression obj) {
        this.writeSpace();
        obj.accept(this);
    }

    protected void write(OWLDataRange obj) {
        this.writeSpace();
        obj.accept(this);
    }

    protected void flattenProperties(List<OWLObjectPropertyExpression> props, @Nullable KRSSVocabulary junctor) {
        int size = props.size();
        if (size == 0) {
            return;
        }
        if (size == 1) {
            this.write(props.iterator().next());
            return;
        }
        if (junctor != null) {
            this.writeOpenBracket();
            this.write(junctor);
        }
        this.write(props.get(0));
        int indent = this.getIndent();
        for (int i = 1; i < size; ++i) {
            this.writeln();
            this.writeIndent(indent);
            this.write(props.get(i));
        }
        if (junctor != null) {
            this.writeCloseBracket();
        }
    }

    protected void flatten(List<OWLClassExpression> descs) {
        int size = descs.size();
        if (size == 0) {
            return;
        }
        this.write(descs.get(0));
        if (size == 1) {
            return;
        }
        this.writeOpenBracket();
        this.write(KRSSVocabulary.AND);
        int indent = this.getIndent();
        for (int i = 1; i < size; ++i) {
            this.writeln();
            this.writeIndent(indent);
            this.write(descs.get(i));
        }
        this.writeCloseBracket();
    }

    @Override
    public void visit(OWLOntology ontology) {
        List<OWLClass> classes = OWLAPIStreamUtils.asList(ontology.classesInSignature());
        classes.remove(ontology.getOWLOntologyManager().getOWLDataFactory().getOWLThing());
        classes.remove(ontology.getOWLOntologyManager().getOWLDataFactory().getOWLNothing());
        CollectionFactory.sortOptionally(classes);
        for (OWLClass eachClass : classes) {
            boolean primitive;
            boolean bl = primitive = !EntitySearcher.isDefined(eachClass, ontology);
            if (primitive) {
                this.writeOpenBracket();
                this.write(KRSSVocabulary.DEFINE_PRIMITIVE_CONCEPT);
                this.write(eachClass);
                this.writeSpace();
                this.flatten(OWLAPIStreamUtils.asList(Searcher.sup(ontology.subClassAxiomsForSubClass(eachClass), OWLClassExpression.class)));
                this.writeCloseBracket();
                this.writeln();
                continue;
            }
            this.writeOpenBracket();
            this.write(KRSSVocabulary.DEFINE_CONCEPT);
            this.write(eachClass);
            this.flatten(OWLAPIStreamUtils.asList(Searcher.equivalent(ontology.equivalentClassesAxioms(eachClass))));
            this.writeCloseBracket();
            this.writeln();
        }
        for (OWLObjectProperty property : CollectionFactory.sortOptionally(ontology.objectPropertiesInSignature())) {
            boolean isDefined;
            this.writeOpenBracket();
            Stream pStream = Searcher.equivalent(ontology.equivalentObjectPropertiesAxioms(property));
            List properties = OWLAPIStreamUtils.asList(pStream);
            boolean bl = isDefined = !properties.isEmpty();
            if (isDefined) {
                this.write(KRSSVocabulary.DEFINE_ROLE);
                this.write(property);
                properties.remove(property);
                if (!properties.isEmpty()) {
                    this.write((OWLPropertyExpression)properties.iterator().next());
                }
            } else {
                this.write(KRSSVocabulary.DEFINE_PRIMITIVE_ROLE);
                this.write(property);
                this.writeSpace();
                Iterator i = Searcher.sup(ontology.axioms(Filters.subObjectPropertyWithSub, (Object)property, Imports.INCLUDED), OWLObjectPropertyExpression.class).iterator();
                if (i.hasNext()) {
                    this.write((OWLPropertyExpression)i.next());
                }
            }
            this.writeCloseBracket();
            this.writeln();
        }
        ontology.axioms().forEach(a -> a.accept(this));
        this.writer.flush();
    }

    @Override
    public void visit(OWLDisjointClassesAxiom axiom) {
        OWLAPIStreamUtils.pairs(axiom.classExpressions()).forEach(v -> {
            this.writeOpenBracket();
            this.write(KRSSVocabulary.DISJOINT);
            this.write((OWLClassExpression)v.i);
            this.write((OWLClassExpression)v.j);
            this.writeCloseBracket();
            this.writeln();
        });
    }

    @Override
    public void visit(OWLObjectPropertyDomainAxiom axiom) {
        this.writeOpenBracket();
        this.write(KRSSVocabulary.DOMAIN);
        this.write((OWLPropertyExpression)axiom.getProperty());
        this.write((OWLClassExpression)axiom.getDomain());
        this.writeCloseBracket();
        this.writeln();
    }

    @Override
    public void visit(OWLDifferentIndividualsAxiom axiom) {
        OWLAPIStreamUtils.pairs(axiom.individuals()).forEach(v -> {
            this.writeOpenBracket();
            this.write(KRSSVocabulary.DISTINCT);
            this.write((OWLIndividual)v.i);
            this.write((OWLIndividual)v.j);
            this.writeCloseBracket();
            this.writeln();
        });
    }

    @Override
    public void visit(OWLObjectPropertyRangeAxiom axiom) {
        this.writeOpenBracket();
        this.write(KRSSVocabulary.RANGE);
        this.write((OWLPropertyExpression)axiom.getProperty());
        this.write((OWLClassExpression)axiom.getRange());
        this.writeCloseBracket();
        this.writeln();
    }

    @Override
    public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        this.writeOpenBracket();
        this.write(KRSSVocabulary.RELATED);
        this.write(axiom.getSubject());
        this.write((OWLPropertyExpression)axiom.getProperty());
        this.write((OWLIndividual)axiom.getObject());
        this.writeCloseBracket();
        this.writeln();
    }

    @Override
    public void visit(OWLClassAssertionAxiom axiom) {
        this.writeOpenBracket();
        this.write(KRSSVocabulary.INSTANCE);
        this.write(axiom.getIndividual());
        this.write(axiom.getClassExpression());
        this.writeCloseBracket();
        this.writeln();
    }

    @Override
    public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
        this.writeOpenBracket();
        this.write(KRSSVocabulary.TRANSITIVE);
        this.write((OWLPropertyExpression)axiom.getProperty());
        this.writeCloseBracket();
        this.writeln();
    }

    @Override
    public void visit(OWLSameIndividualAxiom axiom) {
        OWLAPIStreamUtils.pairs(axiom.individuals()).forEach(v -> {
            this.writeOpenBracket();
            this.write(KRSSVocabulary.EQUAL);
            this.write((OWLIndividual)v.i);
            this.write((OWLIndividual)v.j);
            this.writeCloseBracket();
            this.writeln();
        });
    }

    @Override
    public void visit(OWLClass ce) {
        this.write(ce.getIRI());
    }

    @Override
    public void visit(OWLObjectIntersectionOf ce) {
        this.writeOpenBracket();
        this.write(KRSSVocabulary.AND);
        List<OWLClassExpression> operands = OWLAPIStreamUtils.asList(ce.operands());
        int size = operands.size();
        if (size > 0) {
            int indent = this.getIndent();
            this.write(operands.get(0));
            for (int i = 1; i < size; ++i) {
                this.writeln();
                this.writeIndent(indent);
                this.write(operands.get(i));
            }
        }
        this.writeCloseBracket();
    }

    @Override
    public void visit(OWLObjectUnionOf ce) {
        this.writeOpenBracket();
        this.write(KRSSVocabulary.OR);
        List<OWLClassExpression> operands = OWLAPIStreamUtils.asList(ce.operands());
        int size = operands.size();
        if (size > 0) {
            int indent = this.getIndent();
            this.write(operands.get(0));
            for (int i = 1; i < size; ++i) {
                this.writeln();
                this.writeIndent(indent);
                this.write(operands.get(i));
            }
        }
        this.writeCloseBracket();
    }

    @Override
    public void visit(OWLObjectComplementOf ce) {
        this.writeOpenBracket();
        this.write(KRSSVocabulary.NOT);
        this.write(ce.getOperand());
        this.writeCloseBracket();
    }

    @Override
    public void visit(OWLObjectSomeValuesFrom ce) {
        this.writeOpenBracket();
        this.write(KRSSVocabulary.SOME);
        this.write(ce.getProperty());
        this.write((OWLClassExpression)ce.getFiller());
        this.writeCloseBracket();
    }

    @Override
    public void visit(OWLObjectAllValuesFrom ce) {
        this.writeOpenBracket();
        this.write(KRSSVocabulary.ALL);
        this.write(ce.getProperty());
        this.write((OWLClassExpression)ce.getFiller());
        this.writeCloseBracket();
    }

    @Override
    public void visit(OWLObjectMinCardinality ce) {
        this.writeOpenBracket();
        this.write(KRSSVocabulary.AT_LEAST);
        this.write(ce.getCardinality());
        this.write(ce.getProperty());
        if (ce.isQualified()) {
            this.write((OWLClassExpression)ce.getFiller());
        }
        this.writeCloseBracket();
    }

    @Override
    public void visit(OWLObjectExactCardinality ce) {
        this.writeOpenBracket();
        this.write(KRSSVocabulary.EXACTLY);
        this.write(ce.getCardinality());
        this.write(ce.getProperty());
        if (ce.isQualified()) {
            this.write((OWLClassExpression)ce.getFiller());
        }
        this.writeCloseBracket();
    }

    @Override
    public void visit(OWLObjectMaxCardinality ce) {
        this.writeOpenBracket();
        this.write(KRSSVocabulary.AT_MOST);
        this.write(ce.getCardinality());
        this.write(ce.getProperty());
        if (ce.isQualified()) {
            this.write((OWLClassExpression)ce.getFiller());
        }
        this.writeCloseBracket();
    }

    @Override
    public void visit(OWLDataSomeValuesFrom ce) {
        this.writeOpenBracket();
        this.write(KRSSVocabulary.SOME);
        this.write(ce.getProperty());
        this.write((OWLDataRange)ce.getFiller());
        this.writeCloseBracket();
    }

    @Override
    public void visit(OWLDataAllValuesFrom ce) {
        this.writeOpenBracket();
        this.write(KRSSVocabulary.ALL);
        this.write(ce.getProperty());
        this.write((OWLDataRange)ce.getFiller());
        this.writeCloseBracket();
    }

    @Override
    public void visit(OWLDataMinCardinality ce) {
        this.writeOpenBracket();
        this.write(KRSSVocabulary.AT_LEAST);
        this.write(ce.getCardinality());
        this.write(ce.getProperty());
        if (ce.isQualified()) {
            this.write((OWLDataRange)ce.getFiller());
        }
        this.writeCloseBracket();
    }

    @Override
    public void visit(OWLDataExactCardinality ce) {
        this.writeOpenBracket();
        this.write(KRSSVocabulary.EXACTLY);
        this.write(ce.getCardinality());
        this.write(ce.getProperty());
        if (ce.isQualified()) {
            this.write((OWLDataRange)ce.getFiller());
        }
        this.writeCloseBracket();
    }

    @Override
    public void visit(OWLDataMaxCardinality ce) {
        this.writeOpenBracket();
        this.write(KRSSVocabulary.AT_MOST);
        this.write(ce.getCardinality());
        this.write(ce.getProperty());
        if (ce.isQualified()) {
            this.write((OWLDataRange)ce.getFiller());
        }
        this.writeCloseBracket();
    }

    @Override
    public void visit(OWLLiteral node) {
        this.write(node.getLiteral());
    }

    @Override
    public void visit(OWLObjectProperty property) {
        this.write(property.getIRI());
    }

    @Override
    public void visit(OWLObjectInverseOf property) {
        this.writeOpenBracket();
        this.write(KRSSVocabulary.INVERSE);
        this.writeSpace();
        property.getInverse().accept(this);
        this.writeCloseBracket();
    }

    @Override
    public void visit(OWLDataProperty property) {
        this.write(property.getIRI());
    }

    @Override
    public void visit(OWLNamedIndividual individual) {
        this.write(individual.getIRI());
    }
}

