/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import com.google.inject.multibindings.Multibinder;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.semanticweb.owlapi.annotations.OwlapiModule;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyBuilder;
import org.semanticweb.owlapi.model.OWLOntologyFactory;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import uk.ac.manchester.cs.owl.owlapi.CompressionEnabled;
import uk.ac.manchester.cs.owl.owlapi.OWLDataFactoryImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataFactoryInternals;
import uk.ac.manchester.cs.owl.owlapi.OWLDataFactoryInternalsImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLOntologyFactoryImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLOntologyImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLOntologyImplementationFactory;
import uk.ac.manchester.cs.owl.owlapi.OWLOntologyManagerImpl;
import uk.ac.manchester.cs.owl.owlapi.concurrent.Concurrency;
import uk.ac.manchester.cs.owl.owlapi.concurrent.ConcurrentOWLOntologyBuilder;
import uk.ac.manchester.cs.owl.owlapi.concurrent.NoOpReadWriteLock;
import uk.ac.manchester.cs.owl.owlapi.concurrent.NonConcurrentDelegate;
import uk.ac.manchester.cs.owl.owlapi.concurrent.NonConcurrentOWLOntologyBuilder;

@OwlapiModule
public class OWLAPIImplModule
extends AbstractModule {
    private final Concurrency concurrency;

    public OWLAPIImplModule(Concurrency concurrency) {
        this.concurrency = concurrency;
    }

    protected void configure() {
        if (this.concurrency == Concurrency.CONCURRENT) {
            this.bind(ReadWriteLock.class).to(ReentrantReadWriteLock.class).asEagerSingleton();
        } else {
            this.bind(ReadWriteLock.class).to(NoOpReadWriteLock.class).asEagerSingleton();
        }
        this.bind(Boolean.TYPE).annotatedWith(CompressionEnabled.class).toInstance((Object)Boolean.FALSE);
        this.bind(OWLDataFactory.class).to(OWLDataFactoryImpl.class).asEagerSingleton();
        this.bind(OWLDataFactoryInternals.class).to(OWLDataFactoryInternalsImpl.class);
        this.bind(OWLOntologyManager.class).to(OWLOntologyManagerImpl.class);
        this.bind(OWLOntologyManager.class).annotatedWith(NonConcurrentDelegate.class).to(OWLOntologyManagerImpl.class);
        this.bind(OWLOntologyBuilder.class).to(ConcurrentOWLOntologyBuilder.class);
        this.bind(OWLOntologyBuilder.class).annotatedWith(NonConcurrentDelegate.class).to(NonConcurrentOWLOntologyBuilder.class);
        this.install(new FactoryModuleBuilder().implement(OWLOntology.class, OWLOntologyImpl.class).build(OWLOntologyImplementationFactory.class));
        this.multibind(OWLOntologyFactory.class, OWLOntologyFactoryImpl.class);
    }

    @SafeVarargs
    private final <T> Multibinder<T> multibind(Class<T> type, Class<? extends T> ... implementations) {
        Multibinder binder = Multibinder.newSetBinder((Binder)this.binder(), type);
        for (Class<? extends T> i : implementations) {
            binder.addBinding().to(i);
        }
        return binder;
    }
}

