/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.search;

import java.util.stream.Stream;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;

class EquivalentVisitor<C extends OWLObject>
implements OWLAxiomVisitorEx<Stream<C>> {
    private final boolean equiv;

    EquivalentVisitor(boolean equiv) {
        this.equiv = equiv;
    }

    @Override
    public Stream<C> doDefault(Object o) {
        return OWLAPIStreamUtils.empty();
    }

    @Override
    public Stream<C> visit(OWLEquivalentClassesAxiom axiom) {
        if (this.equiv) {
            return axiom.classExpressions();
        }
        return this.doDefault(axiom);
    }

    @Override
    public Stream<C> visit(OWLEquivalentDataPropertiesAxiom axiom) {
        if (this.equiv) {
            return axiom.properties();
        }
        return this.doDefault(axiom);
    }

    @Override
    public Stream<C> visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        if (this.equiv) {
            return axiom.properties();
        }
        return this.doDefault(axiom);
    }

    @Override
    public Stream<C> visit(OWLDifferentIndividualsAxiom axiom) {
        if (!this.equiv) {
            return axiom.individuals();
        }
        return this.doDefault(axiom);
    }

    @Override
    public Stream<C> visit(OWLSameIndividualAxiom axiom) {
        if (this.equiv) {
            return axiom.individuals();
        }
        return this.doDefault(axiom);
    }

    @Override
    public Stream<C> visit(OWLDisjointClassesAxiom axiom) {
        if (!this.equiv) {
            return axiom.classExpressions();
        }
        return this.doDefault(axiom);
    }

    @Override
    public Stream<C> visit(OWLDisjointDataPropertiesAxiom axiom) {
        if (!this.equiv) {
            return axiom.properties();
        }
        return this.doDefault(axiom);
    }

    @Override
    public Stream<C> visit(OWLDisjointObjectPropertiesAxiom axiom) {
        if (!this.equiv) {
            return axiom.properties();
        }
        return this.doDefault(axiom);
    }
}

