/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Optional;
import java.util.zip.GZIPOutputStream;
import org.semanticweb.owlapi.io.GZipFileDocumentTarget;
import org.semanticweb.owlapi.io.OWLOntologyDocumentTarget;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GZipStreamDocumentTarget
implements OWLOntologyDocumentTarget {
    private static final Logger LOGGER = LoggerFactory.getLogger(GZipFileDocumentTarget.class);
    private final OutputStream outputStream;

    public GZipStreamDocumentTarget(OutputStream os) {
        this.outputStream = os;
    }

    @Override
    public Optional<OutputStream> getOutputStream() {
        try {
            return OWLAPIPreconditions.optional(new GZIPOutputStream(this.outputStream));
        }
        catch (IOException e) {
            LOGGER.error("Fille cannot be found or opened", (Throwable)e);
            return OWLAPIPreconditions.emptyOptional();
        }
    }
}

