/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLObjectDuplicator;

public class OWLEntityRenamer {
    private final OWLOntologyManager m;
    private final Collection<OWLOntology> ontologies;

    public OWLEntityRenamer(OWLOntologyManager owlOntologyManager, Collection<OWLOntology> ontologies) {
        this.m = owlOntologyManager;
        this.ontologies = OWLAPIPreconditions.checkNotNull(ontologies, "ontologies cannot be null");
    }

    public List<OWLOntologyChange> changeIRI(IRI iri, IRI newIRI) {
        OWLAPIPreconditions.checkNotNull(iri, "iri cannot be null");
        OWLAPIPreconditions.checkNotNull(newIRI, "newIRI cannot be null");
        HashMap<IRI, IRI> uriMap = new HashMap<IRI, IRI>();
        uriMap.put(iri, newIRI);
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
        OWLObjectDuplicator dup = new OWLObjectDuplicator(this.m, uriMap);
        this.ontologies.forEach(o -> OWLEntityRenamer.fillListWithTransformChanges(changes, o.referencingAxioms(iri), o, dup));
        return changes;
    }

    public List<OWLOntologyChange> changeIRI(OWLEntity entity, IRI newIRI) {
        HashMap<OWLEntity, IRI> iriMap = new HashMap<OWLEntity, IRI>();
        iriMap.put(entity, newIRI);
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
        OWLObjectDuplicator duplicator = new OWLObjectDuplicator(iriMap, this.m);
        this.ontologies.forEach(o -> OWLEntityRenamer.fillListWithTransformChanges(changes, OWLEntityRenamer.getAxioms(o, entity), o, duplicator));
        return changes;
    }

    public List<OWLOntologyChange> changeIRI(Map<OWLEntity, IRI> entity2IRIMap) {
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
        OWLObjectDuplicator duplicator = new OWLObjectDuplicator(entity2IRIMap, this.m);
        for (OWLOntology ont : this.ontologies) {
            entity2IRIMap.keySet().forEach(e -> OWLEntityRenamer.fillListWithTransformChanges(changes, OWLEntityRenamer.getAxioms(ont, e), ont, duplicator));
        }
        return changes;
    }

    private static Stream<OWLAxiom> getAxioms(OWLOntology ont, OWLEntity entity) {
        return Stream.of(ont.referencingAxioms(entity), ont.declarationAxioms(entity), ont.annotationAssertionAxioms(entity.getIRI())).flatMap(x -> x);
    }

    private static void fillListWithTransformChanges(List<OWLOntologyChange> changes, Stream<OWLAxiom> axioms, OWLOntology ont, OWLObjectDuplicator duplicator) {
        axioms.forEach(ax -> {
            changes.add(new RemoveAxiom(ont, (OWLAxiom)ax));
            OWLAxiom dupAx = duplicator.duplicateObject(ax);
            changes.add(new AddAxiom(ont, dupAx));
        });
    }
}

