/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.reasoner;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.reasoner.BufferingMode;
import org.semanticweb.owlapi.reasoner.FreshEntityPolicy;
import org.semanticweb.owlapi.reasoner.IndividualNodeSetPolicy;
import org.semanticweb.owlapi.reasoner.InferenceDepth;
import org.semanticweb.owlapi.reasoner.InferenceType;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.NodeSet;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.semanticweb.owlapi.util.Version;

public interface OWLReasoner {
    public String getReasonerName();

    public Version getReasonerVersion();

    public BufferingMode getBufferingMode();

    public void flush();

    public List<OWLOntologyChange> getPendingChanges();

    public Set<OWLAxiom> getPendingAxiomAdditions();

    public Set<OWLAxiom> getPendingAxiomRemovals();

    public OWLOntology getRootOntology();

    public void interrupt();

    public void precomputeInferences(InferenceType ... var1);

    public boolean isPrecomputed(InferenceType var1);

    public Set<InferenceType> getPrecomputableInferenceTypes();

    public boolean isConsistent();

    public boolean isSatisfiable(OWLClassExpression var1);

    public Node<OWLClass> getUnsatisfiableClasses();

    public boolean isEntailed(OWLAxiom var1);

    public boolean isEntailed(Set<? extends OWLAxiom> var1);

    default public boolean isEntailed(Stream<? extends OWLAxiom> axioms) {
        return this.isEntailed(OWLAPIStreamUtils.asUnorderedSet(axioms));
    }

    default public boolean isEntailed(OWLAxiom ... axioms) {
        return this.isEntailed(Sets.newHashSet((Object[])axioms));
    }

    public boolean isEntailmentCheckingSupported(AxiomType<?> var1);

    public Node<OWLClass> getTopClassNode();

    public Node<OWLClass> getBottomClassNode();

    public NodeSet<OWLClass> getSubClasses(OWLClassExpression var1, boolean var2);

    default public NodeSet<OWLClass> getSubClasses(OWLClassExpression ce, InferenceDepth depth) {
        return this.getSubClasses(ce, depth.isDirectOnly());
    }

    default public NodeSet<OWLClass> getSubClasses(OWLClassExpression ce) {
        return this.getSubClasses(ce, false);
    }

    public NodeSet<OWLClass> getSuperClasses(OWLClassExpression var1, boolean var2);

    default public NodeSet<OWLClass> getSuperClasses(OWLClassExpression ce, InferenceDepth depth) {
        return this.getSuperClasses(ce, depth.isDirectOnly());
    }

    default public NodeSet<OWLClass> getSuperClasses(OWLClassExpression ce) {
        return this.getSuperClasses(ce, false);
    }

    public Node<OWLClass> getEquivalentClasses(OWLClassExpression var1);

    public NodeSet<OWLClass> getDisjointClasses(OWLClassExpression var1);

    public Node<OWLObjectPropertyExpression> getTopObjectPropertyNode();

    public Node<OWLObjectPropertyExpression> getBottomObjectPropertyNode();

    public NodeSet<OWLObjectPropertyExpression> getSubObjectProperties(OWLObjectPropertyExpression var1, boolean var2);

    default public NodeSet<OWLObjectPropertyExpression> getSubObjectProperties(OWLObjectPropertyExpression pe, InferenceDepth depth) {
        return this.getSubObjectProperties(pe, depth.isDirectOnly());
    }

    default public NodeSet<OWLObjectPropertyExpression> getSubObjectProperties(OWLObjectPropertyExpression pe) {
        return this.getSubObjectProperties(pe, false);
    }

    public NodeSet<OWLObjectPropertyExpression> getSuperObjectProperties(OWLObjectPropertyExpression var1, boolean var2);

    default public NodeSet<OWLObjectPropertyExpression> getSuperObjectProperties(OWLObjectPropertyExpression pe, InferenceDepth depth) {
        return this.getSuperObjectProperties(pe, depth.isDirectOnly());
    }

    default public NodeSet<OWLObjectPropertyExpression> getSuperObjectProperties(OWLObjectPropertyExpression pe) {
        return this.getSuperObjectProperties(pe, false);
    }

    public Node<OWLObjectPropertyExpression> getEquivalentObjectProperties(OWLObjectPropertyExpression var1);

    public NodeSet<OWLObjectPropertyExpression> getDisjointObjectProperties(OWLObjectPropertyExpression var1);

    public Node<OWLObjectPropertyExpression> getInverseObjectProperties(OWLObjectPropertyExpression var1);

    public NodeSet<OWLClass> getObjectPropertyDomains(OWLObjectPropertyExpression var1, boolean var2);

    default public NodeSet<OWLClass> getObjectPropertyDomains(OWLObjectPropertyExpression pe, InferenceDepth depth) {
        return this.getObjectPropertyDomains(pe, depth.isDirectOnly());
    }

    default public NodeSet<OWLClass> getObjectPropertyDomains(OWLObjectPropertyExpression pe) {
        return this.getObjectPropertyDomains(pe, false);
    }

    public NodeSet<OWLClass> getObjectPropertyRanges(OWLObjectPropertyExpression var1, boolean var2);

    default public NodeSet<OWLClass> getObjectPropertyRanges(OWLObjectPropertyExpression pe, InferenceDepth depth) {
        return this.getObjectPropertyRanges(pe, depth.isDirectOnly());
    }

    default public NodeSet<OWLClass> getObjectPropertyRanges(OWLObjectPropertyExpression pe) {
        return this.getObjectPropertyRanges(pe, false);
    }

    public Node<OWLDataProperty> getTopDataPropertyNode();

    public Node<OWLDataProperty> getBottomDataPropertyNode();

    public NodeSet<OWLDataProperty> getSubDataProperties(OWLDataProperty var1, boolean var2);

    default public NodeSet<OWLDataProperty> getSubDataProperties(OWLDataProperty pe, InferenceDepth depth) {
        return this.getSubDataProperties(pe, depth.isDirectOnly());
    }

    default public NodeSet<OWLDataProperty> getSubDataProperties(OWLDataProperty pe) {
        return this.getSubDataProperties(pe, false);
    }

    public NodeSet<OWLDataProperty> getSuperDataProperties(OWLDataProperty var1, boolean var2);

    default public NodeSet<OWLDataProperty> getSuperDataProperties(OWLDataProperty pe, InferenceDepth depth) {
        return this.getSuperDataProperties(pe, depth.isDirectOnly());
    }

    default public NodeSet<OWLDataProperty> getSuperDataProperties(OWLDataProperty pe) {
        return this.getSuperDataProperties(pe, false);
    }

    public Node<OWLDataProperty> getEquivalentDataProperties(OWLDataProperty var1);

    public NodeSet<OWLDataProperty> getDisjointDataProperties(OWLDataPropertyExpression var1);

    public NodeSet<OWLClass> getDataPropertyDomains(OWLDataProperty var1, boolean var2);

    default public NodeSet<OWLClass> getDataPropertyDomains(OWLDataProperty pe, InferenceDepth depth) {
        return this.getDataPropertyDomains(pe, depth.isDirectOnly());
    }

    default public NodeSet<OWLClass> getDataPropertyDomains(OWLDataProperty pe) {
        return this.getDataPropertyDomains(pe, false);
    }

    public NodeSet<OWLClass> getTypes(OWLNamedIndividual var1, boolean var2);

    default public NodeSet<OWLClass> getTypes(OWLNamedIndividual ind, InferenceDepth depth) {
        return this.getTypes(ind, depth.isDirectOnly());
    }

    default public NodeSet<OWLClass> getTypes(OWLNamedIndividual ind) {
        return this.getTypes(ind, false);
    }

    public NodeSet<OWLNamedIndividual> getInstances(OWLClassExpression var1, boolean var2);

    default public NodeSet<OWLNamedIndividual> getInstances(OWLClassExpression ce, InferenceDepth depth) {
        return this.getInstances(ce, depth.isDirectOnly());
    }

    default public NodeSet<OWLNamedIndividual> getInstances(OWLClassExpression ce) {
        return this.getInstances(ce, false);
    }

    public NodeSet<OWLNamedIndividual> getObjectPropertyValues(OWLNamedIndividual var1, OWLObjectPropertyExpression var2);

    public Set<OWLLiteral> getDataPropertyValues(OWLNamedIndividual var1, OWLDataProperty var2);

    public Node<OWLNamedIndividual> getSameIndividuals(OWLNamedIndividual var1);

    public NodeSet<OWLNamedIndividual> getDifferentIndividuals(OWLNamedIndividual var1);

    public long getTimeOut();

    public FreshEntityPolicy getFreshEntityPolicy();

    public IndividualNodeSetPolicy getIndividualNodeSetPolicy();

    public void dispose();
}

