/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import com.google.common.base.Charsets;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.Nullable;
import org.apache.commons.io.ByteOrderMark;
import org.apache.commons.io.input.BOMInputStream;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.OWLOntologyInputSourceException;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tukaani.xz.XZInputStream;

public class DocumentSources {
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentSources.class);
    private static final String ZIP_FILE_EXTENSION = ".zip";
    private static final String CONTENT_DISPOSITION_HEADER = "Content-Disposition";
    private static final Pattern CONTENT_DISPOSITION_FILE_NAME_PATTERN = Pattern.compile(".*filename=\"([^\\s;]*)\".*");
    private static final int CONTENT_DISPOSITION_FILE_NAME_PATTERN_GROUP = 1;
    private static final Pattern ZIP_ENTRY_ONTOLOGY_NAME_PATTERN = Pattern.compile(".*owl|rdf|xml|mos");
    private static final String ACCEPTABLE_CONTENT_ENCODING = "xz,gzip,deflate";
    private static final String REQUESTTYPES = "application/rdf+xml, application/xml; q=0.5, text/xml; q=0.3, */*; q=0.2";

    private DocumentSources() {
    }

    public static Reader wrapInputAsReader(OWLOntologyDocumentSource source, OWLOntologyLoaderConfiguration configuration, Charset encoding) throws OWLOntologyInputSourceException {
        Optional<Reader> reader = source.getReader();
        if (reader.isPresent()) {
            return new BufferedReader(reader.get());
        }
        return new BufferedReader(new InputStreamReader(DocumentSources.wrap(DocumentSources.wrapInput(source, configuration)), encoding));
    }

    public static Reader wrapInputAsReader(OWLOntologyDocumentSource source, OWLOntologyLoaderConfiguration configuration) throws OWLOntologyInputSourceException {
        return DocumentSources.wrapInputAsReader(source, configuration, Charsets.UTF_8);
    }

    public static InputStream wrapInput(OWLOntologyDocumentSource source, OWLOntologyLoaderConfiguration configuration) throws OWLOntologyInputSourceException {
        Optional<InputStream> input = source.getInputStream();
        if (!input.isPresent() && !source.hasAlredyFailedOnIRIResolution()) {
            input = DocumentSources.getInputStream(source.getDocumentIRI(), configuration);
        }
        if (input.isPresent()) {
            return new BufferedInputStream(input.get());
        }
        throw new OWLOntologyInputSourceException("No input reader can be found");
    }

    public static Optional<InputStream> getInputStream(IRI documentIRI, OWLOntologyLoaderConfiguration config) throws OWLOntologyInputSourceException {
        try {
            URL originalURL = documentIRI.toURI().toURL();
            String originalProtocol = originalURL.getProtocol();
            URLConnection conn = originalURL.openConnection();
            conn.addRequestProperty("Accept", REQUESTTYPES);
            if (config.isAcceptingHTTPCompression()) {
                conn.setRequestProperty("Accept-Encoding", ACCEPTABLE_CONTENT_ENCODING);
            }
            int connectionTimeout = config.getConnectionTimeout();
            conn.setConnectTimeout(connectionTimeout);
            conn = DocumentSources.connect(config, originalProtocol, conn, connectionTimeout);
            String contentEncoding = conn.getContentEncoding();
            InputStream is = DocumentSources.connectWithFiveRetries(documentIRI, config, conn, connectionTimeout, contentEncoding);
            if (is == null) {
                return OWLAPIPreconditions.emptyOptional();
            }
            is = DocumentSources.handleZips(documentIRI, conn, is);
            return OWLAPIPreconditions.optional(is);
        }
        catch (IOException e) {
            throw new OWLOntologyInputSourceException(e);
        }
    }

    protected static URLConnection connect(OWLOntologyLoaderConfiguration config, String originalProtocol, URLConnection conn, int connectionTimeout) throws IOException {
        if (conn instanceof HttpURLConnection && config.isFollowRedirects()) {
            String location;
            URL newURL;
            String newProtocol;
            HttpURLConnection con = (HttpURLConnection)conn;
            con.connect();
            int responseCode = con.getResponseCode();
            if (!(responseCode != 302 && responseCode != 301 && responseCode != 303 || originalProtocol.equals(newProtocol = (newURL = new URL(location = con.getHeaderField("Location"))).getProtocol()))) {
                return DocumentSources.rebuildConnection(config, connectionTimeout, newURL);
            }
        }
        return conn;
    }

    protected static URLConnection rebuildConnection(OWLOntologyLoaderConfiguration config, int connectionTimeout, URL newURL) throws IOException {
        URLConnection conn = newURL.openConnection();
        conn.addRequestProperty("Accept", REQUESTTYPES);
        if (config.isAcceptingHTTPCompression()) {
            conn.setRequestProperty("Accept-Encoding", ACCEPTABLE_CONTENT_ENCODING);
        }
        conn.setConnectTimeout(connectionTimeout);
        return conn;
    }

    protected static InputStream handleZips(IRI documentIRI, URLConnection conn, InputStream is) throws IOException {
        if (!DocumentSources.isZipName(documentIRI, conn)) {
            return is;
        }
        ZipInputStream zis = new ZipInputStream(is);
        ZipEntry entry = null;
        ZipEntry nextEntry = zis.getNextEntry();
        while (entry != null && nextEntry != null) {
            if (DocumentSources.couldBeOntology(nextEntry)) {
                entry = nextEntry;
            }
            nextEntry = zis.getNextEntry();
        }
        return zis;
    }

    @Nullable
    protected static InputStream connectWithFiveRetries(IRI documentIRI, OWLOntologyLoaderConfiguration config, URLConnection conn, int connectionTimeout, String contentEncoding) throws IOException, OWLOntologyInputSourceException {
        InputStream is = null;
        int count = 0;
        while (count < config.getRetriesToAttempt() && is == null) {
            try {
                is = DocumentSources.getInputStreamFromContentEncoding(conn, contentEncoding);
            }
            catch (SocketTimeoutException e) {
                if (++count == 5) {
                    throw new OWLOntologyInputSourceException("cannot connect to " + documentIRI + "; retry limit exhausted", e);
                }
                conn.setConnectTimeout(connectionTimeout + connectionTimeout * count);
            }
        }
        return is;
    }

    public static InputStream wrap(InputStream delegate) {
        OWLAPIPreconditions.checkNotNull(delegate, "delegate cannot be null");
        return new BOMInputStream(delegate, new ByteOrderMark[]{ByteOrderMark.UTF_8, ByteOrderMark.UTF_16BE, ByteOrderMark.UTF_16LE, ByteOrderMark.UTF_32BE, ByteOrderMark.UTF_32LE});
    }

    private static boolean couldBeOntology(@Nullable ZipEntry zipEntry) {
        if (zipEntry == null) {
            return false;
        }
        return ZIP_ENTRY_ONTOLOGY_NAME_PATTERN.matcher(zipEntry.getName()).matches();
    }

    private static InputStream getInputStreamFromContentEncoding(URLConnection conn, @Nullable String contentEncoding) throws IOException {
        InputStream toReturn;
        InputStream in = conn.getInputStream();
        if (contentEncoding != null && (toReturn = DocumentSources.handleKnownContentEncodings(contentEncoding, in)) != null) {
            return toReturn;
        }
        String fileName = DocumentSources.getFileNameFromContentDisposition(conn);
        if (fileName == null && conn.getURL() != null) {
            fileName = conn.getURL().toString();
        }
        if (fileName != null) {
            if (fileName.endsWith(".gz")) {
                LOGGER.info("URL connection has no content encoding but name ends with .gz");
                return new BufferedInputStream(new GZIPInputStream(in));
            }
            if (fileName.endsWith(".xz")) {
                LOGGER.info("URL connection has no content encoding but name ends with .xz");
                return new BufferedInputStream((InputStream)new XZInputStream(in));
            }
        }
        return DocumentSources.wrap(in);
    }

    @Nullable
    protected static InputStream handleKnownContentEncodings(String contentEncoding, InputStream in) throws IOException {
        if ("xz".equals(contentEncoding)) {
            LOGGER.info("URL connection input stream is compressed using xz");
            return new BufferedInputStream((InputStream)new XZInputStream(in));
        }
        if ("gzip".equals(contentEncoding)) {
            LOGGER.info("URL connection input stream is compressed using gzip");
            return new BufferedInputStream(new GZIPInputStream(in));
        }
        if ("deflate".equals(contentEncoding)) {
            LOGGER.info("URL connection input stream is compressed using deflate");
            return new InflaterInputStream(in, new Inflater(true));
        }
        return null;
    }

    private static boolean isZipName(IRI documentIRI, URLConnection connection) {
        if (DocumentSources.isZipFileName(documentIRI.toString())) {
            return true;
        }
        String fileName = DocumentSources.getFileNameFromContentDisposition(connection);
        return fileName != null && DocumentSources.isZipFileName(fileName);
    }

    @Nullable
    private static String getFileNameFromContentDisposition(URLConnection connection) {
        Matcher matcher;
        String contentDispositionHeaderValue = connection.getHeaderField(CONTENT_DISPOSITION_HEADER);
        if (contentDispositionHeaderValue != null && (matcher = CONTENT_DISPOSITION_FILE_NAME_PATTERN.matcher(contentDispositionHeaderValue)).matches()) {
            return matcher.group(1);
        }
        return null;
    }

    private static boolean isZipFileName(String fileName) {
        return fileName.toLowerCase(Locale.getDefault()).endsWith(ZIP_FILE_EXTENSION);
    }
}

