/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.template.commons;

import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.coode.oppl.template.ReplacementStrategy;
import org.coode.oppl.utils.ArgCheck;

public final class KeyBasedReplacementStrategy
implements ReplacementStrategy<String, String> {
    private final Properties properties;

    public KeyBasedReplacementStrategy(Properties properties) {
        this.properties = (Properties)ArgCheck.checkNotNull((Object)properties, (String)"properties");
    }

    @Override
    public String replace(String templateString) {
        Pattern pattern = Pattern.compile("\\$\\{(.+?)\\}");
        String replacedString = templateString;
        Matcher matcher = pattern.matcher(replacedString);
        while (matcher.find()) {
            String placeholder = matcher.group();
            String key = matcher.group(1);
            replacedString = replacedString.replaceAll(KeyBasedReplacementStrategy.encode(placeholder), this.getReplacement(key));
            matcher = pattern.matcher(replacedString);
        }
        return replacedString;
    }

    private static String encode(String placeholder) {
        return placeholder.replaceAll("(\\$)", "\\\\$1").replaceAll("(\\{)", "\\\\$1").replaceAll("(\\})", "\\\\$1");
    }

    private String getReplacement(String placeholder) {
        String replacement = this.properties.getProperty(placeholder);
        if (replacement == null) {
            throw new NullPointerException("Missing value for place-holder " + placeholder);
        }
        return replacement;
    }
}

