/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.template.commons;

import org.coode.oppl.template.OPPLTemplate;
import org.coode.oppl.template.ParsingStrategy;
import org.coode.oppl.template.ReplacementStrategy;
import org.coode.oppl.utils.ArgCheck;

public class StringTemplate<O>
implements OPPLTemplate<O> {
    private final String templateString;
    private final ReplacementStrategy<String, String> replacementStrategy;
    private final ParsingStrategy<String, O> parserCreationStrategy;

    public StringTemplate(String templateString, ReplacementStrategy<String, String> replacementStrategy, ParsingStrategy<String, O> parserCreationStrategy) {
        this.templateString = (String)ArgCheck.checkNotNull((Object)templateString, (String)"templateString");
        this.replacementStrategy = (ReplacementStrategy)ArgCheck.checkNotNull(replacementStrategy, (String)"replacementStrategy");
        this.parserCreationStrategy = (ParsingStrategy)ArgCheck.checkNotNull(parserCreationStrategy, (String)"parserCreationStrategy");
    }

    @Override
    public O replace() {
        String replacedString = this.getReplacementStrategy().replace(this.getTemplateString());
        return this.getParserCreationStrategy().parse(replacedString);
    }

    public ReplacementStrategy<String, String> getReplacementStrategy() {
        return this.replacementStrategy;
    }

    @Override
    public String getTemplateString() {
        return this.templateString;
    }

    public ParsingStrategy<String, O> getParserCreationStrategy() {
        return this.parserCreationStrategy;
    }
}

