/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.binaryowl.owlapi;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.semanticweb.binaryowl.BinaryOWLMetadata;
import org.semanticweb.binaryowl.BinaryOWLOntologyDocumentHandler;
import org.semanticweb.binaryowl.BinaryOWLOntologyDocumentPreamble;
import org.semanticweb.binaryowl.BinaryOWLParseException;
import org.semanticweb.binaryowl.change.OntologyChangeDataList;
import org.semanticweb.binaryowl.owlapi.BinaryOWLOntologyDocumentFormat;
import org.semanticweb.owlapi.change.AddAxiomData;
import org.semanticweb.owlapi.change.AddImportData;
import org.semanticweb.owlapi.change.AddOntologyAnnotationData;
import org.semanticweb.owlapi.change.OWLOntologyChangeData;
import org.semanticweb.owlapi.change.OWLOntologyChangeDataVisitor;
import org.semanticweb.owlapi.change.RemoveAxiomData;
import org.semanticweb.owlapi.change.RemoveImportData;
import org.semanticweb.owlapi.change.RemoveOntologyAnnotationData;
import org.semanticweb.owlapi.change.SetOntologyIDData;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.AddOntologyAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.SetOntologyID;
import org.semanticweb.owlapi.model.UnloadableImportException;

public class BinaryOWLOntologyBuildingHandler
implements BinaryOWLOntologyDocumentHandler<BinaryOWLParseException>,
OWLOntologyChangeDataVisitor<Void, RuntimeException> {
    private OWLOntologyLoaderConfiguration loaderConfiguration;
    private OWLOntology ontology;
    private OWLOntologyID ontologyID = new OWLOntologyID();
    private Set<OWLImportsDeclaration> importsDeclarations = new HashSet<OWLImportsDeclaration>();
    private Set<OWLAnnotation> annotations = new HashSet<OWLAnnotation>();
    private List<Set<OWLAxiom>> axiomSets = new ArrayList<Set<OWLAxiom>>();
    private Set<OWLAxiom> mergedAxioms = new HashSet<OWLAxiom>(1);
    private BinaryOWLOntologyDocumentFormat format = new BinaryOWLOntologyDocumentFormat();

    public BinaryOWLOntologyBuildingHandler(OWLOntologyLoaderConfiguration loaderConfiguration, OWLOntology ontology) {
        this.loaderConfiguration = loaderConfiguration;
        this.ontology = ontology;
    }

    public BinaryOWLOntologyBuildingHandler(OWLOntology ontology) {
        this(new OWLOntologyLoaderConfiguration(), ontology);
    }

    public void build() throws UnloadableImportException {
        OWLOntologyManager manager = this.ontology.getOWLOntologyManager();
        manager.applyChange((OWLOntologyChange)new SetOntologyID(this.ontology, this.ontologyID));
        for (OWLImportsDeclaration decl : this.importsDeclarations) {
            manager.applyChange((OWLOntologyChange)new AddImport(this.ontology, decl));
        }
        for (OWLImportsDeclaration decl : this.importsDeclarations) {
            if (this.loaderConfiguration.isIgnoredImport(decl.getIRI())) continue;
            manager.makeLoadImportRequest(decl, this.loaderConfiguration);
        }
        for (OWLAnnotation annotation : this.annotations) {
            manager.applyChange((OWLOntologyChange)new AddOntologyAnnotation(this.ontology, annotation));
        }
        manager.addAxioms(this.ontology, this.mergedAxioms);
    }

    public BinaryOWLOntologyDocumentFormat getFormat() {
        return this.format;
    }

    @Override
    public void handleBeginDocument() throws BinaryOWLParseException {
        this.ontologyID = new OWLOntologyID();
        this.importsDeclarations.clear();
        this.annotations.clear();
        this.axiomSets.clear();
        this.mergedAxioms.clear();
    }

    @Override
    public void handleEndDocument() throws BinaryOWLParseException {
        try {
            this.build();
        }
        catch (UnloadableImportException e) {
            throw new BinaryOWLParseException(e);
        }
    }

    @Override
    public void handleBeginInitialDocumentBlock() {
    }

    @Override
    public void handleEndInitialDocumentBlock() {
        int size = 0;
        for (Set<OWLAxiom> axs : this.axiomSets) {
            size += axs.size();
        }
        this.mergedAxioms = new HashSet<OWLAxiom>(size);
        for (Set<OWLAxiom> axs : this.axiomSets) {
            this.mergedAxioms.addAll(axs);
        }
        this.axiomSets = new ArrayList<Set<OWLAxiom>>();
    }

    @Override
    public void handleBeginDocumentChangesBlock() {
    }

    @Override
    public void handleEndDocumentChangesBlock() {
    }

    @Override
    public void handlePreamble(BinaryOWLOntologyDocumentPreamble preamble) {
    }

    @Override
    public void handleDocumentMetaData(BinaryOWLMetadata metadata) {
        this.format = new BinaryOWLOntologyDocumentFormat(metadata);
    }

    @Override
    public void handleOntologyID(OWLOntologyID ontologyID) {
        this.ontologyID = ontologyID;
    }

    @Override
    public void handleImportsDeclarations(Set<OWLImportsDeclaration> importsDeclarations) {
        this.importsDeclarations = importsDeclarations;
    }

    @Override
    public void handleOntologyAnnotations(Set<OWLAnnotation> annotations) {
        this.annotations.addAll(annotations);
    }

    @Override
    public void handleAxioms(Set<OWLAxiom> axioms) {
        this.axiomSets.add(axioms);
    }

    @Override
    public void handleChanges(OntologyChangeDataList changesList) {
        for (OWLOntologyChangeData changeData : changesList) {
            changeData.accept((OWLOntologyChangeDataVisitor)this);
        }
    }

    public Void visit(AddAxiomData data) {
        this.mergedAxioms.add(data.getAxiom());
        return null;
    }

    public Void visit(RemoveAxiomData data) {
        this.mergedAxioms.remove(data.getAxiom());
        return null;
    }

    public Void visit(AddOntologyAnnotationData data) {
        this.annotations.add(data.getAnnotation());
        return null;
    }

    public Void visit(RemoveOntologyAnnotationData data) {
        this.annotations.remove(data.getAnnotation());
        return null;
    }

    public Void visit(SetOntologyIDData data) {
        this.ontologyID = data.getNewId();
        return null;
    }

    public Void visit(AddImportData data) {
        this.importsDeclarations.add(data.getDeclaration());
        return null;
    }

    public Void visit(RemoveImportData data) {
        this.importsDeclarations.remove(data.getDeclaration());
        return null;
    }
}

