/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.binaryowl;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.semanticweb.binaryowl.BinaryOWLChangeLogHandler;
import org.semanticweb.binaryowl.BinaryOWLMetadata;
import org.semanticweb.binaryowl.BinaryOWLParseException;
import org.semanticweb.binaryowl.BinaryOWLVersion;
import org.semanticweb.binaryowl.change.OntologyChangeRecordList;
import org.semanticweb.binaryowl.chunk.SkipSetting;
import org.semanticweb.binaryowl.stream.BinaryOWLInputStream;
import org.semanticweb.binaryowl.stream.BinaryOWLOutputStream;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLOntologyChange;

public class BinaryOWLOntologyChangeLog {
    public void appendChanges(List<OWLOntologyChange> changeList, long timestamp, BinaryOWLMetadata changeListMetadata, File file) throws IOException {
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file, true));
        this.appendChanges(changeList, timestamp, changeListMetadata, os);
        os.close();
    }

    public void appendChanges(List<OWLOntologyChange> changeList, long timestamp, BinaryOWLMetadata changeListMetadata, OutputStream os) throws IOException {
        this.appendChanges(new OntologyChangeRecordList(changeList, timestamp, changeListMetadata), os);
    }

    public void appendChanges(OntologyChangeRecordList changeList, File file) throws IOException {
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file, true));
        this.appendChanges(changeList, os);
        os.close();
    }

    public void appendChanges(OntologyChangeRecordList changeList, OutputStream os) throws IOException {
        DataOutputStream dos = new DataOutputStream(os);
        dos.writeByte(33);
        BinaryOWLOutputStream outputStream = new BinaryOWLOutputStream(dos, BinaryOWLVersion.getVersion(1));
        changeList.write(outputStream);
    }

    public void readChanges(InputStream inputStream, OWLDataFactory dataFactory, BinaryOWLChangeLogHandler handler) throws IOException, BinaryOWLParseException {
        this.readChanges(inputStream, dataFactory, handler, SkipSetting.SKIP_NONE);
    }

    public void readChanges(InputStream is, OWLDataFactory dataFactory, BinaryOWLChangeLogHandler handler, SkipSetting skipSetting) throws IOException, BinaryOWLParseException {
        CountingInputStream countingInputStream = new CountingInputStream(is);
        BinaryOWLInputStream inputStream = new BinaryOWLInputStream(countingInputStream, dataFactory, BinaryOWLVersion.getVersion(1));
        int marker = countingInputStream.read();
        while (marker == 33) {
            long filePosition = countingInputStream.getPosition();
            OntologyChangeRecordList changeRecordList = new OntologyChangeRecordList(inputStream, skipSetting);
            handler.handleChangesRead(changeRecordList, skipSetting, filePosition);
            marker = countingInputStream.read();
        }
    }

    private class CountingInputStream
    extends InputStream {
        private long position;
        private InputStream delegate;

        protected CountingInputStream(InputStream delegate) {
            this.delegate = delegate;
        }

        public long getPosition() {
            return this.position;
        }

        @Override
        public int read() throws IOException {
            int read = this.delegate.read();
            if (read != -1) {
                ++this.position;
            }
            return read;
        }

        @Override
        public int read(byte[] b) throws IOException {
            int read = super.read(b);
            if (read != -1) {
                this.position += (long)read;
            }
            return read;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int read = super.read(b, off, len);
            if (read != -1) {
                this.position += (long)read;
            }
            return read;
        }

        @Override
        public long skip(long n) throws IOException {
            long skipped = super.skip(n);
            this.position += skipped;
            return skipped;
        }
    }
}

