/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.utility;

import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Locale;
import net.sf.mpxj.DateOrder;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectHeader;
import net.sf.mpxj.ProjectTimeFormat;
import net.sf.mpxj.utility.MPXJDateFormat;
import net.sf.mpxj.utility.MPXJNumberFormat;
import net.sf.mpxj.utility.MPXJTimeFormat;

public final class MPXJFormats {
    private Locale m_locale;
    private String m_nullText;
    private ProjectFile m_projectFile;
    private MPXJNumberFormat m_unitsDecimalFormat = new MPXJNumberFormat();
    private MPXJNumberFormat m_decimalFormat = new MPXJNumberFormat();
    private MPXJNumberFormat m_currencyFormat = new MPXJNumberFormat();
    private MPXJNumberFormat m_durationDecimalFormat = new MPXJNumberFormat();
    private MPXJNumberFormat m_percentageDecimalFormat = new MPXJNumberFormat();
    private MPXJDateFormat m_dateTimeFormat = new MPXJDateFormat();
    private MPXJDateFormat m_dateFormat = new MPXJDateFormat();
    private MPXJTimeFormat m_timeFormat = new MPXJTimeFormat();

    public MPXJFormats(Locale locale, String nullText, ProjectFile file) {
        this.m_locale = locale;
        this.m_nullText = nullText;
        this.m_projectFile = file;
        this.update();
    }

    public void update() {
        ProjectHeader header = this.m_projectFile.getProjectHeader();
        char decimalSeparator = header.getDecimalSeparator();
        char thousandsSeparator = header.getThousandsSeparator();
        this.m_unitsDecimalFormat.applyPattern("#.##", null, decimalSeparator, thousandsSeparator);
        this.m_decimalFormat.applyPattern("0.00#", null, decimalSeparator, thousandsSeparator);
        this.m_durationDecimalFormat.applyPattern("#.##", null, decimalSeparator, thousandsSeparator);
        this.m_percentageDecimalFormat.applyPattern("##0.##", null, decimalSeparator, thousandsSeparator);
        this.updateCurrencyFormats(header, decimalSeparator, thousandsSeparator);
        this.updateDateTimeFormats(header);
    }

    private void updateCurrencyFormats(ProjectHeader header, char decimalSeparator, char thousandsSeparator) {
        String noSymbolSecondaryPattern;
        String noSymbolPrimaryPattern;
        String secondaryPattern;
        String prefix = "";
        String suffix = "";
        String currencySymbol = this.quoteFormatCharacters(header.getCurrencySymbol());
        switch (header.getSymbolPosition()) {
            case AFTER: {
                suffix = currencySymbol;
                break;
            }
            case BEFORE: {
                prefix = currencySymbol;
                break;
            }
            case AFTER_WITH_SPACE: {
                suffix = " " + currencySymbol;
                break;
            }
            case BEFORE_WITH_SPACE: {
                prefix = currencySymbol + " ";
            }
        }
        StringBuffer pattern = new StringBuffer(prefix);
        pattern.append("#0");
        int digits = header.getCurrencyDigits().intValue();
        if (digits > 0) {
            pattern.append('.');
            for (int i = 0; i < digits; ++i) {
                pattern.append("0");
            }
        }
        pattern.append(suffix);
        String primaryPattern = pattern.toString();
        String[] alternativePatterns = new String[7];
        alternativePatterns[0] = primaryPattern + ";(" + primaryPattern + ")";
        pattern.insert(prefix.length(), "#,#");
        alternativePatterns[1] = secondaryPattern = pattern.toString();
        alternativePatterns[2] = secondaryPattern + ";(" + secondaryPattern + ")";
        pattern.setLength(0);
        pattern.append("#0");
        if (digits > 0) {
            pattern.append('.');
            for (int i = 0; i < digits; ++i) {
                pattern.append("0");
            }
        }
        alternativePatterns[3] = noSymbolPrimaryPattern = pattern.toString();
        alternativePatterns[4] = noSymbolPrimaryPattern + ";(" + noSymbolPrimaryPattern + ")";
        pattern.insert(0, "#,#");
        alternativePatterns[5] = noSymbolSecondaryPattern = pattern.toString();
        alternativePatterns[6] = noSymbolSecondaryPattern + ";(" + noSymbolSecondaryPattern + ")";
        this.m_currencyFormat.applyPattern(primaryPattern, alternativePatterns, decimalSeparator, thousandsSeparator);
    }

    private String quoteFormatCharacters(String literal) {
        StringBuffer sb = new StringBuffer();
        int length = literal.length();
        block3: for (int loop = 0; loop < length; ++loop) {
            char c = literal.charAt(loop);
            switch (c) {
                case '#': 
                case '%': 
                case ',': 
                case '-': 
                case '.': 
                case '0': 
                case ';': 
                case 'E': {
                    sb.append("'");
                    sb.append(c);
                    sb.append("'");
                    continue block3;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    private void updateDateTimeFormats(ProjectHeader header) {
        String datePattern = "";
        String dateTimePattern = "";
        String timePattern = this.getTimeElement(header);
        char datesep = header.getDateSeparator();
        DateOrder dateOrder = header.getDateOrder();
        switch (dateOrder) {
            case DMY: {
                datePattern = "dd" + datesep + "MM" + datesep + "yy";
                break;
            }
            case MDY: {
                datePattern = "MM" + datesep + "dd" + datesep + "yy";
                break;
            }
            case YMD: {
                datePattern = "yy" + datesep + "MM" + datesep + "dd";
            }
        }
        block5 : switch (header.getDateFormat()) {
            case DD_MM_YY_HH_MM: {
                switch (dateOrder) {
                    case DMY: {
                        dateTimePattern = "dd" + datesep + "MM" + datesep + "yy " + timePattern;
                        break;
                    }
                    case MDY: {
                        dateTimePattern = "MM" + datesep + "dd" + datesep + "yy " + timePattern;
                        break;
                    }
                    case YMD: {
                        dateTimePattern = "yy" + datesep + "MM" + datesep + "dd " + timePattern;
                    }
                }
                break;
            }
            case DD_MM_YY: {
                switch (dateOrder) {
                    case DMY: {
                        dateTimePattern = "dd" + datesep + "MM" + datesep + "yy";
                        break;
                    }
                    case MDY: {
                        dateTimePattern = "MM" + datesep + "dd" + datesep + "yy";
                        break;
                    }
                    case YMD: {
                        dateTimePattern = "yy" + datesep + "MM" + datesep + "dd";
                    }
                }
                break;
            }
            case DD_MMMMM_YYYY_HH_MM: {
                switch (dateOrder) {
                    case DMY: {
                        dateTimePattern = "dd MMMMM yyyy " + timePattern;
                        break;
                    }
                    case MDY: {
                        dateTimePattern = "MMMMM dd yyyy " + timePattern;
                        break;
                    }
                    case YMD: {
                        dateTimePattern = "yyyy MMMMM dd " + timePattern;
                    }
                }
                break;
            }
            case DD_MMMMM_YYYY: {
                switch (dateOrder) {
                    case DMY: {
                        dateTimePattern = "dd MMMMM yyyy";
                        break;
                    }
                    case MDY: {
                        dateTimePattern = "MMMMM dd yyyy";
                        break;
                    }
                    case YMD: {
                        dateTimePattern = "yyyy MMMMM dd";
                    }
                }
                break;
            }
            case DD_MMM_HH_MM: {
                switch (dateOrder) {
                    case DMY: {
                        dateTimePattern = "dd MMM " + timePattern;
                        break;
                    }
                    case MDY: 
                    case YMD: {
                        dateTimePattern = " MMM dd " + timePattern;
                    }
                }
                break;
            }
            case DD_MMM_YY: {
                switch (dateOrder) {
                    case DMY: {
                        dateTimePattern = "dd MMM ''yy";
                        break;
                    }
                    case MDY: {
                        dateTimePattern = "MMM dd ''yy";
                        break;
                    }
                    case YMD: {
                        dateTimePattern = "''yy MMM dd";
                    }
                }
                break;
            }
            case DD_MMMMM: {
                switch (dateOrder) {
                    case DMY: {
                        dateTimePattern = "dd MMMMM";
                        break;
                    }
                    case MDY: 
                    case YMD: {
                        dateTimePattern = "MMMMM dd";
                    }
                }
                break;
            }
            case DD_MMM: {
                switch (dateOrder) {
                    case DMY: {
                        dateTimePattern = "dd MMM";
                        break;
                    }
                    case MDY: 
                    case YMD: {
                        dateTimePattern = "MMM dd";
                    }
                }
                break;
            }
            case EEE_DD_MM_YY_HH_MM: {
                switch (dateOrder) {
                    case DMY: {
                        dateTimePattern = "EEE dd" + datesep + "MM" + datesep + "yy " + timePattern;
                        break;
                    }
                    case MDY: {
                        dateTimePattern = "EEE MM" + datesep + "dd" + datesep + "yy " + timePattern;
                        break;
                    }
                    case YMD: {
                        dateTimePattern = "EEE yy" + datesep + "MM" + datesep + "dd " + timePattern;
                    }
                }
                break;
            }
            case EEE_DD_MM_YY: {
                switch (dateOrder) {
                    case DMY: {
                        dateTimePattern = "EEE dd" + datesep + "MM" + datesep + "yy";
                        break;
                    }
                    case MDY: {
                        dateTimePattern = "EEE MM" + datesep + "dd" + datesep + "yy";
                        break;
                    }
                    case YMD: {
                        dateTimePattern = "EEE yy" + datesep + "MM" + datesep + "dd";
                    }
                }
                break;
            }
            case EEE_DD_MMM_YY: {
                switch (dateOrder) {
                    case DMY: {
                        dateTimePattern = "EEE dd MMM ''yy";
                        break;
                    }
                    case MDY: {
                        dateTimePattern = "EEE MM dd ''yy";
                        break;
                    }
                    case YMD: {
                        dateTimePattern = "EEE ''yy MMM dd";
                    }
                }
                break;
            }
            case EEE_HH_MM: {
                dateTimePattern = "EEE " + timePattern;
                break;
            }
            case DD_MM: {
                switch (dateOrder) {
                    case DMY: {
                        dateTimePattern = "dd" + datesep + "MM";
                        break;
                    }
                    case MDY: 
                    case YMD: {
                        dateTimePattern = "MM" + datesep + "dd";
                    }
                }
                break;
            }
            case DD: {
                dateTimePattern = "dd";
                break;
            }
            case HH_MM: {
                dateTimePattern = timePattern;
                break;
            }
            case EEE_DD_MMM: {
                switch (dateOrder) {
                    case DMY: {
                        dateTimePattern = "EEE dd MMM";
                        break;
                    }
                    case MDY: 
                    case YMD: {
                        dateTimePattern = "EEE MMM dd";
                    }
                }
                break;
            }
            case EEE_DD_MM: {
                switch (dateOrder) {
                    case DMY: {
                        dateTimePattern = "EEE dd" + datesep + "MM";
                        break;
                    }
                    case MDY: 
                    case YMD: {
                        dateTimePattern = "EEE MM" + datesep + "dd";
                    }
                }
                break;
            }
            case EEE_DD: {
                dateTimePattern = "EEE dd";
                break;
            }
            case DD_WWW: {
                dateTimePattern = "F" + datesep + "'W'ww";
                break;
            }
            case DD_WWW_YY_HH_MM: {
                dateTimePattern = "F" + datesep + "'W'ww" + datesep + "yy " + timePattern;
                break;
            }
            case DD_MM_YYYY: {
                switch (dateOrder) {
                    case DMY: {
                        dateTimePattern = "dd" + datesep + "MM" + datesep + "yyyy";
                        break block5;
                    }
                    case MDY: {
                        dateTimePattern = "MM" + datesep + "dd" + datesep + "yyyy";
                        break block5;
                    }
                    case YMD: {
                        dateTimePattern = "yyyy" + datesep + "MM" + datesep + "dd";
                    }
                }
            }
        }
        this.m_dateTimeFormat.applyPattern(dateTimePattern);
        this.m_dateFormat.applyPattern(datePattern);
        this.m_timeFormat.applyPattern(timePattern);
        this.m_dateTimeFormat.setLocale(this.m_locale, this.m_nullText);
        this.m_dateFormat.setLocale(this.m_locale, this.m_nullText);
        this.m_timeFormat.setNullText(this.m_nullText);
        this.m_dateTimeFormat.setAmPmText(header.getAMText(), header.getPMText());
        this.m_timeFormat.setAmPmText(header.getAMText(), header.getPMText());
    }

    private String getTimeElement(ProjectHeader header) {
        char timesep = header.getTimeSeparator();
        ProjectTimeFormat format = header.getTimeFormat();
        String time = format == null || format == ProjectTimeFormat.TWELVE_HOUR ? "hh" + timesep + "mm a" : "HH" + timesep + "mm";
        return time;
    }

    public NumberFormat getUnitsDecimalFormat() {
        return this.m_unitsDecimalFormat;
    }

    public NumberFormat getDecimalFormat() {
        return this.m_decimalFormat;
    }

    public NumberFormat getCurrencyFormat() {
        return this.m_currencyFormat;
    }

    public NumberFormat getDurationDecimalFormat() {
        return this.m_durationDecimalFormat;
    }

    public NumberFormat getPercentageDecimalFormat() {
        return this.m_percentageDecimalFormat;
    }

    public DateFormat getDateTimeFormat() {
        return this.m_dateTimeFormat;
    }

    public DateFormat getDateFormat() {
        return this.m_dateFormat;
    }

    public DateFormat getTimeFormat() {
        return this.m_timeFormat;
    }

    public String getNullText() {
        return this.m_nullText;
    }
}

