/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpd;

import java.io.File;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.listener.ProjectListener;
import net.sf.mpxj.mpd.MPD9DatabaseReader;
import net.sf.mpxj.reader.ProjectReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MPDDatabaseReader
implements ProjectReader {
    private Integer m_projectID;
    private DataSource m_dataSource;
    private Connection m_connection;
    private boolean m_preserveNoteFormatting;
    private List<ProjectListener> m_projectListeners;

    @Override
    public void addProjectListener(ProjectListener listener) {
        if (this.m_projectListeners == null) {
            this.m_projectListeners = new LinkedList<ProjectListener>();
        }
        this.m_projectListeners.add(listener);
    }

    public Map<Integer, String> listProjects() throws MPXJException {
        MPD9DatabaseReader reader = new MPD9DatabaseReader();
        return reader.listProjects();
    }

    public ProjectFile read() throws MPXJException {
        MPD9DatabaseReader reader = new MPD9DatabaseReader();
        reader.setProjectID(this.m_projectID);
        reader.setPreserveNoteFormatting(this.m_preserveNoteFormatting);
        reader.setDataSource(this.m_dataSource);
        reader.setConnection(this.m_connection);
        ProjectFile project = reader.read();
        return project;
    }

    public void setProjectID(int projectID) {
        this.m_projectID = projectID;
    }

    public void setPreserveNoteFormatting(boolean preserveNoteFormatting) {
        this.m_preserveNoteFormatting = preserveNoteFormatting;
    }

    public void setDataSource(DataSource dataSource) {
        this.m_dataSource = dataSource;
    }

    public void setConnection(Connection connection) {
        this.m_connection = connection;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ProjectFile read(String accessDatabaseFileName) throws MPXJException {
        ProjectFile projectFile;
        try {
            try {
                Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
                String url = "jdbc:odbc:DRIVER=Microsoft Access Driver (*.mdb);DBQ=" + accessDatabaseFileName;
                this.m_connection = DriverManager.getConnection(url);
                this.m_projectID = 1;
                projectFile = this.read();
                Object var5_6 = null;
                if (this.m_connection == null) return projectFile;
            }
            catch (ClassNotFoundException ex) {
                throw new MPXJException("Failed to load JDBC driver", ex);
            }
            catch (SQLException ex) {
                throw new MPXJException("Failed to create connection", ex);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (this.m_connection == null) throw throwable;
            try {
                this.m_connection.close();
                throw throwable;
            }
            catch (SQLException ex) {
                throw throwable;
            }
        }
        try {}
        catch (SQLException ex) {
            // empty catch block
            return projectFile;
        }
        this.m_connection.close();
        return projectFile;
    }

    @Override
    public ProjectFile read(File file) throws MPXJException {
        return this.read(file.getAbsolutePath());
    }

    @Override
    public ProjectFile read(InputStream inputStream) {
        throw new UnsupportedOperationException();
    }
}

