/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.junit;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Duration;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.Task;
import net.sf.mpxj.TimephasedCost;
import net.sf.mpxj.TimephasedWork;
import net.sf.mpxj.junit.MPXJTestCase;
import net.sf.mpxj.mpp.MPPReader;
import net.sf.mpxj.mpp.TimescaleUnits;
import net.sf.mpxj.utility.TimephasedUtility;
import net.sf.mpxj.utility.TimescaleUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimephasedSegmentTest2
extends MPXJTestCase {
    private TimescaleUtility m_timescale = new TimescaleUtility();
    private TimephasedUtility m_timephased = new TimephasedUtility();

    public void testMpp9() throws Exception {
        ProjectFile file = new MPPReader().read(this.m_basedir + "/mpp9timephased2.mpp");
        this.testSegments(file);
    }

    public void testMpp9From12() throws Exception {
        ProjectFile file = new MPPReader().read(this.m_basedir + "/mpp9timephased2-from12.mpp");
        this.testSegments(file);
    }

    public void testMpp9From14() throws Exception {
        ProjectFile file = new MPPReader().read(this.m_basedir + "/mpp9timephased2-from14.mpp");
        this.testSegments(file);
    }

    public void testMpp12() throws Exception {
        ProjectFile file = new MPPReader().read(this.m_basedir + "/mpp12timephased2.mpp");
        this.testSegments(file);
    }

    public void testMpp12From14() throws Exception {
        ProjectFile file = new MPPReader().read(this.m_basedir + "/mpp12timephased2-from14.mpp");
        this.testSegments(file);
    }

    public void testMpp14() throws Exception {
        ProjectFile file = new MPPReader().read(this.m_basedir + "/mpp14timephased2.mpp");
        this.testSegments(file);
    }

    private void testSegments(ProjectFile file) throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
        Date startDate = df.parse("07/12/2011");
        Task task = file.getTaskByID(1);
        TimephasedSegmentTest2.assertEquals((String)"Planned task", (String)task.getName());
        List<ResourceAssignment> assignments = task.getResourceAssignments();
        ResourceAssignment assignment = assignments.get(0);
        this.testBaselineWorkSegments(file, assignment, startDate, TimescaleUnits.DAYS, new double[]{8.0, 8.0, 8.0, 0.0, 0.0, 8.0, 8.0, 8.0, 8.0, 8.0, 0.0, 0.0, 8.0, 8.0, 0.0});
        this.testBaselineCostSegments(file, assignment, startDate, TimescaleUnits.DAYS, new double[]{88.0, 88.0, 88.0, 0.0, 0.0, 88.0, 88.0, 88.0, 88.0, 88.0, 0.0, 0.0, 88.0, 88.0, 0.0});
        this.testCostSegments(assignment, startDate, TimescaleUnits.DAYS, new double[]{88.0, 88.0, 88.0, 0.0, 0.0, 88.0, 88.0, 88.0, 88.0, 88.0, 0.0, 0.0, 88.0, 88.0, 0.0});
        this.testActualCostSegments(assignment, startDate, TimescaleUnits.DAYS, new double[]{0.0, 0.0});
        task = file.getTaskByID(2);
        TimephasedSegmentTest2.assertEquals((String)"Partially complete task", (String)task.getName());
        assignments = task.getResourceAssignments();
        assignment = assignments.get(0);
        this.testBaselineWorkSegments(file, assignment, startDate, TimescaleUnits.DAYS, new double[]{8.0, 8.0, 8.0, 0.0, 0.0, 8.0, 8.0, 8.0, 8.0, 8.0, 0.0, 0.0, 8.0, 8.0, 0.0});
        this.testBaselineCostSegments(file, assignment, startDate, TimescaleUnits.DAYS, new double[]{96.0, 96.0, 96.0, 0.0, 0.0, 96.0, 96.0, 96.0, 96.0, 96.0, 0.0, 0.0, 96.0, 96.0, 0.0});
        this.testCostSegments(assignment, startDate, TimescaleUnits.DAYS, new double[]{0.0, 96.0, 96.0, 0.0, 0.0, 96.0, 96.0, 96.0, 96.0, 96.0, 0.0, 0.0, 96.0, 96.0, 0.0});
        this.testActualCostSegments(assignment, startDate, TimescaleUnits.DAYS, new double[]{96.0, 0.0});
        task = file.getTaskByID(3);
        TimephasedSegmentTest2.assertEquals((String)"Complete task", (String)task.getName());
        assignments = task.getResourceAssignments();
        assignment = assignments.get(0);
        this.testBaselineWorkSegments(file, assignment, startDate, TimescaleUnits.DAYS, new double[]{8.0, 8.0, 8.0, 0.0, 0.0, 8.0, 8.0, 8.0, 8.0, 8.0, 0.0, 0.0, 8.0, 8.0, 0.0});
        this.testBaselineCostSegments(file, assignment, startDate, TimescaleUnits.DAYS, new double[]{104.0, 104.0, 104.0, 0.0, 0.0, 104.0, 104.0, 104.0, 104.0, 104.0, 0.0, 0.0, 104.0, 104.0, 0.0});
        this.testCostSegments(assignment, startDate, TimescaleUnits.DAYS, new double[]{0.0, 0.0});
        this.testActualCostSegments(assignment, startDate, TimescaleUnits.DAYS, new double[]{104.0, 104.0, 104.0, 0.0, 0.0, 104.0, 104.0, 104.0, 104.0, 104.0, 0.0, 0.0, 104.0, 104.0, 0.0});
        task = file.getTaskByID(4);
        TimephasedSegmentTest2.assertEquals((String)"Planned task with resource holiday", (String)task.getName());
        assignments = task.getResourceAssignments();
        assignment = assignments.get(0);
        this.testBaselineWorkSegments(file, assignment, startDate, TimescaleUnits.DAYS, new double[]{8.0, 8.0, 8.0, 0.0, 0.0, 8.0, 8.0, 0.0, 8.0, 8.0, 0.0, 0.0, 8.0, 8.0, 8.0, 0.0});
        this.testBaselineCostSegments(file, assignment, startDate, TimescaleUnits.DAYS, new double[]{112.0, 112.0, 112.0, 0.0, 0.0, 112.0, 112.0, 0.0, 112.0, 112.0, 0.0, 0.0, 112.0, 112.0, 112.0, 0.0});
        this.testCostSegments(assignment, startDate, TimescaleUnits.DAYS, new double[]{112.0, 112.0, 112.0, 0.0, 0.0, 112.0, 112.0, 0.0, 112.0, 112.0, 0.0, 0.0, 112.0, 112.0, 112.0, 0.0});
        this.testActualCostSegments(assignment, startDate, TimescaleUnits.DAYS, new double[]{0.0, 0.0});
        task = file.getTaskByID(5);
        TimephasedSegmentTest2.assertEquals((String)"Partially complete task with resource holiday", (String)task.getName());
        assignments = task.getResourceAssignments();
        assignment = assignments.get(0);
        this.testBaselineWorkSegments(file, assignment, startDate, TimescaleUnits.DAYS, new double[]{8.0, 8.0, 8.0, 0.0, 0.0, 8.0, 8.0, 0.0, 8.0, 8.0, 0.0, 0.0, 8.0, 8.0, 8.0, 0.0});
        this.testBaselineCostSegments(file, assignment, startDate, TimescaleUnits.DAYS, new double[]{120.0, 120.0, 120.0, 0.0, 0.0, 120.0, 120.0, 0.0, 120.0, 120.0, 0.0, 0.0, 120.0, 120.0, 120.0, 0.0});
        this.testCostSegments(assignment, startDate, TimescaleUnits.DAYS, new double[]{0.0, 120.0, 120.0, 0.0, 0.0, 120.0, 120.0, 0.0, 120.0, 120.0, 0.0, 0.0, 120.0, 120.0, 120.0, 0.0});
        this.testActualCostSegments(assignment, startDate, TimescaleUnits.DAYS, new double[]{120.0, 0.0});
        task = file.getTaskByID(6);
        TimephasedSegmentTest2.assertEquals((String)"Complete task with resource holiday", (String)task.getName());
        assignments = task.getResourceAssignments();
        assignment = assignments.get(0);
        this.testBaselineWorkSegments(file, assignment, startDate, TimescaleUnits.DAYS, new double[]{8.0, 8.0, 8.0, 0.0, 0.0, 8.0, 8.0, 0.0, 8.0, 8.0, 0.0, 0.0, 8.0, 8.0, 8.0, 0.0});
        this.testBaselineCostSegments(file, assignment, startDate, TimescaleUnits.DAYS, new double[]{128.0, 128.0, 128.0, 0.0, 0.0, 128.0, 128.0, 0.0, 128.0, 128.0, 0.0, 0.0, 128.0, 128.0, 128.0, 0.0});
        this.testCostSegments(assignment, startDate, TimescaleUnits.DAYS, new double[]{0.0, 0.0});
        this.testActualCostSegments(assignment, startDate, TimescaleUnits.DAYS, new double[]{128.0, 128.0, 128.0, 0.0, 0.0, 128.0, 128.0, 0.0, 128.0, 128.0, 0.0, 0.0, 128.0, 128.0, 128.0, 0.0});
        task = file.getTaskByID(7);
        TimephasedSegmentTest2.assertEquals((String)"Planned task with overtime", (String)task.getName());
        assignments = task.getResourceAssignments();
        assignment = assignments.get(0);
        this.testBaselineWorkSegments(file, assignment, startDate, TimescaleUnits.DAYS, new double[]{9.15, 9.15, 9.15, 0.0, 0.0, 9.15, 9.15, 9.15, 9.15, 9.15, 0.0, 0.0, 6.85, 0.0});
        this.testBaselineCostSegments(file, assignment, startDate, TimescaleUnits.DAYS, new double[]{166.86, 166.86, 166.86, 0.0, 0.0, 166.86, 166.86, 166.86, 166.86, 166.86, 0.0, 0.0, 125.14, 0.0});
        this.testCostSegments(assignment, startDate, TimescaleUnits.DAYS, new double[]{166.86, 166.86, 166.86, 0.0, 0.0, 166.86, 166.86, 166.86, 166.86, 166.86, 0.0, 0.0, 125.14, 0.0});
        this.testActualCostSegments(assignment, startDate, TimescaleUnits.DAYS, new double[]{0.0, 0.0});
        task = file.getTaskByID(8);
        TimephasedSegmentTest2.assertEquals((String)"Partially complete task with overtime", (String)task.getName());
        assignments = task.getResourceAssignments();
        assignment = assignments.get(0);
        this.testBaselineWorkSegments(file, assignment, startDate, TimescaleUnits.DAYS, new double[]{9.15, 9.15, 9.15, 0.0, 0.0, 9.15, 9.15, 9.15, 9.15, 9.15, 0.0, 0.0, 6.85, 0.0});
        this.testBaselineCostSegments(file, assignment, startDate, TimescaleUnits.DAYS, new double[]{176.0, 176.0, 176.0, 0.0, 0.0, 176.0, 176.0, 176.0, 176.0, 176.0, 0.0, 0.0, 132.0, 0.0});
        this.testCostSegments(assignment, startDate, TimescaleUnits.DAYS, new double[]{0.0, 44.0, 176.0, 0.0, 0.0, 176.0, 176.0, 176.0, 176.0, 176.0, 0.0, 0.0, 132.0, 0.0});
        this.testActualCostSegments(assignment, startDate, TimescaleUnits.DAYS, new double[]{176.0, 132.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0});
        task = file.getTaskByID(9);
        TimephasedSegmentTest2.assertEquals((String)"Partially complete task with overtime added", (String)task.getName());
        assignments = task.getResourceAssignments();
        assignment = assignments.get(0);
        this.testBaselineWorkSegments(file, assignment, startDate, TimescaleUnits.DAYS, new double[]{8.0, 8.0, 9.48, 0.0, 0.0, 9.48, 9.48, 9.48, 9.48, 9.48, 0.0, 0.0, 7.12, 0.0});
        this.testBaselineCostSegments(file, assignment, startDate, TimescaleUnits.DAYS, new double[]{152.0, 152.0, 194.96, 0.0, 0.0, 194.96, 194.96, 194.96, 194.96, 194.96, 0.0, 0.0, 146.22, 0.0});
        this.testCostSegments(assignment, startDate, TimescaleUnits.DAYS, new double[]{0.0, 0.0, 194.96, 0.0, 0.0, 194.96, 194.96, 194.96, 194.96, 194.96, 0.0, 0.0, 146.22, 0.0});
        this.testActualCostSegments(assignment, startDate, TimescaleUnits.DAYS, new double[]{152.0, 152.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0});
    }

    private void testBaselineWorkSegments(ProjectFile file, ResourceAssignment assignment, Date startDate, TimescaleUnits units, double[] expected) {
        ArrayList<DateRange> dateList = this.m_timescale.createTimescale(startDate, units, expected.length);
        List<TimephasedWork> assignments = assignment.getTimephasedBaselineWork(0);
        ArrayList<Duration> durationList = this.m_timephased.segmentBaselineWork(file, assignments, units, dateList);
        TimephasedSegmentTest2.assertEquals((int)expected.length, (int)durationList.size());
        for (int loop = 0; loop < expected.length; ++loop) {
            TimephasedSegmentTest2.assertEquals((String)("Failed at index " + loop), (double)expected[loop], (double)durationList.get(loop).getDuration(), (double)0.009);
        }
    }

    private void testBaselineCostSegments(ProjectFile file, ResourceAssignment assignment, Date startDate, TimescaleUnits units, double[] expected) {
        ArrayList<DateRange> dateList = this.m_timescale.createTimescale(startDate, units, expected.length);
        List<TimephasedCost> assignments = assignment.getTimephasedBaselineCost(0);
        ArrayList<Double> costList = this.m_timephased.segmentBaselineCost(file, assignments, units, dateList);
        TimephasedSegmentTest2.assertEquals((int)expected.length, (int)costList.size());
        for (int loop = 0; loop < expected.length; ++loop) {
            TimephasedSegmentTest2.assertEquals((String)("Failed at index " + loop), (double)expected[loop], (double)costList.get(loop), (double)0.009);
        }
    }

    private void testCostSegments(ResourceAssignment assignment, Date startDate, TimescaleUnits units, double[] expected) {
        this.testCostSegments(assignment, assignment.getTimephasedCost(), startDate, units, expected);
    }

    private void testActualCostSegments(ResourceAssignment assignment, Date startDate, TimescaleUnits units, double[] expected) {
        this.testCostSegments(assignment, assignment.getTimephasedActualCost(), startDate, units, expected);
    }

    private void testCostSegments(ResourceAssignment assignment, List<TimephasedCost> assignments, Date startDate, TimescaleUnits units, double[] expected) {
        ArrayList<DateRange> dateList = this.m_timescale.createTimescale(startDate, units, expected.length);
        ArrayList<Double> costList = this.m_timephased.segmentCost(assignment.getCalendar(), assignments, units, dateList);
        TimephasedSegmentTest2.assertEquals((int)expected.length, (int)costList.size());
        for (int loop = 0; loop < expected.length; ++loop) {
            TimephasedSegmentTest2.assertEquals((String)("Failed at index " + loop), (double)expected[loop], (double)costList.get(loop), (double)0.02);
        }
    }
}

