/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.junit;

import java.text.SimpleDateFormat;
import net.sf.mpxj.CurrencySymbolPosition;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectHeader;
import net.sf.mpxj.ScheduleFrom;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.junit.MPXJTestCase;
import net.sf.mpxj.mpd.MPDDatabaseReader;
import net.sf.mpxj.mpp.MPPReader;

public class MppProjectHeaderTest
extends MPXJTestCase {
    public void testMpp9() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/mpp9header.mpp");
        this.testHeader(mpp, true);
    }

    public void testMpp9From12() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/mpp9header-from12.mpp");
        this.testHeader(mpp, true);
    }

    public void testMpp9From14() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/mpp9header-from14.mpp");
        this.testHeader(mpp, true);
    }

    public void testMpp12() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/mpp12header.mpp");
        this.testHeader(mpp, true);
    }

    public void testMpp12From14() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/mpp12header-from14.mpp");
        this.testHeader(mpp, true);
    }

    public void testMpp14() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/mpp14header.mpp");
        this.testHeader(mpp, true);
    }

    public void testMpd9() throws Exception {
        block2: {
            try {
                ProjectFile mpp = new MPDDatabaseReader().read(this.m_basedir + "/mpp9header.mpd");
                this.testHeader(mpp, false);
            }
            catch (Exception ex) {
                if (this.m_ikvm) break block2;
                throw ex;
            }
        }
    }

    private void testHeader(ProjectFile mpp, boolean isMPP) {
        SimpleDateFormat tf = new SimpleDateFormat("HH:mm");
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
        ProjectHeader ph = mpp.getProjectHeader();
        MppProjectHeaderTest.assertEquals((Object)ScheduleFrom.FINISH, (Object)ph.getScheduleFrom());
        MppProjectHeaderTest.assertEquals((String)"24 Hours", (String)ph.getCalendarName());
        MppProjectHeaderTest.assertEquals((String)"08:35", (String)tf.format(ph.getDefaultStartTime()));
        MppProjectHeaderTest.assertEquals((String)"17:35", (String)tf.format(ph.getDefaultEndTime()));
        MppProjectHeaderTest.assertEquals((String)"01/08/2006", (String)df.format(ph.getStatusDate()));
        MppProjectHeaderTest.assertEquals((Object)TimeUnit.HOURS, (Object)ph.getDefaultDurationUnits());
        MppProjectHeaderTest.assertEquals((int)420, (int)ph.getMinutesPerDay().intValue());
        MppProjectHeaderTest.assertEquals((int)2460, (int)ph.getMinutesPerWeek().intValue());
        MppProjectHeaderTest.assertEquals((double)2.0, (double)ph.getDefaultOvertimeRate().getAmount(), (double)0.0);
        MppProjectHeaderTest.assertEquals((Object)TimeUnit.HOURS, (Object)ph.getDefaultOvertimeRate().getUnits());
        MppProjectHeaderTest.assertEquals((double)1.0, (double)ph.getDefaultStandardRate().getAmount(), (double)0.0);
        MppProjectHeaderTest.assertEquals((Object)TimeUnit.HOURS, (Object)ph.getDefaultStandardRate().getUnits());
        MppProjectHeaderTest.assertEquals((Object)TimeUnit.WEEKS, (Object)ph.getDefaultWorkUnits());
        MppProjectHeaderTest.assertEquals((boolean)false, (boolean)ph.getSplitInProgressTasks());
        MppProjectHeaderTest.assertEquals((boolean)false, (boolean)ph.getUpdatingTaskStatusUpdatesResourceStatus());
        MppProjectHeaderTest.assertEquals((int)1, (int)ph.getCurrencyDigits().intValue());
        MppProjectHeaderTest.assertEquals((String)"X", (String)ph.getCurrencySymbol());
        MppProjectHeaderTest.assertEquals((Object)CurrencySymbolPosition.AFTER, (Object)ph.getSymbolPosition());
        MppProjectHeaderTest.assertEquals((String)"title", (String)ph.getProjectTitle());
        MppProjectHeaderTest.assertEquals((String)"subject", (String)ph.getSubject());
        MppProjectHeaderTest.assertEquals((String)"author", (String)ph.getAuthor());
        MppProjectHeaderTest.assertEquals((String)"keywords", (String)ph.getKeywords());
        MppProjectHeaderTest.assertEquals((String)"company", (String)ph.getCompany());
        MppProjectHeaderTest.assertEquals((String)"manager", (String)ph.getManager());
        MppProjectHeaderTest.assertEquals((String)"category", (String)ph.getCategory());
        if (isMPP) {
            MppProjectHeaderTest.assertEquals((String)"comments", (String)ph.getComments());
            MppProjectHeaderTest.assertEquals((boolean)true, (boolean)ph.getCalculateMultipleCriticalPaths());
        }
    }
}

