/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.mailprobe.store;

import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.search.AndTerm;
import javax.mail.search.HeaderTerm;
import javax.mail.search.SearchTerm;
import javax.mail.search.SubjectTerm;
import net.sourceforge.mailprobe.util.Protocol;

public class Mailstore {
    private static final Logger logger = Logger.getLogger(Mailstore.class.getName());
    private Protocol protocol;
    private String hostname;
    private int port;
    private String username;
    private String password;
    private boolean useStarttls;
    private Folder inbox;

    private Mailstore() {
    }

    public Mailstore(Protocol protocol, String hostname, String port, String username, String password, boolean useStarttls) {
        this.protocol = protocol;
        this.hostname = hostname;
        this.port = port != null ? Integer.parseInt(port) : -1;
        this.username = username;
        this.password = password;
        this.useStarttls = useStarttls;
    }

    public String toString() {
        return this.protocol.toString() + "_" + this.hostname + "_" + String.valueOf(this.port) + "_" + this.username + "_" + this.password + "_" + String.valueOf(this.useStarttls);
    }

    public Message searchForSubjectAndUUID(String subjectIdent, String uuid) {
        try {
            AndTerm searchTerm = new AndTerm((SearchTerm)new SubjectTerm(subjectIdent), (SearchTerm)new HeaderTerm("X-MailProbe-UUID", uuid));
            Message[] msgs = this.getInbox().search((SearchTerm)searchTerm);
            logger.log(Level.FINE, "While searching INBOX: messages found: {0}", msgs.length);
            if (msgs.length > 0) {
                return msgs[0];
            }
            return null;
        }
        catch (MessagingException ex) {
            logger.log(Level.WARNING, "While searching INBOX", ex);
            return null;
        }
    }

    public Message searchForUUID(String uuid) {
        try {
            HeaderTerm searchTerm = new HeaderTerm("X-MailProbe-UUID", uuid);
            Message[] msgs = this.getInbox().search((SearchTerm)searchTerm);
            logger.log(Level.FINE, "While searching INBOX: messages found: {0}", msgs.length);
            if (msgs.length > 0) {
                return msgs[0];
            }
            return null;
        }
        catch (MessagingException ex) {
            logger.log(Level.WARNING, "While searching INBOX", ex);
            return null;
        }
    }

    public boolean connect() {
        Folder result;
        this.inbox = result = this.openInbox();
        return result != null;
    }

    public boolean disconnect(boolean expunge) {
        try {
            this.getInbox().close(expunge);
            return true;
        }
        catch (MessagingException ex) {
            logger.log(Level.WARNING, "Disconnecting from INBOX", ex);
            return false;
        }
    }

    public Folder openInbox() {
        Properties props = new Properties(System.getProperties());
        props.setProperty("mail." + this.protocol.toString() + ".host", this.hostname);
        if (this.port > 0) {
            props.setProperty("mail." + this.protocol.toString() + ".port", Integer.toString(this.port));
        }
        props.setProperty("mail." + this.protocol.toString() + ".connectiontimeout", "30000");
        props.setProperty("mail." + this.protocol.toString() + ".timeout", "30000");
        props.setProperty("mail." + this.protocol.toString() + ".starttls.enable", this.useStarttls ? "true" : "false");
        props.setProperty("mail." + this.protocol.toString() + ".ssl.trust", "*");
        Session session = Session.getInstance((Properties)props, null);
        Folder inboxFolder = null;
        try {
            Store store = session.getStore(this.protocol.toString());
            if (this.username != null && this.password != null) {
                store.connect(this.username, this.password);
            } else {
                store.connect();
            }
            inboxFolder = store.getDefaultFolder().getFolder("INBOX");
            inboxFolder.open(2);
        }
        catch (MessagingException messagingException) {
            logger.log(Level.WARNING, "", messagingException);
            return null;
        }
        return inboxFolder;
    }

    public Folder getInbox() {
        return this.inbox;
    }
}

