/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.app.mathviewer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.sourceforge.jeuclid.MathMLSerializer;
import net.sourceforge.jeuclid.app.mathviewer.AboutDialog;
import net.sourceforge.jeuclid.app.mathviewer.FileIO;
import net.sourceforge.jeuclid.app.mathviewer.MathViewer;
import net.sourceforge.jeuclid.app.mathviewer.Messages;
import net.sourceforge.jeuclid.app.mathviewer.ParametersDialog;
import net.sourceforge.jeuclid.context.LayoutContextImpl;
import net.sourceforge.jeuclid.context.Parameter;
import net.sourceforge.jeuclid.swing.JMathComponent;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class MainFrame
extends JFrame {
    private static final int DEFAULT_HEIGHT = 200;
    private static final int DEFAULT_WIDTH = 350;
    private static final FileIO FILEIO = FileIO.getInstance();
    private static final long serialVersionUID = 1L;
    private static final float FONT_SIZE_MULTIPLICATOR = 1.2f;
    private JPanel jContentPane;
    private JMenuBar jJMenuBar;
    private JMenu fileMenu;
    private JMenu editMenu;
    private JMenu helpMenu;
    private JMenuItem exitMenuItem;
    private JMenuItem unformattedCopyMenuItem;
    private JMenuItem formattedCopyMenuItem;
    private JMenuItem pasteMenuItem;
    private JMenuItem aboutMenuItem;
    private JMenuItem openMenuItem;
    private JDialog aboutDialog;
    private JSplitPane splitPane;
    private JScrollPane scrollPane;
    private JScrollPane scrollPane2;
    private JTextArea textArea;
    private JMathComponent mathComponent;
    private JMenu viewMenu;
    private JMenuItem biggerMenuItem;
    private JMenuItem smallerMenuItem;
    private JMenuItem exportMenuItem;
    private JCheckBoxMenuItem aliasMenuItem;
    private JCheckBoxMenuItem debugMenuItem;

    public MainFrame() {
        this.initialize();
    }

    private void initialize() {
        this.setJMenuBar(this.getJJMenuBar());
        this.setSize(350, 200);
        this.setContentPane(this.getJContentPane());
        this.setTitle(Messages.getString("MathViewer.windowTitle"));
        this.setLocationByPlatform(true);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getSplitPane(), "Center");
        }
        return this.jContentPane;
    }

    private JMenuBar getJJMenuBar() {
        if (this.jJMenuBar == null) {
            this.jJMenuBar = new JMenuBar();
            this.jJMenuBar.add(this.getFileMenu());
            this.jJMenuBar.add(this.getEditMenu());
            this.jJMenuBar.add(this.getViewMenu());
            if (!MathViewer.OSX) {
                this.jJMenuBar.add(this.getHelpMenu());
            }
        }
        return this.jJMenuBar;
    }

    private JMenu getFileMenu() {
        if (this.fileMenu == null) {
            this.fileMenu = new JMenu();
            this.fileMenu.setText(Messages.getString("MathViewer.FileMenu"));
            this.fileMenu.add(this.getOpenMenuItem());
            this.fileMenu.add(this.getExportMenuItem());
            if (!MathViewer.OSX) {
                this.fileMenu.add(this.getExitMenuItem());
            }
        }
        return this.fileMenu;
    }

    private JMenu getEditMenu() {
        if (this.editMenu == null) {
            this.editMenu = new JMenu();
            this.editMenu.setText(Messages.getString("MathViewer.EditMenu"));
            this.editMenu.add(this.getUnformattedCopyMenuItem());
            this.editMenu.add(this.getFormattedCopyMenuItem());
            this.editMenu.add(this.getPasteMenuItem());
        }
        return this.editMenu;
    }

    private JMenu getHelpMenu() {
        if (this.helpMenu == null) {
            this.helpMenu = new JMenu();
            this.helpMenu.setText(Messages.getString("MathViewer.helpMenu"));
            this.helpMenu.add(this.getAboutMenuItem());
        }
        return this.helpMenu;
    }

    private JMenuItem getExitMenuItem() {
        if (this.exitMenuItem == null) {
            this.exitMenuItem = new JMenuItem();
            this.exitMenuItem.setText(Messages.getString("MathViewer.exit"));
            this.exitMenuItem.setAccelerator(KeyStroke.getKeyStroke(81, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), true));
            this.exitMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    System.exit(0);
                }
            });
        }
        return this.exitMenuItem;
    }

    private JMenuItem getUnformattedCopyMenuItem() {
        if (this.unformattedCopyMenuItem == null) {
            this.unformattedCopyMenuItem = new JMenuItem();
            this.unformattedCopyMenuItem.setText(Messages.getString("MathViewer.unformattedCopy"));
            this.unformattedCopyMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), true));
            this.unformattedCopyMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MainFrame.this.copyToClipboard(false);
                }
            });
        }
        return this.unformattedCopyMenuItem;
    }

    private JMenuItem getFormattedCopyMenuItem() {
        if (this.formattedCopyMenuItem == null) {
            this.formattedCopyMenuItem = new JMenuItem();
            this.formattedCopyMenuItem.setText(Messages.getString("MathViewer.formattedCopy"));
            this.formattedCopyMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x40, true));
            this.formattedCopyMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MainFrame.this.copyToClipboard(true);
                }
            });
        }
        return this.formattedCopyMenuItem;
    }

    private JMenuItem getPasteMenuItem() {
        if (this.pasteMenuItem == null) {
            this.pasteMenuItem = new JMenuItem();
            this.pasteMenuItem.setText(Messages.getString("MathViewer.paste"));
            this.pasteMenuItem.setAccelerator(KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), true));
            this.pasteMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MainFrame.this.pasteFromClipboard();
                }
            });
        }
        return this.pasteMenuItem;
    }

    private JMenuItem getAboutMenuItem() {
        if (this.aboutMenuItem == null) {
            this.aboutMenuItem = new JMenuItem();
            this.aboutMenuItem.setText(Messages.getString("MathViewer.aboutMenuItem"));
            this.aboutMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MainFrame.this.displayAbout();
                }
            });
        }
        return this.aboutMenuItem;
    }

    public void displayAbout() {
        JDialog jDialog = this.getAboutDialog();
        jDialog.pack();
        Point point = this.getLocation();
        point.translate((this.getWidth() - jDialog.getWidth()) / 2, 0);
        jDialog.setLocation(point);
        jDialog.setVisible(true);
    }

    private JDialog getAboutDialog() {
        if (this.aboutDialog == null) {
            this.aboutDialog = new AboutDialog(this);
        }
        return this.aboutDialog;
    }

    private JMenuItem getOpenMenuItem() {
        if (this.openMenuItem == null) {
            this.openMenuItem = new JMenuItem();
            this.openMenuItem.setText(Messages.getString("MathViewer.open"));
            this.openMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), true));
            this.openMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MainFrame.this.openFile();
                }
            });
        }
        return this.openMenuItem;
    }

    public void loadFile(File file) {
        Document document = FILEIO.loadFile(this, file);
        if (document != null) {
            this.getMathComponent().setDocument((Node)document);
            this.getTextArea().setText(MathMLSerializer.serializeDocument((Node)document, (boolean)false, (boolean)false));
        }
    }

    protected void openFile() {
        File file = FILEIO.selectFileToOpen(this);
        this.loadFile(file);
    }

    private JSplitPane getSplitPane() {
        if (this.splitPane == null) {
            this.splitPane = new JSplitPane(0, this.getScrollPane(), this.getScrollPane2());
            this.splitPane.setOneTouchExpandable(true);
            this.splitPane.setResizeWeight(1.0);
        }
        return this.splitPane;
    }

    private JTextArea getTextArea() {
        if (this.textArea == null) {
            this.textArea = new JTextArea();
            this.textArea.setText("<?xml version='1.0'?>\n<math xmlns='http://www.w3.org/1998/Math/MathML'>\n</math>");
            this.textArea.setEditable(true);
            this.textArea.getDocument().addDocumentListener(new DocumentListener(){

                public void changedUpdate(DocumentEvent documentEvent) {
                    MainFrame.this.updateFromTextArea();
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    MainFrame.this.updateFromTextArea();
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    MainFrame.this.updateFromTextArea();
                }
            });
            this.textArea.setBackground(Color.WHITE);
        }
        return this.textArea;
    }

    private void updateFromTextArea() {
        try {
            this.getMathComponent().setContent(this.getTextArea().getText());
            this.textArea.setForeground(Color.BLACK);
        }
        catch (RuntimeException runtimeException) {
            this.textArea.setForeground(Color.RED);
        }
    }

    private JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane();
            this.scrollPane.setViewportView((Component)this.getMathComponent());
            if (MathViewer.OSX) {
                this.scrollPane.setVerticalScrollBarPolicy(22);
                this.scrollPane.setHorizontalScrollBarPolicy(32);
            }
        }
        return this.scrollPane;
    }

    private JScrollPane getScrollPane2() {
        if (this.scrollPane2 == null) {
            this.scrollPane2 = new JScrollPane();
            this.scrollPane2.setViewportView(this.getTextArea());
            if (MathViewer.OSX) {
                this.scrollPane2.setVerticalScrollBarPolicy(22);
                this.scrollPane2.setHorizontalScrollBarPolicy(32);
            }
        }
        return this.scrollPane2;
    }

    public JMathComponent getMathComponent() {
        if (this.mathComponent == null) {
            this.mathComponent = new JMathComponent();
            this.mathComponent.setContent("<math><mtext>" + Messages.getString("MathViewer.noFileLoaded") + "</mtext></math>");
            this.mathComponent.setFocusable(true);
        }
        return this.mathComponent;
    }

    private JMenu getViewMenu() {
        if (this.viewMenu == null) {
            this.viewMenu = new JMenu();
            this.viewMenu.setText(Messages.getString("MathViewer.viewMenu"));
            this.viewMenu.add(this.getBiggerMenuItem());
            this.viewMenu.add(this.getSmallerMenuItem());
            this.viewMenu.add(this.getAliasMenuItem());
            this.viewMenu.add(this.getDebugMenuItem());
            if (!MathViewer.OSX) {
                this.viewMenu.add(this.getViewModifyParams());
            }
        }
        return this.viewMenu;
    }

    private JMenuItem getViewModifyParams() {
        JMenuItem jMenuItem = new JMenuItem(Messages.getString("MathViewer.viewModifyParams"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.displaySettings();
            }
        });
        return jMenuItem;
    }

    public void displaySettings() {
        new ParametersDialog(this).setVisible(true);
        this.debugMenuItem.setSelected((Boolean)this.mathComponent.getParameters().getParameter(Parameter.DEBUG));
        this.aliasMenuItem.setSelected((Boolean)this.mathComponent.getParameters().getParameter(Parameter.ANTIALIAS));
    }

    private JMenuItem getBiggerMenuItem() {
        if (this.biggerMenuItem == null) {
            this.biggerMenuItem = new JMenuItem();
            this.biggerMenuItem.setText(Messages.getString("MathViewer.textBigger"));
            this.biggerMenuItem.setAccelerator(KeyStroke.getKeyStroke(107, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), true));
            this.biggerMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JMathComponent jMathComponent = MainFrame.this.getMathComponent();
                    jMathComponent.setFontSize(jMathComponent.getFontSize() * 1.2f);
                }
            });
        }
        return this.biggerMenuItem;
    }

    private JMenuItem getSmallerMenuItem() {
        if (this.smallerMenuItem == null) {
            this.smallerMenuItem = new JMenuItem();
            this.smallerMenuItem.setText(Messages.getString("MathViewer.textSmaller"));
            this.smallerMenuItem.setAccelerator(KeyStroke.getKeyStroke(109, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), true));
            this.smallerMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JMathComponent jMathComponent = MainFrame.this.getMathComponent();
                    jMathComponent.setFontSize(jMathComponent.getFontSize() / 1.2f);
                }
            });
        }
        return this.smallerMenuItem;
    }

    private JMenuItem getExportMenuItem() {
        if (this.exportMenuItem == null) {
            this.exportMenuItem = new JMenuItem();
            this.exportMenuItem.setText(Messages.getString("MathViewer.export"));
            this.exportMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), true));
            this.exportMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MainFrame.this.exportFile();
                }
            });
        }
        return this.exportMenuItem;
    }

    protected void exportFile() {
        FILEIO.saveDocument(this, this.getMathComponent().getDocument(), this.getMathComponent().getParameters());
    }

    private JCheckBoxMenuItem getAliasMenuItem() {
        if (this.aliasMenuItem == null) {
            this.aliasMenuItem = new JCheckBoxMenuItem();
            this.aliasMenuItem.setText(Messages.getString("MathViewer.alias"));
            this.aliasMenuItem.setSelected((Boolean)LayoutContextImpl.getDefaultLayoutContext().getParameter(Parameter.ANTIALIAS));
            this.aliasMenuItem.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    MainFrame.this.getMathComponent().setParameter(Parameter.ANTIALIAS, (Object)MainFrame.this.aliasMenuItem.isSelected());
                }
            });
        }
        return this.aliasMenuItem;
    }

    private JCheckBoxMenuItem getDebugMenuItem() {
        if (this.debugMenuItem == null) {
            this.debugMenuItem = new JCheckBoxMenuItem();
            this.debugMenuItem.setText(Messages.getString("MathViewer.debug"));
            this.debugMenuItem.setSelected((Boolean)LayoutContextImpl.getDefaultLayoutContext().getParameter(Parameter.DEBUG));
            this.debugMenuItem.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    MainFrame.this.getMathComponent().setParameter(Parameter.DEBUG, (Object)MainFrame.this.debugMenuItem.isSelected());
                }
            });
        }
        return this.debugMenuItem;
    }

    private void pasteFromClipboard() {
        Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
        if (transferable != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                this.getMathComponent().setContent(string);
                this.getTextArea().setText(string);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, new String[]{Messages.getString("MathViewer.pasteFailure"), exception.toString()}, Messages.getString("MathViewer.error"), 0);
            }
        }
    }

    private void copyToClipboard(boolean bl) {
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(MathMLSerializer.serializeDocument((Node)this.mathComponent.getDocument(), (boolean)false, (boolean)bl)), null);
    }
}

