/*
 * ============================================================================
 * GNU Lesser General Public License
 * ============================================================================
 *
 * JasperReports - Free Java report-generating library.
 * Copyright (C) 2001-2006 JasperSoft Corporation http://www.jaspersoft.com
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.
 * 
 * JasperSoft Corporation
 * 303 Second Street, Suite 450 North
 * San Francisco, CA 94107
 * http://www.jaspersoft.com
 */
package net.sf.jasperreports.engine.design;

import java.io.File;

import net.sf.jasperreports.engine.JRException;

/**
 * Base class that can be used by single source file compilers to implement multiple compilation.
 * 
 * @author Lucian Chirita (lucianc@users.sourceforge.net)
 * @version $Id: JRAbstractSingleClassCompiler.java 1229 2006-04-19 10:27:35Z teodord $
 */
public abstract class JRAbstractSingleClassCompiler extends JRAbstractClassCompiler
{

	public String compileClasses(File[] sourceFiles, String classpath) throws JRException
	{
		if (sourceFiles.length == 1)
		{
			return compileClass(sourceFiles[0], classpath);
		}
		
		StringBuffer errors = new StringBuffer();
		for (int i = 0; i < sourceFiles.length; ++i)
		{
			errors.append(compileClass(sourceFiles[i], classpath));
		}
		
		return errors.toString();
	}
	
}
