/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlTextArea;
import com.gargoylesoftware.htmlunit.html.HtmlTextInput;
import com.gargoylesoftware.htmlunit.html.impl.SimpleRange;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;
import org.w3c.dom.ranges.Range;

public class TextRange
extends SimpleScriptable {
    private static final long serialVersionUID = -3763822832184277966L;
    private static final Log LOG = LogFactory.getLog(TextRange.class);
    private boolean collapsed_ = false;
    private Range range_;

    public TextRange() {
    }

    public TextRange(HTMLElement elt) {
        this.range_ = new SimpleRange(elt.getDomNodeOrDie());
    }

    public TextRange(Range range) {
        this.range_ = range.cloneRange();
    }

    public Object jsxGet_text() {
        if (this.collapsed_) {
            return "";
        }
        HtmlPage page = (HtmlPage)this.getWindow().getDomNodeOrDie();
        Range selection = page.getSelection();
        if (selection.getStartContainer() == selection.getEndContainer()) {
            if (selection.getStartContainer() instanceof HtmlTextInput) {
                HtmlTextInput input = (HtmlTextInput)selection.getStartContainer();
                return input.getValueAttribute().substring(input.getSelectionStart(), input.getSelectionEnd());
            }
            if (selection.getStartContainer() instanceof HtmlTextArea) {
                HtmlTextArea input = (HtmlTextArea)selection.getStartContainer();
                return input.getText().substring(input.getSelectionStart(), input.getSelectionEnd());
            }
        }
        return "";
    }

    public void jsxSet_text(String text) {
        this.collapsed_ = false;
        HtmlPage page = (HtmlPage)this.getWindow().getDomNodeOrDie();
        Range selection = page.getSelection();
        if (selection.getStartContainer() == selection.getEndContainer()) {
            if (selection.getStartContainer() instanceof HtmlTextInput) {
                HtmlTextInput input = (HtmlTextInput)selection.getStartContainer();
                String oldValue = input.getValueAttribute();
                input.setValueAttribute(oldValue.substring(0, input.getSelectionStart()) + text + oldValue.substring(input.getSelectionEnd()));
            } else if (selection.getStartContainer() instanceof HtmlTextArea) {
                HtmlTextArea input = (HtmlTextArea)selection.getStartContainer();
                String oldValue = input.getText();
                input.setText(oldValue.substring(0, input.getSelectionStart()) + text + oldValue.substring(input.getSelectionEnd()));
            }
        }
    }

    public Object jsxFunction_duplicate() {
        TextRange range = new TextRange();
        range.setParentScope(this.getParentScope());
        range.setPrototype(this.getPrototype());
        range.range_ = this.range_.cloneRange();
        return range;
    }

    public Object jsxFunction_parentElement() {
        Node parent = this.range_.getCommonAncestorContainer();
        return this.getScriptableFor(parent);
    }

    public void jsxFunction_collapse(boolean toStart) {
        this.collapsed_ = true;
        this.range_.collapse(toStart);
    }

    public void jsxFunction_select() {
    }

    public int jsxFunction_moveStart(String unit, Object count) {
        HtmlPage page;
        Range selection;
        if ("characters".equals(unit)) {
            LOG.info((Object)("moveStart('" + unit + "' is not yet supported."));
        }
        int c = 1;
        if (count != Undefined.instance) {
            c = (int)Context.toNumber((Object)count);
        }
        if ((selection = (page = (HtmlPage)this.getWindow().getDomNodeOrDie()).getSelection()).getStartContainer() == selection.getEndContainer()) {
            if (selection.getStartContainer() instanceof HtmlTextInput) {
                HtmlTextInput input = (HtmlTextInput)selection.getStartContainer();
                selection.setStart(input, selection.getStartOffset() + c);
            } else if (selection.getStartContainer() instanceof HtmlTextArea) {
                HtmlTextArea input = (HtmlTextArea)selection.getStartContainer();
                selection.setStart(input, selection.getStartOffset() + c);
            }
        }
        return c;
    }

    public int jsxFunction_moveEnd(String unit, Object count) {
        HtmlPage page;
        Range selection;
        if ("characters".equals(unit)) {
            LOG.info((Object)("moveEnd('" + unit + "' is not yet supported."));
        }
        int c = 1;
        if (count != Undefined.instance) {
            c = (int)Context.toNumber((Object)count);
        }
        if ((selection = (page = (HtmlPage)this.getWindow().getDomNodeOrDie()).getSelection()).getStartContainer() == selection.getEndContainer()) {
            if (selection.getStartContainer() instanceof HtmlTextInput) {
                HtmlTextInput input = (HtmlTextInput)selection.getStartContainer();
                selection.setEnd(input, selection.getEndOffset() + c);
            } else if (selection.getStartContainer() instanceof HtmlTextArea) {
                HtmlTextArea input = (HtmlTextArea)selection.getStartContainer();
                selection.setEnd(input, selection.getEndOffset() + c);
            }
        }
        return c;
    }

    public boolean jsxFunction_inRange(TextRange other) {
        boolean startNodeBefore;
        Range otherRange = other.range_;
        Node start = this.range_.getStartContainer();
        Node otherStart = otherRange.getStartContainer();
        if (otherStart == null) {
            return false;
        }
        short startComparison = start.compareDocumentPosition(otherStart);
        boolean bl = startNodeBefore = startComparison == 0 || (startComparison & 8) != 0 || (startComparison & 2) != 0;
        if (startNodeBefore && (start != otherStart || this.range_.getStartOffset() <= otherRange.getStartOffset())) {
            boolean endNodeAfter;
            Node otherEnd;
            Node end = this.range_.getEndContainer();
            short endComparison = end.compareDocumentPosition(otherEnd = otherRange.getEndContainer());
            boolean bl2 = endNodeAfter = endComparison == 0 || (endComparison & 8) != 0 || (endComparison & 4) != 0;
            if (endNodeAfter && (end != otherEnd || this.range_.getEndOffset() >= otherRange.getEndOffset())) {
                return true;
            }
        }
        return false;
    }
}

