/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebResponseData
implements Serializable {
    private static final long serialVersionUID = 2979956380280496543L;
    private byte[] body_;
    private int statusCode_;
    private String statusMessage_;
    private List<NameValuePair> responseHeaders_;

    public WebResponseData(byte[] body, int statusCode, String statusMessage, List<NameValuePair> responseHeaders) {
        this.statusCode_ = statusCode;
        this.statusMessage_ = statusMessage;
        this.responseHeaders_ = Collections.unmodifiableList(responseHeaders);
        if (body != null) {
            try {
                this.body_ = this.getBody(new ByteArrayInputStream(body), responseHeaders);
            }
            catch (IOException e) {
                this.body_ = body;
            }
        }
    }

    public WebResponseData(InputStream bodyStream, int statusCode, String statusMessage, List<NameValuePair> responseHeaders) throws IOException {
        this.statusCode_ = statusCode;
        this.statusMessage_ = statusMessage;
        this.responseHeaders_ = Collections.unmodifiableList(responseHeaders);
        this.body_ = this.getBody(bodyStream, responseHeaders);
    }

    protected WebResponseData(int statusCode, String statusMessage, List<NameValuePair> responseHeaders) throws IOException {
        this.statusCode_ = statusCode;
        this.statusMessage_ = statusMessage;
        this.responseHeaders_ = Collections.unmodifiableList(responseHeaders);
    }

    protected byte[] getBody(InputStream stream, List<NameValuePair> headers) throws IOException {
        if (stream == null) {
            return null;
        }
        String encoding = null;
        for (NameValuePair header : headers) {
            String headerName = header.getName().trim();
            if (!headerName.equalsIgnoreCase("content-encoding")) continue;
            encoding = header.getValue();
            break;
        }
        if (encoding != null && StringUtils.contains(encoding, (String)"gzip")) {
            stream = new GZIPInputStream(stream);
        } else if (encoding != null && StringUtils.contains(encoding, (String)"deflate")) {
            stream = new InflaterInputStream(stream);
        }
        return IOUtils.toByteArray((InputStream)stream);
    }

    public byte[] getBody() {
        return this.body_;
    }

    public List<NameValuePair> getResponseHeaders() {
        return this.responseHeaders_;
    }

    public int getStatusCode() {
        return this.statusCode_;
    }

    public String getStatusMessage() {
        return this.statusMessage_;
    }
}

