/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.constructs.blocking;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.Statistics;
import net.sf.ehcache.Status;
import net.sf.ehcache.bootstrap.BootstrapCacheLoader;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.constructs.blocking.LockTimeoutException;
import net.sf.ehcache.constructs.concurrent.ConcurrencyUtil;
import net.sf.ehcache.constructs.concurrent.Mutex;
import net.sf.ehcache.event.RegisteredEventListeners;
import net.sf.ehcache.exceptionhandler.CacheExceptionHandler;
import net.sf.ehcache.extension.CacheExtension;
import net.sf.ehcache.loader.CacheLoader;
import net.sf.ehcache.store.MemoryStoreEvictionPolicy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BlockingCache
implements Ehcache {
    public static final int LOCK_NUMBER = 2048;
    private static final Log LOG = LogFactory.getLog((String)BlockingCache.class.getName());
    protected final Mutex[] locks = new Mutex[2048];
    protected final Ehcache cache;
    protected int timeoutMillis;

    public BlockingCache(Ehcache cache) throws CacheException {
        for (int i = 0; i < 2048; ++i) {
            this.locks[i] = new Mutex();
        }
        this.cache = cache;
    }

    protected Ehcache getCache() {
        return this.cache;
    }

    public String getName() {
        return this.cache.getName();
    }

    public void setName(String name) {
        this.cache.setName(name);
    }

    public long getTimeToIdleSeconds() {
        return this.cache.getTimeToIdleSeconds();
    }

    public long getTimeToLiveSeconds() {
        return this.cache.getTimeToLiveSeconds();
    }

    public boolean isEternal() {
        return this.cache.isEternal();
    }

    public boolean isOverflowToDisk() {
        return this.cache.isOverflowToDisk();
    }

    public int getMaxElementsInMemory() {
        return this.cache.getMaxElementsInMemory();
    }

    public int getMaxElementsOnDisk() {
        return this.cache.getMaxElementsOnDisk();
    }

    public MemoryStoreEvictionPolicy getMemoryStoreEvictionPolicy() {
        return this.cache.getMemoryStoreEvictionPolicy();
    }

    public boolean isExpired(Element element) throws IllegalStateException, NullPointerException {
        return this.cache.isExpired(element);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean isDiskPersistent() {
        return this.cache.isDiskPersistent();
    }

    public long getDiskExpiryThreadIntervalSeconds() {
        return this.cache.getDiskExpiryThreadIntervalSeconds();
    }

    public RegisteredEventListeners getCacheEventNotificationService() {
        return this.cache.getCacheEventNotificationService();
    }

    public boolean isElementInMemory(Serializable key) {
        return this.cache.isElementInMemory(key);
    }

    public boolean isElementInMemory(Object key) {
        return this.cache.isElementInMemory(key);
    }

    public boolean isElementOnDisk(Serializable key) {
        return this.cache.isElementOnDisk(key);
    }

    public boolean isElementOnDisk(Object key) {
        return this.cache.isElementOnDisk(key);
    }

    public String getGuid() {
        return this.cache.getGuid();
    }

    public CacheManager getCacheManager() {
        return this.cache.getCacheManager();
    }

    public void clearStatistics() {
        this.cache.clearStatistics();
    }

    public int getStatisticsAccuracy() {
        return this.cache.getStatisticsAccuracy();
    }

    public void setStatisticsAccuracy(int statisticsAccuracy) {
        this.cache.setStatisticsAccuracy(statisticsAccuracy);
    }

    public void evictExpiredElements() {
        this.cache.evictExpiredElements();
    }

    public boolean isKeyInCache(Object key) {
        return this.cache.isKeyInCache(key);
    }

    public boolean isValueInCache(Object value) {
        return this.cache.isValueInCache(value);
    }

    public Statistics getStatistics() throws IllegalStateException {
        return this.cache.getStatistics();
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cache.setCacheManager(cacheManager);
    }

    public BootstrapCacheLoader getBootstrapCacheLoader() {
        return this.cache.getBootstrapCacheLoader();
    }

    public void setBootstrapCacheLoader(BootstrapCacheLoader bootstrapCacheLoader) throws CacheException {
        this.cache.setBootstrapCacheLoader(bootstrapCacheLoader);
    }

    public void setDiskStorePath(String diskStorePath) throws CacheException {
        this.cache.setDiskStorePath(diskStorePath);
    }

    public void initialise() {
        this.cache.initialise();
    }

    public void bootstrap() {
        this.cache.bootstrap();
    }

    public void dispose() throws IllegalStateException {
        this.cache.dispose();
    }

    public CacheConfiguration getCacheConfiguration() {
        return this.cache.getCacheConfiguration();
    }

    public Element get(Object key) throws LockTimeoutException {
        Mutex lock = this.getLockForKey(key);
        try {
            if (this.timeoutMillis == 0) {
                lock.acquire();
            } else {
                boolean acquired = lock.attempt(this.timeoutMillis);
                if (!acquired) {
                    StringBuffer message = new StringBuffer("Lock timeout. Waited more than ").append(this.timeoutMillis).append("ms to acquire lock for key ").append(key).append(" on blocking cache ").append(this.cache.getName());
                    throw new LockTimeoutException(message.toString());
                }
            }
            Element element = this.cache.get(key);
            if (element != null) {
                lock.release();
                return element;
            }
            return null;
        }
        catch (InterruptedException e) {
            throw new CacheException("Get interrupted for key " + key + ". Message was: " + e.getMessage());
        }
    }

    protected Mutex getLockForKey(Object key) {
        int lockNumber = ConcurrencyUtil.selectLock(key, 2048);
        return this.locks[lockNumber];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Element element) {
        if (element == null) {
            return;
        }
        Object key = element.getObjectKey();
        Object value = element.getObjectValue();
        Mutex lock = this.getLockForKey(key);
        try {
            if (value != null) {
                this.cache.put(element);
            } else {
                this.cache.remove(key);
            }
        }
        finally {
            lock.release();
        }
    }

    public void put(Element element, boolean doNotNotifyCacheReplicators) throws IllegalArgumentException, IllegalStateException, CacheException {
        this.cache.put(element, doNotNotifyCacheReplicators);
    }

    public void putQuiet(Element element) throws IllegalArgumentException, IllegalStateException, CacheException {
        this.cache.putQuiet(element);
    }

    public Element get(Serializable key) throws IllegalStateException, CacheException {
        return this.get((Object)key);
    }

    public Element getQuiet(Serializable key) throws IllegalStateException, CacheException {
        return this.cache.getQuiet(key);
    }

    public Element getQuiet(Object key) throws IllegalStateException, CacheException {
        return this.cache.getQuiet(key);
    }

    public List getKeys() throws CacheException {
        return this.cache.getKeys();
    }

    public List getKeysWithExpiryCheck() throws IllegalStateException, CacheException {
        return this.cache.getKeysWithExpiryCheck();
    }

    public List getKeysNoDuplicateCheck() throws IllegalStateException {
        return this.cache.getKeysNoDuplicateCheck();
    }

    public boolean remove(Serializable key) throws IllegalStateException {
        return this.cache.remove(key);
    }

    public boolean remove(Object key) throws IllegalStateException {
        return this.cache.remove(key);
    }

    public boolean remove(Serializable key, boolean doNotNotifyCacheReplicators) throws IllegalStateException {
        return this.cache.remove(key, doNotNotifyCacheReplicators);
    }

    public boolean remove(Object key, boolean doNotNotifyCacheReplicators) throws IllegalStateException {
        return this.cache.remove(key, doNotNotifyCacheReplicators);
    }

    public boolean removeQuiet(Serializable key) throws IllegalStateException {
        return this.cache.removeQuiet(key);
    }

    public boolean removeQuiet(Object key) throws IllegalStateException {
        return this.cache.removeQuiet(key);
    }

    public void removeAll() throws IllegalStateException, CacheException {
        this.cache.removeAll();
    }

    public void removeAll(boolean doNotNotifyCacheReplicators) throws IllegalStateException, CacheException {
        this.cache.removeAll(doNotNotifyCacheReplicators);
    }

    public void flush() throws IllegalStateException, CacheException {
        this.cache.flush();
    }

    public int getSize() throws IllegalStateException, CacheException {
        return this.cache.getSize();
    }

    public long calculateInMemorySize() throws IllegalStateException, CacheException {
        return this.cache.calculateInMemorySize();
    }

    public long getMemoryStoreSize() throws IllegalStateException {
        return this.cache.getMemoryStoreSize();
    }

    public int getDiskStoreSize() throws IllegalStateException {
        return this.cache.getDiskStoreSize();
    }

    public Status getStatus() {
        return this.cache.getStatus();
    }

    public synchronized String liveness() {
        return this.getName();
    }

    public void setTimeoutMillis(int timeoutMillis) {
        if (timeoutMillis < 0) {
            throw new CacheException("The lock timeout must be a positive number of ms. Value was " + timeoutMillis);
        }
        this.timeoutMillis = timeoutMillis;
    }

    public int getTimeoutMillis() {
        return this.timeoutMillis;
    }

    public void registerCacheExtension(CacheExtension cacheExtension) {
        this.cache.registerCacheExtension(cacheExtension);
    }

    public void unregisterCacheExtension(CacheExtension cacheExtension) {
        this.cache.unregisterCacheExtension(cacheExtension);
    }

    public float getAverageGetTime() {
        return this.cache.getAverageGetTime();
    }

    public void setCacheExceptionHandler(CacheExceptionHandler cacheExceptionHandler) {
        this.cache.setCacheExceptionHandler(cacheExceptionHandler);
    }

    public CacheExceptionHandler getCacheExceptionHandler() {
        return this.cache.getCacheExceptionHandler();
    }

    public void setCacheLoader(CacheLoader cacheLoader) {
        throw new CacheException("This method is not appropriate for a Blocking Cache");
    }

    public CacheLoader getCacheLoader() {
        return this.cache.getCacheLoader();
    }

    public Element getWithLoader(Object key, CacheLoader loader, Object loaderArgument) throws CacheException {
        throw new CacheException("This method is not appropriate for a Blocking Cache");
    }

    public Map getAllWithLoader(Collection keys, Object loaderArgument) throws CacheException {
        throw new CacheException("This method is not appropriate for a Blocking Cache");
    }

    public void load(Object key) throws CacheException {
        throw new CacheException("This method is not appropriate for a Blocking Cache");
    }

    public void loadAll(Collection keys, Object argument) throws CacheException {
        throw new CacheException("This method is not appropriate for a Blocking Cache");
    }
}

