/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.adhoc.transformation;

import java.awt.Color;
import java.util.List;
import net.sf.dynamicreports.adhoc.configuration.AdhocAxisFormat;
import net.sf.dynamicreports.adhoc.configuration.AdhocCalculation;
import net.sf.dynamicreports.adhoc.configuration.AdhocChart;
import net.sf.dynamicreports.adhoc.configuration.AdhocChartSerie;
import net.sf.dynamicreports.adhoc.configuration.AdhocChartType;
import net.sf.dynamicreports.adhoc.configuration.AdhocColumn;
import net.sf.dynamicreports.adhoc.configuration.AdhocComponent;
import net.sf.dynamicreports.adhoc.configuration.AdhocConfiguration;
import net.sf.dynamicreports.adhoc.configuration.AdhocFilter;
import net.sf.dynamicreports.adhoc.configuration.AdhocFont;
import net.sf.dynamicreports.adhoc.configuration.AdhocGroup;
import net.sf.dynamicreports.adhoc.configuration.AdhocGroupHeaderLayout;
import net.sf.dynamicreports.adhoc.configuration.AdhocHorizontalAlignment;
import net.sf.dynamicreports.adhoc.configuration.AdhocOrderType;
import net.sf.dynamicreports.adhoc.configuration.AdhocOrientation;
import net.sf.dynamicreports.adhoc.configuration.AdhocPage;
import net.sf.dynamicreports.adhoc.configuration.AdhocPageOrientation;
import net.sf.dynamicreports.adhoc.configuration.AdhocPen;
import net.sf.dynamicreports.adhoc.configuration.AdhocProperties;
import net.sf.dynamicreports.adhoc.configuration.AdhocReport;
import net.sf.dynamicreports.adhoc.configuration.AdhocRestriction;
import net.sf.dynamicreports.adhoc.configuration.AdhocSort;
import net.sf.dynamicreports.adhoc.configuration.AdhocStyle;
import net.sf.dynamicreports.adhoc.configuration.AdhocSubtotal;
import net.sf.dynamicreports.adhoc.configuration.AdhocSubtotalPosition;
import net.sf.dynamicreports.adhoc.configuration.AdhocTextField;
import net.sf.dynamicreports.adhoc.configuration.AdhocTimePeriod;
import net.sf.dynamicreports.adhoc.configuration.AdhocValueOperator;
import net.sf.dynamicreports.adhoc.configuration.AdhocValueRestriction;
import net.sf.dynamicreports.adhoc.configuration.AdhocVerticalAlignment;
import net.sf.dynamicreports.adhoc.exception.AdhocException;
import net.sf.dynamicreports.adhoc.xmlconfiguration.XmlAdhocAxisFormat;
import net.sf.dynamicreports.adhoc.xmlconfiguration.XmlAdhocCalculation;
import net.sf.dynamicreports.adhoc.xmlconfiguration.XmlAdhocChart;
import net.sf.dynamicreports.adhoc.xmlconfiguration.XmlAdhocChartSerie;
import net.sf.dynamicreports.adhoc.xmlconfiguration.XmlAdhocChartType;
import net.sf.dynamicreports.adhoc.xmlconfiguration.XmlAdhocColumn;
import net.sf.dynamicreports.adhoc.xmlconfiguration.XmlAdhocComponent;
import net.sf.dynamicreports.adhoc.xmlconfiguration.XmlAdhocConfiguration;
import net.sf.dynamicreports.adhoc.xmlconfiguration.XmlAdhocFilter;
import net.sf.dynamicreports.adhoc.xmlconfiguration.XmlAdhocFont;
import net.sf.dynamicreports.adhoc.xmlconfiguration.XmlAdhocGroup;
import net.sf.dynamicreports.adhoc.xmlconfiguration.XmlAdhocGroupHeaderLayout;
import net.sf.dynamicreports.adhoc.xmlconfiguration.XmlAdhocHorizontalAlignment;
import net.sf.dynamicreports.adhoc.xmlconfiguration.XmlAdhocOrderType;
import net.sf.dynamicreports.adhoc.xmlconfiguration.XmlAdhocOrientation;
import net.sf.dynamicreports.adhoc.xmlconfiguration.XmlAdhocPage;
import net.sf.dynamicreports.adhoc.xmlconfiguration.XmlAdhocPageOrientation;
import net.sf.dynamicreports.adhoc.xmlconfiguration.XmlAdhocPen;
import net.sf.dynamicreports.adhoc.xmlconfiguration.XmlAdhocProperty;
import net.sf.dynamicreports.adhoc.xmlconfiguration.XmlAdhocReport;
import net.sf.dynamicreports.adhoc.xmlconfiguration.XmlAdhocRestriction;
import net.sf.dynamicreports.adhoc.xmlconfiguration.XmlAdhocSort;
import net.sf.dynamicreports.adhoc.xmlconfiguration.XmlAdhocStyle;
import net.sf.dynamicreports.adhoc.xmlconfiguration.XmlAdhocSubtotal;
import net.sf.dynamicreports.adhoc.xmlconfiguration.XmlAdhocSubtotalPosition;
import net.sf.dynamicreports.adhoc.xmlconfiguration.XmlAdhocTextField;
import net.sf.dynamicreports.adhoc.xmlconfiguration.XmlAdhocValueOperator;
import net.sf.dynamicreports.adhoc.xmlconfiguration.XmlAdhocValueRestriction;
import net.sf.dynamicreports.adhoc.xmlconfiguration.XmlAdhocVerticalAlignment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdhocToXmlTransform {
    private static final Logger log = LoggerFactory.getLogger(AdhocToXmlTransform.class);

    public XmlAdhocConfiguration transform(AdhocConfiguration adhocConfiguration) {
        log.debug("Transforming object : {} to XmlAdhocConfiguration", (Object)adhocConfiguration);
        XmlAdhocConfiguration xmlAdhocConfiguration = new XmlAdhocConfiguration();
        xmlAdhocConfiguration.setReport(this.report(adhocConfiguration.getReport()));
        xmlAdhocConfiguration.setFilter(this.filter(adhocConfiguration.getFilter()));
        log.debug("XmlAdhocConfiguration : {} generated from adhocConfiguration: {}", (Object)xmlAdhocConfiguration, (Object)adhocConfiguration);
        return xmlAdhocConfiguration;
    }

    protected void properties(AdhocProperties properties, List<XmlAdhocProperty> xmlAdhocProperties) {
        for (String key : properties.getProperties().keySet()) {
            XmlAdhocProperty xmlAdhocProperty = new XmlAdhocProperty();
            xmlAdhocProperty.setKey(key);
            Object propertyValue = properties.getProperty(key);
            xmlAdhocProperty.setValue(this.propertyValueToString(propertyValue));
            if (propertyValue != null && !(propertyValue instanceof String)) {
                xmlAdhocProperty.setValueClass(propertyValue.getClass().getName());
            }
            xmlAdhocProperties.add(xmlAdhocProperty);
        }
    }

    protected String propertyValueToString(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Boolean || value instanceof Integer) {
            return String.valueOf(value);
        }
        if (value instanceof AdhocTimePeriod) {
            return ((AdhocTimePeriod)((Object)value)).name();
        }
        throw new AdhocException("Property value type " + value.getClass().getName() + " not supported");
    }

    protected XmlAdhocReport report(AdhocReport adhocReport) {
        log.debug("Converting adhocReport :{} to XmlAdhocReport", (Object)adhocReport);
        if (adhocReport == null) {
            return null;
        }
        XmlAdhocReport xmlAdhocReport = new XmlAdhocReport();
        xmlAdhocReport.setTextStyle(this.style(adhocReport.getTextStyle()));
        xmlAdhocReport.setColumnStyle(this.style(adhocReport.getColumnStyle()));
        xmlAdhocReport.setColumnTitleStyle(this.style(adhocReport.getColumnTitleStyle()));
        xmlAdhocReport.setGroupStyle(this.style(adhocReport.getGroupStyle()));
        xmlAdhocReport.setGroupTitleStyle(this.style(adhocReport.getGroupTitleStyle()));
        xmlAdhocReport.setSubtotalStyle(this.style(adhocReport.getSubtotalStyle()));
        xmlAdhocReport.setDetailOddRowStyle(this.style(adhocReport.getDetailOddRowStyle()));
        xmlAdhocReport.setHighlightDetailOddRows(adhocReport.getHighlightDetailOddRows());
        xmlAdhocReport.setDetailEvenRowStyle(this.style(adhocReport.getDetailEvenRowStyle()));
        xmlAdhocReport.setHighlightDetailEvenRows(adhocReport.getHighlightDetailEvenRows());
        xmlAdhocReport.setIgnorePagination(adhocReport.getIgnorePagination());
        xmlAdhocReport.setTableOfContents(adhocReport.getTableOfContents());
        xmlAdhocReport.setPage(this.page(adhocReport.getPage()));
        if (adhocReport.getColumns() != null && !adhocReport.getColumns().isEmpty()) {
            for (AdhocColumn adhocColumn : adhocReport.getColumns()) {
                xmlAdhocReport.getColumn().add(this.column(adhocColumn));
            }
        }
        if (adhocReport.getGroups() != null && !adhocReport.getGroups().isEmpty()) {
            for (AdhocGroup adhocGroup : adhocReport.getGroups()) {
                xmlAdhocReport.getGroup().add(this.group(adhocGroup));
            }
        }
        if (adhocReport.getSorts() != null && !adhocReport.getSorts().isEmpty()) {
            for (AdhocSort adhocSort : adhocReport.getSorts()) {
                xmlAdhocReport.getSort().add(this.sort(adhocSort));
            }
        }
        if (adhocReport.getSubtotals() != null && !adhocReport.getSubtotals().isEmpty()) {
            for (AdhocSubtotal adhocSubtotal : adhocReport.getSubtotals()) {
                xmlAdhocReport.getSubtotal().add(this.subtotal(adhocSubtotal));
            }
        }
        if (adhocReport.getComponents() != null && !adhocReport.getComponents().isEmpty()) {
            for (AdhocComponent adhocComponent : adhocReport.getComponents()) {
                xmlAdhocReport.getComponent().add(this.component(adhocComponent));
            }
        }
        if (adhocReport.getProperties() != null && !adhocReport.getProperties().isEmpty()) {
            this.properties(adhocReport.getProperties(), xmlAdhocReport.getProperty());
        }
        log.debug("XmlAdhocReport created and configured as : {}", (Object)xmlAdhocReport);
        return xmlAdhocReport;
    }

    protected XmlAdhocColumn column(AdhocColumn adhocColumn) {
        XmlAdhocColumn xmlAdhocColumn = new XmlAdhocColumn();
        xmlAdhocColumn.setName(adhocColumn.getName());
        xmlAdhocColumn.setTitle(adhocColumn.getTitle());
        xmlAdhocColumn.setWidth(adhocColumn.getWidth());
        xmlAdhocColumn.setStyle(this.style(adhocColumn.getStyle()));
        xmlAdhocColumn.setTitleStyle(this.style(adhocColumn.getTitleStyle()));
        if (adhocColumn.getProperties() != null && !adhocColumn.getProperties().isEmpty()) {
            this.properties(adhocColumn.getProperties(), xmlAdhocColumn.getProperty());
        }
        return xmlAdhocColumn;
    }

    protected XmlAdhocGroup group(AdhocGroup adhocGroup) {
        XmlAdhocGroup xmlAdhocGroup = new XmlAdhocGroup();
        xmlAdhocGroup.setName(adhocGroup.getName());
        xmlAdhocGroup.setStartInNewPage(adhocGroup.getStartInNewPage());
        xmlAdhocGroup.setHeaderLayout(this.groupHeaderLayout(adhocGroup.getHeaderLayout()));
        xmlAdhocGroup.setStyle(this.style(adhocGroup.getStyle()));
        xmlAdhocGroup.setTitleStyle(this.style(adhocGroup.getTitleStyle()));
        if (adhocGroup.getProperties() != null && !adhocGroup.getProperties().isEmpty()) {
            this.properties(adhocGroup.getProperties(), xmlAdhocGroup.getProperty());
        }
        return xmlAdhocGroup;
    }

    protected XmlAdhocGroupHeaderLayout groupHeaderLayout(AdhocGroupHeaderLayout adhocGroupHeaderLayout) {
        if (adhocGroupHeaderLayout == null) {
            return null;
        }
        switch (adhocGroupHeaderLayout) {
            case EMPTY: {
                return XmlAdhocGroupHeaderLayout.EMPTY;
            }
            case VALUE: {
                return XmlAdhocGroupHeaderLayout.VALUE;
            }
            case TITLE_AND_VALUE: {
                return XmlAdhocGroupHeaderLayout.TITLE_AND_VALUE;
            }
        }
        throw new AdhocException("Group header layout " + adhocGroupHeaderLayout.name() + " not supported");
    }

    protected XmlAdhocSubtotal subtotal(AdhocSubtotal adhocSubtotal) {
        XmlAdhocSubtotal xmlAdhocSubtotal = new XmlAdhocSubtotal();
        xmlAdhocSubtotal.setName(adhocSubtotal.getName());
        xmlAdhocSubtotal.setLabel(adhocSubtotal.getLabel());
        xmlAdhocSubtotal.setCalculation(this.calculation(adhocSubtotal.getCalculation()));
        xmlAdhocSubtotal.setStyle(this.style(adhocSubtotal.getStyle()));
        xmlAdhocSubtotal.setLabelStyle(this.style(adhocSubtotal.getLabelStyle()));
        xmlAdhocSubtotal.setPosition(this.subtotalPosition(adhocSubtotal.getPosition()));
        xmlAdhocSubtotal.setGroupName(adhocSubtotal.getGroupName());
        return xmlAdhocSubtotal;
    }

    protected XmlAdhocCalculation calculation(AdhocCalculation adhocCalculation) {
        if (adhocCalculation == null) {
            return null;
        }
        switch (adhocCalculation) {
            case NOTHING: {
                return XmlAdhocCalculation.NOTHING;
            }
            case COUNT: {
                return XmlAdhocCalculation.COUNT;
            }
            case SUM: {
                return XmlAdhocCalculation.SUM;
            }
            case AVERAGE: {
                return XmlAdhocCalculation.AVERAGE;
            }
            case LOWEST: {
                return XmlAdhocCalculation.LOWEST;
            }
            case HIGHEST: {
                return XmlAdhocCalculation.HIGHEST;
            }
            case STANDARD_DEVIATION: {
                return XmlAdhocCalculation.STANDARD_DEVIATION;
            }
            case VARIANCE: {
                return XmlAdhocCalculation.VARIANCE;
            }
            case FIRST: {
                return XmlAdhocCalculation.FIRST;
            }
            case DISTINCT_COUNT: {
                return XmlAdhocCalculation.DISTINCT_COUNT;
            }
        }
        throw new AdhocException("Calculation " + adhocCalculation.name() + " not supported");
    }

    protected XmlAdhocSubtotalPosition subtotalPosition(AdhocSubtotalPosition adhocSubtotalPosition) {
        if (adhocSubtotalPosition == null) {
            return null;
        }
        switch (adhocSubtotalPosition) {
            case TITLE: {
                return XmlAdhocSubtotalPosition.TITLE;
            }
            case PAGE_HEADER: {
                return XmlAdhocSubtotalPosition.PAGE_HEADER;
            }
            case PAGE_FOOTER: {
                return XmlAdhocSubtotalPosition.PAGE_FOOTER;
            }
            case COLUMN_HEADER: {
                return XmlAdhocSubtotalPosition.COLUMN_HEADER;
            }
            case COLUMN_FOOTER: {
                return XmlAdhocSubtotalPosition.COLUMN_FOOTER;
            }
            case GROUP_HEADER: {
                return XmlAdhocSubtotalPosition.GROUP_HEADER;
            }
            case GROUP_FOOTER: {
                return XmlAdhocSubtotalPosition.GROUP_FOOTER;
            }
            case FIRST_GROUP_HEADER: {
                return XmlAdhocSubtotalPosition.FIRST_GROUP_HEADER;
            }
            case FIRST_GROUP_FOOTER: {
                return XmlAdhocSubtotalPosition.FIRST_GROUP_FOOTER;
            }
            case LAST_GROUP_HEADER: {
                return XmlAdhocSubtotalPosition.LAST_GROUP_HEADER;
            }
            case LAST_GROUP_FOOTER: {
                return XmlAdhocSubtotalPosition.LAST_GROUP_FOOTER;
            }
            case LAST_PAGE_FOOTER: {
                return XmlAdhocSubtotalPosition.LAST_PAGE_FOOTER;
            }
            case SUMMARY: {
                return XmlAdhocSubtotalPosition.SUMMARY;
            }
        }
        throw new AdhocException("SubtotalPosition " + adhocSubtotalPosition.name() + " not supported");
    }

    protected XmlAdhocSort sort(AdhocSort adhocSort) {
        XmlAdhocSort xmlAdhocSort = new XmlAdhocSort();
        xmlAdhocSort.setName(adhocSort.getName());
        xmlAdhocSort.setOrderType(this.orderType(adhocSort.getOrderType()));
        return xmlAdhocSort;
    }

    protected XmlAdhocOrderType orderType(AdhocOrderType adhocOrderType) {
        if (adhocOrderType == null) {
            return null;
        }
        switch (adhocOrderType) {
            case ASCENDING: {
                return XmlAdhocOrderType.ASCENDING;
            }
            case DESCENDING: {
                return XmlAdhocOrderType.DESCENDING;
            }
        }
        throw new AdhocException("Order type " + adhocOrderType.name() + " not supported");
    }

    protected XmlAdhocStyle style(AdhocStyle adhocStyle) {
        if (adhocStyle == null) {
            return null;
        }
        XmlAdhocStyle xmlAdhocStyle = new XmlAdhocStyle();
        xmlAdhocStyle.setFont(this.font(adhocStyle.getFont()));
        xmlAdhocStyle.setTopBorder(this.pen(adhocStyle.getTopBorder()));
        xmlAdhocStyle.setLeftBorder(this.pen(adhocStyle.getLeftBorder()));
        xmlAdhocStyle.setBottomBorder(this.pen(adhocStyle.getBottomBorder()));
        xmlAdhocStyle.setRightBorder(this.pen(adhocStyle.getRightBorder()));
        xmlAdhocStyle.setForegroundColor(this.color(adhocStyle.getForegroundColor()));
        xmlAdhocStyle.setBackgroundColor(this.color(adhocStyle.getBackgroundColor()));
        xmlAdhocStyle.setHorizontalAlignment(this.horizontalAlignment(adhocStyle.getHorizontalAlignment()));
        xmlAdhocStyle.setVerticalAlignment(this.verticalAlignment(adhocStyle.getVerticalAlignment()));
        xmlAdhocStyle.setPattern(adhocStyle.getPattern());
        return xmlAdhocStyle;
    }

    protected String color(Color color) {
        if (color == null) {
            return null;
        }
        int colorMask = Integer.parseInt("FFFFFF", 16);
        int rgb = color.getRGB();
        String hex = Integer.toHexString(rgb & colorMask).toUpperCase();
        return "#" + ("000000" + hex).substring(hex.length());
    }

    protected XmlAdhocFont font(AdhocFont adhocFont) {
        if (adhocFont == null) {
            return null;
        }
        XmlAdhocFont xmlAdhocFont = new XmlAdhocFont();
        xmlAdhocFont.setFontName(adhocFont.getFontName());
        xmlAdhocFont.setFontSize(adhocFont.getFontSize());
        xmlAdhocFont.setBold(adhocFont.getBold());
        xmlAdhocFont.setItalic(adhocFont.getItalic());
        xmlAdhocFont.setUnderline(adhocFont.getUnderline());
        xmlAdhocFont.setStrikeThrough(adhocFont.getStrikeThrough());
        return xmlAdhocFont;
    }

    protected XmlAdhocPen pen(AdhocPen adhocPen) {
        if (adhocPen == null) {
            return null;
        }
        XmlAdhocPen xmlAdhocPen = new XmlAdhocPen();
        xmlAdhocPen.setLineWidth(adhocPen.getLineWidth());
        xmlAdhocPen.setLineColor(this.color(adhocPen.getLineColor()));
        return xmlAdhocPen;
    }

    protected XmlAdhocHorizontalAlignment horizontalAlignment(AdhocHorizontalAlignment adhocHorizontalAlignment) {
        if (adhocHorizontalAlignment == null) {
            return null;
        }
        switch (adhocHorizontalAlignment) {
            case LEFT: {
                return XmlAdhocHorizontalAlignment.LEFT;
            }
            case CENTER: {
                return XmlAdhocHorizontalAlignment.CENTER;
            }
            case RIGHT: {
                return XmlAdhocHorizontalAlignment.RIGHT;
            }
            case JUSTIFIED: {
                return XmlAdhocHorizontalAlignment.JUSTIFIED;
            }
        }
        throw new AdhocException("Horizontal alignment " + adhocHorizontalAlignment.name() + " not supported");
    }

    protected XmlAdhocVerticalAlignment verticalAlignment(AdhocVerticalAlignment adhocVerticalAlignment) {
        if (adhocVerticalAlignment == null) {
            return null;
        }
        switch (adhocVerticalAlignment) {
            case TOP: {
                return XmlAdhocVerticalAlignment.TOP;
            }
            case MIDDLE: {
                return XmlAdhocVerticalAlignment.MIDDLE;
            }
            case BOTTOM: {
                return XmlAdhocVerticalAlignment.BOTTOM;
            }
            case JUSTIFIED: {
                return XmlAdhocVerticalAlignment.JUSTIFIED;
            }
        }
        throw new AdhocException("Vertical alignment " + adhocVerticalAlignment.name() + " not supported");
    }

    protected XmlAdhocPage page(AdhocPage adhocPage) {
        if (adhocPage == null) {
            return null;
        }
        XmlAdhocPage xmlAdhocPage = new XmlAdhocPage();
        xmlAdhocPage.setWidth(adhocPage.getWidth());
        xmlAdhocPage.setHeight(adhocPage.getHeight());
        xmlAdhocPage.setOrientation(this.pageOrientation(adhocPage.getOrientation()));
        xmlAdhocPage.setTopMargin(adhocPage.getTopMargin());
        xmlAdhocPage.setBottomMargin(adhocPage.getBottomMargin());
        xmlAdhocPage.setLeftMargin(adhocPage.getLeftMargin());
        xmlAdhocPage.setRightMargin(adhocPage.getRightMargin());
        xmlAdhocPage.setIgnorePageWidth(adhocPage.getIgnorePageWidth());
        return xmlAdhocPage;
    }

    protected XmlAdhocPageOrientation pageOrientation(AdhocPageOrientation adhocPageOrientation) {
        if (adhocPageOrientation == null) {
            return null;
        }
        switch (adhocPageOrientation) {
            case PORTRAIT: {
                return XmlAdhocPageOrientation.PORTRAIT;
            }
            case LANDSCAPE: {
                return XmlAdhocPageOrientation.LANDSCAPE;
            }
        }
        throw new AdhocException("Page orientation " + adhocPageOrientation.name() + " not supported");
    }

    protected XmlAdhocComponent component(AdhocComponent adhocComponent) {
        if (adhocComponent instanceof AdhocTextField) {
            XmlAdhocTextField xmlAdhocComponent = new XmlAdhocTextField();
            this.textField((AdhocTextField)adhocComponent, xmlAdhocComponent);
            return xmlAdhocComponent;
        }
        if (adhocComponent instanceof AdhocChart) {
            XmlAdhocChart xmlAdhocComponent = new XmlAdhocChart();
            this.chart((AdhocChart)adhocComponent, xmlAdhocComponent);
            return xmlAdhocComponent;
        }
        XmlAdhocComponent xmlAdhocComponent = new XmlAdhocComponent();
        this.component(adhocComponent, xmlAdhocComponent);
        return xmlAdhocComponent;
    }

    protected void component(AdhocComponent adhocComponent, XmlAdhocComponent xmlAdhocComponent) {
        xmlAdhocComponent.setKey(adhocComponent.getKey());
        xmlAdhocComponent.setStyle(this.style(adhocComponent.getStyle()));
        xmlAdhocComponent.setWidth(adhocComponent.getWidth());
        xmlAdhocComponent.setHeight(adhocComponent.getHeight());
        if (adhocComponent.getProperties() != null && !adhocComponent.getProperties().isEmpty()) {
            this.properties(adhocComponent.getProperties(), xmlAdhocComponent.getProperty());
        }
    }

    protected void textField(AdhocTextField adhocTextField, XmlAdhocTextField xmlAdhocTextField) {
        this.component(adhocTextField, xmlAdhocTextField);
        xmlAdhocTextField.setText(adhocTextField.getText());
    }

    protected void chart(AdhocChart adhocChart, XmlAdhocChart xmlAdhocChart) {
        this.component(adhocChart, xmlAdhocChart);
        xmlAdhocChart.setType(this.chartType(adhocChart.getType()));
        xmlAdhocChart.setTitle(adhocChart.getTitle());
        xmlAdhocChart.setTitleFont(this.font(adhocChart.getTitleFont()));
        xmlAdhocChart.setTitleColor(this.color(adhocChart.getTitleColor()));
        xmlAdhocChart.setShowLegend(adhocChart.getShowLegend());
        xmlAdhocChart.setXValue(adhocChart.getXValue());
        if (adhocChart.getSeries() != null && !adhocChart.getSeries().isEmpty()) {
            for (AdhocChartSerie adhocChartSerie : adhocChart.getSeries()) {
                xmlAdhocChart.getSerie().add(this.chartSerie(adhocChartSerie));
            }
        }
        if (adhocChart.getSeriesColors() != null && !adhocChart.getSeriesColors().isEmpty()) {
            for (Color adhocSeriesColor : adhocChart.getSeriesColors()) {
                xmlAdhocChart.getSeriesColors().add(this.color(adhocSeriesColor));
            }
        }
        xmlAdhocChart.setXAxisFormat(this.axisFormat(adhocChart.getXAxisFormat()));
        xmlAdhocChart.setYAxisFormat(this.axisFormat(adhocChart.getYAxisFormat()));
        xmlAdhocChart.setOrientation(this.orientation(adhocChart.getOrientation()));
    }

    protected XmlAdhocOrientation orientation(AdhocOrientation adhocOrientation) {
        if (adhocOrientation == null) {
            return null;
        }
        switch (adhocOrientation) {
            case HORIZONTAL: {
                return XmlAdhocOrientation.HORIZONTAL;
            }
            case VERTICAL: {
                return XmlAdhocOrientation.VERTICAL;
            }
        }
        throw new AdhocException("Orientation " + adhocOrientation.name() + " not supported");
    }

    protected XmlAdhocAxisFormat axisFormat(AdhocAxisFormat adhocAxisFormat) {
        if (adhocAxisFormat == null) {
            return null;
        }
        XmlAdhocAxisFormat xmlAdhocAxisFormat = new XmlAdhocAxisFormat();
        xmlAdhocAxisFormat.setLabel(adhocAxisFormat.getLabel());
        xmlAdhocAxisFormat.setLabelFont(this.font(adhocAxisFormat.getLabelFont()));
        xmlAdhocAxisFormat.setLabelColor(this.color(adhocAxisFormat.getLabelColor()));
        return xmlAdhocAxisFormat;
    }

    protected XmlAdhocChartSerie chartSerie(AdhocChartSerie adhocChartSerie) {
        XmlAdhocChartSerie xmlAdhocChartSerie = new XmlAdhocChartSerie();
        xmlAdhocChartSerie.setSeries(adhocChartSerie.getSeries());
        xmlAdhocChartSerie.setXValue(adhocChartSerie.getXValue());
        xmlAdhocChartSerie.setYValue(adhocChartSerie.getYValue());
        xmlAdhocChartSerie.setZValue(adhocChartSerie.getZValue());
        xmlAdhocChartSerie.setLabel(adhocChartSerie.getLabel());
        if (adhocChartSerie.getProperties() != null && !adhocChartSerie.getProperties().isEmpty()) {
            this.properties(adhocChartSerie.getProperties(), xmlAdhocChartSerie.getProperty());
        }
        return xmlAdhocChartSerie;
    }

    protected XmlAdhocChartType chartType(AdhocChartType adhocChartType) {
        if (adhocChartType == null) {
            return null;
        }
        switch (adhocChartType) {
            case AREA: {
                return XmlAdhocChartType.AREA;
            }
            case STACKEDAREA: {
                return XmlAdhocChartType.STACKEDAREA;
            }
            case BAR: {
                return XmlAdhocChartType.BAR;
            }
            case STACKEDBAR: {
                return XmlAdhocChartType.STACKEDBAR;
            }
            case GROUPEDSTACKEDBAR: {
                return XmlAdhocChartType.GROUPEDSTACKEDBAR;
            }
            case BAR3D: {
                return XmlAdhocChartType.BAR_3_D;
            }
            case STACKEDBAR3D: {
                return XmlAdhocChartType.STACKEDBAR_3_D;
            }
            case LINE: {
                return XmlAdhocChartType.LINE;
            }
            case LAYEREDBAR: {
                return XmlAdhocChartType.LAYEREDBAR;
            }
            case WATERFALLBAR: {
                return XmlAdhocChartType.WATERFALLBAR;
            }
            case DIFFERENCE: {
                return XmlAdhocChartType.DIFFERENCE;
            }
            case PIE: {
                return XmlAdhocChartType.PIE;
            }
            case PIE3D: {
                return XmlAdhocChartType.PIE_3_D;
            }
            case SCATTER: {
                return XmlAdhocChartType.SCATTER;
            }
            case SPIDER: {
                return XmlAdhocChartType.SPIDER;
            }
            case TIMESERIES: {
                return XmlAdhocChartType.TIMESERIES;
            }
            case XYAREA: {
                return XmlAdhocChartType.XYAREA;
            }
            case XYBAR: {
                return XmlAdhocChartType.XYBAR;
            }
            case XYLINE: {
                return XmlAdhocChartType.XYLINE;
            }
            case XYSTEP: {
                return XmlAdhocChartType.XYSTEP;
            }
            case BUBBLE: {
                return XmlAdhocChartType.BUBBLE;
            }
        }
        throw new AdhocException("Chart type " + adhocChartType.name() + " not supported");
    }

    protected XmlAdhocFilter filter(AdhocFilter adhocFilter) {
        log.debug("Converting adhocFilter : {} into XmlAdhocFilter", (Object)adhocFilter);
        if (adhocFilter == null) {
            return null;
        }
        XmlAdhocFilter xmlAdhocFilter = new XmlAdhocFilter();
        if (adhocFilter.getRestrictions() != null && !adhocFilter.getRestrictions().isEmpty()) {
            for (AdhocRestriction adhocRestriction : adhocFilter.getRestrictions()) {
                xmlAdhocFilter.getRestriction().add(this.restriction(adhocRestriction));
            }
        }
        log.debug("XmlAdhocFilter : {} generated from AdhocFilter : {}", (Object)xmlAdhocFilter, (Object)adhocFilter);
        return xmlAdhocFilter;
    }

    protected XmlAdhocRestriction restriction(AdhocRestriction adhocRestriction) {
        if (adhocRestriction instanceof AdhocValueRestriction) {
            XmlAdhocValueRestriction xmlAdhocRestriction = new XmlAdhocValueRestriction();
            this.valueRestriction((AdhocValueRestriction)adhocRestriction, xmlAdhocRestriction);
            return xmlAdhocRestriction;
        }
        XmlAdhocRestriction xmlAdhocRestriction = new XmlAdhocRestriction();
        this.restriction(adhocRestriction, xmlAdhocRestriction);
        return xmlAdhocRestriction;
    }

    protected void restriction(AdhocRestriction adhocRestriction, XmlAdhocRestriction xmlAdhocRestriction) {
        xmlAdhocRestriction.setKey(adhocRestriction.getKey());
        if (adhocRestriction.getProperties() != null && !adhocRestriction.getProperties().isEmpty()) {
            this.properties(adhocRestriction.getProperties(), xmlAdhocRestriction.getProperty());
        }
    }

    protected void valueRestriction(AdhocValueRestriction adhocValueRestriction, XmlAdhocValueRestriction xmlAdhocValueRestriction) {
        this.restriction(adhocValueRestriction, xmlAdhocValueRestriction);
        xmlAdhocValueRestriction.setName(adhocValueRestriction.getName());
        xmlAdhocValueRestriction.setOperator(this.valueOperator(adhocValueRestriction.getOperator()));
        if (adhocValueRestriction.getValues() != null && !adhocValueRestriction.getValues().isEmpty()) {
            for (String value : adhocValueRestriction.getValues()) {
                xmlAdhocValueRestriction.getValue().add(value);
            }
        }
    }

    protected XmlAdhocValueOperator valueOperator(AdhocValueOperator adhocValueOperator) {
        if (adhocValueOperator == null) {
            return null;
        }
        switch (adhocValueOperator) {
            case EQUAL: {
                return XmlAdhocValueOperator.EQUAL;
            }
            case UNEQUAL: {
                return XmlAdhocValueOperator.UNEQUAL;
            }
            case IN: {
                return XmlAdhocValueOperator.IN;
            }
            case NOT_IN: {
                return XmlAdhocValueOperator.NOT_IN;
            }
            case LIKE: {
                return XmlAdhocValueOperator.LIKE;
            }
            case NOT_LIKE: {
                return XmlAdhocValueOperator.NOT_LIKE;
            }
            case START_WITH: {
                return XmlAdhocValueOperator.START_WITH;
            }
            case NOT_START_WITH: {
                return XmlAdhocValueOperator.NOT_START_WITH;
            }
            case END_WITH: {
                return XmlAdhocValueOperator.END_WITH;
            }
            case NOT_END_WITH: {
                return XmlAdhocValueOperator.NOT_END_WITH;
            }
            case GREATER: {
                return XmlAdhocValueOperator.GREATER;
            }
            case GREATER_OR_EQUAL: {
                return XmlAdhocValueOperator.GREATER_OR_EQUAL;
            }
            case SMALLER: {
                return XmlAdhocValueOperator.SMALLER;
            }
            case SMALLER_OR_EQUAL: {
                return XmlAdhocValueOperator.SMALLER_OR_EQUAL;
            }
            case BETWEEN: {
                return XmlAdhocValueOperator.BETWEEN;
            }
            case NOT_BETWEEN: {
                return XmlAdhocValueOperator.NOT_BETWEEN;
            }
            case IS_NOT_NULL: {
                return XmlAdhocValueOperator.IS_NOT_NULL;
            }
            case IS_NULL: {
                return XmlAdhocValueOperator.IS_NULL;
            }
        }
        throw new AdhocException("Value operator " + adhocValueOperator.name() + " not supported");
    }
}

