/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.adhoc;

import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.dynamicreports.adhoc.configuration.AdhocConfiguration;
import net.sf.dynamicreports.adhoc.configuration.AdhocReport;
import net.sf.dynamicreports.adhoc.exception.ConfigurationMarshallerException;
import net.sf.dynamicreports.adhoc.exception.ConfigurationUnMarshallerException;
import net.sf.dynamicreports.adhoc.report.AdhocReportCustomizer;
import net.sf.dynamicreports.adhoc.report.DefaultAdhocReportCustomizer;
import net.sf.dynamicreports.adhoc.transformation.AdhocToXmlTransform;
import net.sf.dynamicreports.adhoc.transformation.XmlToAdhocTransform;
import net.sf.dynamicreports.adhoc.xmlconfiguration.ObjectFactory;
import net.sf.dynamicreports.adhoc.xmlconfiguration.XmlAdhocConfiguration;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.ReportBuilder;
import net.sf.dynamicreports.report.exception.DRException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdhocManager {
    private static final Logger log = LoggerFactory.getLogger(AdhocManager.class);
    private static volatile AdhocManager INSTANCE = null;
    private final AdhocToXmlTransform adhocToXmlTransform;
    private final XmlToAdhocTransform xmlToAdhocTransform;

    private AdhocManager(AdhocToXmlTransform adhocToXmlTransform, XmlToAdhocTransform xmlToAdhocTransform) {
        this.adhocToXmlTransform = adhocToXmlTransform;
        this.xmlToAdhocTransform = xmlToAdhocTransform;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AdhocManager getInstance(AdhocToXmlTransform adhocToXmlTransform, XmlToAdhocTransform xmlToAdhocTransform) {
        if (INSTANCE != null) return INSTANCE;
        Class<AdhocManager> clazz = AdhocManager.class;
        synchronized (AdhocManager.class) {
            INSTANCE = new AdhocManager(adhocToXmlTransform, xmlToAdhocTransform);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public JasperReportBuilder createReport(AdhocReport adhocReport) throws DRException {
        log.debug("Creating JasperReportBuilder from adhocReport: {} using defaultAdhocReportCustomizer", adhocReport.getProperties().getProperties());
        return this.createReport(adhocReport, new DefaultAdhocReportCustomizer());
    }

    public JasperReportBuilder createReport(AdhocReport adhocReport, AdhocReportCustomizer adhocReportCustomizer) throws DRException {
        log.debug("Creating JasperReportBuilder from adhocReport: {} and adhocReportCustomizer : {}", adhocReport.getProperties().getProperties(), (Object)adhocReportCustomizer);
        JasperReportBuilder report = DynamicReports.report();
        adhocReportCustomizer.customize((ReportBuilder<?>)report, adhocReport);
        return report;
    }

    public void saveConfiguration(AdhocConfiguration adhocConfiguration, OutputStream os) throws DRException {
        log.info("Saving the AdhocConfiguration : {} to the outputStream {} in XML format using JAXB Api", adhocConfiguration.getReport().getProperties().getProperties(), (Object)os.toString());
        XmlAdhocConfiguration xmlAdhocConfiguration = this.adhocToXmlTransform.transform(adhocConfiguration);
        JAXBElement<XmlAdhocConfiguration> element = null;
        try {
            Marshaller marshaller = JAXBContext.newInstance((Class[])new Class[]{XmlAdhocConfiguration.class}).createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            element = new ObjectFactory().createConfiguration(xmlAdhocConfiguration);
            marshaller.marshal(element, (Result)new StreamResult(os));
        }
        catch (JAXBException e) {
            throw new ConfigurationMarshallerException(element, os);
        }
    }

    public AdhocConfiguration loadConfiguration(InputStream is) throws DRException {
        try {
            Unmarshaller unmarshaller = JAXBContext.newInstance((Class[])new Class[]{XmlAdhocConfiguration.class}).createUnmarshaller();
            JAXBElement element = unmarshaller.unmarshal((Source)new StreamSource(is), XmlAdhocConfiguration.class);
            XmlAdhocConfiguration xmlAdhocConfiguration = (XmlAdhocConfiguration)element.getValue();
            return this.xmlToAdhocTransform.transform(xmlAdhocConfiguration);
        }
        catch (JAXBException e) {
            throw new ConfigurationUnMarshallerException(is);
        }
    }
}

