/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.web.csskit.antlr;

import cz.vutbr.web.css.CSSException;
import cz.vutbr.web.css.CSSFactory;
import cz.vutbr.web.css.RuleBlock;
import cz.vutbr.web.css.StyleSheet;
import cz.vutbr.web.csskit.PriorityStrategy;
import cz.vutbr.web.csskit.antlr.CSSInputStream;
import cz.vutbr.web.csskit.antlr.CSSLexer;
import cz.vutbr.web.csskit.antlr.CSSParser;
import cz.vutbr.web.csskit.antlr.CSSTreeParser;
import cz.vutbr.web.csskit.antlr.Preparator;
import cz.vutbr.web.csskit.antlr.SimplePreparator;
import cz.vutbr.web.csskit.antlr.TreeUtil;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.atomic.AtomicInteger;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.antlr.runtime.tree.TreeNodeStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class CSSParserFactory {
    private static final Logger log = LoggerFactory.getLogger(CSSParserFactory.class);
    private static RuleBlock.Priority lastPriority = null;

    private CSSParserFactory() {
        throw new AssertionError();
    }

    public static StyleSheet parse(Object source, String encoding, SourceType type, Element inline, boolean inlinePriority, URL base) throws IOException, CSSException {
        StyleSheet sheet = (StyleSheet)CSSFactory.getRuleFactory().createStyleSheet().unlock();
        AtomicPriorityStrategy ps = new AtomicPriorityStrategy(lastPriority);
        SimplePreparator preparator = new SimplePreparator(ps, inline, inlinePriority);
        CSSTreeParser parser = CSSParserFactory.createParser(source, encoding, type, preparator, sheet, base);
        StyleSheet ret = type.parse(parser);
        lastPriority = ret.getLastMark();
        return ret;
    }

    public static StyleSheet parse(Object source, String encoding, SourceType type, URL base) throws IOException, CSSException {
        if (type == SourceType.INLINE) {
            throw new IllegalArgumentException("Missing element for INLINE input");
        }
        return CSSParserFactory.parse(source, encoding, type, null, false, base);
    }

    public static StyleSheet append(Object source, String encoding, SourceType type, Element inline, boolean inlinePriority, StyleSheet sheet, URL base) throws IOException, CSSException {
        RuleBlock.Priority start = sheet.getLastMark();
        if (start == null) {
            start = lastPriority;
        }
        AtomicPriorityStrategy ps = new AtomicPriorityStrategy(start);
        SimplePreparator preparator = new SimplePreparator(ps, inline, inlinePriority);
        CSSTreeParser parser = CSSParserFactory.createParser(source, encoding, type, preparator, sheet, base);
        StyleSheet ret = type.parse(parser);
        lastPriority = ret.getLastMark();
        return ret;
    }

    public static StyleSheet append(Object source, String encoding, SourceType type, StyleSheet sheet, URL base) throws IOException, CSSException {
        if (type == SourceType.INLINE) {
            throw new IllegalArgumentException("Missing element for INLINE input");
        }
        return CSSParserFactory.append(source, encoding, type, null, false, sheet, base);
    }

    public static void resetPriority() {
        lastPriority = null;
    }

    private static CSSTreeParser createParser(Object source, String encoding, SourceType type, Preparator preparator, StyleSheet stylesheet, URL base) throws IOException, CSSException {
        CSSInputStream input = type.getInput(source, encoding);
        input.setBase(base);
        CommonTokenStream tokens = CSSParserFactory.feedLexer(input, stylesheet);
        CommonTree ast = CSSParserFactory.feedParser(tokens, type, stylesheet);
        return CSSParserFactory.feedAST(tokens, ast, preparator, stylesheet);
    }

    private static CommonTokenStream feedLexer(CSSInputStream source, StyleSheet stylesheet) throws CSSException {
        try {
            CSSLexer lexer = new CSSLexer(source);
            lexer.init(stylesheet);
            return new CommonTokenStream((TokenSource)lexer);
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof CSSException) {
                throw (CSSException)re.getCause();
            }
            log.error("LEXER THROWS:", (Throwable)re);
            throw re;
        }
    }

    private static CommonTree feedParser(CommonTokenStream source, SourceType type, StyleSheet stylesheet) throws CSSException {
        CSSParser parser = new CSSParser((TokenStream)source);
        parser.init(stylesheet);
        return type.getAST(parser);
    }

    private static CSSTreeParser feedAST(CommonTokenStream source, CommonTree ast, Preparator preparator, StyleSheet stylesheet) {
        if (log.isTraceEnabled()) {
            log.trace("Feeding tree parser with AST:\n{}", (Object)TreeUtil.toStringTree(ast));
        }
        CommonTreeNodeStream nodes = new CommonTreeNodeStream((Object)ast);
        nodes.setTokenStream((TokenStream)source);
        CSSTreeParser parser = new CSSTreeParser((TreeNodeStream)nodes);
        return parser.init(stylesheet, preparator);
    }

    private static final class PriorityImpl
    implements RuleBlock.Priority {
        final int priority;

        public PriorityImpl(int priority) {
            this.priority = priority;
        }

        public int compareTo(RuleBlock.Priority o) {
            PriorityImpl other = (PriorityImpl)o;
            return this.priority - other.priority;
        }

        public String toString() {
            return String.valueOf(this.priority);
        }
    }

    private static final class SimplePriorityStrategy
    implements PriorityStrategy {
        private int counter;

        public SimplePriorityStrategy() {
            this.counter = 0;
        }

        public SimplePriorityStrategy(RuleBlock.Priority last) {
            if (!(last instanceof PriorityImpl)) {
                throw new ClassCastException("Unable to continue with priority class provided: " + last.getClass());
            }
            this.counter = ((PriorityImpl)last).priority;
        }

        public RuleBlock.Priority getAndIncrement() {
            return new PriorityImpl(this.counter++);
        }

        public RuleBlock.Priority markAndIncrement() {
            return new PriorityImpl(this.counter++);
        }
    }

    private static final class AtomicPriorityStrategy
    implements PriorityStrategy {
        private final AtomicInteger counter;

        public AtomicPriorityStrategy() {
            this.counter = new AtomicInteger(0);
        }

        public AtomicPriorityStrategy(RuleBlock.Priority last) {
            if (last == null) {
                this.counter = new AtomicInteger(0);
            } else {
                if (!(last instanceof PriorityImpl)) {
                    throw new ClassCastException("Unable to continue with priority class provided: " + last.getClass());
                }
                this.counter = new AtomicInteger(((PriorityImpl)last).priority);
            }
        }

        public RuleBlock.Priority getAndIncrement() {
            return new PriorityImpl(this.counter.incrementAndGet());
        }

        public RuleBlock.Priority markAndIncrement() {
            return new PriorityImpl(this.counter.incrementAndGet());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SourceType {
        INLINE{

            public CommonTree getAST(CSSParser parser) throws CSSException {
                try {
                    CSSParser.inlinestyle_return retval = parser.inlinestyle();
                    return (CommonTree)retval.getTree();
                }
                catch (RecognitionException re) {
                    throw SourceType.encapsulateException(re, "Unable to parse inline CSS style");
                }
                catch (RuntimeException re) {
                    throw SourceType.encapsulateException(re, "Unable to parse inline CSS style");
                }
            }

            public StyleSheet parse(CSSTreeParser parser) throws CSSException {
                try {
                    return parser.inlinestyle();
                }
                catch (RecognitionException re) {
                    throw SourceType.encapsulateException(re, "Unable to parse inline CSS style [AST]");
                }
                catch (RuntimeException re) {
                    throw SourceType.encapsulateException(re, "Unable to parse inline CSS style [AST]");
                }
            }

            public CSSInputStream getInput(Object source, String encoding) throws IOException {
                return CSSInputStream.stringStream((String)source);
            }
        }
        ,
        EMBEDDED{

            public CommonTree getAST(CSSParser parser) throws CSSException {
                try {
                    CSSParser.stylesheet_return retval = parser.stylesheet();
                    return (CommonTree)retval.getTree();
                }
                catch (RecognitionException re) {
                    throw SourceType.encapsulateException(re, "Unable to parse embedded CSS style");
                }
                catch (RuntimeException re) {
                    throw SourceType.encapsulateException(re, "Unable to parse embedded CSS style");
                }
            }

            public StyleSheet parse(CSSTreeParser parser) throws CSSException {
                try {
                    return parser.stylesheet();
                }
                catch (RecognitionException re) {
                    throw SourceType.encapsulateException(re, "Unable to parse embedded CSS style [AST]");
                }
                catch (RuntimeException re) {
                    throw SourceType.encapsulateException(re, "Unable to parse embedded CSS style [AST]");
                }
            }

            public CSSInputStream getInput(Object source, String encoding) throws IOException {
                return CSSInputStream.stringStream((String)source);
            }
        }
        ,
        URL{

            public CommonTree getAST(CSSParser parser) throws CSSException {
                try {
                    CSSParser.stylesheet_return retval = parser.stylesheet();
                    return (CommonTree)retval.getTree();
                }
                catch (RecognitionException re) {
                    throw SourceType.encapsulateException(re, "Unable to parse URL CSS style");
                }
                catch (RuntimeException re) {
                    throw SourceType.encapsulateException(re, "Unable to parse URL CSS style");
                }
            }

            public StyleSheet parse(CSSTreeParser parser) throws CSSException {
                try {
                    return parser.stylesheet();
                }
                catch (RecognitionException re) {
                    throw SourceType.encapsulateException(re, "Unable to parse file CSS style [AST]");
                }
                catch (RuntimeException re) {
                    throw SourceType.encapsulateException(re, "Unable to parse file CSS style [AST]");
                }
            }

            public CSSInputStream getInput(Object source, String encoding) throws IOException {
                return CSSInputStream.urlStream((URL)source, encoding);
            }
        };


        public abstract CSSInputStream getInput(Object var1, String var2) throws IOException;

        public abstract CommonTree getAST(CSSParser var1) throws CSSException;

        public abstract StyleSheet parse(CSSTreeParser var1) throws CSSException;

        private static CSSException encapsulateException(Throwable t, String msg) {
            log.error("THROWN:", t);
            return new CSSException(msg, t);
        }
    }
}

