/*
 * Decompiled with CFR 0.152.
 */
package net.soulwolf.widget.speedyselector;

import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.support.annotation.NonNull;
import net.soulwolf.widget.speedyselector.SpeedyArrayMap;
import net.soulwolf.widget.speedyselector.StateType;

class SpeedyStateListDrawable {
    SpeedyArrayMap<int[], Drawable> mSpeedyArrayMap = new SpeedyArrayMap();
    int[] mDefaultStateSet;
    Drawable mDrawable;

    public SpeedyStateListDrawable() {
    }

    public SpeedyStateListDrawable(Drawable drawable) {
        this();
        this.addStateDrawable(drawable);
    }

    public void addStateDrawable(Drawable drawable) {
        this.addStateDrawable(StateType.STATE_DEFAULT, drawable);
    }

    public void addStateDrawable(@NonNull StateType state, Drawable drawable) {
        if (drawable == null) {
            return;
        }
        if (state == StateType.STATE_DEFAULT) {
            this.mDefaultStateSet = state.mCurrentStateSet;
            this.mDrawable = drawable;
        } else {
            this.mSpeedyArrayMap.putFirst(state.getStateSet(), drawable);
        }
    }

    public StateListDrawable build() {
        StateListDrawable stateListDrawable = new StateListDrawable();
        SpeedyArrayMap<int[], Drawable> speedyArrayMap = this.mSpeedyArrayMap.copy();
        speedyArrayMap.put(this.mDefaultStateSet, this.mDrawable);
        for (SpeedyArrayMap.Entry<int[], Drawable> entry : speedyArrayMap.entryList()) {
            stateListDrawable.addState(entry.getKey(), entry.getValue());
        }
        return stateListDrawable;
    }
}

