/*
 * Decompiled with CFR 0.152.
 */
package net.soulwolf.widget.speedyselector;

import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TextView;
import net.soulwolf.widget.speedyselector.BackgroundDelegate;
import net.soulwolf.widget.speedyselector.GeneralDelegate;
import net.soulwolf.widget.speedyselector.SelectorMode;
import net.soulwolf.widget.speedyselector.StateType;

public final class SpeedySelectorDelegate<GENERAL extends TextView, BACKGROUND extends View> {
    private GeneralDelegate mGeneralDelegate;
    private BackgroundDelegate mBackgroundDelegate;
    private SelectorMode mSelectorMode = SelectorMode.BACKGROUND;

    public static <GENERAL extends TextView> SpeedySelectorDelegate obtainGeneral(GENERAL selector) {
        return SpeedySelectorDelegate.obtainGeneral(selector, null);
    }

    public static <GENERAL extends TextView> SpeedySelectorDelegate obtainGeneral(GENERAL selector, AttributeSet attrs) {
        return SpeedySelectorDelegate.obtainGeneral(selector, attrs, 0);
    }

    public static <GENERAL extends TextView> SpeedySelectorDelegate obtainGeneral(GENERAL selector, AttributeSet attrs, int defStyleAttr) {
        return SpeedySelectorDelegate.obtainGeneral(selector, attrs, defStyleAttr, 0);
    }

    public static <GENERAL extends TextView> SpeedySelectorDelegate obtainGeneral(GENERAL selector, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        return new SpeedySelectorDelegate(new GeneralDelegate<GENERAL>(selector, attrs, defStyleAttr, defStyleRes));
    }

    public static <BACKGROUND extends View> SpeedySelectorDelegate obtain(BACKGROUND selector) {
        return SpeedySelectorDelegate.obtain(selector, null);
    }

    public static <BACKGROUND extends View> SpeedySelectorDelegate obtain(BACKGROUND selector, AttributeSet attrs) {
        return SpeedySelectorDelegate.obtain(selector, attrs, 0);
    }

    public static <BACKGROUND extends View> SpeedySelectorDelegate obtain(BACKGROUND selector, AttributeSet attrs, int defStyleAttr) {
        return SpeedySelectorDelegate.obtain(selector, attrs, defStyleAttr, 0);
    }

    public static <BACKGROUND extends View> SpeedySelectorDelegate obtain(BACKGROUND selector, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        return new SpeedySelectorDelegate(new BackgroundDelegate<BACKGROUND>(selector, attrs, defStyleAttr, defStyleRes));
    }

    private SpeedySelectorDelegate(GeneralDelegate<GENERAL> delegate) {
        this.mSelectorMode = SelectorMode.GENERAL;
        this.mGeneralDelegate = delegate;
    }

    private SpeedySelectorDelegate(BackgroundDelegate<BACKGROUND> delegate) {
        this.mSelectorMode = SelectorMode.BACKGROUND;
        this.mBackgroundDelegate = delegate;
    }

    public void addStateBackground(StateType state, Drawable drawable) {
        if (this.mSelectorMode == SelectorMode.BACKGROUND) {
            this.mBackgroundDelegate.addStateBackground(state, drawable);
        } else {
            this.mGeneralDelegate.addStateBackground(state, drawable);
        }
    }

    public void addStateBackgroundResource(StateType state, @DrawableRes int draRes) {
        if (this.mSelectorMode == SelectorMode.BACKGROUND) {
            this.mBackgroundDelegate.addStateBackgroundResource(state, draRes);
        } else {
            this.mGeneralDelegate.addStateBackgroundResource(state, draRes);
        }
    }

    public void addStateBackground(StateType state, float radius, @ColorInt int color) {
        if (this.mSelectorMode == SelectorMode.BACKGROUND) {
            this.mBackgroundDelegate.addStateBackground(state, radius, color);
        } else {
            this.mGeneralDelegate.addStateBackground(state, radius, color);
        }
    }

    public void addStateBackground(StateType state, float radius, boolean justBorder, @ColorInt int color) {
        if (this.mSelectorMode == SelectorMode.BACKGROUND) {
            this.mBackgroundDelegate.addStateBackground(state, radius, justBorder, color);
        } else {
            this.mGeneralDelegate.addStateBackground(state, radius, justBorder, color);
        }
    }

    public void addStateBackground(StateType state, float radius, boolean justBorder, float borderWidth, @ColorInt int color) {
        if (this.mSelectorMode == SelectorMode.BACKGROUND) {
            this.mBackgroundDelegate.addStateBackground(state, radius, justBorder, borderWidth, color);
        } else {
            this.mGeneralDelegate.addStateBackground(state, radius, justBorder, borderWidth, color);
        }
    }

    public void addStateBackgroundResource(StateType state, float radius, @ColorRes int colorRes) {
        if (this.mSelectorMode == SelectorMode.BACKGROUND) {
            this.mBackgroundDelegate.addStateBackgroundResource(state, radius, colorRes);
        } else {
            this.mGeneralDelegate.addStateBackgroundResource(state, radius, colorRes);
        }
    }

    public void addStateBackgroundResource(StateType state, float radius, boolean justBorder, @ColorRes int colorRes) {
        if (this.mSelectorMode == SelectorMode.BACKGROUND) {
            this.mBackgroundDelegate.addStateBackgroundResource(state, radius, justBorder, colorRes);
        } else {
            this.mGeneralDelegate.addStateBackgroundResource(state, radius, justBorder, colorRes);
        }
    }

    public void addStateBackgroundResource(StateType state, float radius, boolean justBorder, float borderWidth, @ColorRes int colorRes) {
        if (this.mSelectorMode == SelectorMode.BACKGROUND) {
            this.mBackgroundDelegate.addStateBackgroundResource(state, radius, justBorder, borderWidth, colorRes);
        } else {
            this.mGeneralDelegate.addStateBackgroundResource(state, radius, justBorder, borderWidth, colorRes);
        }
    }

    public void setTextColorRessource(@ColorRes int resId) {
        if (this.mSelectorMode != SelectorMode.GENERAL) {
            throw new IllegalStateException("Not set TextColor");
        }
        this.mGeneralDelegate.setTextColorResource(resId);
    }

    public void addTextStateColor(StateType state, @ColorInt int color) {
        if (this.mSelectorMode != SelectorMode.GENERAL) {
            throw new IllegalStateException("Not set TextColor");
        }
        this.mGeneralDelegate.addTextStateColor(state, color);
    }

    public void addTextStateColorRessource(StateType state, @ColorRes int colorRes) {
        if (this.mSelectorMode != SelectorMode.GENERAL) {
            throw new IllegalStateException("Not set TextColor");
        }
        this.mGeneralDelegate.addTextStateColorResource(state, colorRes);
    }

    public void requestSelector() {
        if (this.mSelectorMode == SelectorMode.BACKGROUND) {
            this.mBackgroundDelegate.requestSelector();
        } else {
            this.mGeneralDelegate.requestSelector();
        }
    }
}

