/*
 * Decompiled with CFR 0.152.
 */
package net.soulwolf.widget.speedyselector;

import android.content.res.ColorStateList;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import net.soulwolf.widget.speedyselector.SpeedyArrayMap;
import net.soulwolf.widget.speedyselector.StateType;

class SpeedyColorStateList {
    SpeedyArrayMap<int[], Integer> mColorStateList = new SpeedyArrayMap();
    int[] mDefaultStateSet;
    int mDefaultStateColor;

    public SpeedyColorStateList(@ColorInt int defaultColor) {
        this.addStateColor(defaultColor);
    }

    public void addStateColor(@ColorInt int color) {
        this.addStateColor(StateType.STATE_DEFAULT, color);
    }

    public void addStateColor(@NonNull StateType state, @ColorInt int color) {
        if (state == StateType.STATE_DEFAULT) {
            this.mDefaultStateSet = state.mCurrentStateSet;
            this.mDefaultStateColor = color;
        } else {
            this.mColorStateList.putFirst(state.getStateSet(), color);
        }
    }

    public ColorStateList build() {
        SpeedyArrayMap<int[], Integer> speedyArrayMap = this.mColorStateList.copy();
        speedyArrayMap.put(this.mDefaultStateSet, this.mDefaultStateColor);
        int size = speedyArrayMap.size();
        int[][] stateSet = new int[size][];
        int[] colors = new int[size];
        for (int index = 0; index < size; ++index) {
            stateSet[index] = speedyArrayMap.keyAt(index);
            colors[index] = speedyArrayMap.valueAt(index);
        }
        return new ColorStateList((int[][])stateSet, colors);
    }
}

