/*
 * Decompiled with CFR 0.152.
 */
package net.soulwolf.widget.speedyselector;

import java.util.ArrayList;
import java.util.Collection;

final class SpeedyArrayMap<KEY, VALUE> {
    final ArrayList<KEY> mKeyList = new ArrayList();
    final ArrayList<VALUE> mValueList = new ArrayList();

    SpeedyArrayMap() {
    }

    public void clear() {
        this.mKeyList.clear();
        this.mValueList.clear();
    }

    public void putFirst(KEY key, VALUE value) {
        this.put(0, key, value);
    }

    public void put(KEY key, VALUE value) {
        this.mKeyList.add(key);
        this.mValueList.add(value);
    }

    public void put(int index, KEY key, VALUE value) {
        this.mKeyList.add(index, key);
        this.mValueList.add(index, value);
    }

    public void putAll(SpeedyArrayMap<? extends KEY, ? extends VALUE> collections) {
        if (collections == null) {
            throw new NullPointerException("collections == null");
        }
        this.mKeyList.addAll(collections.keys());
        this.mValueList.addAll(collections.values());
    }

    public void putAll(int index, SpeedyArrayMap<? extends KEY, ? extends VALUE> collections) {
        if (collections == null) {
            throw new NullPointerException("collections == null");
        }
        this.mKeyList.addAll(index, collections.keys());
        this.mValueList.addAll(index, collections.values());
    }

    public void remove(KEY key) {
        int index = this.mKeyList.indexOf(key);
        this.remove(index);
    }

    public void removeLast() {
        int size = this.size();
        if (size > 0) {
            this.mKeyList.remove(size - 1);
            this.mKeyList.remove(size - 1);
        }
    }

    public void remove(int index) {
        if (index != -1) {
            this.mKeyList.remove(index);
            this.mValueList.remove(index);
        }
    }

    public KEY keyAt(int index) {
        return this.mKeyList.get(index);
    }

    public VALUE valueAt(int index) {
        return this.mValueList.get(index);
    }

    public VALUE get(KEY key) {
        int index = this.mKeyList.indexOf(key);
        if (index != -1) {
            return this.mValueList.get(index);
        }
        return null;
    }

    public Collection<KEY> keys() {
        return this.mKeyList;
    }

    public Collection<VALUE> values() {
        return this.mValueList;
    }

    public int size() {
        int valueSize;
        int keySize = this.mKeyList.size();
        if (keySize != (valueSize = this.mValueList.size())) {
            throw new IllegalStateException("keySize != valueSize");
        }
        return keySize;
    }

    public Collection<Entry<KEY, VALUE>> entryList() {
        int size = this.size();
        ArrayList<Entry<KEY, VALUE>> entryList = new ArrayList<Entry<KEY, VALUE>>(size);
        for (int i = 0; i < size; ++i) {
            entryList.add(new Entry<KEY, VALUE>(this.mKeyList.get(i), this.mValueList.get(i)));
        }
        return entryList;
    }

    public SpeedyArrayMap<KEY, VALUE> copy() {
        SpeedyArrayMap<KEY, VALUE> copy = new SpeedyArrayMap<KEY, VALUE>();
        copy.putAll(this);
        return copy;
    }

    public static class Entry<KEY, VALUE> {
        final KEY key;
        final VALUE value;

        Entry(KEY key, VALUE value) {
            this.key = key;
            this.value = value;
        }

        public KEY getKey() {
            return this.key;
        }

        public VALUE getValue() {
            return this.value;
        }
    }
}

