/*
 * Decompiled with CFR 0.152.
 */
package net.soulwolf.widget.speedyselector;

import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.util.AttributeSet;
import android.widget.TextView;
import net.soulwolf.widget.speedyselector.BackgroundDelegate;
import net.soulwolf.widget.speedyselector.R;
import net.soulwolf.widget.speedyselector.SpeedyColorStateList;
import net.soulwolf.widget.speedyselector.StateType;

final class GeneralDelegate<GENERAL extends TextView>
extends BackgroundDelegate<GENERAL> {
    GENERAL mGeneralSelector;
    int mDefaultColor = -16777216;
    SpeedyColorStateList mSpeedyColorStateList;

    GeneralDelegate(GENERAL selector, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(selector, attrs, defStyleAttr, defStyleRes);
        this.mGeneralSelector = selector;
        this.applyGeneralAttributeSet(attrs, defStyleAttr, defStyleRes);
    }

    void applyGeneralAttributeSet(AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        TypedArray a;
        ColorStateList textColors = this.mGeneralSelector.getTextColors();
        if (textColors != null) {
            this.mDefaultColor = textColors.getDefaultColor();
        }
        this.mSpeedyColorStateList = new SpeedyColorStateList(this.mDefaultColor);
        if (attrs != null && (a = this.mGeneralSelector.getContext().obtainStyledAttributes(attrs, R.styleable.SpeedySelectorTextColor, defStyleAttr, defStyleRes)) != null) {
            this.parserGeneralAttribute(a, R.styleable.SpeedySelectorTextColor_spStateDefaultTextColor, StateType.STATE_DEFAULT);
            this.parserGeneralAttribute(a, R.styleable.SpeedySelectorTextColor_spStateFocusedTextColor, StateType.STATE_FOCUSED);
            this.parserGeneralAttribute(a, R.styleable.SpeedySelectorTextColor_spStateWindowFocusedTextColor, StateType.STATE_WINDOW_FOCUSED);
            this.parserGeneralAttribute(a, R.styleable.SpeedySelectorTextColor_spStateEnabledTextColor, StateType.STATE_ENABLED);
            this.parserGeneralAttribute(a, R.styleable.SpeedySelectorTextColor_spStateCheckedTextColor, StateType.STATE_CHECKED);
            this.parserGeneralAttribute(a, R.styleable.SpeedySelectorTextColor_spStateSelectedTextColor, StateType.STATE_SELECTED);
            this.parserGeneralAttribute(a, R.styleable.SpeedySelectorTextColor_spStateActivatedTextColor, StateType.STATE_ACTIVATED);
            this.parserGeneralAttribute(a, R.styleable.SpeedySelectorTextColor_spStatePressedTextColor, StateType.STATE_PRESSED);
            this.parserGeneralAttribute(a, R.styleable.SpeedySelectorTextColor_spStateActiveTextColor, StateType.STATE_ACTIVE);
            a.recycle();
        }
        this.requestSelector();
    }

    void parserGeneralAttribute(TypedArray a, int index, StateType state) {
        int color;
        if (a.hasValue(index) && (color = a.getColor(index, -1)) != -1) {
            this.addTextStateColor(state, color);
        }
    }

    public void setTextColorResource(@ColorRes int resId) {
        this.mSpeedyColorStateList.addStateColor(this.getColor(resId));
    }

    public void addTextStateColor(StateType state, @ColorInt int color) {
        this.mSpeedyColorStateList.addStateColor(state, color);
    }

    public void addTextStateColorResource(StateType state, @ColorRes int colorRes) {
        this.addTextStateColor(state, this.getColor(colorRes));
    }

    @Override
    public void requestSelector() {
        super.requestSelector();
        if (this.mGeneralSelector != null) {
            this.mGeneralSelector.setTextColor(this.mSpeedyColorStateList.build());
        }
    }
}

